/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.msgselector;

import com.sap.sdb.msgServer.client.MessageHeaderFields;
import com.sap.sdb.msgServer.client.MessageProperties;
import com.sap.sdb.msgServer.msgselector.parsing.Dataobject;
import com.sap.sdb.msgServer.msgselector.parsing.Datatype;
import com.sap.sdb.msgServer.msgselector.parsing.LanguageDefinition;
import com.sap.sdb.msgServer.msgselector.parsing.Set;
import java.util.Enumeration;
import javax.jms.JMSException;

public class GlobalContextData
implements Dataobject,
LanguageDefinition {
    private static final String[] MSG_HDR_NAMES = new String[]{"JMSDeliveryMode", "JMSPriority", "JMSMessageID", "JMSTimestamp", "JMSCorrelationID", "JMSType"};
    private static final int[] MSG_HDR_TYPES = new int[]{8194, 8197, 8194, 8197, 8194, 8194};
    private MessageHeaderFields m_header = null;
    private MessageProperties m_props = null;
    private Datatype m_dtype = null;

    public GlobalContextData(MessageHeaderFields header, MessageProperties props) throws JMSException {
        this.m_header = header;
        this.m_props = props;
        int hlen = MSG_HDR_NAMES.length;
        int plen = this.m_props.getPropCount();
        int attlen = hlen + plen;
        String[] att_names = new String[attlen];
        int[] att_types = new int[attlen];
        String name = null;
        Object value = null;
        System.arraycopy(MSG_HDR_NAMES, 0, att_names, 0, hlen);
        System.arraycopy(MSG_HDR_TYPES, 0, att_types, 0, hlen);
        Enumeration prop_enum = this.m_props.getPropertyNames();
        int i = hlen;
        while (prop_enum.hasMoreElements()) {
            name = (String)prop_enum.nextElement();
            value = this.m_props.getObjectProperty(name);
            att_names[i] = name;
            att_types[i] = value instanceof String ? 8194 : (value instanceof Boolean ? 8193 : (value instanceof Short ? 8197 : (value instanceof Character ? 8194 : (value instanceof Double ? 8195 : (value instanceof Float ? 8195 : (value instanceof Long ? 8197 : (value instanceof Integer ? 8197 : (value instanceof Byte ? 8197 : -1))))))));
            ++i;
        }
        this.m_dtype = new Datatype("", att_names, att_types);
    }

    public boolean getAttributeAsBoolean(String attrName) {
        throw new RuntimeException("com.sap.sdb.msgServer.msgselector.parsing.Dataobject.getAttributeAsBoolean(String) is not implemented by com.sap.sdb.msgServer.msgselector.GlobalContextData");
    }

    public double getAttributeAsDouble(String attrName) {
        throw new RuntimeException("com.sap.sdb.msgServer.msgselector.parsing.Dataobject.getAttributeAsDouble(String) is not implemented by com.sap.sdb.msgServer.msgselector.GlobalContextData");
    }

    public Object getAttributeAsObject(String attrName) {
        Object retval = null;
        int i = 0;
        for (i = 0; i < MSG_HDR_NAMES.length && !attrName.equals(MSG_HDR_NAMES[i]); ++i) {
        }
        if (i < MSG_HDR_NAMES.length) {
            switch (i) {
                case 0: {
                    retval = this.m_header.getJMSDeliveryMode() == 2 ? "PERSISTENT" : "NON_PERSISTENT";
                    break;
                }
                case 1: {
                    retval = new Long(this.m_header.getJMSPriority());
                    break;
                }
                case 2: {
                    retval = this.m_header.getJMSMessageID();
                    break;
                }
                case 3: {
                    retval = new Long(this.m_header.getJMSTimestamp());
                    break;
                }
                case 4: {
                    retval = this.m_header.getJMSCorrelationID();
                    break;
                }
                case 5: {
                    retval = this.m_header.getJMSType();
                }
            }
        } else {
            try {
                retval = this.m_props.getObjectProperty(attrName);
                if (retval instanceof Byte) {
                    retval = new Long(((Byte)retval).longValue());
                } else if (retval instanceof Short) {
                    retval = new Long(((Short)retval).longValue());
                } else if (retval instanceof Integer) {
                    retval = new Long(((Integer)retval).longValue());
                } else if (retval instanceof Float) {
                    retval = new Double(((Float)retval).floatValue());
                }
            }
            catch (JMSException e) {
                // empty catch block
            }
        }
        return retval;
    }

    public Set getAttributeAsSet(String attrName) {
        throw new RuntimeException("com.sap.sdb.msgServer.msgselector.parsing.Dataobject.getAttributeAsSet(String) is not implemented by com.sap.sdb.msgServer.msgselector.GlobalContextData");
    }

    public String getAttributeAsString(String attrName) {
        throw new RuntimeException("com.sap.sdb.msgServer.msgselector.parsing.Dataobject.getAttributeAsSet(String) is not implemented by com.sap.sdb.msgServer.msgselector.GlobalContextData");
    }

    public Datatype getDatatype() {
        return this.m_dtype;
    }

    public String getID() {
        throw new RuntimeException("com.sap.sdb.msgServer.msgselector.parsing.Dataobject.getAttributeAsSet(String) is not implemented by com.sap.sdb.msgServer.msgselector.GlobalContextData");
    }
}

