/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.database;

import com.sap.sdb.msgServer.client.MessageImpl;
import com.sap.sdb.msgServer.client.MessageProperties;
import com.sap.sdb.msgServer.database.DeliveryPreparedStmt;
import com.sap.sdb.msgServer.database.DeliveryResultSet;
import com.sap.sdb.msgServer.database.UserConnection;
import com.sap.sdb.msgServer.util.ReceiveStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.jms.JMSException;

public class UserDefMsgPropTable {
    static MessageProperties selectProperties(UserConnection dbConnection, int modeDelivery, long messageID, int sizeProperties) throws SQLException, JMSException {
        MessageProperties msgProperties = null;
        int stmtIndex = sizeProperties <= 2048 ? 37 : 38;
        DeliveryPreparedStmt stmt = dbConnection.getDeliveryPreparedStmt(stmtIndex, modeDelivery);
        stmt.setLong(1, messageID);
        DeliveryResultSet result = stmt.executeQuery();
        if (result.next()) {
            msgProperties = UserDefMsgPropTable.initPropertiesFromColumn(result, 1);
        }
        result.close();
        return msgProperties;
    }

    static MessageProperties initPropertiesFromColumn(ResultSet result, int columnNo) throws SQLException, JMSException {
        MessageProperties msgProperties = new MessageProperties();
        byte[] propBytes = result.getBytes(columnNo);
        ByteArrayInputStream byteStream = new ByteArrayInputStream(propBytes);
        try {
            ReceiveStream objByteStream = new ReceiveStream(byteStream);
            msgProperties.readFromStream(objByteStream);
        }
        catch (IOException ex) {
            throw new JMSException(ex.toString());
        }
        return msgProperties;
    }

    static void createMessageProperties(UserConnection dbConnection, MessageImpl aMessage) throws SQLException, JMSException {
        DeliveryPreparedStmt stmt = dbConnection.getDeliveryPreparedStmt(33, aMessage.getJMSDeliveryMode());
        stmt.setLong(1, aMessage.getMessageID());
        byte[] propBytes = aMessage.getUserDefPropBytes();
        if (propBytes.length <= 2048) {
            stmt.setBytes(2, propBytes);
            stmt.setNull(3, 2004);
        } else {
            stmt.setNull(2, 2004);
            stmt.setBytes(3, propBytes);
        }
        stmt.executeUpdate();
    }

    static void deleteAllPropsUpToMsg(UserConnection dbConnection, int modeDelivery, long maxMessageId) throws SQLException {
        UserDefMsgPropTable.deleteProperties(dbConnection, modeDelivery, 36, maxMessageId);
    }

    static void deletePropsById(UserConnection dbConnection, int modeDelivery, long messageId) throws SQLException {
        UserDefMsgPropTable.deleteProperties(dbConnection, modeDelivery, 34, messageId);
    }

    static void deleteUnusedPropsById(UserConnection dbConnection, int modeDelivery, long messageId) throws SQLException {
        UserDefMsgPropTable.deleteProperties(dbConnection, modeDelivery, 35, messageId);
    }

    private static void deleteProperties(UserConnection dbConnection, int modeDelivery, int stmtIndex, long messageId) throws SQLException {
        DeliveryPreparedStmt stmt = dbConnection.getDeliveryPreparedStmt(stmtIndex, modeDelivery);
        stmt.setLong(1, messageId);
        stmt.executeUpdate();
    }
}

