/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.database;

import com.sap.sdb.msgServer.Server;
import com.sap.sdb.msgServer.agents.JmsThread;
import com.sap.sdb.msgServer.database.DBConnectionPool;
import com.sap.sdb.msgServer.database.DeliveryPreparedStmt;
import com.sap.sdb.msgServer.database.SqlCmd;
import com.sap.sdb.msgServer.service.JmsService;
import com.sap.sdb.msgServer.util.DeliveryModeImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class UserConnection {
    private int myPersistentDBType;
    private int myTransientDBType;
    private int myPersistentTransAccessCount = 0;
    private int myTransientTransAccessCount = 0;
    private int myFirstTransCmd = 0;
    private int myReferenceCounter = 0;
    private long myConnectionID;
    private Thread myThread = null;
    private Connection myPersistentConnection;
    private Connection myTransientConnection;
    private PreparedStatement[] myPersistentStatements;
    private PreparedStatement[] myTransientStatements;
    private static long myConnectionCount = 0L;
    private static final int ACCESS_WARNING_COUNTER = 10000;
    private static final int RETCODE_DATABASE_NOT_AVAILABLE = -919;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserConnection(Connection persistentConnection, int persistentDBType, Connection transientConnection, int transientDBType) {
        this.myPersistentDBType = persistentDBType;
        this.myTransientDBType = transientDBType;
        this.myPersistentConnection = persistentConnection;
        this.myTransientConnection = transientConnection;
        this.myPersistentStatements = this.myPersistentDBType == 0 ? null : new PreparedStatement[77];
        this.myTransientStatements = this.myTransientDBType == 0 ? null : new PreparedStatement[77];
        Class clazz = UserConnection.class;
        synchronized (clazz) {
            this.myConnectionID = ++myConnectionCount;
        }
    }

    private void checkReferencedByOneThread() {
        if (this.myReferenceCounter != 1) {
            String owner = this.myThread == null ? "null" : this.myThread.getName();
            new Exception("invalid connection access: " + this.myReferenceCounter + " [owner: " + owner + " accessing thread: " + Thread.currentThread()).printStackTrace();
            System.out.flush();
            System.exit(0);
        }
    }

    private void checkThread() {
        if (this.myThread != Thread.currentThread()) {
            String owner = this.myThread == null ? "null" : this.myThread.getName();
            new Exception("connection accessed by other thread [owner: " + owner + " accessing thread: " + Thread.currentThread()).printStackTrace();
            System.out.flush();
            System.exit(0);
        }
    }

    public synchronized void close() throws SQLException {
        if (this.myPersistentConnection != null) {
            if (!this.myPersistentConnection.isClosed()) {
                this.myPersistentConnection.close();
            }
            this.myPersistentConnection = null;
        }
        if (this.myTransientConnection != null) {
            if (!this.myTransientConnection.isClosed()) {
                this.myTransientConnection.close();
            }
            this.myTransientConnection = null;
        }
        this.myPersistentStatements = null;
        this.myTransientStatements = null;
    }

    public synchronized void commit() throws SQLException {
        this.checkThread();
        if (this.myPersistentTransAccessCount > 0) {
            this.myPersistentConnection.commit();
            if (this.myThread instanceof JmsThread) {
                ((JmsThread)this.myThread).resetSQLAction();
            }
        }
        if (this.myTransientTransAccessCount > 0) {
            this.myTransientConnection.commit();
        }
        this.resetTransState();
    }

    public DeliveryPreparedStmt getAvailablePreparedStmt(int sqlCmdIndex) throws SQLException {
        int modeDelivery = this.myPersistentDBType == 0 ? 1 : 2;
        return this.getDeliveryPreparedStmt(sqlCmdIndex, modeDelivery);
    }

    public synchronized DeliveryPreparedStmt getDeliveryPreparedStmt(int sqlCmdIndex, int modeDelivery) throws SQLException {
        this.checkThread();
        DeliveryModeImpl.checkModeThrowSQLException(modeDelivery);
        if (modeDelivery == 2 && this.myPersistentConnection == null) {
            throw new SQLException("persistent database not available", SqlCmd.getCmd(sqlCmdIndex), -919);
        }
        if (modeDelivery == 2 || this.myTransientConnection == null) {
            ++this.myPersistentTransAccessCount;
            PreparedStatement prepStmt = this.getPreparedStatement(false, this.myPersistentConnection, this.myPersistentStatements, sqlCmdIndex);
            return new DeliveryPreparedStmt(this, 2, this.myPersistentDBType, prepStmt);
        }
        ++this.myTransientTransAccessCount;
        PreparedStatement stmt = this.getPreparedStatement(DBConnectionPool.isTransientMemoryUsed(), this.myTransientConnection, this.myTransientStatements, sqlCmdIndex);
        return new DeliveryPreparedStmt(this, 1, this.myTransientDBType, stmt);
    }

    public String getDriverVersion(int modeDelivery) throws SQLException {
        DeliveryModeImpl.checkModeThrowSQLException(modeDelivery);
        if (modeDelivery == 2) {
            return this.myPersistentDBType == 0 ? "not accessible" : this.myPersistentConnection.getMetaData().getDriverName() + " " + this.myPersistentConnection.getMetaData().getDriverVersion();
        }
        return this.myTransientDBType == 0 ? "not accessible" : this.myTransientConnection.getMetaData().getDriverName() + " " + this.myTransientConnection.getMetaData().getDriverVersion();
    }

    public int getDriverMajorVersion(int modeDelivery) throws SQLException {
        DeliveryModeImpl.checkModeThrowSQLException(modeDelivery);
        if (modeDelivery == 2) {
            return this.myPersistentDBType == 0 ? -1 : this.myPersistentConnection.getMetaData().getDriverMajorVersion();
        }
        return this.myTransientDBType == 0 ? -1 : this.myTransientConnection.getMetaData().getDriverMajorVersion();
    }

    public int getDriverMinorVersion(int modeDelivery) throws SQLException {
        DeliveryModeImpl.checkModeThrowSQLException(modeDelivery);
        if (modeDelivery == 2) {
            return this.myPersistentDBType == 0 ? -1 : this.myPersistentConnection.getMetaData().getDriverMinorVersion();
        }
        return this.myTransientDBType == 0 ? -1 : this.myTransientConnection.getMetaData().getDriverMinorVersion();
    }

    public DeliveryPreparedStmt getPersistentPreparedStmt(int sqlCmdIndex) throws SQLException {
        return this.getDeliveryPreparedStmt(sqlCmdIndex, 2);
    }

    private PreparedStatement getPreparedStatement(boolean isTransientMemory, Connection connect, PreparedStatement[] stmtList, int sqlCmdIndex) throws SQLException {
        PreparedStatement stmt;
        if (stmtList == null) {
            return null;
        }
        if (this.myFirstTransCmd == 0) {
            this.myFirstTransCmd = sqlCmdIndex;
        }
        if ((stmt = stmtList[sqlCmdIndex]) != null) {
            return stmt;
        }
        stmtList[sqlCmdIndex] = stmt = isTransientMemory ? connect.prepareStatement(Integer.toString(sqlCmdIndex)) : connect.prepareStatement(SqlCmd.getCmd(sqlCmdIndex));
        return stmt;
    }

    synchronized void incrAccessCount(int modeDelivery) {
        this.checkThread();
        if (modeDelivery == 2) {
            ++this.myPersistentTransAccessCount;
        } else {
            ++this.myTransientTransAccessCount;
        }
    }

    void releaseConnection() {
        this.checkReferencedByOneThread();
        --this.myReferenceCounter;
        this.myThread = null;
        if (JmsService.getVerboseSQLConnection()) {
            Server.log("release connection " + this.myConnectionID + " [Thread: " + Thread.currentThread().getName() + "]");
        }
    }

    private synchronized void resetTransState() {
        if (this.myPersistentTransAccessCount + this.myTransientTransAccessCount > 10000 && JmsService.getVerboseException()) {
            Server.log("access count per SQL transaction: " + (this.myPersistentTransAccessCount + this.myTransientTransAccessCount) + "; first command: " + SqlCmd.getCmd(this.myFirstTransCmd));
        }
        this.myPersistentTransAccessCount = 0;
        this.myTransientTransAccessCount = 0;
        this.myFirstTransCmd = 0;
    }

    public synchronized void rollback() throws SQLException {
        this.checkThread();
        if (this.myPersistentTransAccessCount > 0) {
            this.myPersistentConnection.rollback();
            if (this.myThread instanceof JmsThread) {
                ((JmsThread)this.myThread).resetSQLAction();
            }
        }
        if (this.myTransientTransAccessCount > 0) {
            this.myTransientConnection.rollback();
        }
        this.resetTransState();
    }

    void useConnection() {
        ++this.myReferenceCounter;
        this.checkReferencedByOneThread();
        this.myThread = Thread.currentThread();
        if (JmsService.getVerboseSQLConnection()) {
            Server.log("get SQL connection " + this.myConnectionID + " [Thread: " + Thread.currentThread().getName() + "]");
        }
    }
}

