/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.database;

import com.sap.sdb.msgServer.database.DeliveryResultSet;
import com.sap.sdb.msgServer.database.UserConnection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DeliveryPreparedStmt {
    private int m_databaseType;
    private int m_deliveryMode;
    private int m_addBatchCounter;
    private int m_rowCountInsteadOfAddBatch;
    private boolean m_batchAlreadyExecuted;
    private UserConnection m_connection;
    private PreparedStatement m_statement;

    DeliveryPreparedStmt(UserConnection dbConnection, int modeDelivery, int dbType, PreparedStatement stmt) {
        this.m_connection = dbConnection;
        this.m_deliveryMode = modeDelivery;
        this.m_databaseType = dbType;
        this.m_statement = stmt;
        this.m_batchAlreadyExecuted = false;
        this.m_addBatchCounter = 0;
        this.m_rowCountInsteadOfAddBatch = 0;
    }

    public void addBatch() throws SQLException {
        ++this.m_addBatchCounter;
        this.m_connection.incrAccessCount(this.m_deliveryMode);
        if (this.m_databaseType == 1) {
            this.m_statement.addBatch();
            return;
        }
        this.m_rowCountInsteadOfAddBatch += this.m_statement.executeUpdate();
        this.m_batchAlreadyExecuted = true;
    }

    public boolean execute() throws SQLException {
        this.m_connection.incrAccessCount(this.m_deliveryMode);
        return this.m_statement.execute();
    }

    public int executeBatchGetRowCount() throws SQLException {
        this.m_addBatchCounter = 0;
        this.m_connection.incrAccessCount(this.m_deliveryMode);
        int count = 0;
        if (this.m_batchAlreadyExecuted) {
            count = this.m_rowCountInsteadOfAddBatch;
            this.m_rowCountInsteadOfAddBatch = 0;
            this.m_batchAlreadyExecuted = false;
            return count;
        }
        int[] updCountList = this.m_statement.executeBatch();
        for (int i = 0; i < updCountList.length; ++i) {
            if (updCountList[i] == -2) {
                count = -2;
                break;
            }
            if (updCountList[i] < 0) continue;
            count += updCountList[i];
        }
        return count;
    }

    public int executeUpdate() throws SQLException {
        this.m_connection.incrAccessCount(this.m_deliveryMode);
        return this.m_statement.executeUpdate();
    }

    public DeliveryResultSet executeQuery() throws SQLException {
        this.m_connection.incrAccessCount(this.m_deliveryMode);
        ResultSet result = this.m_statement.executeQuery();
        return new DeliveryResultSet(this.m_connection, this.m_deliveryMode, result);
    }

    public int getAddBatchCount() {
        return this.m_addBatchCounter;
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        int xValue = x ? 1 : 0;
        this.m_statement.setInt(parameterIndex, xValue);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.m_statement.setByte(parameterIndex, x);
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.m_statement.setBytes(parameterIndex, x);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.m_statement.setDouble(parameterIndex, x);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.m_statement.setFloat(parameterIndex, x);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.m_statement.setInt(parameterIndex, x);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.m_statement.setLong(parameterIndex, x);
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.m_statement.setNull(parameterIndex, sqlType);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.m_statement.setObject(parameterIndex, x);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.m_statement.setShort(parameterIndex, x);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.m_statement.setString(parameterIndex, x);
    }

    public void setMaxRows(int maxrows) throws SQLException {
        this.m_statement.setMaxRows(maxrows);
    }
}

