/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.database;

import com.sap.sdb.msgServer.Server;
import com.sap.sdb.msgServer.database.UserConnection;
import com.sap.sdb.msgServer.service.JmsService;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Properties;

public class DBConnectionPool {
    static final int DATABASE_NONE = 0;
    static final int DATABASE_MAXDB = 1;
    static final int DATABASE_TRANSIENT_STORAGE = 2;
    static final int DATABASE_MINDB = 3;
    private static final String USER_PROPERTY = "user";
    private static final String PASSWORD_PROPERTY = "password";
    private static final String MAX_ORDERS_PROPERTY = "maxSendOrders";
    private static final String MAX_MSG_SPACE_PROPERTY = "maxMessageSpace";
    private static final String MAXDB_PACKAGE_PREFIX = "com.sap.dbtech";
    private static final String MINDB_PACKAGE_PREFIX = "com.sap.sdb.minDB";
    private static final String TRANSIENT_PACKAGE_PREFIX = "com.sap.sdb.msgServer.transientStorage";
    private static DBConnectionPool m_connectionPool = null;
    private int myMaxUnusedConnections;
    private int myPersistentDBType;
    private int myTransientDBType;
    private String myPersistentURL;
    private String myTransientURL;
    private Properties myPersistentProperties;
    private Properties myTransientProperties;
    private LinkedList myUnusedConnections;

    private DBConnectionPool(int persistentDBType, int transientDBType, String persistentDatabaseURL, String transientDatabaseURL, Properties persistentProperties, Properties transientProperties, int initialConnections) {
        this.myPersistentDBType = persistentDBType;
        this.myTransientDBType = transientDBType;
        this.myPersistentURL = persistentDatabaseURL;
        this.myTransientURL = transientDatabaseURL;
        this.myPersistentProperties = persistentProperties;
        this.myTransientProperties = transientProperties;
        this.myUnusedConnections = new LinkedList();
        this.myMaxUnusedConnections = 10 * initialConnections;
    }

    private static void checkInstance() throws SQLException {
        if (m_connectionPool == null) {
            throw new SQLException("Connection pool not created.");
        }
    }

    private void cleanUp() throws SQLException {
        Server.log("clean up connection pool");
        while (this.myUnusedConnections.size() > 0) {
            UserConnection currConnection = (UserConnection)this.myUnusedConnections.removeFirst();
            currConnection.close();
        }
    }

    public static boolean connectedToSAPDB(int modeDelivery) {
        return m_connectionPool == null ? false : (modeDelivery == 2 ? DBConnectionPool.m_connectionPool.myPersistentDBType == 1 : DBConnectionPool.m_connectionPool.myTransientDBType == 1);
    }

    private void createInitialConnections(int initialConnections) throws SQLException {
        for (int i = 0; i < initialConnections; ++i) {
            this.myUnusedConnections.add(this.createNewConnection());
        }
    }

    public static synchronized void createInstance(String persistentDatabaseURL, String persistentJdbcDriver, String persistentUsername, String persistentPassword, String transientDatabaseURL, String transientJDBCDriver, String transientUsername, String transientPassword, int transientMaxSendOrders, long transientMessageLimit, int initialConnections) throws SQLException {
        if (m_connectionPool != null) {
            throw new IllegalStateException("DBConnectionPool singleton already created.");
        }
        if (persistentDatabaseURL == null && transientDatabaseURL == null) {
            throw new SQLException("database URL not specified");
        }
        if (persistentDatabaseURL != null && persistentJdbcDriver == null) {
            throw new SQLException("JDBC driver of persistent database not specified");
        }
        if (transientDatabaseURL != null && transientJDBCDriver == null) {
            throw new SQLException("JDBC driver of transient database not specified");
        }
        int persistentDBType = DBConnectionPool.getDatabaseType(persistentJdbcDriver);
        int transientDBType = DBConnectionPool.getDatabaseType(transientJDBCDriver);
        Properties persistentProperties = null;
        Properties transientProperties = null;
        if (persistentDBType != 0) {
            DBConnectionPool.loadJDBCDriver(persistentJdbcDriver);
            persistentProperties = new Properties();
            if (persistentUsername != null) {
                persistentUsername = "\"" + persistentUsername + "\"";
                persistentProperties.put(USER_PROPERTY, persistentUsername);
            }
            if (persistentPassword != null) {
                persistentPassword = "\"" + persistentPassword + "\"";
                persistentProperties.put(PASSWORD_PROPERTY, persistentPassword);
            }
        }
        if (transientDBType != 0) {
            DBConnectionPool.loadJDBCDriver(transientJDBCDriver);
            transientProperties = new Properties();
            if (transientUsername != null) {
                transientProperties.put(USER_PROPERTY, transientUsername);
            }
            if (transientPassword != null) {
                transientProperties.put(PASSWORD_PROPERTY, transientPassword);
            }
            if (transientDBType == 2) {
                if (transientMaxSendOrders > 0) {
                    transientProperties.put(MAX_ORDERS_PROPERTY, Integer.toString(transientMaxSendOrders));
                }
                if (transientMessageLimit > 0L && 0x1FFFFFFFFFFFFFL > transientMessageLimit) {
                    transientProperties.put(MAX_MSG_SPACE_PROPERTY, Long.toString(transientMessageLimit * 1024L));
                }
            }
        }
        int initialConnectCount = initialConnections > 0 ? initialConnections : 2;
        m_connectionPool = new DBConnectionPool(persistentDBType, transientDBType, persistentDatabaseURL, transientDatabaseURL, persistentProperties, transientProperties, initialConnectCount);
        m_connectionPool.createInitialConnections(initialConnectCount);
        m_connectionPool.printDatabaseInfo(persistentDatabaseURL, transientDatabaseURL);
    }

    private UserConnection createNewConnection() throws SQLException {
        Connection persistentConnection = this.myPersistentDBType == 0 ? null : this.establishConnection(this.myPersistentURL, this.myPersistentProperties);
        Connection transientConnection = this.myTransientDBType == 0 ? null : this.establishConnection(this.myTransientURL, this.myTransientProperties);
        return new UserConnection(persistentConnection, this.myPersistentDBType, transientConnection, this.myTransientDBType);
    }

    public static synchronized void destroyInstance() throws SQLException {
        if (m_connectionPool == null) {
            return;
        }
        m_connectionPool.cleanUp();
        m_connectionPool = null;
    }

    private Connection establishConnection(String databaseURL, Properties connectProperties) throws SQLException {
        Connection connection = DriverManager.getConnection(databaseURL, connectProperties);
        connection.setAutoCommit(false);
        connection.setTransactionIsolation(2);
        return connection;
    }

    public static boolean existsConnection(int modeDelivery) {
        if (m_connectionPool == null) {
            return false;
        }
        switch (modeDelivery) {
            case 2: {
                return DBConnectionPool.m_connectionPool.myPersistentDBType != 0;
            }
            case 1: {
                return DBConnectionPool.m_connectionPool.myTransientDBType != 0;
            }
        }
        return false;
    }

    public static boolean existsPersistentConnection() {
        return m_connectionPool == null ? false : DBConnectionPool.m_connectionPool.myPersistentDBType != 0;
    }

    public static boolean existsTransientConnection() {
        return m_connectionPool == null ? false : DBConnectionPool.m_connectionPool.myTransientDBType != 0;
    }

    private static int getDatabaseType(String jdbcDriver) {
        if (jdbcDriver == null) {
            return 0;
        }
        if (DBConnectionPool.isJDBCDriverMaxDB(jdbcDriver)) {
            return 1;
        }
        if (DBConnectionPool.isJDBCDriverTransientStorage(jdbcDriver)) {
            return 2;
        }
        if (DBConnectionPool.isJDBCDriverMinDB(jdbcDriver)) {
            return 3;
        }
        return 0;
    }

    public static UserConnection getNewConnection() throws SQLException {
        DBConnectionPool.checkInstance();
        UserConnection connection = m_connectionPool.createNewConnection();
        connection.useConnection();
        return connection;
    }

    public static boolean isJDBCDriverMaxDB(String jdbcDriver) {
        return jdbcDriver == null ? false : jdbcDriver.startsWith(MAXDB_PACKAGE_PREFIX);
    }

    public static boolean isJDBCDriverMinDB(String jdbcDriver) {
        return jdbcDriver == null ? false : jdbcDriver.startsWith(MINDB_PACKAGE_PREFIX);
    }

    public static boolean isJDBCDriverTransientStorage(String jdbcDriver) {
        return jdbcDriver == null ? false : jdbcDriver.startsWith(TRANSIENT_PACKAGE_PREFIX);
    }

    public static boolean isTransientMemoryUsed() {
        return m_connectionPool == null ? false : DBConnectionPool.m_connectionPool.myTransientDBType == 2;
    }

    private static void loadJDBCDriver(String jdbcDriver) throws SQLException {
        try {
            Class.forName(jdbcDriver);
        }
        catch (ClassNotFoundException ex) {
            throw new SQLException("JDBC driver " + jdbcDriver + " not found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printDatabaseInfo(String persistentURL, String transientURL) throws SQLException {
        UserConnection dbConnection = DBConnectionPool.useConnection();
        try {
            if (this.myPersistentDBType == 0) {
                Server.log("persistent database.... : not defined");
            } else {
                Server.log("persistent database.... : " + persistentURL);
                Server.log("persistent JDBC driver  : " + dbConnection.getDriverVersion(2));
                Server.log("persistent database user: " + this.myPersistentProperties.getProperty(USER_PROPERTY));
            }
            if (this.myTransientDBType == 0) {
                Server.log("transient  database.... : not defined");
            } else {
                Server.log("transient  database.... : " + transientURL);
                Server.log("transient  JDBC driver  : " + dbConnection.getDriverVersion(1));
                if (!DBConnectionPool.isTransientMemoryUsed()) {
                    Server.log("transient  database user: " + this.myTransientProperties.getProperty(USER_PROPERTY));
                }
            }
        }
        finally {
            DBConnectionPool.returnConnection(dbConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void returnConnection(UserConnection connection) {
        if (connection == null) {
            return;
        }
        try {
            connection.rollback();
            connection.releaseConnection();
            boolean closeConnection = true;
            Class clazz = DBConnectionPool.class;
            synchronized (clazz) {
                if (m_connectionPool != null && DBConnectionPool.m_connectionPool.myUnusedConnections.size() < DBConnectionPool.m_connectionPool.myMaxUnusedConnections) {
                    DBConnectionPool.m_connectionPool.myUnusedConnections.add(connection);
                    closeConnection = false;
                }
            }
            if (closeConnection) {
                connection.close();
            }
        }
        catch (SQLException ex) {
            JmsService.logException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserConnection useConnection() throws SQLException {
        UserConnection connection = null;
        DBConnectionPool.checkInstance();
        Class clazz = DBConnectionPool.class;
        synchronized (clazz) {
            if (DBConnectionPool.m_connectionPool.myUnusedConnections.size() > 0) {
                connection = (UserConnection)DBConnectionPool.m_connectionPool.myUnusedConnections.removeFirst();
            }
        }
        if (connection == null) {
            connection = m_connectionPool.createNewConnection();
        }
        connection.useConnection();
        return connection;
    }
}

