/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.database;

import com.sap.sdb.msgServer.Server;
import com.sap.sdb.msgServer.agents.SendOrderPolling;
import com.sap.sdb.msgServer.agents.SyncReceiveHandler;
import com.sap.sdb.msgServer.database.DBConnectionPool;
import com.sap.sdb.msgServer.database.DeliveryPreparedStmt;
import com.sap.sdb.msgServer.database.DeliveryResultSet;
import com.sap.sdb.msgServer.database.DestinationList;
import com.sap.sdb.msgServer.database.QueueReceiverList;
import com.sap.sdb.msgServer.database.SendOrderTable;
import com.sap.sdb.msgServer.database.UserConnection;
import com.sap.sdb.msgServer.service.JmsService;
import com.sap.sdb.msgServer.util.ClientSessionAddress;
import com.sap.sdb.msgServer.util.ConsumerEntity;
import com.sap.sdb.msgServer.util.MessageConsumerInfo;
import com.sap.sdb.msgServer.util.SendingNotificationQueue;
import com.sap.sdb.msgServer.util.StreamString;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;

public class ConsumerList {
    private static ConsumerList sConsumerList = null;
    private static boolean myVerbose = false;
    private Hashtable myActiveConsumers = new Hashtable(100);
    private Hashtable myInactiveConsumers = new Hashtable(100);
    private Hashtable myQueueReceivers = new Hashtable(100);
    private Object mSendOrderSync = new Object();

    private ConsumerList() {
    }

    public static void setVerbose(boolean verbose) {
        myVerbose = verbose;
    }

    public static synchronized void createInstance(UserConnection dbConnection) throws SQLException {
        if (sConsumerList != null) {
            throw new IllegalStateException("ConsumerList singleton already created.");
        }
        sConsumerList = new ConsumerList();
        if (DBConnectionPool.existsPersistentConnection() && DBConnectionPool.existsTransientConnection()) {
            ConsumerList.loadTransientConsumerTable(dbConnection);
        }
    }

    public static synchronized void destroyInstance() {
        if (sConsumerList == null) {
            throw new IllegalStateException("ConsumerList singleton not created.");
        }
        sConsumerList = null;
    }

    private static ConsumerList getInstance() {
        if (sConsumerList == null) {
            throw new IllegalStateException("ConsumerList singleton not created.");
        }
        return sConsumerList;
    }

    public static int getNumberOfActiveConsumers() {
        return ConsumerList.getInstance().myActiveConsumers.size();
    }

    public static int getNumberOfInActiveConsumers() {
        return ConsumerList.getInstance().myInactiveConsumers.size();
    }

    public static Vector getConsumersForDestination(UserConnection dbConnection, long destinationID) throws SQLException {
        Vector<ConsumerEntity> consumers = new Vector<ConsumerEntity>();
        DeliveryPreparedStmt stmt = dbConnection.getAvailablePreparedStmt(16);
        stmt.setLong(1, destinationID);
        DeliveryResultSet res = stmt.executeQuery();
        while (res.next()) {
            ConsumerEntity consumer = new ConsumerEntity();
            consumer.setID(res.getLong(1));
            consumer.setClient(res.getString(2));
            consumer.setType(res.getInt(3));
            consumer.setState(res.getInt(4));
            consumer.setMessageSelector(res.getString(5));
            consumer.setSubscription(res.getString(6));
            consumer.setDestination(destinationID);
            consumer.setNoLocal(res.getInt(7) == 1);
            consumers.add(consumer);
        }
        if (res != null) {
            res.close();
        }
        return consumers;
    }

    public static MessageConsumerInfo getActiveConsumer(long consumerID) {
        return ConsumerList.getActiveConsumer(new Long(consumerID));
    }

    private static MessageConsumerInfo getActiveConsumer(Long consumerID) {
        return (MessageConsumerInfo)ConsumerList.getInstance().myActiveConsumers.get(consumerID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageConsumerInfo getActiveConsumer(StreamString clientID, long consumerID) {
        if (clientID == null) {
            return null;
        }
        Class clazz = ConsumerList.class;
        synchronized (clazz) {
            MessageConsumerInfo consumerInfo = ConsumerList.getActiveConsumer(consumerID);
            if (consumerInfo != null) {
                if (!ConsumerList.checkClientID(clientID, consumerInfo)) {
                    return null;
                }
                return consumerInfo;
            }
            return null;
        }
    }

    public static QueueReceiverList getQueueReceiverList(long destinationID) {
        return ConsumerList.getQueueReceiverList(new Long(destinationID));
    }

    private static QueueReceiverList getQueueReceiverList(Long destinationID) {
        return (QueueReceiverList)ConsumerList.getInstance().myQueueReceivers.get(destinationID);
    }

    public static Object getSendOrderSync() {
        return ConsumerList.getInstance().mSendOrderSync;
    }

    public static synchronized boolean hasActiveConsumer(boolean isQueueReceiver, long consumerID, long destID) {
        if (!isQueueReceiver) {
            MessageConsumerInfo aConsumer = ConsumerList.getActiveConsumer(consumerID);
            if (aConsumer != null) {
                return true;
            }
        } else {
            QueueReceiverList list = ConsumerList.getQueueReceiverList(destID);
            if (list != null) {
                return list.size() > 0;
            }
        }
        return false;
    }

    private static void addActiveConsumer(UserConnection dbConnection, MessageConsumerInfo consumerInfo) throws SQLException {
        long consumerID = consumerInfo.getConsumerID();
        long destID = consumerInfo.getDestinationID();
        boolean isSendorderActivated = ConsumerList.resetActiveFlag(dbConnection, consumerID, destID, consumerInfo.isQueueReceiver(), true);
        Long aConsumer = new Long(consumerID);
        ConsumerList.getInstance().myActiveConsumers.put(aConsumer, consumerInfo);
        ConsumerList.getInstance().myInactiveConsumers.remove(new Long(consumerID));
        if (consumerInfo.isQueueReceiver()) {
            Long aDestID = new Long(consumerInfo.getDestinationID());
            QueueReceiverList list = ConsumerList.getQueueReceiverList(aDestID);
            if (list == null) {
                list = new QueueReceiverList();
                ConsumerList.getInstance().myQueueReceivers.put(aDestID, list);
            }
            list.addConsumerInfo(consumerInfo);
        }
        if (isSendorderActivated) {
            SendOrderPolling.notifyNewConsumerActive();
        }
        if (myVerbose) {
            Server.log(Thread.currentThread().toString() + ":ConsumerList: add active consumer:" + consumerID + ",client session address: " + consumerInfo.getClientSessionAddress().toString());
        }
    }

    private static synchronized MessageConsumerInfo removeActiveConsumer(long consumerID) {
        Long aConsumer = new Long(consumerID);
        MessageConsumerInfo consumerInfo = (MessageConsumerInfo)ConsumerList.getInstance().myActiveConsumers.remove(aConsumer);
        if (consumerInfo != null) {
            Long aDestID;
            QueueReceiverList list;
            if (consumerInfo.isQueueReceiver() && (list = ConsumerList.getQueueReceiverList(aDestID = new Long(consumerInfo.getDestinationID()))) != null) {
                list.removeConsumerInfo(consumerInfo);
                if (list.size() < 1) {
                    ConsumerList.getInstance().myQueueReceivers.remove(aDestID);
                }
            }
            if (myVerbose) {
                Server.log(Thread.currentThread().toString() + ":ConsumerList: remove active consumer:" + consumerID + ",client session address: " + consumerInfo.getClientSessionAddress().toString());
            }
        }
        return consumerInfo;
    }

    private static synchronized void addInactiveConsumer(long consumerID, MessageConsumerInfo consumerInfo) {
        consumerInfo.setIgnoreBySendOrderPolling(-1L);
        ConsumerList.getInstance().myInactiveConsumers.put(new Long(consumerID), consumerInfo);
        ConsumerList.getInstance().myActiveConsumers.remove(new Long(consumerID));
        if (myVerbose) {
            Server.log(Thread.currentThread().toString() + ":ConsumerList: delete/inactive consumer:" + consumerID + ",client session address: " + consumerInfo.getClientSessionAddress().toString());
        }
    }

    public static synchronized void setIgnoreBySendOrderPolling(String receiverClientAddress, long startTime) {
        Enumeration consumers = ConsumerList.getInstance().myActiveConsumers.elements();
        while (consumers.hasMoreElements()) {
            MessageConsumerInfo consumer = (MessageConsumerInfo)consumers.nextElement();
            if (!consumer.getClientSessionAddress().toString().equals(receiverClientAddress)) continue;
            consumer.setIgnoreBySendOrderPolling(startTime);
            if (!myVerbose) continue;
            Server.log("--------------------------------------------------------------------------------------------------------");
            Server.log("    Set Ignore By SendOrderPolling to " + startTime + " for clients with adress " + receiverClientAddress + ", consumer ID:" + consumer.getConsumerID());
            Server.log("--------------------------------------------------------------------------------------------------------");
        }
    }

    public static MessageConsumerInfo removeDeletedConsumer(long consumerID) {
        MessageConsumerInfo consumer = (MessageConsumerInfo)ConsumerList.getInstance().myInactiveConsumers.remove(new Long(consumerID));
        return consumer;
    }

    public static MessageConsumerInfo getInactiveConsumer(long consumerID) {
        MessageConsumerInfo consumer = (MessageConsumerInfo)ConsumerList.getInstance().myInactiveConsumers.get(new Long(consumerID));
        return consumer;
    }

    public static void recover(UserConnection dbConnection) throws SQLException, InvalidSelectorException {
        ConsumerList.recover(dbConnection, 2);
        ConsumerList.recover(dbConnection, 1);
    }

    private static void recover(UserConnection dbConnection, int modeDelivery) throws SQLException, InvalidSelectorException {
        if (!DBConnectionPool.existsConnection(modeDelivery)) {
            return;
        }
        DeliveryPreparedStmt stmt = dbConnection.getDeliveryPreparedStmt(7, modeDelivery);
        stmt.executeUpdate();
        stmt = dbConnection.getDeliveryPreparedStmt(10, modeDelivery);
        stmt.executeUpdate();
        if (modeDelivery == 2) {
            ConsumerList.initInactiveConsumers(dbConnection);
        }
    }

    private static boolean deleteByID(UserConnection dbConnection, long id) throws SQLException {
        boolean oneRowDeleted = false;
        if (DBConnectionPool.existsTransientConnection()) {
            oneRowDeleted = ConsumerList.deleteByID(dbConnection, 1, id);
        }
        if (DBConnectionPool.existsPersistentConnection()) {
            oneRowDeleted = ConsumerList.deleteByID(dbConnection, 2, id);
        }
        return oneRowDeleted;
    }

    private static boolean deleteByID(UserConnection dbConnection, int modeDelivery, long id) throws SQLException {
        DeliveryPreparedStmt stmt = dbConnection.getDeliveryPreparedStmt(5, modeDelivery);
        stmt.setLong(1, id);
        int rowCount = stmt.executeUpdate();
        return rowCount < 0 || rowCount == 1;
    }

    public static int update(UserConnection dbConnection, ConsumerEntity consumer) throws SQLException, JMSException {
        int rowCount = 0;
        if (DBConnectionPool.existsTransientConnection()) {
            rowCount = ConsumerList.update(dbConnection, 1, consumer);
        }
        if (DBConnectionPool.existsPersistentConnection()) {
            rowCount = ConsumerList.update(dbConnection, 2, consumer);
        }
        return rowCount;
    }

    private static int update(UserConnection dbConnection, int modeDelivery, ConsumerEntity consumer) throws SQLException, JMSException {
        if (!consumer.isValid()) {
            throw new JMSException("attempt to update a consumer record with uninitialized data");
        }
        DeliveryPreparedStmt stmt = dbConnection.getDeliveryPreparedStmt(8, modeDelivery);
        stmt.setString(1, consumer.getClient());
        stmt.setLong(2, consumer.getDestination());
        stmt.setInt(3, consumer.getType());
        stmt.setInt(4, consumer.getState());
        stmt.setString(5, consumer.getSubscription());
        stmt.setString(6, consumer.getMessageSelector());
        stmt.setBoolean(7, consumer.getNoLocal());
        stmt.setLong(8, consumer.getID());
        int rowCount = stmt.executeUpdate();
        return rowCount;
    }

    public static boolean changeConsumerState(UserConnection dbConnection, long consumerID, int state) throws SQLException {
        boolean oneRowChanged = false;
        if (DBConnectionPool.existsTransientConnection()) {
            oneRowChanged = ConsumerList.changeConsumerState(dbConnection, 1, consumerID, state);
        }
        if (DBConnectionPool.existsPersistentConnection()) {
            oneRowChanged = ConsumerList.changeConsumerState(dbConnection, 2, consumerID, state);
        }
        return oneRowChanged;
    }

    private static boolean changeConsumerState(UserConnection dbConnection, int modeDelivery, long consumerID, int state) throws SQLException {
        DeliveryPreparedStmt stmt = dbConnection.getDeliveryPreparedStmt(9, modeDelivery);
        stmt.setInt(1, state);
        stmt.setLong(2, consumerID);
        int rowCount = stmt.executeUpdate();
        return rowCount < 0 || rowCount == 1;
    }

    public static void persist(UserConnection dbConnection, ConsumerEntity consumer) throws SQLException, JMSException {
        ConsumerList.persist(dbConnection, 2, consumer);
        ConsumerList.persist(dbConnection, 1, consumer);
    }

    private static void persist(UserConnection dbConnection, int modeDelivery, ConsumerEntity consumer) throws SQLException, JMSException {
        if (!DBConnectionPool.existsConnection(modeDelivery)) {
            return;
        }
        if (!consumer.isValid()) {
            throw new JMSException("attempt to create a consumer record with uninitialized data");
        }
        DeliveryPreparedStmt stmt = dbConnection.getDeliveryPreparedStmt(4, modeDelivery);
        stmt.setLong(1, consumer.getID());
        stmt.setString(2, consumer.getClient());
        stmt.setLong(3, consumer.getDestination());
        stmt.setInt(4, consumer.getType());
        stmt.setInt(5, consumer.getState());
        stmt.setString(6, consumer.getSubscription());
        stmt.setString(7, consumer.getMessageSelector());
        stmt.setBoolean(8, consumer.getNoLocal());
        stmt.executeUpdate();
    }

    public static ConsumerEntity loadFromDb(UserConnection dbConnection, String subscription, long destId) throws SQLException {
        ConsumerEntity retval = null;
        DeliveryPreparedStmt stmt = dbConnection.getAvailablePreparedStmt(15);
        stmt.setString(1, subscription);
        stmt.setLong(2, destId);
        DeliveryResultSet res = stmt.executeQuery();
        if (res.next()) {
            ConsumerEntity consumer = new ConsumerEntity();
            consumer.setID(res.getLong(1));
            consumer.setClient(res.getString(2));
            consumer.setType(res.getInt(3));
            consumer.setState(res.getInt(4));
            consumer.setMessageSelector(res.getString(5));
            consumer.setSubscription(subscription);
            consumer.setDestination(destId);
            consumer.setNoLocal(res.getInt(6) == 1);
            retval = consumer;
        }
        if (res != null) {
            res.close();
        }
        return retval;
    }

    public static ConsumerEntity loadFromDbByID(UserConnection dbConnection, long consumerId) throws SQLException {
        ConsumerEntity retval = null;
        DeliveryPreparedStmt stmt = dbConnection.getAvailablePreparedStmt(11);
        stmt.setLong(1, consumerId);
        DeliveryResultSet res = stmt.executeQuery();
        if (res.next()) {
            ConsumerEntity consumer = new ConsumerEntity();
            consumer.setClient(res.getString(1));
            consumer.setDestination(res.getLong(2));
            consumer.setType(res.getInt(3));
            consumer.setState(res.getInt(4));
            consumer.setSubscription(res.getString(5));
            consumer.setMessageSelector(res.getString(6));
            consumer.setNoLocal(res.getInt(7) == 1);
            retval = consumer;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void loadTransientConsumerTable(UserConnection dbConnection) throws SQLException {
        DeliveryPreparedStmt transientStmt;
        DeliveryPreparedStmt persistentStmt;
        DeliveryResultSet transientResult;
        DeliveryResultSet persistentResult;
        block13: {
            block14: {
                persistentResult = null;
                transientResult = null;
                persistentStmt = dbConnection.getPersistentPreparedStmt(13);
                transientStmt = dbConnection.getDeliveryPreparedStmt(13, 1);
                try {
                    persistentResult = persistentStmt.executeQuery();
                    transientResult = transientStmt.executeQuery();
                    persistentResult.next();
                    transientResult.next();
                    int pers = persistentResult.getInt(1);
                    int tran = transientResult.getInt(1);
                    if (pers != tran) break block13;
                    Object var8_9 = null;
                    if (persistentResult == null) break block14;
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    if (persistentResult != null) {
                        persistentResult.close();
                        persistentResult = null;
                    }
                    if (transientResult == null) throw throwable;
                    transientResult.close();
                    throw throwable;
                }
                persistentResult.close();
                persistentResult = null;
            }
            if (transientResult == null) return;
            transientResult.close();
            return;
        }
        Object var8_10 = null;
        if (persistentResult != null) {
            persistentResult.close();
            persistentResult = null;
        }
        if (transientResult != null) {
            transientResult.close();
        }
        try {
            transientStmt = dbConnection.getDeliveryPreparedStmt(6, 1);
            transientStmt.executeUpdate();
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            persistentStmt = dbConnection.getPersistentPreparedStmt(12);
            persistentResult = persistentStmt.executeQuery();
            transientStmt = dbConnection.getDeliveryPreparedStmt(4, 1);
            int countAddBatch = 0;
            while (persistentResult.next()) {
                transientStmt.setLong(1, persistentResult.getLong(1));
                transientStmt.setString(2, persistentResult.getString(2));
                transientStmt.setLong(3, persistentResult.getLong(3));
                transientStmt.setInt(4, persistentResult.getInt(4));
                transientStmt.setInt(5, persistentResult.getInt(5));
                transientStmt.setString(6, persistentResult.getString(6));
                transientStmt.setString(7, persistentResult.getString(7));
                transientStmt.setInt(8, persistentResult.getInt(8));
                transientStmt.addBatch();
                if (++countAddBatch % 100 != 0) continue;
                transientStmt.executeBatchGetRowCount();
                countAddBatch = 0;
            }
            if (countAddBatch > 0) {
                transientStmt.executeBatchGetRowCount();
            }
            dbConnection.commit();
            return;
        }
        finally {
            if (persistentResult != null) {
                persistentResult.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initInactiveConsumers(UserConnection dbConnection) throws InvalidSelectorException, SQLException {
        ResultSet persistentResult = null;
        DeliveryPreparedStmt persistentStmt = null;
        try {
            persistentStmt = dbConnection.getPersistentPreparedStmt(12);
            persistentResult = persistentStmt.executeQuery();
            while (persistentResult.next()) {
                if (persistentResult.getInt(5) != 1) continue;
                MessageConsumerInfo consumerInfo = new MessageConsumerInfo();
                consumerInfo.setClientSessionAddress(null);
                consumerInfo.setMessageListener(null);
                consumerInfo.setConsumerID(persistentResult.getLong(1));
                consumerInfo.setDestinationID(persistentResult.getLong(3));
                consumerInfo.setType(persistentResult.getInt(4));
                consumerInfo.setMsgSelector(persistentResult.getString(7));
                consumerInfo.setNoLocal(persistentResult.getInt(8) == 1);
                consumerInfo.setSubscription(persistentResult.getString(6));
                ConsumerList.addInactiveConsumer(consumerInfo.getConsumerID(), consumerInfo);
            }
            dbConnection.commit();
        }
        finally {
            if (persistentResult != null) {
                persistentResult.close();
            }
        }
    }

    public static ConsumerEntity CreateConsumer(long consumerID) {
        ConsumerEntity retval = new ConsumerEntity();
        retval.setID(consumerID);
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterAndCommit(UserConnection dbConnection, SendingNotificationQueue sendingQueue, long consumerID, StreamString clientID, boolean remove) throws JMSException, SQLException {
        boolean res = false;
        MessageConsumerInfo consumerInfo = null;
        SendOrderTable.lockSendOrders(dbConnection, 2);
        SendOrderTable.lockSendOrders(dbConnection, 1);
        Class clazz = ConsumerList.class;
        synchronized (clazz) {
            if (myVerbose) {
                Server.log("removeAllNotificationsForConsumer:" + consumerID);
            }
            sendingQueue.removeAllNotificationsForConsumer(consumerID);
            consumerInfo = ConsumerList.getActiveConsumer(consumerID);
            if (consumerInfo == null) {
                consumerInfo = ConsumerList.getInactiveConsumer(consumerID);
            }
            if (consumerInfo == null) {
                Server.log(Thread.currentThread().toString() + ":No consumer with ID <" + consumerID + "> registered by the Server");
                return;
            }
            if (clientID.getString() != null && clientID.getString().length() > 1 && !ConsumerList.checkClientID(clientID, consumerInfo)) {
                return;
            }
            consumerInfo = ConsumerList.removeActiveConsumer(consumerID);
            if (consumerInfo == null) {
                consumerInfo = ConsumerList.removeDeletedConsumer(consumerID);
            }
            if (consumerInfo == null) {
                Server.log(Thread.currentThread().toString() + ":No consumer with ID <" + consumerID + "> registered by the Server");
                return;
            }
            ConsumerList.resetSendOrders(dbConnection, consumerID, consumerInfo.isQueueReceiver(), remove && consumerInfo.getType() != 2);
            ConsumerList.resetActiveFlag(dbConnection, consumerID, consumerInfo.getDestinationID(), consumerInfo.isQueueReceiver(), false);
            if (!remove || consumerInfo.getType() == 2) {
                res = ConsumerList.changeConsumerState(dbConnection, consumerID, 1);
                ConsumerList.addInactiveConsumer(consumerID, consumerInfo);
                if (!res) {
                    throw new JMSException("Could not deactivate consumer with ID <" + consumerID + ">");
                }
            } else {
                SyncReceiveHandler.removePendingConsumer(consumerID);
                res = ConsumerList.deleteByID(dbConnection, consumerID);
                if (!res) {
                    throw new JMSException("Could not delete Consumer with ID <" + consumerID + ">");
                }
            }
            dbConnection.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unsubscribe(UserConnection dbConnection, SendingNotificationQueue sendingQueue, long consumerID) throws JMSException, SQLException {
        SendOrderTable.lockSendOrders(dbConnection, 2);
        SendOrderTable.lockSendOrders(dbConnection, 1);
        Class clazz = ConsumerList.class;
        synchronized (clazz) {
            if (myVerbose) {
                Server.log("removeAllNotificationsForConsumer:" + consumerID);
            }
            sendingQueue.removeAllNotificationsForConsumer(consumerID);
            MessageConsumerInfo consumerInfo = ConsumerList.removeActiveConsumer(consumerID);
            if (consumerInfo != null) {
                throw new JMSException("Subscriber with ID <" + consumerID + "> still active, close session or subscriber first");
            }
            MessageConsumerInfo consumerInfo2 = ConsumerList.removeDeletedConsumer(consumerID);
            if (consumerInfo2 == null) {
                throw new JMSException("No subscriber with ID <" + consumerID + ">");
            }
            SyncReceiveHandler.removePendingConsumer(consumerID);
            boolean res = false;
            ConsumerList.resetSendOrders(dbConnection, consumerID, false, true);
            ConsumerList.resetActiveFlag(dbConnection, consumerID, consumerInfo2.getDestinationID(), consumerInfo2.isQueueReceiver(), false);
            res = ConsumerList.deleteByID(dbConnection, consumerID);
            if (!res) {
                throw new JMSException("Could not deactive Subscription for consumer <" + consumerID + ">");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long register(UserConnection dbConnection, String destinationName, String subscription, StreamString clientID, String sessionQueueID, Integer sessionListenerID, boolean isQueue, boolean isDurable, long consumerID, String msgSelector, boolean isActive, boolean bNoLocal) throws SQLException, JMSException {
        Object object;
        if (isActive) {
            object = ConsumerList.getSendOrderSync();
            synchronized (object) {
                SendOrderTable.lockSendOrders(dbConnection, 2);
                SendOrderTable.lockSendOrders(dbConnection, 1);
            }
        }
        object = ConsumerList.class;
        synchronized (object) {
            ConsumerEntity consumer;
            int state;
            boolean bDurableExists = false;
            long destinationID = DestinationList.getDestinationID(destinationName, isQueue);
            if (destinationID < 0L) {
                throw new JMSException("Destination " + destinationName + " not found");
            }
            ClientSessionAddress clientSessionAddress = new ClientSessionAddress();
            clientSessionAddress.setAddress(clientID, sessionQueueID);
            int type = isQueue ? 1 : (isDurable ? 2 : 0);
            int n = state = isActive ? 2 : 1;
            if (type == 2) {
                consumer = ConsumerList.loadFromDb(dbConnection, subscription, destinationID);
                if (consumer != null) {
                    int oldstate = consumer.getState();
                    if (oldstate == 0 || consumer.getDestination() != destinationID || !consumer.getMessageSelector().equals(msgSelector)) {
                        long rowCount = SendOrderTable.deleteTopicOrdersForConsumer(dbConnection, 2, consumer.getID());
                        Server.log(Thread.currentThread().toString() + ":ConsumerList: Deleted " + (rowCount += (long)SendOrderTable.deleteTopicOrdersForConsumer(dbConnection, 1, consumer.getID())) + " sendorders for durable consumer <" + consumer.getID() + ">\n");
                    }
                    if (oldstate == 2) {
                        throw new JMSException("ConsumerList : Active subscription <" + subscription + "> with ID <" + consumer.getID() + "> for destination <" + destinationID + "> already exists");
                    }
                    if (oldstate == 1) {
                        bDurableExists = true;
                    }
                } else {
                    consumer = ConsumerList.CreateConsumer(consumerID);
                }
            } else {
                consumer = ConsumerList.CreateConsumer(consumerID);
            }
            MessageConsumerInfo consumerInfo = new MessageConsumerInfo();
            consumerInfo.setClientSessionAddress(clientSessionAddress);
            consumerInfo.setMessageListener(sessionListenerID);
            consumerInfo.setConsumerID(consumer.getID());
            consumerInfo.setDestinationID(destinationID);
            consumerInfo.setType(type);
            consumerInfo.setMsgSelector(msgSelector);
            consumerInfo.setNoLocal(bNoLocal);
            consumerInfo.setSubscription(subscription);
            consumer.setClient(consumerInfo.getClientAsString());
            consumer.setDestination(destinationID);
            consumer.setType(type);
            consumer.setSubscription(subscription);
            consumer.setMessageSelector(msgSelector);
            consumer.setState(state);
            consumer.setNoLocal(bNoLocal);
            if (isActive || bDurableExists) {
                int updates = ConsumerList.update(dbConnection, consumer);
                if (updates >= 0 && updates != 1) {
                    throw new JMSException("Could not update client address for inactive consumer  with ID " + consumer.getID() + " for destination " + destinationID);
                }
                if (isActive) {
                    ConsumerList.addActiveConsumer(dbConnection, consumerInfo);
                } else {
                    ConsumerList.addInactiveConsumer(consumer.getID(), consumerInfo);
                }
            } else {
                ConsumerList.addInactiveConsumer(consumer.getID(), consumerInfo);
                ConsumerList.persist(dbConnection, consumer);
            }
            return consumer.getID();
        }
    }

    private static synchronized boolean resetActiveFlag(UserConnection dbConnection, long consumerID, long destID, boolean isQueueReceiver, boolean active) throws SQLException {
        boolean isSendorderActivated = false;
        String sText = "";
        sText = active ? "Activated " : "Deactivated ";
        if (!ConsumerList.hasActiveConsumer(isQueueReceiver, consumerID, destID)) {
            int rowCount = 0;
            if (isQueueReceiver) {
                int rows = SendOrderTable.setSendOrdersActiveForQueueDestination(dbConnection, 2, destID, active);
                rowCount += rows;
                Server.log(Thread.currentThread().toString() + ":ConsumerList: " + sText + rows + " persistent sendorders for Destination <" + destID + ">");
                rows = SendOrderTable.setSendOrdersActiveForQueueDestination(dbConnection, 1, destID, active);
                rowCount += rows;
                Server.log(Thread.currentThread().toString() + ":ConsumerList: " + sText + rows + " non persistent sendorders for Destination <" + destID + ">");
            } else {
                int rows = SendOrderTable.setSendOrdersActiveForTopicConsumer(dbConnection, 2, consumerID, active);
                rowCount += rows;
                Server.log(Thread.currentThread().toString() + ":ConsumerList: " + sText + rows + " persistent sendorders for Consumer <" + consumerID + ">");
                rows = SendOrderTable.setSendOrdersActiveForTopicConsumer(dbConnection, 1, consumerID, active);
                rowCount += rows;
                Server.log(Thread.currentThread().toString() + ": ConsumerList: " + sText + rows + " non persistent sendorders for Consumer <" + consumerID + ">");
            }
            if (active && rowCount > 0) {
                isSendorderActivated = true;
            }
        }
        return isSendorderActivated;
    }

    private static synchronized void resetSendOrders(UserConnection dbConnection, long consumerID, boolean isQueue, boolean deleteTopicOrder) throws SQLException {
        long rows = 0L;
        if (isQueue) {
            rows = SendOrderTable.resetQueueOrdersForConsumer(dbConnection, 2, consumerID);
            Server.log(Thread.currentThread().toString() + ":ConsumerList: Reset " + (rows += (long)SendOrderTable.resetQueueOrdersForConsumer(dbConnection, 1, consumerID)) + " queue orders for Consumer <" + consumerID + ">");
        } else if (deleteTopicOrder) {
            rows = SendOrderTable.deleteTopicOrdersForConsumer(dbConnection, 2, consumerID);
            Server.log(Thread.currentThread().toString() + ":ConsumerList: Deleted " + (rows += (long)SendOrderTable.deleteTopicOrdersForConsumer(dbConnection, 1, consumerID)) + " topic orders for Consumer <" + consumerID + ">");
        } else {
            rows = SendOrderTable.resetTopicOrdersForConsumer(dbConnection, 2, consumerID);
            Server.log(Thread.currentThread().toString() + ":ConsumerList: Reset " + (rows += (long)SendOrderTable.resetTopicOrdersForConsumer(dbConnection, 1, consumerID)) + " topic orders for Consumer <" + consumerID + ">");
        }
    }

    private static boolean checkClientID(StreamString clientID, MessageConsumerInfo consumerInfo) {
        StreamString consumerClientID = consumerInfo.getClientSessionAddress().toStreamString();
        if (myVerbose) {
            Server.log(Thread.currentThread().toString() + ":Requested client id <" + clientID.toString() + ">, consumer client id <" + consumerClientID.toString() + ">");
        }
        if (clientID != null && consumerClientID != null) {
            if (!clientID.equals(consumerClientID)) {
                Server.log(Thread.currentThread().toString() + ":Requested client id <" + clientID.toString() + "> does not equal consumer client id <" + consumerClientID.toString() + ">");
                return false;
            }
        } else {
            if (clientID != null) {
                Server.log(Thread.currentThread().toString() + ":Invalid requested client id: " + clientID);
            }
            if (consumerClientID != null) {
                Server.log(Thread.currentThread().toString() + ":Invalid consumer client id: " + consumerClientID);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryUnregisterActiveConsumers(StreamString clientID, JmsService service) {
        if (clientID == null) {
            return;
        }
        MessageConsumerInfo[] unregisterConsumerList = null;
        int countUnregisterConsumer = 0;
        Class clazz = ConsumerList.class;
        synchronized (clazz) {
            unregisterConsumerList = new MessageConsumerInfo[ConsumerList.getInstance().myActiveConsumers.size()];
            Enumeration enumeration = ConsumerList.getInstance().myActiveConsumers.elements();
            while (enumeration.hasMoreElements()) {
                MessageConsumerInfo consumerInfo = (MessageConsumerInfo)enumeration.nextElement();
                StreamString consumerClientID = consumerInfo.getClientSessionAddress().getClientID();
                if (!clientID.equals(consumerClientID)) continue;
                unregisterConsumerList[countUnregisterConsumer] = consumerInfo;
                ++countUnregisterConsumer;
            }
        }
        if (countUnregisterConsumer < 1) {
            return;
        }
        UserConnection dbConnection = null;
        try {
            dbConnection = DBConnectionPool.useConnection();
            for (int i = 0; i < countUnregisterConsumer; ++i) {
                ConsumerList.unregisterAndCommit(dbConnection, service.getSendingQueue(), unregisterConsumerList[i].getConsumerID(), unregisterConsumerList[i].getClientSessionAddress().toStreamString(), false);
            }
        }
        catch (SQLException ex) {
            JmsService.logException(ex);
        }
        catch (JMSException ex) {
            JmsService.logException((Exception)((Object)ex));
        }
        finally {
            DBConnectionPool.returnConnection(dbConnection);
        }
    }
}

