/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.client;

import com.sap.sdb.msgServer.client.MessageConsumerImpl;
import com.sap.sdb.msgServer.client.SessionImpl;
import com.sap.sdb.msgServer.util.ActivateAdminNotification;
import com.sap.sdb.msgServer.util.NotificationException;
import javax.jms.JMSException;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;

public class TopicSubscriberImpl
extends MessageConsumerImpl
implements TopicSubscriber {
    private Topic myTopic;
    private boolean myNoLocal = false;

    public TopicSubscriberImpl(Topic topic, SessionImpl session, boolean isDurable, String subscription, String msgSelector, boolean bNoLocal) throws JMSException {
        super(session, msgSelector);
        this.myTopic = topic;
        this.myIsDurable = isDurable;
        this.mySubscription = subscription;
        this.myNoLocal = bNoLocal;
        ActivateAdminNotification command = new ActivateAdminNotification(topic.getTopicName(), subscription, session.getNetworkHandler().getClientID(), null, this.getID(), false, isDurable, this.myServerSideConsumerID, msgSelector, session.getConnection().isStarted(), this.myNoLocal);
        try {
            this.myServerSideConsumerID = this.mySession.getNetworkHandler().requestID(command);
        }
        catch (NotificationException ex) {
            throw new JMSException("Unable to get a consumer id for topic subscriber from the server: " + ex);
        }
    }

    public boolean getNoLocal() throws JMSException {
        return this.myNoLocal;
    }

    public Topic getTopic() throws JMSException {
        return this.myTopic;
    }

    protected String getName() throws JMSException {
        return this.myTopic.getTopicName();
    }

    protected boolean getIsDurable() {
        return this.myIsDurable;
    }

    protected String getDurableSubscription() {
        return this.mySubscription;
    }

    protected int getType() {
        return 1;
    }
}

