/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.client;

import com.sap.sdb.msgServer.client.MessageImpl;
import com.sap.sdb.msgServer.util.ReceiveRetryStream;
import com.sap.sdb.msgServer.util.ReceiveStream;
import com.sap.sdb.msgServer.util.SendStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.StreamMessage;

public class StreamMessageImpl
extends MessageImpl
implements StreamMessage {
    private ByteArrayOutputStream m_outputByteStream;
    private SendStream m_outStream;
    private ReceiveRetryStream m_inStream;
    private byte[] m_inStreamContents;
    private static final int INITIAL_OUTBUF_SIZE = 1024;

    public StreamMessageImpl() {
        super(4);
        this.m_inStream = null;
        this.m_inStreamContents = null;
        this.m_outputByteStream = null;
        this.m_outStream = null;
    }

    public StreamMessageImpl(long messageID, boolean isQueueMessage) throws JMSException {
        super(messageID, isQueueMessage, 4);
        this.setWriteOnly();
        this.m_inStream = null;
        this.m_inStreamContents = null;
        this.m_outputByteStream = new ByteArrayOutputStream(1024);
        try {
            this.m_outStream = new SendStream(this.m_outputByteStream);
        }
        catch (IOException e) {
            throw this.getJMSException(e);
        }
    }

    public void clearBody() throws JMSException {
        this.setWriteOnly();
        try {
            if (this.m_inStream != null) {
                this.m_inStream.close();
            }
            this.m_outStream = null;
            this.m_inStream = null;
            this.m_inStreamContents = null;
            if (this.m_outputByteStream == null) {
                this.m_outputByteStream = new ByteArrayOutputStream(1024);
            } else {
                this.m_outputByteStream.reset();
            }
            this.m_outStream = new SendStream(this.m_outputByteStream);
        }
        catch (IOException e) {
            throw this.getJMSException(e);
        }
    }

    public boolean readBoolean() throws JMSException {
        this.checkForRead();
        return this.m_inStream.readBooleanType();
    }

    public byte readByte() throws JMSException {
        this.checkForRead();
        return this.m_inStream.readByteType();
    }

    public int readBytes(byte[] byteArray) throws JMSException {
        this.checkForRead();
        return this.m_inStream.readByteArrayType(byteArray, 0, byteArray.length);
    }

    public char readChar() throws JMSException {
        this.checkForRead();
        return this.m_inStream.readCharType();
    }

    public double readDouble() throws JMSException {
        this.checkForRead();
        return this.m_inStream.readDoubleType();
    }

    public float readFloat() throws JMSException {
        this.checkForRead();
        return this.m_inStream.readFloatType();
    }

    public int readInt() throws JMSException {
        this.checkForRead();
        return this.m_inStream.readIntType();
    }

    public long readLong() throws JMSException {
        this.checkForRead();
        return this.m_inStream.readLongType();
    }

    public Object readObject() throws JMSException {
        this.checkForRead();
        return this.m_inStream.readObjectType();
    }

    public short readShort() throws JMSException {
        this.checkForRead();
        return this.m_inStream.readShortType();
    }

    public String readString() throws JMSException {
        this.checkForRead();
        return this.m_inStream.readStringType();
    }

    public void reset() throws JMSException {
        this.setReadOnly();
        try {
            if (this.m_outputByteStream != null && this.m_outStream != null) {
                this.m_outStream.flush();
                this.m_inStreamContents = this.m_outputByteStream.toByteArray();
                this.m_outStream.close();
            }
            this.m_outStream = null;
            this.m_outputByteStream = null;
            this.m_inStream = null;
            ByteArrayInputStream byteStream = new ByteArrayInputStream(this.m_inStreamContents);
            this.m_inStream = new ReceiveRetryStream(byteStream);
        }
        catch (IOException e) {
            throw this.getJMSException(e);
        }
    }

    public void writeBoolean(boolean value) throws JMSException {
        this.checkForWrite();
        try {
            this.m_outStream.writeTypeBoolean(value);
        }
        catch (IOException e) {
            throw this.getJMSException(e);
        }
    }

    public void writeByte(byte value) throws JMSException {
        this.checkForWrite();
        try {
            this.m_outStream.writeTypeByte(value);
        }
        catch (IOException e) {
            throw this.getJMSException(e);
        }
    }

    public void writeBytes(byte[] value) throws JMSException {
        this.checkForWrite();
        try {
            this.m_outStream.writeTypeByteArray(value);
        }
        catch (IOException e) {
            throw this.getJMSException(e);
        }
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        this.checkForWrite();
        try {
            this.m_outStream.writeTypeByteArray(value, offset, length);
        }
        catch (IOException e) {
            throw this.getJMSException(e);
        }
    }

    public void writeChar(char value) throws JMSException {
        this.checkForWrite();
        try {
            this.m_outStream.writeTypeChar(value);
        }
        catch (IOException e) {
            throw this.getJMSException(e);
        }
    }

    public void writeDouble(double value) throws JMSException {
        this.checkForWrite();
        try {
            this.m_outStream.writeTypeDouble(value);
        }
        catch (IOException e) {
            throw this.getJMSException(e);
        }
    }

    public void writeFloat(float value) throws JMSException {
        this.checkForWrite();
        try {
            this.m_outStream.writeTypeFloat(value);
        }
        catch (IOException e) {
            throw this.getJMSException(e);
        }
    }

    public void writeInt(int value) throws JMSException {
        this.checkForWrite();
        try {
            this.m_outStream.writeTypeInt(value);
        }
        catch (IOException e) {
            throw this.getJMSException(e);
        }
    }

    public void writeLong(long value) throws JMSException {
        this.checkForWrite();
        try {
            this.m_outStream.writeTypeLong(value);
        }
        catch (IOException e) {
            throw this.getJMSException(e);
        }
    }

    public void writeObject(Object obj) throws JMSException {
        this.checkForWrite();
        try {
            if (!this.m_outStream.writeSpecialObject(obj)) {
                throw new MessageFormatException("invalid object" + obj.toString());
            }
        }
        catch (IOException e) {
            throw this.getJMSException(e);
        }
    }

    public void writeShort(short value) throws JMSException {
        this.checkForWrite();
        try {
            this.m_outStream.writeTypeShort(value);
        }
        catch (IOException e) {
            throw this.getJMSException(e);
        }
    }

    public void writeString(String value) throws JMSException {
        this.checkForWrite();
        try {
            this.m_outStream.writeString(value);
        }
        catch (IOException e) {
            throw this.getJMSException(e);
        }
    }

    private JMSException getJMSException(IOException e) {
        JMSException jmsException = new JMSException(e.getMessage());
        jmsException.setLinkedException((Exception)e);
        return jmsException;
    }

    void readMessageContentsFromStream(ReceiveStream in) throws IOException {
        this.m_inStreamContents = in.readByteArray();
        ByteArrayInputStream byteStream = new ByteArrayInputStream(this.m_inStreamContents);
        this.m_inStream = new ReceiveRetryStream(byteStream);
    }

    void writeMessageContentsToStream(SendStream out) throws IOException {
        this.m_outStream.flush();
        out.writeByteArray(this.m_outputByteStream);
    }
}

