/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.client;

import com.sap.sdb.msgServer.client.BytesMessageImpl;
import com.sap.sdb.msgServer.client.ClientNetworkHandler;
import com.sap.sdb.msgServer.client.ClientOID;
import com.sap.sdb.msgServer.client.ConnectionImpl;
import com.sap.sdb.msgServer.client.MapMessageImpl;
import com.sap.sdb.msgServer.client.MessageConsumerImpl;
import com.sap.sdb.msgServer.client.MessageImpl;
import com.sap.sdb.msgServer.client.MessageProducerImpl;
import com.sap.sdb.msgServer.client.ObjectMessageImpl;
import com.sap.sdb.msgServer.client.QueueBrowserImpl;
import com.sap.sdb.msgServer.client.QueueReceiverImpl;
import com.sap.sdb.msgServer.client.QueueSenderImpl;
import com.sap.sdb.msgServer.client.SessionThread;
import com.sap.sdb.msgServer.client.StreamMessageImpl;
import com.sap.sdb.msgServer.client.TemporaryQueueImpl;
import com.sap.sdb.msgServer.client.TemporaryTopicImpl;
import com.sap.sdb.msgServer.client.TextMessageImpl;
import com.sap.sdb.msgServer.client.TopicPublisherImpl;
import com.sap.sdb.msgServer.client.TopicSubscriberImpl;
import com.sap.sdb.msgServer.util.AckOneMessageByClientNotification;
import com.sap.sdb.msgServer.util.ClientEndTransNotification;
import com.sap.sdb.msgServer.util.MessageNotification;
import com.sap.sdb.msgServer.util.NotificationException;
import com.sap.sdb.msgServer.util.SendOrderKey;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueSender;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSubscriber;

public class SessionImpl
implements Session {
    private ConnectionImpl myConnection;
    private boolean myIsTransacted;
    private int myAcknowledgeMode;
    private boolean myIAmAQueueSession;
    private boolean myIsClosed;
    private Thread myProducerThread;
    private SessionThread myReceiverThread;
    private Hashtable myConsumers;
    private Hashtable myDurableConsumers;
    private Vector myProducers;
    private Vector myFreeAutoAckByClientNot;
    private ClientEndTransNotification myCurrentTransNotification;
    private Object myTransSynchronizeSection;
    private Object myCommitRollbSynchronizeSection;
    private ClientEndTransNotification myEndTransNotification1;
    private ClientEndTransNotification myEndTransNotification2;
    public static final int NIL_TRANS_ID = -1;

    public SessionImpl(ConnectionImpl connection, boolean transacted, boolean iAmAQueueSession, int acknowledgeMode) throws JMSException {
        this.myConnection = connection;
        this.myIsTransacted = transacted;
        this.myAcknowledgeMode = acknowledgeMode == 2 || acknowledgeMode == 3 ? acknowledgeMode : 1;
        this.myIAmAQueueSession = iAmAQueueSession;
        this.myIsClosed = false;
        this.myProducerThread = null;
        this.myReceiverThread = null;
        this.myConsumers = new Hashtable(100);
        this.myDurableConsumers = new Hashtable(100);
        this.myProducers = new Vector(100);
        if (transacted || acknowledgeMode == 2) {
            this.myFreeAutoAckByClientNot = null;
            this.myEndTransNotification1 = new ClientEndTransNotification(100);
            this.myEndTransNotification2 = new ClientEndTransNotification(100);
            this.myCurrentTransNotification = this.myEndTransNotification1;
            this.myTransSynchronizeSection = new Object();
            this.myCommitRollbSynchronizeSection = new Object();
            this.initNewTransaction();
        } else {
            this.myFreeAutoAckByClientNot = new Vector(100);
            this.myEndTransNotification1 = null;
            this.myEndTransNotification2 = null;
            this.myCurrentTransNotification = null;
            this.myTransSynchronizeSection = null;
            this.myCommitRollbSynchronizeSection = null;
        }
    }

    public void close() throws JMSException {
        this.stopAsyncConsumer(true);
        if (this.isTransactedMsgReceive()) {
            this.rollback();
        }
        this.myIsClosed = true;
    }

    public void commit() throws JMSException {
        this.commitRollbackHandling(1);
    }

    public BytesMessage createBytesMessage() throws JMSException {
        this.checkSessionState();
        return new BytesMessageImpl(ClientOID.getNext(), this.myIAmAQueueSession);
    }

    public MapMessage createMapMessage() throws JMSException {
        this.checkSessionState();
        return new MapMessageImpl(ClientOID.getNext(), this.myIAmAQueueSession);
    }

    public Message createMessage() throws JMSException {
        this.checkSessionState();
        return new MessageImpl(ClientOID.getNext(), this.myIAmAQueueSession);
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        this.checkSessionState();
        return new ObjectMessageImpl(ClientOID.getNext(), this.myIAmAQueueSession);
    }

    public ObjectMessage createObjectMessage(Serializable obj) throws JMSException {
        this.checkSessionState();
        ObjectMessageImpl aObj = new ObjectMessageImpl(ClientOID.getNext(), this.myIAmAQueueSession);
        aObj.setObject(obj);
        return aObj;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        this.checkSessionState();
        return new StreamMessageImpl(ClientOID.getNext(), this.myIAmAQueueSession);
    }

    public TextMessage createTextMessage() throws JMSException {
        this.checkSessionState();
        return new TextMessageImpl(ClientOID.getNext(), this.myIAmAQueueSession, "");
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        this.checkSessionState();
        return new TextMessageImpl(ClientOID.getNext(), this.myIAmAQueueSession, text);
    }

    public MessageListener getMessageListener() throws JMSException {
        this.checkSessionState();
        throw new UnsupportedOperationException("Method getMessageListener() not supported by this JSM Server, use getMessageListener from MessageConsumer.");
    }

    public boolean getTransacted() throws JMSException {
        this.checkSessionState();
        return this.myIsTransacted;
    }

    public void recover() throws JMSException {
        this.checkSessionState();
        throw new UnsupportedOperationException("Method recover() not yet implemented.");
    }

    public void rollback() throws JMSException {
        if (this.myConnection.isStarted()) {
            ExceptionListener listener = null;
            try {
                listener = this.getConnection().getExceptionListener();
            }
            catch (JMSException ex2) {
                ex2.printStackTrace();
                this.getNetworkHandler().log("Unexpected exception in class SessionImpl/rollback: " + (Object)((Object)ex2));
            }
            if (listener != null) {
                listener.onException(new JMSException("Warning: Connection is not stopped."));
            }
        }
        this.commitRollbackHandling(0);
    }

    public void run() {
        throw new UnsupportedOperationException("Method run() not yet implemented.");
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        throw new UnsupportedOperationException("Method setMessageListener() not supported by this JSM Server, use setMessageListener from MessageConsumer.");
    }

    protected void acknowledgeReceivedMsg(MessageNotification msg) throws JMSException {
        if (this.isTransactedMsgReceive()) {
            this.acknowledgeReceivedTransactionMsg(msg);
            return;
        }
        this.sendAutoAcknowledgeIfRequired(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void acknowledgeReceivedTransactionMsg(MessageNotification msg) throws JMSException {
        msg.getMessage().setAcknowledgeSession(this);
        SendOrderKey aSendOrderKey = new SendOrderKey(msg.getMessage().getMessageID(), msg.getMessageConsumerInfo().getConsumerID(), msg.getMessage().isQueueMessage());
        Object object = this.myTransSynchronizeSection;
        synchronized (object) {
            this.myCurrentTransNotification.addReceivedMessage(aSendOrderKey, msg.getMessage().getJMSDeliveryMode());
        }
    }

    protected void addDurableMessageConsumer(MessageConsumerImpl consumer, String subscriptionName) throws JMSException {
        if (this.myDurableConsumers.get(subscriptionName) != null && this.myConsumers.get(consumer.getID()) != null) {
            throw new JMSException("Durable subscription " + subscriptionName + "already exists");
        }
        this.myDurableConsumers.put(subscriptionName, consumer);
        this.addMessageConsumer(consumer);
    }

    protected void addMessageConsumer(MessageConsumerImpl consumer) {
        this.myConsumers.put(consumer.getID(), consumer);
    }

    protected int getMessageConsumerCount() {
        return this.myConsumers.size();
    }

    protected void addMessageProducer(MessageProducerImpl producer) {
        this.myProducers.add(producer);
    }

    protected void checkSessionState() throws JMSException {
        if (this.myIsClosed) {
            throw new IllegalStateException("Session is closed");
        }
        if (Thread.currentThread().equals(this.myReceiverThread)) {
            throw new IllegalStateException("Function call not allowed in Session Thread");
        }
    }

    protected void checkConnectionState() throws JMSException {
        if (this.getConnection().isStarted()) {
            throw new IllegalStateException("Connection is started.");
        }
    }

    protected void checkSessionClosed() throws JMSException {
        if (this.myIsClosed) {
            throw new IllegalStateException("Session is closed");
        }
    }

    void checkIfQueueIsInUse(Queue queue) throws JMSException {
        Enumeration keys = this.myConsumers.keys();
        while (keys.hasMoreElements()) {
            Integer key = (Integer)keys.nextElement();
            QueueReceiverImpl consumer = (QueueReceiverImpl)this.myConsumers.get(key);
            if (!consumer.getQueue().getQueueName().equals(queue.getQueueName())) continue;
            throw new JMSException("Queue " + queue.getQueueName() + " used by " + consumer.getID().toString());
        }
    }

    void checkIfTopicIsInUse(Topic topic) throws JMSException {
        Enumeration keys = this.myConsumers.keys();
        while (keys.hasMoreElements()) {
            Integer key = (Integer)keys.nextElement();
            TopicSubscriberImpl consumer = (TopicSubscriberImpl)this.myConsumers.get(key);
            if (!consumer.getTopic().getTopicName().equals(topic.getTopicName())) continue;
            throw new JMSException("Topic " + topic.getTopicName() + " used by " + consumer.getID().toString());
        }
    }

    private void checkProducer() throws JMSException {
        if (this.myProducerThread == null) {
            this.setProducerThread();
        }
        if (this.myProducerThread != Thread.currentThread()) {
            throw new JMSException("session methods are executed multi-threaded");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitRollbackHandling(int commitRollbType) throws JMSException {
        if (!this.isTransactedMsgReceive()) {
            throw new IllegalStateException("Session is not in transaction mode");
        }
        this.checkSessionClosed();
        Object object = this.myCommitRollbSynchronizeSection;
        synchronized (object) {
            ClientEndTransNotification endTransNotification;
            Object object2 = this.myTransSynchronizeSection;
            synchronized (object2) {
                endTransNotification = this.myCurrentTransNotification;
                this.myCurrentTransNotification = this.myCurrentTransNotification == this.myEndTransNotification1 ? this.myEndTransNotification2 : this.myEndTransNotification1;
                this.initNewTransaction();
            }
            if (!endTransNotification.isEmptyAtClientSide()) {
                endTransNotification.setType(commitRollbType);
                try {
                    this.myConnection.getNetworkHandler().requestOK(endTransNotification);
                }
                catch (NotificationException ex) {
                    throw new JMSException("Unable to send a message to the server:" + ex);
                }
                catch (InterruptedException ex) {
                    throw new JMSException("Unable to send a message to the server:" + ex);
                }
            }
        }
    }

    boolean existAsyncConsumer() throws JMSException {
        Enumeration keys = this.myConsumers.keys();
        while (keys.hasMoreElements()) {
            Integer key = (Integer)keys.nextElement();
            if (((MessageConsumerImpl)this.myConsumers.get(key)).getMessageListener() == null) continue;
            return true;
        }
        return false;
    }

    private void freeAutoAckByClient(AckOneMessageByClientNotification ackNot) {
        this.myFreeAutoAckByClientNot.add(ackNot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AckOneMessageByClientNotification getAutoAckByClientNot(long messageID, long consumerID, int modeDelivery, boolean isQueueMessage) {
        AckOneMessageByClientNotification ackNotification = null;
        Vector vector = this.myFreeAutoAckByClientNot;
        synchronized (vector) {
            if (this.myFreeAutoAckByClientNot.size() > 0) {
                ackNotification = (AckOneMessageByClientNotification)this.myFreeAutoAckByClientNot.remove(0);
            }
        }
        if (ackNotification != null) {
            ackNotification.setMessageID(messageID);
            ackNotification.setConsumerID(consumerID);
            ackNotification.setDeliveryMode(modeDelivery);
            ackNotification.setIsQueueMessage(isQueueMessage);
            return ackNotification;
        }
        return new AckOneMessageByClientNotification(1, modeDelivery, messageID, consumerID, isQueueMessage);
    }

    ConnectionImpl getConnection() {
        return this.myConnection;
    }

    boolean getIsClosed() {
        return this.myIsClosed;
    }

    MessageListener getMessageListener(Integer id) throws JMSException {
        Enumeration keys = this.myConsumers.keys();
        while (keys.hasMoreElements()) {
            Integer key = (Integer)keys.nextElement();
            if (!id.equals(key)) continue;
            return ((MessageConsumerImpl)this.myConsumers.get(key)).getMessageListener();
        }
        return null;
    }

    public ClientNetworkHandler getNetworkHandler() {
        return this.myConnection.getNetworkHandler();
    }

    public String getQueueID() {
        return this.myReceiverThread.getQueueID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getTransactionID() {
        if (!this.myIsTransacted) {
            return -1L;
        }
        Object object = this.myTransSynchronizeSection;
        synchronized (object) {
            return this.myCurrentTransNotification.getTransactionID();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrSentTransactionMsg(int modeDelivery) throws JMSException {
        this.checkProducer();
        if (this.myIsTransacted) {
            Object object = this.myTransSynchronizeSection;
            synchronized (object) {
                this.myCurrentTransNotification.incrSentMessage(modeDelivery);
            }
        }
    }

    private void initNewTransaction() {
        long transactionID = this.myIsTransacted ? ClientOID.getNext() : -1L;
        this.myCurrentTransNotification.initForWrite(transactionID);
    }

    public boolean isImmediateSendAcknowledge() {
        return this.myAcknowledgeMode == 1;
    }

    public boolean isTransactedMsgReceive() {
        return this.myIsTransacted || this.myAcknowledgeMode == 2;
    }

    protected MessageConsumerImpl removeMessageConsumer(Integer clientSideConsumerID) throws JMSException {
        return (MessageConsumerImpl)this.myConsumers.remove(clientSideConsumerID);
    }

    protected MessageConsumerImpl getMessageConsumer(Integer clientSideConsumerID) {
        return (MessageConsumerImpl)this.myConsumers.get(clientSideConsumerID);
    }

    protected boolean isReceivingQueueDeactivated() {
        return this.myReceiverThread.isQueueDeactivated();
    }

    void removeMessageProducer(MessageProducerImpl producer) {
        this.myProducers.remove(producer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAutoAcknowledgeIfRequired(MessageNotification msg) throws JMSException {
        if (this.isTransactedMsgReceive()) {
            return;
        }
        AckOneMessageByClientNotification ackNotification = this.getAutoAckByClientNot(msg.getMessage().getMessageID(), msg.getMessageConsumerInfo().getConsumerID(), msg.getMessage().getJMSDeliveryMode(), msg.getMessage().isQueueMessage());
        try {
            this.getNetworkHandler().requestOK(ackNotification);
        }
        catch (NotificationException e) {
            throw new JMSException("Unable to send an acknowledgement to the server:" + e);
        }
        catch (InterruptedException e) {
            this.getNetworkHandler().log("thread interrupted while sending acknowledgement" + e);
        }
        finally {
            this.freeAutoAckByClient(ackNotification);
        }
    }

    private synchronized void setProducerThread() throws JMSException {
        if (this.myProducerThread == null) {
            this.myProducerThread = Thread.currentThread();
        }
    }

    void startAsyncConsumer() throws JMSException {
        if (this.existAsyncConsumer()) {
            boolean restart = this.myReceiverThread != null;
            this.startAsyncListening(restart);
            Enumeration keys = this.myConsumers.keys();
            while (keys.hasMoreElements()) {
                Integer key = (Integer)keys.nextElement();
                MessageConsumerImpl aConsumer = (MessageConsumerImpl)this.myConsumers.get(key);
                if (!aConsumer.activateOnServerAtSessionRestart()) continue;
                aConsumer.registerAsyncConsumer();
            }
        }
    }

    void startAsyncListening(boolean restart) {
        if (!restart) {
            this.myReceiverThread = new SessionThread(this);
        }
        this.myReceiverThread.pleaseStart(restart);
    }

    void startAsyncListening() {
        boolean restart = this.myReceiverThread != null;
        this.startAsyncListening(restart);
    }

    void stopAsyncConsumer(boolean remove) throws JMSException {
        Enumeration consumers = this.myConsumers.elements();
        try {
            while (consumers.hasMoreElements()) {
                MessageConsumerImpl aConsumer = (MessageConsumerImpl)consumers.nextElement();
                aConsumer.unregisterConsumer(remove);
            }
        }
        catch (JMSException ex) {
            throw new JMSException(ex.toString());
        }
        finally {
            this.stopAsyncListening(remove);
        }
    }

    void stopAsyncListening(boolean remove) {
        if (this.myReceiverThread != null) {
            this.myReceiverThread.pleaseStop(remove);
            if (remove) {
                this.myReceiverThread = null;
            }
        }
    }

    public MessageConsumerImpl getDurableConsumer(String subscriptionName) {
        MessageConsumerImpl aConsumer = (MessageConsumerImpl)this.myDurableConsumers.get(subscriptionName);
        return aConsumer;
    }

    void unsubscribeDurableConsumer(String subscriptionName) throws JMSException {
        MessageConsumerImpl aConsumer = (MessageConsumerImpl)this.myDurableConsumers.remove(subscriptionName);
        if (aConsumer == null) {
            throw new JMSException("Durable subscription " + subscriptionName + " does not exist");
        }
        if (aConsumer instanceof TopicSubscriberImpl && !((TopicSubscriberImpl)aConsumer).getIsDurable()) {
            throw new JMSException("Subscription " + subscriptionName + " is not durable");
        }
        aConsumer.unsubscribeDurableConsumer();
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.createBrowser(queue, "");
    }

    public QueueBrowser createBrowser(Queue queue, String msgSelector) throws JMSException {
        this.checkSessionState();
        if (this.getIsClosed()) {
            throw new IllegalStateException("Session is closed");
        }
        if (this.getConnection() == null) {
            throw new JMSException("No connection available");
        }
        if (!this.getConnection().isStarted()) {
            throw new JMSException("Connection is not started");
        }
        return new QueueBrowserImpl(queue, this, msgSelector);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        return this.createDurableSubscriber(topic, name, "", false);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String msgSelector, boolean noLocal) throws JMSException {
        this.checkConnectionState();
        this.checkSessionState();
        if (topic instanceof TemporaryTopic) {
            this.checkTempTopicExists(topic);
        }
        TopicSubscriberImpl subscriber = new TopicSubscriberImpl(topic, this, true, name, msgSelector, noLocal);
        this.addDurableMessageConsumer(subscriber, name);
        return subscriber;
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        this.checkSessionState();
        TemporaryQueueImpl aTQ = new TemporaryQueueImpl(this.getConnection());
        this.getConnection().addTemporaryQueue(aTQ);
        return aTQ;
    }

    public Queue createQueue(String name) throws JMSException {
        this.checkSessionState();
        throw new UnsupportedOperationException("Method createQueue() not supported. Use JNDI lookup to get a Queue object.");
    }

    protected void checkTempTopicExists(Topic topic) throws JMSException {
        if (this.getConnection().getTemporaryTopic(topic) == null) {
            throw new JMSException("Temporary Topic" + topic.getTopicName() + " does not exits.");
        }
    }

    public void unsubscribe(String name) throws JMSException {
        this.checkSessionState();
        this.unsubscribeDurableConsumer(name);
    }

    public Topic createTopic(String name) throws JMSException {
        this.checkSessionState();
        throw new UnsupportedOperationException("Method createTopic() not  not supported. Use JNDI lookup to get a Topic object.");
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        this.checkSessionState();
        TemporaryTopicImpl aTT = new TemporaryTopicImpl(this.getConnection());
        this.getConnection().addTemporaryTopic(aTT);
        return aTT;
    }

    public int getAcknowledgeMode() throws JMSException {
        if (this.myIsTransacted) {
            return 0;
        }
        return this.myAcknowledgeMode;
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.createConsumer(destination, "", false);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        return this.createConsumer(destination, messageSelector, false);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        if (destination instanceof Topic) {
            return new TopicSubscriberImpl((Topic)destination, this, false, "", messageSelector, noLocal);
        }
        if (destination instanceof Topic) {
            return new QueueReceiverImpl((Queue)destination, this, messageSelector);
        }
        throw new JMSException("Invalid destination type");
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        if (destination instanceof Topic) {
            return this.createPublisher((Topic)destination);
        }
        if (destination instanceof Topic) {
            return this.createSender((Queue)destination);
        }
        throw new JMSException("Invalid destination type");
    }

    protected QueueSender createSender(Queue queue) throws JMSException {
        this.checkConnectionState();
        this.checkSessionState();
        QueueSenderImpl sender = new QueueSenderImpl(queue, this);
        this.addMessageProducer(sender);
        return sender;
    }

    protected TopicPublisher createPublisher(Topic topic) throws JMSException {
        this.checkSessionState();
        TopicPublisherImpl publisher = new TopicPublisherImpl(topic, this);
        this.addMessageProducer(publisher);
        return publisher;
    }
}

