/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.client;

import com.sap.sdb.msgServer.client.ClientOID;
import com.sap.sdb.msgServer.client.MessageImpl;
import com.sap.sdb.msgServer.client.QueueBrowserEnumeration;
import com.sap.sdb.msgServer.client.SessionImpl;
import com.sap.sdb.msgServer.util.BrowserNotification;
import com.sap.sdb.msgServer.util.BrowserRegNotification;
import com.sap.sdb.msgServer.util.NotificationException;
import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueBrowser;

public class QueueBrowserImpl
implements QueueBrowser {
    private SessionImpl mySession;
    private Queue myQueue;
    private QueueBrowserEnumeration myEnumeration;
    private long myLastMessageID;
    private String myMsgSelector;
    private long myID;

    public QueueBrowserImpl(Queue queue, SessionImpl session, String msgSelector) throws JMSException {
        this.myQueue = queue;
        this.mySession = session;
        this.myEnumeration = new QueueBrowserEnumeration(this);
        this.myLastMessageID = -1L;
        this.myMsgSelector = msgSelector;
        this.myID = ClientOID.getNext();
        BrowserRegNotification aQBReg = new BrowserRegNotification(true, this.myID, msgSelector);
        try {
            this.mySession.getNetworkHandler().requestOK(aQBReg);
        }
        catch (NotificationException ex) {
            throw new JMSException("Could not register QueueBrowser");
        }
        catch (InterruptedException ex) {
            throw new JMSException("Could not register QueueBrowser");
        }
    }

    public void close() throws JMSException {
        this.myEnumeration = null;
        BrowserRegNotification aQBReg = new BrowserRegNotification(false, this.myID, this.myMsgSelector);
        try {
            this.mySession.getNetworkHandler().requestOK(aQBReg);
        }
        catch (NotificationException ex) {
            throw new JMSException("Could not register QueueBrowser");
        }
        catch (InterruptedException ex) {
            throw new JMSException("Could not register QueueBrowser");
        }
    }

    public Enumeration getEnumeration() throws JMSException {
        this.myLastMessageID = -1L;
        return this.myEnumeration;
    }

    public String getMessageSelector() throws JMSException {
        return this.myMsgSelector;
    }

    public Queue getQueue() throws JMSException {
        return this.myQueue;
    }

    protected Message getNextMessage() {
        try {
            BrowserNotification command = new BrowserNotification(this.myQueue.getQueueName(), this.myLastMessageID, this.myID, 0);
            MessageImpl aMessage = this.mySession.getNetworkHandler().requestMessageForBrowser(command);
            if (aMessage != null) {
                this.myLastMessageID = aMessage.getMessageID();
            }
            return aMessage;
        }
        catch (JMSException ex) {
            ex.printStackTrace();
        }
        catch (NotificationException ex) {
            ex.printStackTrace();
        }
        return null;
    }
}

