/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.client;

import com.sap.sdb.msgServer.util.ReceiveStream;
import com.sap.sdb.msgServer.util.SendStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;

public class MessageProperties {
    private Hashtable myObjects = null;
    private boolean myReadOnly = false;
    private static final String[] MESSAGE_SELECTOR_IDENT = new String[]{"TRUE", "FALSE", "AND", "OR", "NOT", "BETWEEN", "ESCAPE", "IN", "IS", "NULL", "LIKE"};
    private static final int MSG_PROPERTY_VERSION = -889279231;

    public int getPropCount() {
        return this.myObjects == null ? 0 : this.myObjects.size();
    }

    void clearProperties() throws JMSException {
        if (this.myObjects != null) {
            this.myObjects.clear();
        }
        this.myReadOnly = false;
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        Object data;
        this.checkPropertyName(name);
        Object object = data = this.myObjects == null ? null : (Object)this.myObjects.get(name);
        if (data instanceof Boolean) {
            return (Boolean)data;
        }
        if (data instanceof String) {
            return Boolean.valueOf((String)data);
        }
        if (data == null) {
            throw new NumberFormatException("null not a valid value");
        }
        throw new MessageFormatException("MessageProperties: conversion from " + data.getClass().getName() + " to boolean not possible");
    }

    public byte getByteProperty(String name) throws JMSException {
        Object data;
        this.checkPropertyName(name);
        Object object = data = this.myObjects == null ? null : (Object)this.myObjects.get(name);
        if (data instanceof Byte) {
            return (Byte)data;
        }
        if (data instanceof String) {
            return Byte.parseByte((String)data);
        }
        if (data == null) {
            throw new NumberFormatException("null not a valid value");
        }
        throw new MessageFormatException("MessageProperties: conversion from " + data.getClass().getName() + " to byte not possible");
    }

    public double getDoubleProperty(String name) throws JMSException {
        Object data;
        this.checkPropertyName(name);
        Object object = data = this.myObjects == null ? null : (Object)this.myObjects.get(name);
        if (data instanceof Double) {
            return (Double)data;
        }
        if (data instanceof Float) {
            return ((Float)data).doubleValue();
        }
        if (data instanceof String) {
            return Double.parseDouble((String)data);
        }
        if (data == null) {
            throw new NumberFormatException("null not a valid value");
        }
        throw new MessageFormatException("MessageProperties: conversion " + data.getClass().getName() + " to double not possible");
    }

    public float getFloatProperty(String name) throws JMSException {
        Object data;
        this.checkPropertyName(name);
        Object object = data = this.myObjects == null ? null : (Object)this.myObjects.get(name);
        if (data instanceof Float) {
            return ((Float)data).floatValue();
        }
        if (data instanceof String) {
            return Float.parseFloat((String)data);
        }
        if (data == null) {
            throw new NumberFormatException("null not a valid value");
        }
        throw new MessageFormatException("MessageProperties: conversion " + data.getClass().getName() + " to float not possible");
    }

    public int getIntProperty(String name) throws JMSException {
        Object data;
        this.checkPropertyName(name);
        Object object = data = this.myObjects == null ? null : (Object)this.myObjects.get(name);
        if (data instanceof Integer) {
            return (Integer)data;
        }
        if (data instanceof Short) {
            return ((Short)data).intValue();
        }
        if (data instanceof Byte) {
            return ((Byte)data).intValue();
        }
        if (data instanceof String) {
            return Integer.parseInt((String)data);
        }
        if (data == null) {
            throw new NumberFormatException("null not a valid value");
        }
        throw new MessageFormatException("MessageProperties: conversion " + data.getClass().getName() + " to int not possible");
    }

    public long getLongProperty(String name) throws JMSException {
        Object data;
        this.checkPropertyName(name);
        Object object = data = this.myObjects == null ? null : (Object)this.myObjects.get(name);
        if (data instanceof Long) {
            return (Long)data;
        }
        if (data instanceof Integer) {
            return ((Integer)data).longValue();
        }
        if (data instanceof Short) {
            return ((Short)data).longValue();
        }
        if (data instanceof Byte) {
            return ((Byte)data).longValue();
        }
        if (data instanceof String) {
            return Long.parseLong((String)data);
        }
        if (data == null) {
            throw new NumberFormatException("null not a valid value");
        }
        throw new MessageFormatException("MessageProperties: conversion " + data.getClass().getName() + " to long not possible");
    }

    public Object getObjectProperty(String name) throws JMSException {
        this.checkPropertyName(name);
        return this.myObjects == null ? null : this.myObjects.get(name);
    }

    public Enumeration getPropertyNames() throws JMSException {
        if (this.myObjects == null) {
            this.myObjects = new Hashtable();
        }
        return this.myObjects.keys();
    }

    public short getShortProperty(String name) throws JMSException {
        Object data;
        this.checkPropertyName(name);
        Object object = data = this.myObjects == null ? null : (Object)this.myObjects.get(name);
        if (data instanceof Short) {
            return (Short)data;
        }
        if (data instanceof String) {
            return Short.parseShort((String)data);
        }
        if (data instanceof Byte) {
            return ((Byte)data).shortValue();
        }
        if (data == null) {
            throw new NumberFormatException("null not a valid value");
        }
        throw new MessageFormatException("MessageProperties: conversion " + data.getClass().getName() + " to long not possible");
    }

    public String getStringProperty(String name) throws JMSException {
        Object data;
        this.checkPropertyName(name);
        Object object = data = this.myObjects == null ? null : (Object)this.myObjects.get(name);
        if (data instanceof String) {
            return (String)data;
        }
        if (data instanceof Boolean) {
            return ((Boolean)data).toString();
        }
        if (data instanceof Short) {
            return ((Short)data).toString();
        }
        if (data instanceof Character) {
            return ((Character)data).toString();
        }
        if (data instanceof Double) {
            return ((Double)data).toString();
        }
        if (data instanceof Float) {
            return ((Float)data).toString();
        }
        if (data instanceof Long) {
            return ((Long)data).toString();
        }
        if (data instanceof Integer) {
            return ((Integer)data).toString();
        }
        if (data instanceof Byte) {
            return ((Byte)data).toString();
        }
        throw new MessageFormatException("MessageProperties: conversion " + data.getClass().getName() + " to String not possible");
    }

    public boolean propertyExists(String name) throws JMSException {
        this.checkPropertyName(name);
        return this.myObjects == null ? false : this.myObjects.get(name) != null;
    }

    void setBooleanProperty(String name, boolean value) throws JMSException {
        Boolean boolObj = value ? Boolean.TRUE : Boolean.FALSE;
        this.putIntoHashtable(name, boolObj);
    }

    void setByteProperty(String name, byte value) throws JMSException {
        this.putIntoHashtable(name, new Byte(value));
    }

    void setDoubleProperty(String name, double value) throws JMSException {
        this.putIntoHashtable(name, new Double(value));
    }

    void setFloatProperty(String name, float value) throws JMSException {
        this.putIntoHashtable(name, new Float(value));
    }

    void setIntProperty(String name, int value) throws JMSException {
        this.putIntoHashtable(name, new Integer(value));
    }

    void setLongProperty(String name, long value) throws JMSException {
        this.putIntoHashtable(name, new Long(value));
    }

    void setObjectProperty(String name, Object value) throws JMSException {
        if (!(value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof String)) {
            throw new MessageFormatException("Invalid object property type!");
        }
        this.putIntoHashtable(name, value);
    }

    void setShortProperty(String name, short value) throws JMSException {
        this.putIntoHashtable(name, new Short(value));
    }

    void setStringProperty(String name, String value) throws JMSException {
        this.putIntoHashtable(name, value);
    }

    public void setReadOnly() {
        this.myReadOnly = true;
    }

    private void checkForWrite() throws MessageNotWriteableException {
        if (this.myReadOnly) {
            throw new MessageNotWriteableException("MessageProperties can't be written while being in read mode");
        }
    }

    private void checkPropertyName(String name) throws JMSException {
        int i;
        if (name == null || name.length() < 1) {
            throw new JMSException("Invalid property Name: null value or zero length not allowed");
        }
        for (i = 0; i < MESSAGE_SELECTOR_IDENT.length; ++i) {
            if (!name.equalsIgnoreCase(MESSAGE_SELECTOR_IDENT[i])) continue;
            throw new JMSException("Invalid property Name:" + name + " name is reserved for Message Selector");
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            throw new JMSException("Invalid property Name:" + name);
        }
        for (i = 1; i < name.length(); ++i) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
            throw new JMSException("Invalid property Name:" + name);
        }
        if (name.startsWith("JMSX")) {
            if (name.equals("JMSXGroupID") || name.equals("JMSXGroupSeq")) {
                throw new JMSException("Invalid property Name:" + name + " Property not supported");
            }
            throw new JMSException("Invalid property Name:" + name + " Property can't be set by client");
        }
    }

    private void putIntoHashtable(String name, Object value) throws JMSException {
        this.checkPropertyName(name);
        this.checkForWrite();
        if (this.myObjects == null) {
            this.myObjects = new Hashtable();
        }
        this.myObjects.put(name, value);
    }

    private void checkVersion(ReceiveStream in) throws IOException {
        int msgPropVersion = in.readInt();
        if (msgPropVersion != -889279231) {
            throw new IOException("wrong message properties version: " + msgPropVersion + "[required version: " + -889279231 + "]");
        }
    }

    public void readFromStream(ReceiveStream in) throws IOException {
        this.myReadOnly = true;
        this.checkVersion(in);
        this.myObjects = in.readHashtable();
    }

    void writeToStream(SendStream out) throws IOException {
        out.writeInt(-889279231);
        out.writeHashtable(this.myObjects);
    }
}

