/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.client;

import com.sap.sdb.msgServer.client.BytesMessageImpl;
import com.sap.sdb.msgServer.client.DestinationImpl;
import com.sap.sdb.msgServer.client.MapMessageImpl;
import com.sap.sdb.msgServer.client.MessageHeaderFields;
import com.sap.sdb.msgServer.client.MessageProperties;
import com.sap.sdb.msgServer.client.ObjectMessageImpl;
import com.sap.sdb.msgServer.client.SessionImpl;
import com.sap.sdb.msgServer.client.StreamMessageImpl;
import com.sap.sdb.msgServer.client.TextMessageImpl;
import com.sap.sdb.msgServer.util.DeliveryModeImpl;
import com.sap.sdb.msgServer.util.ReceiveStream;
import com.sap.sdb.msgServer.util.SendStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;

public class MessageImpl
implements Message {
    private int myClientClassType = 0;
    private boolean myIsQueueMessage = false;
    private long myMessageID = 0L;
    private long myTimeToLive = -1L;
    private MessageHeaderFields myMessageHeader = new MessageHeaderFields();
    private DestinationImpl myJMSDestination = null;
    private DestinationImpl myJMSReplyTo = null;
    private MessageProperties myMessageProperties = new MessageProperties();
    private transient int myReadWriteMode = 2;
    private transient SessionImpl myAcknowledgeSession = null;
    private transient int mySizeMsgContents = 0;
    private transient int mySizeMsgContentsHead = 0;
    private transient int mySizeUserDefProp = 0;
    private transient byte[] myInternalMsgContents = null;
    private transient ByteArrayOutputStream myByteArrayOutStream = null;
    static final int MESSAGE = 0;
    static final int BYTES_MESSAGE = 1;
    static final int MAP_MESSAGE = 2;
    static final int OBJECT_MESSAGE = 3;
    static final int STREAM_MESSAGE = 4;
    static final int TEXT_MESSAGE = 5;
    static final long UNDEF_MSG_ID = 0L;
    private static final int MSG_CONTENTS_VERSION = -889267455;
    private static final int CLIENT_READ_ONLY = 0;
    private static final int CLIENT_WRITE_ONLY = 1;
    private static final int CLIENT_READ_WRITE = 2;
    private static final int SERVER_ACCESS = 3;

    public MessageImpl() {
    }

    public MessageImpl(int classType) {
        this();
        this.myClientClassType = classType;
    }

    public MessageImpl(long messageID, boolean isQueueMessage) {
        this();
        this.setMessageID(messageID);
        this.myIsQueueMessage = isQueueMessage;
    }

    MessageImpl(long messageID, boolean isQueueMessage, int classType) {
        this(messageID, isQueueMessage);
        this.myClientClassType = classType;
    }

    public void acknowledge() throws JMSException {
        this.checkForClientOnlyAccess();
        this.myAcknowledgeSession.commit();
    }

    public void clearBody() throws JMSException {
        this.checkForClientOnlyAccess();
        this.setReadWrite();
    }

    public void clearProperties() throws JMSException {
        this.checkForClientOnlyAccess();
        this.myMessageProperties.clearProperties();
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        return this.myMessageProperties.getBooleanProperty(name);
    }

    public byte getByteProperty(String name) throws JMSException {
        return this.myMessageProperties.getByteProperty(name);
    }

    public double getDoubleProperty(String name) throws JMSException {
        return this.myMessageProperties.getDoubleProperty(name);
    }

    public float getFloatProperty(String name) throws JMSException {
        return this.myMessageProperties.getFloatProperty(name);
    }

    public int getIntProperty(String name) throws JMSException {
        return this.myMessageProperties.getIntProperty(name);
    }

    public long getLongProperty(String name) throws JMSException {
        return this.myMessageProperties.getLongProperty(name);
    }

    public Object getObjectProperty(String name) throws JMSException {
        return this.myMessageProperties.getObjectProperty(name);
    }

    public Enumeration getPropertyNames() throws JMSException {
        return this.myMessageProperties.getPropertyNames();
    }

    public short getShortProperty(String name) throws JMSException {
        return this.myMessageProperties.getShortProperty(name);
    }

    public String getStringProperty(String name) throws JMSException {
        return this.myMessageProperties.getStringProperty(name);
    }

    public String getJMSCorrelationID() throws JMSException {
        return this.myMessageHeader.getJMSCorrelationID();
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        throw new UnsupportedOperationException("Method getJMSCorrelationIDAsBytes() not yet implemented.");
    }

    public int getJMSDeliveryMode() throws JMSException {
        return this.myMessageHeader.getJMSDeliveryMode();
    }

    public Destination getJMSDestination() throws JMSException {
        return this.myJMSDestination;
    }

    public long getJMSExpiration() throws JMSException {
        return this.myMessageHeader.getJMSExpiration();
    }

    public String getJMSMessageID() throws JMSException {
        return this.myMessageHeader.getJMSMessageID();
    }

    public int getJMSPriority() throws JMSException {
        return this.myMessageHeader.getJMSPriority();
    }

    public boolean getJMSRedelivered() throws JMSException {
        return this.myMessageHeader.getJMSRedelivered();
    }

    public Destination getJMSReplyTo() throws JMSException {
        return this.myJMSReplyTo;
    }

    public long getJMSTimestamp() throws JMSException {
        return this.myMessageHeader.getJMSTimestamp();
    }

    public String getJMSType() throws JMSException {
        return this.myMessageHeader.getJMSType();
    }

    public boolean propertyExists(String name) throws JMSException {
        return this.myMessageProperties.propertyExists(name);
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        this.checkForClientOnlyAccess();
        this.myMessageProperties.setBooleanProperty(name, value);
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        this.checkForClientOnlyAccess();
        this.myMessageProperties.setByteProperty(name, value);
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        this.checkForClientOnlyAccess();
        this.myMessageProperties.setDoubleProperty(name, value);
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        this.checkForClientOnlyAccess();
        this.myMessageProperties.setFloatProperty(name, value);
    }

    public void setIntProperty(String name, int value) throws JMSException {
        this.checkForClientOnlyAccess();
        this.myMessageProperties.setIntProperty(name, value);
    }

    public void setLongProperty(String name, long value) throws JMSException {
        this.checkForClientOnlyAccess();
        this.myMessageProperties.setLongProperty(name, value);
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        this.checkForClientOnlyAccess();
        this.myMessageProperties.setObjectProperty(name, value);
    }

    public void setShortProperty(String name, short value) throws JMSException {
        this.checkForClientOnlyAccess();
        this.myMessageProperties.setShortProperty(name, value);
    }

    public void setStringProperty(String name, String value) throws JMSException {
        this.checkForClientOnlyAccess();
        this.myMessageProperties.setStringProperty(name, value);
    }

    public void setJMSCorrelationID(String correlationId) throws JMSException {
        this.myMessageHeader.setJMSCorrelationID(correlationId);
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationId) throws JMSException {
        throw new UnsupportedOperationException("Method setJMSCorrelationIDAsBytes() not yet implemented.");
    }

    public void setJMSDeliveryMode(int value) throws JMSException {
        DeliveryModeImpl.checkModeThrowJMSException(value);
        this.myMessageHeader.setJMSDeliveryMode(value);
    }

    public void setJMSDestination(Destination dest) throws JMSException {
        this.checkForClientOnlyAccess();
        this.myJMSDestination = (DestinationImpl)dest;
    }

    public void setJMSExpiration(long value) throws JMSException {
        this.myMessageHeader.setJMSExpiration(value);
    }

    public void setJMSMessageID(String id) throws JMSException {
        this.myMessageHeader.setJMSMessageID(id);
    }

    public void setJMSPriority(int priority) throws JMSException {
        this.myMessageHeader.setJMSPriority(priority);
    }

    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        this.checkForClientOnlyAccess();
        this.myMessageHeader.setJMSRedelivered(redelivered);
    }

    public void setJMSReplyTo(Destination replyTo) throws JMSException {
        this.checkForClientOnlyAccess();
        this.myJMSReplyTo = (DestinationImpl)replyTo;
    }

    public void setJMSTimestamp(long timestamp) throws JMSException {
        this.myMessageHeader.setJMSTimestamp(timestamp);
    }

    public void setJMSType(String type) throws JMSException {
        this.myMessageHeader.setJMSType(type);
    }

    public long getBytesUsed() {
        return 128 + this.mySizeMsgContentsHead + this.mySizeMsgContents;
    }

    public int getClassType() {
        return this.myClientClassType;
    }

    public long getMessageID() {
        return this.myMessageID;
    }

    public MessageHeaderFields getHeaderFields() {
        return this.myMessageHeader;
    }

    public MessageProperties getPropertyList() {
        return this.myMessageProperties;
    }

    public boolean isQueueMessage() {
        return this.myIsQueueMessage;
    }

    public void setMessageID(long messageID) {
        this.myMessageID = messageID;
        this.myMessageHeader.setJMSMessageID(Long.toString(messageID));
    }

    void setReadOnly() {
        if (this.myReadWriteMode != 3) {
            this.myReadWriteMode = 0;
        }
    }

    void setReadWrite() {
        if (this.myReadWriteMode != 3) {
            this.myReadWriteMode = 2;
        }
    }

    void setWriteOnly() {
        if (this.myReadWriteMode != 3) {
            this.myReadWriteMode = 1;
        }
    }

    public void prepareForClient() throws JMSException {
    }

    void checkForRead() throws MessageNotReadableException {
        if (this.myReadWriteMode == 1) {
            throw new MessageNotReadableException("Message can't be read while being in write mode");
        }
    }

    void checkForWrite() throws MessageNotWriteableException {
        if (this.myReadWriteMode == 0 || this.myReadWriteMode == 3) {
            throw new MessageNotWriteableException("Message can't be written while being in read mode");
        }
    }

    void checkForClientOnlyAccess() throws MessageNotReadableException {
        if (this.myReadWriteMode == 3) {
            throw new MessageNotReadableException("no server access privileges");
        }
    }

    void checkForServerOnlyAccess() throws MessageNotReadableException {
        if (this.myReadWriteMode != 3) {
            throw new MessageNotReadableException("no client access privileges");
        }
    }

    public void setMessageTimeToLive(long value) throws JMSException {
        this.myTimeToLive = value;
    }

    public long getMessageTimeToLive() throws JMSException {
        return this.myTimeToLive;
    }

    public void setAcknowledgeSession(SessionImpl session) throws JMSException {
        this.myAcknowledgeSession = session;
    }

    public byte[] getMessageContentsBytes() {
        if (this.myInternalMsgContents.length == this.mySizeMsgContents) {
            return this.myInternalMsgContents;
        }
        byte[] resizedArray = new byte[this.mySizeMsgContents];
        if (this.myInternalMsgContents.length > this.mySizeMsgContents) {
            System.arraycopy(this.myInternalMsgContents, 0, resizedArray, 0, this.mySizeMsgContents);
        } else {
            System.arraycopy(this.myInternalMsgContents, 0, resizedArray, 0, this.myInternalMsgContents.length);
            Arrays.fill(resizedArray, this.myInternalMsgContents.length, this.mySizeMsgContents, (byte)0);
        }
        return resizedArray;
    }

    public int getMessageContentsSize() {
        return this.mySizeMsgContents;
    }

    public byte[] getUserDefPropBytes() {
        if (this.mySizeUserDefProp <= 0) {
            return null;
        }
        byte[] propBytes = new byte[this.mySizeUserDefProp];
        System.arraycopy(this.myInternalMsgContents, 4, propBytes, 0, this.mySizeUserDefProp);
        return propBytes;
    }

    public int getUserDefPropSize() {
        return this.mySizeUserDefProp;
    }

    public int getWriteToClientLength() {
        return this.getWriteHeaderInfoLength() + 4 + this.mySizeMsgContents;
    }

    public int initSendToServer() throws IOException {
        int headerInfoLength = this.getWriteHeaderInfoLength();
        if (this.myByteArrayOutStream == null) {
            this.myByteArrayOutStream = new ByteArrayOutputStream(1024);
        } else {
            this.myByteArrayOutStream.reset();
        }
        SendStream messageSendStream = new SendStream(this.myByteArrayOutStream);
        messageSendStream.writeInt(-889267455);
        this.myMessageProperties.writeToStream(messageSendStream);
        this.mySizeUserDefProp = messageSendStream.size() - 4;
        this.writeDestinationsToStream(messageSendStream);
        this.mySizeMsgContentsHead = headerInfoLength + messageSendStream.size();
        this.writeMessageContentsToStream(messageSendStream);
        this.mySizeMsgContents = headerInfoLength + messageSendStream.size();
        messageSendStream.flush();
        messageSendStream = null;
        return headerInfoLength + 4 + this.myByteArrayOutStream.size();
    }

    public static MessageImpl newMessageUsingSqlColumns(long msgID, boolean isQueueMessage, int msgClassType, int msgSize, byte[] msgContents) throws JMSException {
        MessageImpl msg = new MessageImpl(msgID, isQueueMessage, msgClassType);
        msg.myReadWriteMode = 3;
        msg.mySizeMsgContents = msgSize;
        msg.myInternalMsgContents = msgContents;
        if (msgContents.length < msgSize) {
            msg.myInternalMsgContents = msg.getMessageContentsBytes();
        }
        try {
            msg.readDestinationsAndPropertiesFromInternalMsg();
        }
        catch (IOException e) {
            throw new JMSException("Message not deserializable: " + e);
        }
        return msg;
    }

    public static MessageImpl receiveFromClient(ReceiveStream in) throws IOException {
        MessageImpl msg = new MessageImpl();
        msg.myClientClassType = in.readByte();
        msg.readHeaderInfoFromStream(in);
        msg.myMessageHeader.setJMSRedelivered(false);
        msg.myReadWriteMode = 3;
        msg.myInternalMsgContents = in.readByteArray();
        msg.mySizeMsgContents = msg.myInternalMsgContents.length;
        msg.readDestinationsAndPropertiesFromInternalMsg();
        return msg;
    }

    public static MessageImpl receiveFromServer(ReceiveStream in) throws IOException {
        MessageImpl msg = null;
        byte msgClassType = in.readByte();
        switch (msgClassType) {
            case 0: {
                msg = new MessageImpl();
                break;
            }
            case 1: {
                msg = new BytesMessageImpl();
                break;
            }
            case 2: {
                msg = new MapMessageImpl();
                break;
            }
            case 3: {
                msg = new ObjectMessageImpl();
                break;
            }
            case 4: {
                msg = new StreamMessageImpl();
                break;
            }
            case 5: {
                msg = new TextMessageImpl();
                break;
            }
            default: {
                throw new IOException("No valid message class type: " + msgClassType);
            }
        }
        msg.readHeaderInfoFromStream(in);
        msg.myReadWriteMode = 0;
        byte[] msgContents = in.readByteArray();
        msg.readAllFromByteArray(msgContents);
        return msg;
    }

    public void sendToClient(SendStream out, boolean redelivered) throws IOException {
        this.writeHeaderInfoToStream(out);
        this.myMessageHeader.writeToStream(out, redelivered);
        out.writeByteArray(this.myInternalMsgContents, 0, this.mySizeMsgContents);
    }

    public void sendToServer(SendStream out) throws IOException {
        if (this.myByteArrayOutStream == null) {
            this.initSendToServer();
        }
        this.writeHeaderInfoToStream(out);
        this.myMessageHeader.writeToStream(out);
        out.writeByteArray(this.myByteArrayOutStream);
    }

    private void checkMsgContentsVersion(ReceiveStream in) throws IOException {
        int msgContentsVersion = in.readInt();
        if (msgContentsVersion != -889267455) {
            throw new IOException("wrong message contents version: " + msgContentsVersion + "[required version: " + -889267455 + "]");
        }
    }

    private int getWriteHeaderInfoLength() {
        return 26 + this.myMessageHeader.getWriteToStreamLength();
    }

    private void readAllFromByteArray(byte[] byteArray) throws IOException {
        if (byteArray == null) {
            return;
        }
        ByteArrayInputStream byteStream = new ByteArrayInputStream(byteArray);
        ReceiveStream objByteStream = new ReceiveStream(byteStream);
        this.checkMsgContentsVersion(objByteStream);
        this.myMessageProperties.readFromStream(objByteStream);
        this.readDestinationsFromStream(objByteStream);
        this.readMessageContentsFromStream(objByteStream);
    }

    private void readDestinationsAndPropertiesFromInternalMsg() throws IOException {
        ByteArrayInputStream byteStream = new ByteArrayInputStream(this.myInternalMsgContents);
        ReceiveStream objByteStream = new ReceiveStream(byteStream);
        this.checkMsgContentsVersion(objByteStream);
        this.myMessageProperties.readFromStream(objByteStream);
        this.readDestinationsFromStream(objByteStream);
    }

    private void readDestinationsFromStream(ReceiveStream in) throws IOException {
        this.myJMSDestination = in.isNullObject() ? null : DestinationImpl.getDestinationFromStream(in);
        this.myJMSReplyTo = in.isNullObject() ? null : DestinationImpl.getDestinationFromStream(in);
    }

    private void readHeaderInfoFromStream(ReceiveStream in) throws IOException {
        this.myMessageID = in.readLong();
        this.myTimeToLive = in.readLong();
        this.myIsQueueMessage = in.readBoolean();
        this.mySizeMsgContentsHead = in.readInt();
        this.mySizeUserDefProp = in.readInt();
        this.myMessageHeader.readFromStream(in);
    }

    void readMessageContentsFromStream(ReceiveStream in) throws IOException {
    }

    private void writeDestinationsToStream(SendStream out) throws IOException {
        if (out.isWriteObject(this.myJMSDestination)) {
            this.myJMSDestination.writeToStream(out);
        }
        if (out.isWriteObject(this.myJMSReplyTo)) {
            this.myJMSReplyTo.writeToStream(out);
        }
    }

    private void writeHeaderInfoToStream(SendStream out) throws IOException {
        out.writeByte(this.myClientClassType);
        out.writeLong(this.myMessageID);
        out.writeLong(this.myTimeToLive);
        out.writeBoolean(this.myIsQueueMessage);
        out.writeInt(this.mySizeMsgContentsHead);
        out.writeInt(this.mySizeUserDefProp);
    }

    void writeMessageContentsToStream(SendStream out) throws IOException {
    }
}

