/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.client;

import com.sap.sdb.msgServer.client.ClientOID;
import com.sap.sdb.msgServer.client.MessageImpl;
import com.sap.sdb.msgServer.client.SessionImpl;
import com.sap.sdb.msgServer.client.TopicSubscriberImpl;
import com.sap.sdb.msgServer.util.ActivateAdminNotification;
import com.sap.sdb.msgServer.util.ClientSessionAddress;
import com.sap.sdb.msgServer.util.DeactivateAdminNotification;
import com.sap.sdb.msgServer.util.MessageNotification;
import com.sap.sdb.msgServer.util.NotificationException;
import java.io.IOException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;

public abstract class MessageConsumerImpl
implements MessageConsumer {
    public static final int CONSUMER_TYPE_QUEUERECEIVER = 0;
    public static final int CONSUMER_TYPE_TOPICSUBSCRIBER = 1;
    static int myCurrentID = 1;
    private Integer myID = new Integer(myCurrentID++);
    protected long myServerSideConsumerID;
    protected boolean myIsDurable;
    protected String mySubscription;
    protected SessionImpl mySession;
    private MessageListener myMessageListener;
    protected String myMsgSelector;
    private boolean myActivateOnServerAtSessionRestart;

    public MessageConsumerImpl(SessionImpl session, String msgSelector) {
        this.mySession = session;
        this.myMessageListener = null;
        this.myServerSideConsumerID = ClientOID.getNext();
        this.myMsgSelector = msgSelector;
        this.myActivateOnServerAtSessionRestart = true;
    }

    public void close() throws JMSException {
        this.unregisterConsumer(true);
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.myMessageListener;
    }

    public String getMessageSelector() throws JMSException {
        return this.myMsgSelector;
    }

    public Message receive() throws JMSException {
        this.checkReceiveAllowed();
        return this.internalReceive(0L, false);
    }

    public Message receive(long value) throws JMSException {
        this.checkReceiveAllowed();
        return this.internalReceive(value, false);
    }

    public Message receiveNoWait() throws JMSException {
        this.checkReceiveAllowed();
        return this.internalReceive(0L, true);
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.checkRegistered();
        this.myMessageListener = listener;
    }

    protected abstract int getType();

    public SessionImpl getSession() {
        return this.mySession;
    }

    public Integer getID() {
        return this.myID;
    }

    protected abstract String getName() throws JMSException;

    public void registerAsyncConsumer() throws JMSException {
        if (this.myMessageListener != null) {
            this.registerConsumer();
            this.myActivateOnServerAtSessionRestart = false;
        }
    }

    protected void unregisterConsumer(boolean remove) throws JMSException {
        this.mySession.checkSessionClosed();
        MessageConsumerImpl aConsumer = null;
        aConsumer = this.mySession.getMessageConsumer(this.myID);
        if (aConsumer == null) {
            throw new JMSException("No consumer with Client ID <" + this.myID + "> in session registered");
        }
        if (remove) {
            if (this.getType() == 1 && ((TopicSubscriberImpl)this).getIsDurable()) {
                remove = false;
            }
            if ((aConsumer = this.mySession.removeMessageConsumer(this.myID)) == null) {
                throw new JMSException("No consumer with Client ID <" + this.myID + "> in session registered");
            }
            String address = null;
            address = aConsumer.getMessageListener() != null ? ClientSessionAddress.createClientSessionAddressString(this.mySession.getNetworkHandler().getClientID().toString(), this.mySession.getQueueID()) : ClientSessionAddress.createClientSessionAddressString(this.mySession.getNetworkHandler().getClientID().toString(), null);
            DeactivateAdminNotification command = new DeactivateAdminNotification(0, address, remove, this.myServerSideConsumerID);
            try {
                this.mySession.getNetworkHandler().request(command, true);
            }
            catch (IOException ex) {
                throw new JMSException("Unable to unregister the AsyncListener in the server: " + ex);
            }
            catch (InterruptedException ex) {
                throw new JMSException("Unable to unregister the AsyncListener in the server: " + ex);
            }
            this.myMessageListener = null;
        }
    }

    public void unsubscribeDurableConsumer() throws JMSException {
        this.mySession.checkSessionState();
        if (this.getType() == 1 && !((TopicSubscriberImpl)this).getIsDurable()) {
            throw new JMSException("Consumer not durable");
        }
        this.mySession.removeMessageConsumer(this.myID);
        String address = null;
        address = this.myMessageListener != null ? ClientSessionAddress.createClientSessionAddressString(this.mySession.getNetworkHandler().getClientID().toString(), this.mySession.getQueueID()) : ClientSessionAddress.createClientSessionAddressString(this.mySession.getNetworkHandler().getClientID().toString(), null);
        DeactivateAdminNotification command = new DeactivateAdminNotification(1, address, true, this.myServerSideConsumerID);
        try {
            this.mySession.getNetworkHandler().requestOK(command);
        }
        catch (NotificationException ex) {
            throw new JMSException("Unable to unregister the AsyncListener in the server: " + ex);
        }
        catch (InterruptedException ex) {
            throw new JMSException("Unable to unregister the AsyncListener in the server: " + ex);
        }
        this.myMessageListener = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message internalReceive(long timeOut, boolean noWait) throws JMSException {
        MessageNotification msgntf = null;
        MessageImpl retval = null;
        if (this.myMessageListener == null) {
            SessionImpl sessionImpl = this.mySession;
            synchronized (sessionImpl) {
                msgntf = this.mySession.getNetworkHandler().getAMessage(this.getName(), this.getType(), timeOut, noWait, this.myServerSideConsumerID);
                if (msgntf != null) {
                    MessageConsumerImpl aConsumer = this.mySession.getMessageConsumer(this.myID);
                    if (aConsumer == null) {
                        return null;
                    }
                    retval = msgntf.getMessage();
                    if (retval != null) {
                        msgntf.getMessageConsumerInfo().setConsumerID(this.myServerSideConsumerID);
                        retval.prepareForClient();
                        this.mySession.acknowledgeReceivedMsg(msgntf);
                    }
                }
                return retval;
            }
        }
        throw new JMSException("Synchronous listening not allowed, while MessageListener is registered");
    }

    private void registerConsumer() throws JMSException {
        boolean isQueue = false;
        boolean isDurable = false;
        boolean noLocal = false;
        String durableSubscription = "";
        if (this.getType() == 0) {
            isQueue = true;
        } else {
            durableSubscription = ((TopicSubscriberImpl)this).getDurableSubscription();
            isDurable = ((TopicSubscriberImpl)this).getIsDurable();
            noLocal = ((TopicSubscriberImpl)this).getNoLocal();
        }
        ActivateAdminNotification command = new ActivateAdminNotification(this.getName(), durableSubscription, this.mySession.getNetworkHandler().getClientID(), this.mySession.getQueueID(), this.getID(), isQueue, isDurable, this.myServerSideConsumerID, this.myMsgSelector, true, noLocal);
        try {
            this.myServerSideConsumerID = this.mySession.getNetworkHandler().requestID(command);
            if (this.mySession.isReceivingQueueDeactivated()) {
                String address = null;
                address = this.myMessageListener != null ? ClientSessionAddress.createClientSessionAddressString(this.mySession.getNetworkHandler().getClientID().toString(), this.mySession.getQueueID()) : ClientSessionAddress.createClientSessionAddressString(this.mySession.getNetworkHandler().getClientID().toString(), null);
                DeactivateAdminNotification command2 = new DeactivateAdminNotification(2, address, false, this.myServerSideConsumerID);
                this.mySession.getNetworkHandler().requestOK(command2);
            }
        }
        catch (NotificationException ex) {
            throw new JMSException("Unable to register the AsyncListener in the server: " + ex);
        }
        catch (InterruptedException ex) {
            throw new JMSException("Unable to register the AsyncListener in the server: " + ex);
        }
    }

    private void checkReceiveAllowed() throws JMSException {
        if (!this.mySession.getConnection().isStarted()) {
            throw new JMSException("Receive not allowed: connection not started.");
        }
        if (this.mySession.existAsyncConsumer()) {
            throw new JMSException("Receive not allowed: asynchronous message listeners are already bound to session.");
        }
        this.checkRegistered();
    }

    private void checkRegistered() throws JMSException {
        MessageConsumerImpl aConsumer = this.mySession.getMessageConsumer(this.myID);
        if (aConsumer == null) {
            if (this.myIsDurable) {
                if (this.mySession.getDurableConsumer(this.mySubscription) == null) {
                    this.mySession.addDurableMessageConsumer(this, this.mySubscription);
                } else {
                    this.mySession.addMessageConsumer(this);
                }
            } else {
                this.mySession.addMessageConsumer(this);
            }
        }
    }

    protected boolean activateOnServerAtSessionRestart() {
        return this.myActivateOnServerAtSessionRestart;
    }
}

