/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.client;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLSocketFactory;

public class AdminConnection {
    private Socket m_clientSocket = null;
    private DataInputStream m_inStream = null;
    private DataOutputStream m_outStream = null;
    private StringBuffer m_outLines = null;
    private static final int ADMIN_MSG_VERSION = -889279231;
    private static final String QUIT_COMMAND = "quit";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public void close() {
        if (this.m_outLines != null) {
            this.sendLines();
        }
        if (this.m_clientSocket != null) {
            this.sendMessage(QUIT_COMMAND);
        }
        this.closeConnection();
    }

    private void closeConnection() {
        if (this.m_inStream != null) {
            try {
                this.m_inStream.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.m_inStream = null;
        }
        if (this.m_outStream != null) {
            try {
                this.m_outStream.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.m_outStream = null;
        }
        if (this.m_clientSocket != null) {
            try {
                this.m_clientSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.m_clientSocket = null;
        }
    }

    public void connectToAdminService(boolean useSSL, String adminHost, int adminPort) throws IOException {
        if (useSSL) {
            SSLSocketFactory sslFact = (SSLSocketFactory)SSLSocketFactory.getDefault();
            this.m_clientSocket = sslFact.createSocket(adminHost, adminPort);
        } else {
            this.m_clientSocket = new Socket(adminHost, adminPort);
        }
        this.open(this.m_clientSocket.getInputStream(), this.m_clientSocket.getOutputStream());
    }

    public InetAddress getInetAddress() {
        return this.m_clientSocket == null ? null : this.m_clientSocket.getInetAddress();
    }

    public int getPort() {
        return this.m_clientSocket == null ? -1 : this.m_clientSocket.getPort();
    }

    public void open(InputStream inStream, OutputStream outStream) {
        this.m_inStream = new DataInputStream(inStream);
        this.m_outStream = new DataOutputStream(outStream);
    }

    public void println(String line) {
        if (this.m_outLines == null) {
            this.m_outLines = new StringBuffer(4096);
        }
        this.m_outLines.append(line);
        this.m_outLines.append(LINE_SEPARATOR);
    }

    public String receivedMessage() throws IOException {
        if (this.m_inStream == null) {
            return null;
        }
        String message = null;
        int version = 0;
        try {
            version = this.m_inStream.readInt();
            if (version == -889279231) {
                message = this.m_inStream.readUTF();
                version = this.m_inStream.readInt();
            }
        }
        catch (IOException ex) {
            this.closeConnection();
            return null;
        }
        if (version != -889279231) {
            throw new IOException("Invalid admin message version " + version);
        }
        return message;
    }

    private void send(String message) {
        if (this.m_outStream == null) {
            return;
        }
        try {
            this.m_outStream.writeInt(-889279231);
            this.m_outStream.writeUTF(message);
            this.m_outStream.writeInt(-889279231);
            this.m_outStream.flush();
        }
        catch (IOException ex) {
            this.closeConnection();
        }
    }

    public void sendLines() {
        if (this.m_outLines != null) {
            this.send(this.m_outLines.toString());
            this.m_outLines = null;
        } else {
            this.sendMessage("");
        }
    }

    public void sendMessage(String message) {
        this.send(message + LINE_SEPARATOR);
    }
}

