/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.agents;

import com.sap.sdb.msgServer.Server;
import com.sap.sdb.msgServer.agents.FreeLists;
import com.sap.sdb.msgServer.agents.JmsOutputManager;
import com.sap.sdb.msgServer.agents.JmsThread;
import com.sap.sdb.msgServer.agents.ReceivingException;
import com.sap.sdb.msgServer.client.MessageImpl;
import com.sap.sdb.msgServer.database.ConsumerList;
import com.sap.sdb.msgServer.database.DBConnectionPool;
import com.sap.sdb.msgServer.database.DestinationList;
import com.sap.sdb.msgServer.database.MessageTable;
import com.sap.sdb.msgServer.database.SendOrderTable;
import com.sap.sdb.msgServer.database.UserConnection;
import com.sap.sdb.msgServer.msgselector.MsgSelector;
import com.sap.sdb.msgServer.service.JmsService;
import com.sap.sdb.msgServer.service.ServiceException;
import com.sap.sdb.msgServer.util.ClientSessionAddress;
import com.sap.sdb.msgServer.util.MessageConsumerInfo;
import com.sap.sdb.msgServer.util.MessageNotification;
import com.sap.sdb.msgServer.util.SyncReceiveNotification;
import com.sap.sdb.msgServer.util.TimeOutNotification;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.JMSException;

public class SyncReceiveHandler {
    private static SyncReceiveHandler sSyncReceiveHandler = null;
    private Hashtable myPendingSyncReceivers;
    private long myMinTimeToWait;
    private long myLastTimeToWait;
    JmsService myService;
    private static boolean myIsSelectTransientFirst = false;
    private long myStart;
    private boolean WRITE_PROTOCOL = false;
    private final Object mySyncReceiveWait = new Object();
    private SyncReceiverThread mySyncReceiverThread;

    public static synchronized void createInstance(JmsService service) throws ServiceException {
        if (sSyncReceiveHandler != null) {
            throw new IllegalStateException("SyncReceiveHandler singleton already created.");
        }
        sSyncReceiveHandler = new SyncReceiveHandler(service);
        SyncReceiveHandler.getInstance().mySyncReceiverThread.start();
    }

    public static synchronized void destroyInstance() {
        if (sSyncReceiveHandler == null) {
            throw new IllegalStateException("SyncReceiveHandler singleton not created.");
        }
        SyncReceiveHandler.getInstance().mySyncReceiverThread.pleaseStop();
        sSyncReceiveHandler = null;
    }

    private static SyncReceiveHandler getInstance() {
        if (sSyncReceiveHandler == null) {
            throw new IllegalStateException("SyncReceiveHandler singleton not created.");
        }
        return sSyncReceiveHandler;
    }

    private SyncReceiveHandler(JmsService service) throws ServiceException {
        this.myService = service;
        this.myPendingSyncReceivers = new Hashtable();
        this.myMinTimeToWait = 0L;
        this.mySyncReceiverThread = new SyncReceiverThread(service, "SyncReceiverThread");
        service.addJmsThread(this.mySyncReceiverThread);
    }

    public static synchronized void removePendingConsumer(long consumerID) {
        SyncReceiveHandler.getInstance().myPendingSyncReceivers.remove(new Long(consumerID));
    }

    public static synchronized MessageConsumerInfo getQueueConsumer(UserConnection dbConnection, int modeDelivery, long messageID, long destID) throws JMSException, SQLException {
        Enumeration keys = SyncReceiveHandler.getInstance().myPendingSyncReceivers.keys();
        while (keys.hasMoreElements()) {
            Long key = (Long)keys.nextElement();
            SyncReceiveNotification syncNot = (SyncReceiveNotification)SyncReceiveHandler.getInstance().myPendingSyncReceivers.get(key);
            long consumerID = syncNot.getConsumerID();
            long syncDestID = DestinationList.getDestinationID(syncNot.getDestName(), true);
            if (syncDestID != destID) continue;
            MessageConsumerInfo consumerInfo = ConsumerList.getInactiveConsumer(consumerID);
            if (consumerInfo == null) {
                throw new JMSException("No inactive consumer with ID <" + consumerID + "> registered by the Server.");
            }
            MsgSelector selector = consumerInfo.getMsgSelector();
            if (!MessageTable.matches(dbConnection, modeDelivery, messageID, selector)) continue;
            SyncReceiveHandler.getInstance().myPendingSyncReceivers.remove(key);
            return consumerInfo;
        }
        return null;
    }

    public static synchronized MessageConsumerInfo getTopicConsumer(long topicConsumerId, long destID) throws JMSException {
        Enumeration keys = SyncReceiveHandler.getInstance().myPendingSyncReceivers.keys();
        while (keys.hasMoreElements()) {
            Long key = (Long)keys.nextElement();
            SyncReceiveNotification syncNot = (SyncReceiveNotification)SyncReceiveHandler.getInstance().myPendingSyncReceivers.get(key);
            long consumerID = syncNot.getConsumerID();
            long syncDestID = DestinationList.getDestinationID(syncNot.getDestName(), false);
            MessageConsumerInfo consumerInfo = ConsumerList.getInactiveConsumer(consumerID);
            if (consumerInfo == null) {
                throw new JMSException("No inactive consumer with ID <" + consumerID + "> registered by the Server.");
            }
            if (syncDestID != destID || consumerID != topicConsumerId) continue;
            SyncReceiveHandler.getInstance().myPendingSyncReceivers.remove(key);
            return consumerInfo;
        }
        return null;
    }

    private static synchronized long checkWaitTimeAndPendingReceivers() throws ReceivingException {
        if (SyncReceiveHandler.getInstance().myPendingSyncReceivers.size() < 1) {
            return 0L;
        }
        long timeToWait = 0L;
        long timeToWaitMin = 0L;
        long waitedTime = 0L;
        if (SyncReceiveHandler.getInstance().WRITE_PROTOCOL) {
            Server.log("checkWaitTimeAndPendingReceivers: " + (System.currentTimeMillis() - SyncReceiveHandler.getInstance().myStart));
        }
        if (SyncReceiveHandler.getInstance().myLastTimeToWait > 0L) {
            waitedTime = System.currentTimeMillis() - SyncReceiveHandler.getInstance().myLastTimeToWait;
        }
        if (SyncReceiveHandler.getInstance().WRITE_PROTOCOL) {
            Server.log("waitedTime: " + waitedTime);
        }
        Enumeration keys = SyncReceiveHandler.getInstance().myPendingSyncReceivers.keys();
        while (keys.hasMoreElements()) {
            Long key = (Long)keys.nextElement();
            SyncReceiveNotification notification = (SyncReceiveNotification)SyncReceiveHandler.getInstance().myPendingSyncReceivers.get(key);
            timeToWait = notification.getTimeOut();
            if (timeToWait <= 0L) continue;
            if (waitedTime >= timeToWait) {
                SyncReceiveHandler.getInstance().myPendingSyncReceivers.remove(key);
                if (SyncReceiveHandler.getInstance().WRITE_PROTOCOL) {
                    Server.log("SyncReceiveHandler remove pending sync notification (left wait time " + timeToWait + "ms) for consumer: " + key);
                }
                SyncReceiveHandler.sendTimeOutNotification(notification.getConsumerID());
                continue;
            }
            long temp = timeToWait - waitedTime;
            notification.setTimeOut(temp);
            if (timeToWaitMin > temp || timeToWaitMin == 0L) {
                timeToWaitMin = temp;
            }
            if (!SyncReceiveHandler.getInstance().WRITE_PROTOCOL) continue;
            Server.log("temp: " + temp);
        }
        if (SyncReceiveHandler.getInstance().WRITE_PROTOCOL) {
            Server.log("timeToWaitMin: " + timeToWaitMin);
        }
        return timeToWaitMin;
    }

    private static void sendTimeOutNotification(long consumerID) throws ReceivingException {
        MessageConsumerInfo consumerInfo = ConsumerList.getInactiveConsumer(consumerID);
        if (consumerInfo == null) {
            throw new ReceivingException("No inactive consumer with ID <" + consumerID + "> registered by the Server.");
        }
        TimeOutNotification timeOutNot = new TimeOutNotification("No message for consumer with ID <" + consumerID + ">.");
        timeOutNot.setClientSessionAddress(consumerInfo.getSynchronousClientSessionAddress());
        try {
            JmsOutputManager.send(timeOutNot);
        }
        catch (IOException ex) {
            JmsService.logException(ex);
            throw new ReceivingException(ex);
        }
        finally {
            consumerInfo.setSynchronousClientSessionAddress(null);
        }
    }

    public static synchronized void sendMessage(MessageImpl aMessage, int modeDelivery, MessageConsumerInfo consumerInfo) throws SQLException, ReceivingException {
        long messageID = 0L;
        long consumerID = 0L;
        boolean isQueueOrder = false;
        UserConnection dbConnection = null;
        ClientSessionAddress syncClientSessionAddress = null;
        MessageNotification messageNot = null;
        try {
            try {
                syncClientSessionAddress = consumerInfo.getSynchronousClientSessionAddress();
                if (syncClientSessionAddress == null) {
                    throw new ReceivingException("SyncReceiveHandler.sendMessage:Synchronous consumer <" + consumerInfo.getConsumerID() + "> not available");
                }
                messageNot = FreeLists.getMessageNot(aMessage);
                messageNot.setClientSessionAddress(syncClientSessionAddress);
                messageNot.setMessageConsumerInfo(consumerInfo);
                messageID = messageNot.getMessage().getMessageID();
                consumerID = consumerInfo.getConsumerID();
                isQueueOrder = messageNot.getMessage().isQueueMessage();
                dbConnection = DBConnectionPool.useConnection();
                if (!SendOrderTable.setDelivered(dbConnection, modeDelivery, isQueueOrder, messageID, consumerID, false)) {
                    throw new SQLException("setDelivered failed, messageID <" + messageID + ">,consumerID<" + consumerID + ">");
                }
                dbConnection.commit();
                JmsOutputManager.send(messageNot);
            }
            catch (IOException ex) {
                SyncReceiveHandler.exceptionAction(dbConnection, messageID, consumerID, isQueueOrder, modeDelivery);
                JmsService.logException(ex);
                throw new ReceivingException(ex);
            }
            catch (SQLException ex) {
                SyncReceiveHandler.exceptionAction(dbConnection, messageID, consumerID, isQueueOrder, modeDelivery);
                JmsService.logException(ex);
                throw new ReceivingException(ex);
            }
            catch (ReceivingException ex) {
                SyncReceiveHandler.exceptionAction(dbConnection, messageID, consumerID, isQueueOrder, modeDelivery);
                JmsService.logException(ex);
                throw new ReceivingException(ex);
            }
            Object var13_9 = null;
            consumerInfo.setSynchronousClientSessionAddress(null);
        }
        catch (Throwable throwable) {
            Object var13_10 = null;
            consumerInfo.setSynchronousClientSessionAddress(null);
            FreeLists.freeMessageNot(messageNot);
            DBConnectionPool.returnConnection(dbConnection);
            throw throwable;
        }
        FreeLists.freeMessageNot(messageNot);
        DBConnectionPool.returnConnection(dbConnection);
    }

    private static void exceptionAction(UserConnection dbConnection, long messageID, long consumerID, boolean isQueueOrder, int modeDelivery) throws SQLException {
        dbConnection.rollback();
        if (isQueueOrder) {
            SendOrderTable.resetQueueOrder(dbConnection, modeDelivery, messageID, consumerID);
        } else {
            SendOrderTable.resetTopicOrder(dbConnection, modeDelivery, messageID, consumerID);
        }
        dbConnection.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageNotification handleSyncRecReq(SyncReceiveNotification notification) throws ReceivingException {
        int destType = notification.getDestType();
        long consumerID = notification.getConsumerID();
        boolean isQueue = destType == 0;
        MessageNotification messageNot = null;
        UserConnection dbConnection = null;
        MessageConsumerInfo consumerInfo = ConsumerList.getInactiveConsumer(consumerID);
        if (consumerInfo == null) {
            throw new ReceivingException("No inactive consumer with ID <" + consumerID + "> registered by the Server");
        }
        try {
            dbConnection = DBConnectionPool.useConnection();
            messageNot = SyncReceiveHandler.getMsgAndMarkSendOrder(dbConnection, consumerInfo, isQueue);
            if (messageNot != null) {
                messageNot.setMessageConsumerInfo(consumerInfo);
            }
            dbConnection.commit();
        }
        catch (JMSException ex) {
            FreeLists.freeMessageNot(messageNot);
            messageNot = null;
            JmsService.logException((Exception)((Object)ex));
        }
        catch (SQLException ex) {
            FreeLists.freeMessageNot(messageNot);
            messageNot = null;
            JmsService.logException(ex);
        }
        finally {
            DBConnectionPool.returnConnection(dbConnection);
        }
        if (messageNot == null && !notification.getNoWait()) {
            consumerInfo.setSynchronousClientSessionAddress(notification.getClientSessionAddress());
            if (SyncReceiveHandler.getInstance().myPendingSyncReceivers.size() < 1) {
                SyncReceiveHandler.getInstance().myLastTimeToWait = 0L;
            }
            SyncReceiveHandler.getInstance().myPendingSyncReceivers.put(new Long(consumerID), notification);
            if (SyncReceiveHandler.getInstance().WRITE_PROTOCOL) {
                Server.log("Put Consumer <" + consumerID + "> at " + (System.currentTimeMillis() - SyncReceiveHandler.getInstance().myStart));
            }
            if (SyncReceiveHandler.getInstance().myLastTimeToWait > 0L) {
                long waitedTime = System.currentTimeMillis() - SyncReceiveHandler.getInstance().myLastTimeToWait;
                notification.setTimeOut(notification.getTimeOut() + waitedTime);
            }
            Object object = SyncReceiveHandler.getInstance().mySyncReceiveWait;
            synchronized (object) {
                SyncReceiveHandler.getInstance().mySyncReceiveWait.notify();
            }
        } else if (messageNot == null && notification.getNoWait()) {
            messageNot = FreeLists.getMessageNot(null);
            messageNot.setNullMessage();
            messageNot.setMessageConsumerInfo(consumerInfo);
        }
        return messageNot;
    }

    private static MessageNotification getMsgAndMarkSendOrder(UserConnection dbConnection, MessageConsumerInfo consumerInfo, boolean isQueue) throws SQLException, JMSException {
        MessageNotification msgNotification = null;
        int modeDelivery = myIsSelectTransientFirst ? 1 : 2;
        for (int i = 0; !(i >= 2 || DBConnectionPool.existsConnection(modeDelivery) && (msgNotification = SendOrderTable.getMarkedMessageForSyncReceive(dbConnection, modeDelivery, isQueue, consumerInfo)) != null); ++i) {
            modeDelivery = modeDelivery == 1 ? 2 : 1;
        }
        if (msgNotification != null) {
            myIsSelectTransientFirst = !myIsSelectTransientFirst;
        }
        return msgNotification;
    }

    private class SyncReceiverThread
    extends JmsThread {
        boolean myStopFlag;

        public SyncReceiverThread(JmsService service, String name) throws ServiceException {
            super(service, name);
            this.myStopFlag = false;
            this.myStopFlag = false;
        }

        public void pleaseStop() {
            this.myStopFlag = true;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            SyncReceiveHandler.this.myStart = System.currentTimeMillis();
            while (!this.myStopFlag) {
                try {
                    Object object = SyncReceiveHandler.getInstance().mySyncReceiveWait;
                    synchronized (object) {
                        SyncReceiveHandler.getInstance().myLastTimeToWait = System.currentTimeMillis();
                        JmsThread.performWait(SyncReceiveHandler.getInstance().mySyncReceiveWait, SyncReceiveHandler.getInstance().myMinTimeToWait, "synchronous receive");
                    }
                    SyncReceiveHandler.getInstance().myMinTimeToWait = SyncReceiveHandler.checkWaitTimeAndPendingReceivers();
                }
                catch (InterruptedException ex) {
                    this.log("Thread interrupted");
                }
                catch (ReceivingException ex) {
                    Server.log("SyncReceiverThread: " + ex.toString());
                }
            }
        }

        public void doWork() {
        }
    }
}

