/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.agents;

import com.sap.sdb.msgServer.Server;
import com.sap.sdb.msgServer.agents.ConnectionManager;
import com.sap.sdb.msgServer.agents.JmsThread;
import com.sap.sdb.msgServer.service.Service;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

public class SocketListener
extends JmsThread {
    ConnectionManager myConnectionManager;
    ServerSocket myListenSocket;
    SSLServerSocket myListenSSLSocket;
    boolean myUseSSL;
    int myPort;
    Service myService;
    boolean myStopFlag;

    public SocketListener(ThreadGroup group, int port, ConnectionManager manager, Service service, boolean useSSL) throws IOException {
        super(group, "Listener:" + port);
        this.myUseSSL = useSSL;
        if (this.myUseSSL) {
            SSLServerSocketFactory sslServFact = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
            this.myListenSSLSocket = (SSLServerSocket)sslServFact.createServerSocket(port);
            this.myListenSSLSocket.setSoTimeout(5000);
        } else {
            this.myListenSocket = new ServerSocket(port);
            this.myListenSocket.setSoTimeout(5000);
        }
        this.myPort = port;
        this.myConnectionManager = manager;
        this.myService = service;
    }

    public Service getService() {
        return this.myService;
    }

    public int getPort() {
        return this.myPort;
    }

    public void pleaseStop() {
        this.myStopFlag = true;
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block13: {
            super.registerThisThread();
            try {
                this.myStopFlag = false;
                while (!this.myStopFlag) {
                    try {
                        super.setOwnAction("listening for connection");
                        Socket client = null;
                        client = this.myUseSSL ? this.myListenSSLSocket.accept() : this.myListenSocket.accept();
                        super.setOwnAction("add " + this.myService.getName() + " connection");
                        if (!this.myStopFlag) {
                            this.myConnectionManager.addConnection(client, this.myService);
                        }
                    }
                    catch (InterruptedIOException e) {
                    }
                    catch (IOException e) {
                        Server.log(e);
                    }
                    super.resetAction();
                }
                if (this.myUseSSL) {
                    Server.log("SocketListener ended: " + this.myListenSSLSocket.getLocalPort());
                } else {
                    Server.log("SocketListener ended: " + this.myListenSocket.getLocalPort());
                }
                try {
                    if (this.myUseSSL) {
                        this.myListenSSLSocket.close();
                        break block13;
                    }
                    this.myListenSocket.close();
                }
                catch (IOException e) {
                    Server.log(e);
                }
            }
            finally {
                super.unregisterThisThread();
            }
        }
    }
}

