/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.agents;

import com.sap.sdb.msgServer.agents.FreeLists;
import com.sap.sdb.msgServer.agents.JmsOutputManager;
import com.sap.sdb.msgServer.agents.JmsThread;
import com.sap.sdb.msgServer.database.ConsumerList;
import com.sap.sdb.msgServer.database.DBConnectionPool;
import com.sap.sdb.msgServer.database.MessageTable;
import com.sap.sdb.msgServer.database.QueueReceiverList;
import com.sap.sdb.msgServer.database.SendOrderTable;
import com.sap.sdb.msgServer.database.UserConnection;
import com.sap.sdb.msgServer.msgselector.MsgSelector;
import com.sap.sdb.msgServer.service.JmsService;
import com.sap.sdb.msgServer.service.ServiceException;
import com.sap.sdb.msgServer.util.InvalidSocketException;
import com.sap.sdb.msgServer.util.MessageConsumerInfo;
import com.sap.sdb.msgServer.util.NotificationChannel;
import com.sap.sdb.msgServer.util.SendNotification;
import com.sap.sdb.msgServer.util.SendingNotificationCounter;
import com.sap.sdb.msgServer.util.SendingNotificationQueue;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import javax.jms.JMSException;

public class SendOrderPolling
extends JmsThread {
    private int myPollingWaitTimeout = 10000;
    private int myPushSize = 50;
    private int myOrdersPrevPolling = 0;
    private int myCountOrdersSent;
    private int myCheckedResultCacheEntries;
    private int myResultCacheEntries;
    private int myPreparedOrders;
    private int myDeliveryMode;
    private long myClientTimeOut = -1L;
    private HashMap myIgnoreClientMap;
    private SendNotification[] myResultCache = null;
    private SendNotification[] myListPreparedOrders = null;
    private SendingNotificationQueue mySendingQueue;
    private SendingNotificationCounter mySendingCounter;
    private UserConnection myConnection = null;
    private static Object[] myPollingWait = null;
    private static boolean[] myDoWaitBeforePolling = null;
    private static final String POLLING = "polling";

    public SendOrderPolling(JmsService service, SendingNotificationQueue sendingQueue, SendingNotificationCounter sendingCounter, int modeDelivery, int pollingWaitTimeout, int fetchSize, int pushSize, long clientTimeOutInSec) throws ServiceException {
        super(service, "SendOrderPolling");
        int resultCacheSize;
        this.mySendingQueue = sendingQueue;
        this.mySendingCounter = sendingCounter;
        this.myClientTimeOut = clientTimeOutInSec;
        this.myIgnoreClientMap = new HashMap();
        if (myPollingWait == null) {
            myPollingWait = new Object[3];
            myDoWaitBeforePolling = new boolean[3];
        }
        this.myDeliveryMode = modeDelivery;
        if (pollingWaitTimeout > 0) {
            this.myPollingWaitTimeout = pollingWaitTimeout;
        }
        if (pushSize > 0) {
            this.myPushSize = pushSize;
        }
        int n = resultCacheSize = fetchSize > 0 ? fetchSize : this.myPushSize;
        if (this.myPushSize > resultCacheSize) {
            this.myPushSize = resultCacheSize;
        }
        this.myResultCache = new SendNotification[resultCacheSize];
        this.myListPreparedOrders = new SendNotification[this.myPushSize];
        SendOrderPolling.myPollingWait[modeDelivery] = new Object();
        SendOrderPolling.myDoWaitBeforePolling[modeDelivery] = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIgnoredConsumer(MessageConsumerInfo consumer, long consumerTimeStamp) throws JMSException, SQLException {
        this.myIgnoreClientMap.put(consumer, null);
        if (ConsumerList.getNumberOfActiveConsumers() <= 0) {
            return;
        }
        long ts = JmsService.getTimeStamp();
        long waitedTime = (ts - consumerTimeStamp) / 1000L;
        if (waitedTime <= this.myClientTimeOut) {
            return;
        }
        UserConnection dbConnection = null;
        try {
            dbConnection = DBConnectionPool.useConnection();
            ConsumerList.unregisterAndCommit(dbConnection, this.getJmsService().getSendingQueue(), consumer.getConsumerID(), consumer.getClientSessionAddress().toStreamString(), false);
            JmsOutputManager.closeNotificationChannel(consumer.getClientSessionAddress().getClientID());
            this.log("-------------------------------------------------------------");
            this.log("    Consumer <" + consumer.getConsumerID() + "> was deactivated, waited time:" + waitedTime + ", client time out:" + this.myClientTimeOut);
            this.log("-------------------------------------------------------------");
        }
        catch (IOException ex) {
            this.logException(ex);
        }
        finally {
            DBConnectionPool.returnConnection(dbConnection);
        }
    }

    private void clearSendList() {
        int i;
        for (i = 0; i < this.myResultCache.length; ++i) {
            if (this.myResultCache[i] == null) continue;
            FreeLists.freeSendNotification(this.myResultCache[i]);
            this.myResultCache[i] = null;
        }
        for (i = 0; i < this.myListPreparedOrders.length; ++i) {
            if (this.myListPreparedOrders[i] == null) continue;
            NotificationChannel channel = JmsOutputManager.getChannel(this.myListPreparedOrders[i].getServerChannel());
            if (channel != null) {
                channel.tryDropNotification(this.myListPreparedOrders[i]);
            }
            FreeLists.freeSendNotification(this.myListPreparedOrders[i]);
            this.myListPreparedOrders[i] = null;
        }
        this.myResultCacheEntries = 0;
        this.myCheckedResultCacheEntries = 0;
        this.myPreparedOrders = 0;
    }

    public void doWork() throws Exception {
        this.waitBeforePolling();
        this.myCountOrdersSent = 0;
        if (ConsumerList.getNumberOfActiveConsumers() > 0) {
            if (this.myConnection == null) {
                this.myConnection = DBConnectionPool.getNewConnection();
            } else {
                this.myConnection.rollback();
            }
            this.selectAndPushSendOrders();
            this.myOrdersPrevPolling = this.myCountOrdersSent;
        }
    }

    public void finishWork() throws Exception {
        if (this.myConnection != null) {
            this.myConnection.rollback();
            this.myConnection.close();
            this.myConnection = null;
        }
    }

    public int getPreviousNumberOfOrdersSent() {
        return this.myOrdersPrevPolling;
    }

    private long getQueueConsumerIdForSending(SendNotification order) throws JMSException, SQLException {
        QueueReceiverList queueConsumers = ConsumerList.getQueueReceiverList(order.getDestinationID());
        if (queueConsumers == null) {
            return 0L;
        }
        MessageConsumerInfo[] consumerInfo = queueConsumers.getConsumerArray();
        long consumerID = 0L;
        for (int i = 0; i < consumerInfo.length; ++i) {
            if (this.myIgnoreClientMap.containsKey(consumerInfo[i])) continue;
            long consumerTimeStamp = consumerInfo[i].getIgnoreBySendOrderPolling();
            if (consumerTimeStamp > 0L) {
                this.checkIgnoredConsumer(consumerInfo[i], consumerTimeStamp);
                continue;
            }
            MsgSelector selector = consumerInfo[i].getMsgSelector();
            if (selector != null && !selector.isEmpty() && !MessageTable.matches(this.myConnection, this.myDeliveryMode, order.getMessageID(), selector)) continue;
            consumerID = consumerInfo[i].getConsumerID();
            order.setReceiverClientAddress(consumerInfo[i].getClientSessionAddress().toStreamString());
            queueConsumers.reorderConsumerInfo(consumerInfo[i]);
            break;
        }
        return consumerID;
    }

    private long getTopicConsumerIdForSending(SendNotification order) throws JMSException, SQLException {
        long consumerID = order.getConsumerID();
        MessageConsumerInfo consumerInfo = ConsumerList.getActiveConsumer(consumerID);
        if (consumerInfo == null || this.myIgnoreClientMap.containsKey(consumerInfo)) {
            consumerID = 0L;
        } else {
            long consumerTimeStamp = consumerInfo.getIgnoreBySendOrderPolling();
            if (consumerTimeStamp > 0L) {
                this.checkIgnoredConsumer(consumerInfo, consumerTimeStamp);
                consumerID = 0L;
            } else {
                order.setReceiverClientAddress(consumerInfo.getClientSessionAddress().toStreamString());
            }
        }
        return consumerID;
    }

    public static void notifyNewConsumerActive() {
        for (int i = 1; i <= 2; ++i) {
            if (myPollingWait[i] == null) continue;
            SendOrderPolling.notifyPollingThread(i);
        }
    }

    public static void notifyMessageArrived(int modeDelivery) {
        if (modeDelivery == 1 && myPollingWait[modeDelivery] == null) {
            SendOrderPolling.notifyPollingThread(2);
        } else {
            SendOrderPolling.notifyPollingThread(modeDelivery);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyPollingThread(int modeDelivery) {
        Object object = myPollingWait[modeDelivery];
        synchronized (object) {
            myPollingWait[modeDelivery].notify();
            SendOrderPolling.myDoWaitBeforePolling[modeDelivery] = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean prepareNextOrder() throws JMSException, InvalidSocketException, SQLException {
        boolean bl;
        block11: {
            SendNotification order;
            block9: {
                boolean newConsumerID2;
                block10: {
                    order = null;
                    try {
                        while (order == null && this.myCheckedResultCacheEntries < this.myResultCacheEntries) {
                            long newConsumerID2;
                            order = this.myResultCache[this.myCheckedResultCacheEntries];
                            this.myResultCache[this.myCheckedResultCacheEntries] = null;
                            ++this.myCheckedResultCacheEntries;
                            long l = newConsumerID2 = order.getIsQueueSendNotification() ? this.getQueueConsumerIdForSending(order) : this.getTopicConsumerIdForSending(order);
                            if (newConsumerID2 <= 0L) {
                                FreeLists.freeSendNotification(order);
                                order = null;
                                continue;
                            }
                            int rowCount = SendOrderTable.setInprocessAndDelivered(this.myConnection, this.myDeliveryMode, 1, newConsumerID2, order.getMessageID(), order.getConsumerID());
                            if (rowCount == 1) {
                                order.setConsumerID(newConsumerID2);
                                continue;
                            }
                            FreeLists.freeSendNotification(order);
                            order = null;
                        }
                        if (order != null) break block9;
                        newConsumerID2 = false;
                        if (order == null) break block10;
                    }
                    catch (Throwable throwable) {
                        if (order != null) {
                            FreeLists.freeSendNotification(order);
                        }
                        throw throwable;
                    }
                    FreeLists.freeSendNotification(order);
                }
                return newConsumerID2;
            }
            NotificationChannel channel = JmsOutputManager.getChannel(order.getServerChannel());
            if (channel == null) {
                InvalidSocketException ex = new InvalidSocketException(order.getMessageID(), order.getConsumerID(), order.getDeliveryMode(), order.getIsQueueSendNotification(), order.getReceiverClientAddress(), this.getName() + ": No valid notification channel");
                throw ex;
            }
            channel.addNotification(order);
            if (JmsService.getVerboseSendingQueues()) {
                this.log("channel [" + order.getServerChannel() + "].addNotification: messageID <" + order.getMessageID() + ">, consumerID <" + order.getConsumerID() + ">");
            }
            this.myListPreparedOrders[this.myPreparedOrders] = order;
            ++this.myPreparedOrders;
            order = null;
            bl = true;
            if (order == null) break block11;
            FreeLists.freeSendNotification(order);
        }
        return bl;
    }

    private void pushSendOrders() throws InterruptedException, SQLException {
        if (this.myPreparedOrders <= 0) {
            return;
        }
        this.myConnection.commit();
        this.mySendingQueue.addSendNotifications(this.myListPreparedOrders, this.myPreparedOrders);
        this.myCountOrdersSent += this.myPreparedOrders;
        this.mySendingCounter.waitForSpace(this.myPreparedOrders);
        this.myPreparedOrders = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void selectAndPushSendOrders() throws InterruptedException, JMSException, SQLException {
        block17: {
            if (ConsumerList.getNumberOfActiveConsumers() <= 0) {
                return;
            }
            ResultSet result = null;
            int fetchSize = this.myResultCache.length;
            try {
                try {
                    boolean anyOrderPrepared = false;
                    for (int i = 0; i < 2; ++i) {
                        this.myIgnoreClientMap.clear();
                        this.myPreparedOrders = 0;
                        this.myCheckedResultCacheEntries = 0;
                        Object object = ConsumerList.getSendOrderSync();
                        synchronized (object) {
                            result = SendOrderTable.selectOrdersForReceive(this.myConnection, this.myDeliveryMode, fetchSize);
                            this.myResultCacheEntries = SendOrderTable.fetchNextOrdersForReceive(result, this.myDeliveryMode, this.myResultCache);
                            this.myConnection.commit();
                            if (this.myResultCacheEntries <= 0) break;
                        }
                        while (this.prepareNextOrder()) {
                            anyOrderPrepared = true;
                            if (this.myPreparedOrders < this.myPushSize) continue;
                            this.pushSendOrders();
                        }
                        if (this.myPreparedOrders > 0) {
                            this.pushSendOrders();
                        }
                        if (anyOrderPrepared) break;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException ex) {
                            // empty catch block
                        }
                        if (this.myIgnoreClientMap.size() > 0) break;
                        fetchSize = Integer.MAX_VALUE;
                        result.close();
                        result = null;
                    }
                    if (this.myResultCacheEntries == this.myResultCache.length || this.myIgnoreClientMap.size() > 0) {
                        SendOrderPolling.myDoWaitBeforePolling[this.myDeliveryMode] = false;
                    }
                    this.myIgnoreClientMap.clear();
                    if (JmsService.getVerboseSendOrderStat()) {
                        this.log("myResultCacheEntries: " + this.myResultCacheEntries + "; myResultCache.length: " + this.myResultCache.length + "; fetchSize: " + fetchSize);
                    }
                }
                catch (InvalidSocketException ex) {
                    this.myConnection.rollback();
                    this.clearSendList();
                    ConsumerList.unregisterAndCommit(this.myConnection, this.mySendingQueue, ex.getConsumerID(), ex.getReceiverClientAddress(), false);
                    this.logException(ex);
                    Object var8_11 = null;
                    if (result == null) return;
                    result.close();
                    return;
                }
                catch (JMSException ex) {
                    this.myConnection.rollback();
                    this.clearSendList();
                    this.logException((Exception)((Object)ex));
                    Object var8_12 = null;
                    if (result == null) return;
                    result.close();
                    return;
                }
                catch (SQLException ex) {
                    this.myConnection.rollback();
                    this.clearSendList();
                    this.logException(ex);
                    Object var8_13 = null;
                    if (result == null) return;
                    result.close();
                    return;
                }
                Object var8_10 = null;
                if (result == null) break block17;
            }
            catch (Throwable throwable) {
                Object var8_14 = null;
                if (result != null) {
                    result.close();
                    result = null;
                }
                throw throwable;
            }
            result.close();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitBeforePolling() throws InterruptedException {
        Object object = myPollingWait[this.myDeliveryMode];
        synchronized (object) {
            if (myDoWaitBeforePolling[this.myDeliveryMode]) {
                this.waitSemaphore(myPollingWait[this.myDeliveryMode], this.myPollingWaitTimeout, POLLING);
            }
            SendOrderPolling.myDoWaitBeforePolling[this.myDeliveryMode] = true;
        }
    }
}

