/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.agents;

import com.sap.sdb.msgServer.client.MessageImpl;
import com.sap.sdb.msgServer.util.MessageNotification;
import com.sap.sdb.msgServer.util.OkNotification;
import com.sap.sdb.msgServer.util.SendNotification;
import java.util.ArrayList;

public class FreeLists {
    private ArrayList myOKNotFreelist = new ArrayList(100);
    private ArrayList myMessageNotFreelist = new ArrayList(100);
    private int myMaxSendNotifications;
    private ArrayList mySendNotificationFreelist;
    private static FreeLists sFreeLists = null;

    private FreeLists(int maxSendNotifications) {
        this.myMaxSendNotifications = maxSendNotifications;
        this.mySendNotificationFreelist = new ArrayList(maxSendNotifications);
    }

    public static synchronized void createInstance(int maxSendNotifications) {
        if (sFreeLists != null) {
            throw new IllegalStateException("FreeLists singleton already created.");
        }
        sFreeLists = new FreeLists(maxSendNotifications);
    }

    private static FreeLists getInstance() {
        if (sFreeLists == null) {
            throw new IllegalStateException("FreeLists singleton not created.");
        }
        return sFreeLists;
    }

    public static synchronized void destroyInstance() {
        if (sFreeLists == null) {
            throw new IllegalStateException("FreeLists singleton not created.");
        }
        sFreeLists = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OkNotification getOkNotification() {
        ArrayList okNotificationFreeList;
        OkNotification notification = null;
        ArrayList arrayList = okNotificationFreeList = FreeLists.getInstance().myOKNotFreelist;
        synchronized (arrayList) {
            int listSize = okNotificationFreeList.size();
            if (listSize > 0) {
                notification = (OkNotification)okNotificationFreeList.remove(listSize - 1);
            }
        }
        if (notification == null) {
            notification = new OkNotification();
        }
        return notification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freeOkNotification(OkNotification notification) {
        ArrayList okNotificationFreeList;
        if (notification == null) {
            return;
        }
        ArrayList arrayList = okNotificationFreeList = FreeLists.getInstance().myOKNotFreelist;
        synchronized (arrayList) {
            okNotificationFreeList.add(notification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageNotification getMessageNot(MessageImpl message) {
        ArrayList messageFreeList;
        int type = -1;
        long transactionID = -1L;
        MessageNotification notification = null;
        ArrayList arrayList = messageFreeList = FreeLists.getInstance().myMessageNotFreelist;
        synchronized (arrayList) {
            int listSize = messageFreeList.size();
            if (listSize > 0) {
                notification = (MessageNotification)messageFreeList.remove(listSize - 1);
            }
        }
        if (notification != null) {
            notification.setType(-1);
            notification.setTransactionID(-1L);
            notification.setMessage(message);
        } else {
            notification = new MessageNotification(-1, message, -1L);
        }
        return notification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freeMessageNot(MessageNotification notification) {
        ArrayList messageFreeList;
        if (notification == null) {
            return;
        }
        ArrayList arrayList = messageFreeList = FreeLists.getInstance().myMessageNotFreelist;
        synchronized (arrayList) {
            messageFreeList.add(notification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SendNotification getSendNotification(long messageID, long consumerID, long destination, int modeDelivery, int priority, long transSequence, long msgSequence, boolean wasAlreadyDelivered, boolean isQueueSendNotification) {
        ArrayList sendFreeList;
        SendNotification notification = null;
        ArrayList arrayList = sendFreeList = FreeLists.getInstance().mySendNotificationFreelist;
        synchronized (arrayList) {
            int listSize = sendFreeList.size();
            if (listSize > 0) {
                notification = (SendNotification)sendFreeList.remove(listSize - 1);
            }
        }
        if (notification != null) {
            notification.init(messageID, consumerID, destination, modeDelivery, priority, transSequence, msgSequence, wasAlreadyDelivered, isQueueSendNotification);
        } else {
            notification = new SendNotification(messageID, consumerID, destination, modeDelivery, priority, transSequence, msgSequence, wasAlreadyDelivered, isQueueSendNotification);
        }
        return notification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freeSendNotification(SendNotification notification) {
        ArrayList sendFreeList;
        if (notification == null) {
            return;
        }
        notification.clear();
        FreeLists instance = FreeLists.getInstance();
        ArrayList arrayList = sendFreeList = instance.mySendNotificationFreelist;
        synchronized (arrayList) {
            if (sendFreeList.size() < instance.myMaxSendNotifications) {
                sendFreeList.add(notification);
            }
        }
    }
}

