/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.agents;

import com.sap.sdb.msgServer.agents.Agent;
import com.sap.sdb.msgServer.agents.FreeLists;
import com.sap.sdb.msgServer.agents.ReceivingException;
import com.sap.sdb.msgServer.agents.SendOrderPolling;
import com.sap.sdb.msgServer.agents.SyncReceiveHandler;
import com.sap.sdb.msgServer.client.MessageImpl;
import com.sap.sdb.msgServer.database.ConsumerList;
import com.sap.sdb.msgServer.database.DBConnectionPool;
import com.sap.sdb.msgServer.database.DeliveryPreparedStmt;
import com.sap.sdb.msgServer.database.DestinationList;
import com.sap.sdb.msgServer.database.MessageTable;
import com.sap.sdb.msgServer.database.SendOrderTable;
import com.sap.sdb.msgServer.database.UserConnection;
import com.sap.sdb.msgServer.service.JmsService;
import com.sap.sdb.msgServer.service.ServiceException;
import com.sap.sdb.msgServer.util.AckOneMessageByClientNotification;
import com.sap.sdb.msgServer.util.ClientEndTransNotification;
import com.sap.sdb.msgServer.util.ErrorNotification;
import com.sap.sdb.msgServer.util.MessageConsumerInfo;
import com.sap.sdb.msgServer.util.MessageNotification;
import com.sap.sdb.msgServer.util.Notification;
import com.sap.sdb.msgServer.util.NotificationQueue;
import com.sap.sdb.msgServer.util.SendOrderKey;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import javax.jms.JMSException;

public class AcknowledgeAgent
extends Agent {
    private UserConnection m_connection = null;

    public AcknowledgeAgent(JmsService service, NotificationQueue queue) throws ServiceException {
        super(service, "AcknowledgeAgent", queue);
    }

    public Notification doCommand(Notification notification) {
        this.increaseNotificationCount();
        try {
            if (this.m_connection == null) {
                this.m_connection = DBConnectionPool.getNewConnection();
            } else {
                this.m_connection.rollback();
            }
            if (notification instanceof AckOneMessageByClientNotification) {
                boolean isCommit;
                boolean bl = isCommit = notification.getType() == 1;
                if (!isCommit && notification.getType() != 0) {
                    throw new JMSException("Invalid type (" + notification.getType() + ") for AckOneMessageByClientNotification");
                }
                AckOneMessageByClientNotification ack = (AckOneMessageByClientNotification)notification;
                long consumerID = ack.getConsumerID();
                int rows = SendOrderTable.ackOneMsgReceivedByClient(this.m_connection, ack.getDeliveryMode(), isCommit, ack.getMessageID(), consumerID, ack.isQueueMessage());
                if (rows != 1 && rows != -2) {
                    this.log(LINE_SEP + "################################################################################" + LINE_SEP + "Could not acknowledge one received message for " + "message <" + ack.getMessageID() + "> and consumer <" + consumerID + ">" + " return value: " + rows + LINE_SEP + "################################################################################");
                }
                this.m_connection.commit();
                if (!isCommit) {
                    SendOrderPolling.notifyMessageArrived(2);
                    SendOrderPolling.notifyMessageArrived(1);
                }
                return FreeLists.getOkNotification();
            }
            if (notification instanceof ClientEndTransNotification) {
                boolean isCommit;
                Vector syncMessageNot = new Vector();
                boolean bl = isCommit = notification.getType() == 1;
                if (!isCommit && notification.getType() != 0) {
                    throw new JMSException("Invalid type (" + notification.getType() + ") for ClientEndTransNotification");
                }
                ClientEndTransNotification endTransNotify = (ClientEndTransNotification)notification;
                this.ackReceivedByClient(2, endTransNotify, isCommit);
                this.ackReceivedByClient(1, endTransNotify, isCommit);
                int transientSentCount = endTransNotify.getTransientSentCount();
                int persistentSentCount = endTransNotify.getPersistentSentCount();
                if (transientSentCount > 0 || persistentSentCount > 0) {
                    long transactionID = endTransNotify.getTransactionID();
                    if (transactionID == -1L) {
                        throw new JMSException("invalid TransactionID: " + transactionID);
                    }
                    if (persistentSentCount > 0) {
                        this.ackSentByClient(2, transactionID, persistentSentCount, isCommit, syncMessageNot);
                    }
                    if (transientSentCount > 0) {
                        this.ackSentByClient(1, transactionID, transientSentCount, isCommit, syncMessageNot);
                    }
                }
                this.m_connection.commit();
                if (!isCommit) {
                    SendOrderPolling.notifyMessageArrived(2);
                    SendOrderPolling.notifyMessageArrived(1);
                }
                this.sendMessageToSyncConsumers(syncMessageNot);
                return FreeLists.getOkNotification();
            }
            throw new JMSException("Invalid acknowledgement notification: " + notification.toString());
        }
        catch (SQLException ex) {
            this.logException(ex);
            return new ErrorNotification(ex);
        }
        catch (JMSException ex) {
            this.logException((Exception)((Object)ex));
            return new ErrorNotification((Exception)((Object)ex));
        }
        catch (ReceivingException ex) {
            this.logException(ex);
            return new ErrorNotification(ex);
        }
    }

    public void finishWork() throws Exception {
        if (this.m_connection != null) {
            this.m_connection.rollback();
            this.m_connection.close();
            this.m_connection = null;
        }
    }

    private void ackReceivedByClient(int modeDelivery, ClientEndTransNotification notification, boolean isCommit) throws JMSException, SQLException {
        String isQueue;
        SendOrderKey[] sendOrderKeys = notification.getSendOrderKeys(modeDelivery);
        if (sendOrderKeys == null) {
            return;
        }
        int rows = SendOrderTable.ackMsgListReceivedByClient(this.m_connection, modeDelivery, isCommit, sendOrderKeys);
        String string = isQueue = sendOrderKeys[0].isQueueMessage() ? "Queue" : "Topic";
        if (JmsService.getVerboseSendReceive()) {
            String commitRollb = isCommit ? "Commit" : "Rollback";
            String msgRows = rows >= 0 ? Integer.toString(rows) : "some";
            this.log("Info: " + commitRollb + " received by client affected " + msgRows + " rows");
        }
        if (rows < sendOrderKeys.length && rows != -2) {
            this.log(LINE_SEP + "################################################################################" + LINE_SEP + "Could not acknowledge received messages for " + (sendOrderKeys.length - rows) + " " + isQueue + " messages" + LINE_SEP + "################################################################################");
        }
    }

    private void ackSentByClient(int modeDelivery, long transactionID, int entryCount, boolean isCommit, Vector syncMessageNot) throws JMSException, SQLException {
        int rows = 0;
        rows = isCommit ? this.commitSentByClient(modeDelivery, transactionID, syncMessageNot) : SendOrderTable.rollbackSentByClient(this.m_connection, modeDelivery, transactionID);
        if (rows < entryCount && rows != -2 && JmsService.getVerboseSendReceive()) {
            this.log("AcknowledgeAgent.ackSentByClient transactionID " + transactionID + ": " + entryCount + " messages sent / " + rows + " messages acknowledged");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int commitSentByClient(int modeDelivery, long transactionID, Vector syncMessageNot) throws SQLException, JMSException {
        int rows = 0;
        long msgSeq = 0L;
        long lastMessageID = 0L;
        ResultSet result = null;
        MessageConsumerInfo syncConsumerInfo = null;
        long transSeq = DestinationList.getSequenceNumberForTrans(this.m_connection);
        try {
            result = SendOrderTable.getResultForCommitSentByClient(this.m_connection, modeDelivery, transactionID);
            boolean notifySendOrderPolling = false;
            if (result != null) {
                DeliveryPreparedStmt stmt = this.m_connection.getDeliveryPreparedStmt(39, modeDelivery);
                int batchCount = 0;
                while (result.next()) {
                    long messageID = result.getLong(1);
                    long consumerID = result.getLong(2);
                    long destinationID = result.getLong(3);
                    boolean isQueueOrder = result.getInt(4) == 1;
                    boolean isInProcess = false;
                    long msgserver_transaction = result.getLong(5);
                    int priority = result.getInt(6);
                    long expires = result.getLong(7);
                    syncConsumerInfo = isQueueOrder ? SyncReceiveHandler.getQueueConsumer(this.m_connection, modeDelivery, messageID, destinationID) : SyncReceiveHandler.getTopicConsumer(consumerID, destinationID);
                    if (syncConsumerInfo != null) {
                        isInProcess = true;
                        consumerID = syncConsumerInfo.getConsumerID();
                        this.buildMessageList(syncMessageNot, messageID, consumerID, modeDelivery);
                    }
                    if (lastMessageID != messageID) {
                        msgSeq = DestinationList.getSequenceNumberForMsg(this.m_connection, destinationID);
                        lastMessageID = messageID;
                    }
                    long topicConsumerID = isQueueOrder ? 0L : consumerID;
                    boolean hasActiveConsumer = ConsumerList.hasActiveConsumer(isQueueOrder, consumerID, destinationID);
                    stmt.setLong(1, messageID);
                    stmt.setLong(2, topicConsumerID);
                    stmt.setLong(3, consumerID);
                    stmt.setLong(4, destinationID);
                    stmt.setLong(5, transSeq);
                    stmt.setLong(6, msgSeq);
                    stmt.setBoolean(7, isQueueOrder);
                    stmt.setBoolean(8, isInProcess);
                    stmt.setBoolean(9, false);
                    stmt.setLong(10, msgserver_transaction);
                    stmt.setInt(11, priority);
                    stmt.setLong(12, expires);
                    stmt.setBoolean(13, hasActiveConsumer);
                    stmt.addBatch();
                    ++batchCount;
                    if (notifySendOrderPolling || !hasActiveConsumer || transactionID <= 0L) continue;
                    notifySendOrderPolling = true;
                }
                if (batchCount > 0) {
                    rows = stmt.executeBatchGetRowCount();
                }
            }
            SendOrderTable.rollbackSentByClient(this.m_connection, modeDelivery, transactionID);
            if (notifySendOrderPolling) {
                SendOrderPolling.notifyMessageArrived(modeDelivery);
            }
        }
        finally {
            if (result != null) {
                result.close();
            }
        }
        return rows;
    }

    private void sendMessageToSyncConsumers(Vector syncMessageNot) throws ReceivingException, SQLException, JMSException {
        MessageImpl aMessage = null;
        MessageNotification messageNot = null;
        Enumeration syncEnum = syncMessageNot.elements();
        while (syncEnum.hasMoreElements()) {
            messageNot = (MessageNotification)syncEnum.nextElement();
            aMessage = messageNot.getMessage();
            MessageConsumerInfo consumerInfo = messageNot.getMessageConsumerInfo();
            SyncReceiveHandler.sendMessage(aMessage, aMessage.getJMSDeliveryMode(), consumerInfo);
        }
    }

    private void buildMessageList(Vector syncMessageNot, long messageID, long consumerID, int modeDelivery) throws SQLException, JMSException {
        MessageImpl aMessage = null;
        MessageNotification messageNot = null;
        aMessage = MessageTable.findByID(this.m_connection, modeDelivery, messageID);
        if (aMessage == null) {
            throw new SQLException("Message for syncronous receiver not found  MessageID = " + messageID + " ConsumerID = " + consumerID);
        }
        messageNot = FreeLists.getMessageNot(aMessage);
        MessageConsumerInfo consumerInfo = ConsumerList.getInactiveConsumer(consumerID);
        if (consumerInfo == null) {
            throw new JMSException("No consumer registered for message <" + messageID + ">, consumer <" + consumerID + ">");
        }
        messageNot.setClientSessionAddress(consumerInfo.getClientSessionAddress());
        messageNot.setMessageConsumerInfo(consumerInfo);
        syncMessageNot.add(messageNot);
    }
}

