/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.minDB.dataAccess;

import com.sap.sdb.minDB.common.DatabaseInputStream;
import com.sap.sdb.minDB.common.DatabaseOutputStream;
import com.sap.sdb.minDB.common.Row;
import com.sap.sdb.minDB.dataAccess.AnyKey;
import com.sap.sdb.minDB.dataAccess.ConnectionImpl;
import com.sap.sdb.minDB.dataAccess.IndexKey;
import com.sap.sdb.minDB.dataAccess.TransList;
import com.sap.sdb.minDB.dataAccessInterface.ConnectionHandle;
import com.sap.sdb.minDB.dataAccessInterface.DatabaseKey;
import com.sap.sdb.minDB.dataAccessInterface.DatabaseTableRow;
import com.sap.sdb.minDB.util.Console;
import com.sap.sdb.minDB.util.ErrorMsg;
import java.io.IOException;
import java.sql.SQLException;

public class TableRow
extends Row
implements DatabaseTableRow {
    private boolean m_isDeleted = false;
    private int m_transListIndex = -1;
    private long m_transID = -1L;
    private DatabaseKey m_primKey = null;
    private IndexKey[] m_indexKeys = null;

    TableRow() {
    }

    public TableRow(int maxNumberColNo, int maxObjectColNo, DatabaseKey key) {
        super(maxNumberColNo, maxObjectColNo);
        this.m_primKey = key;
    }

    public TableRow(TableRow sourceRow) {
        super(sourceRow);
        this.m_isDeleted = sourceRow.m_isDeleted;
        this.m_transListIndex = sourceRow.m_transListIndex;
        this.m_transID = sourceRow.m_transID;
        this.m_primKey = sourceRow.m_primKey;
        if (sourceRow.m_indexKeys != null) {
            this.m_indexKeys = new IndexKey[sourceRow.m_indexKeys.length];
            System.arraycopy(sourceRow.m_indexKeys, 0, this.m_indexKeys, 0, sourceRow.m_indexKeys.length);
        }
    }

    void assignIndexKeys(TableRow sourceRow) {
        this.m_indexKeys = sourceRow.m_indexKeys;
    }

    public static TableRow createTableRowFromStream(DatabaseInputStream inStream) throws IOException {
        TableRow row = new TableRow();
        row.readFromStream(inStream);
        return row;
    }

    TableRow getCopy() {
        return new TableRow(this);
    }

    public DatabaseKey getKey() {
        return this.m_primKey;
    }

    public DatabaseKey getKey(int indexNo) {
        if (indexNo == -1) {
            return this.m_primKey;
        }
        return this.m_indexKeys != null && indexNo < this.m_indexKeys.length ? this.m_indexKeys[indexNo] : null;
    }

    long getTransactionID() {
        return this.m_transID;
    }

    int getTransListIndex() {
        return this.m_transListIndex;
    }

    void initKey(int[] keyColNoList, byte[] rowColTypeList) throws SQLException {
        block4: for (int keyColNo = 1; keyColNo < keyColNoList.length; ++keyColNo) {
            int rowCol = keyColNoList[keyColNo];
            if (super.getColumnState(rowCol) == 0) {
                throw ErrorMsg.newSQLException("Null value in key column not allowed", -7009);
            }
            switch (rowColTypeList[rowCol]) {
                case 4: {
                    this.m_primKey.addCol(keyColNo, this.getNumericCol(rowCol));
                    continue block4;
                }
                case 2: {
                    this.m_primKey.addCol(keyColNo, this.getCharCol(rowCol));
                    continue block4;
                }
                default: {
                    this.m_primKey.addCol(keyColNo, this.getObjectCol(rowCol));
                }
            }
        }
    }

    void initNumericKey(int keyColNo) throws SQLException {
        this.m_primKey.addCol(1, this.getNumericCol(keyColNo));
    }

    public boolean isDeleted() {
        return this.m_isDeleted;
    }

    public synchronized boolean isLockCollision(ConnectionHandle connection) {
        return TransList.isLockCollision((ConnectionImpl)connection, this);
    }

    public synchronized boolean lock(ConnectionHandle connection) {
        return TransList.lockTableRow((ConnectionImpl)connection, this);
    }

    public void printContents(int rowNo) {
        String keyMsg = this.m_primKey == null ? "undefined key" : ((Object)this.m_primKey).toString();
        Console.println();
        if (this.m_isDeleted) {
            Console.println("   " + rowNo + " --- deleted TABLE ROW: " + keyMsg);
        } else {
            Console.println("   " + rowNo + " --- TABLE ROW: " + keyMsg);
        }
        Console.println("      transListIndex: " + this.m_transListIndex + ", transID: " + this.m_transID);
        if (this.m_indexKeys != null) {
            for (int indexNo = 1; indexNo < this.m_indexKeys.length; ++indexNo) {
                if (this.m_indexKeys[indexNo] == null) {
                    Console.println("      indexKey" + indexNo + " undefined");
                    continue;
                }
                Console.println("      indexKey" + indexNo + ": " + this.m_indexKeys[indexNo].toString());
            }
        }
        super.printContents();
    }

    public void readFromStream(DatabaseInputStream inStream) throws IOException {
        super.readFromStream(inStream);
        this.m_primKey = AnyKey.createFromStream(inStream);
    }

    void setDeleted(boolean deleted) {
        this.m_isDeleted = deleted;
    }

    void setIndexKey(int indexNo, IndexKey indexKey) {
        if (this.m_indexKeys == null) {
            this.m_indexKeys = new IndexKey[indexNo + 1];
        } else if (indexNo >= this.m_indexKeys.length) {
            IndexKey[] auxKeys = new IndexKey[indexNo + 1];
            System.arraycopy(this.m_indexKeys, 0, auxKeys, 0, this.m_indexKeys.length);
            this.m_indexKeys = auxKeys;
        }
        this.m_indexKeys[indexNo] = indexKey;
    }

    void setTransactionID(long transID) {
        this.m_transID = transID;
    }

    void setTransListIndex(int listIndex) {
        this.m_transListIndex = listIndex;
    }

    public void writeToStream(DatabaseOutputStream outStream) throws IOException {
        super.writeToStream(outStream);
        ((AnyKey)this.m_primKey).writeToStream(outStream);
    }
}

