/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.minDB.dataAccess;

import com.sap.sdb.minDB.common.DatabaseInputStream;
import com.sap.sdb.minDB.common.DatabaseOutputStream;
import com.sap.sdb.minDB.util.ErrorMsg;
import java.io.IOException;
import java.sql.SQLException;

public class TableName
implements Comparable {
    private String m_schema;
    private String m_identifier;
    private static final char SQL_QUOTATION_MARKS = '\"';
    private static final char SQL_NAME_SEPARATOR = '.';

    public TableName(String schema, String identifier) {
        this.m_schema = schema;
        this.m_identifier = identifier;
    }

    public int compareTo(Object o) {
        TableName other = (TableName)o;
        int result = this.m_schema.compareTo(other.m_schema);
        return result != 0 ? result : this.m_identifier.compareTo(other.m_identifier);
    }

    static TableName createFromStream(DatabaseInputStream inStream) throws IOException {
        return new TableName(inStream.readString(), inStream.readString());
    }

    public boolean equals(Object o) {
        TableName other = (TableName)o;
        return this.m_schema.equals(other.m_schema) && this.m_identifier.equals(other.m_identifier);
    }

    public String getIdentifier() {
        return this.m_identifier;
    }

    public String getSchema() {
        return this.m_schema;
    }

    public String getSQLIdentifier() {
        return '\"' + this.m_identifier + '\"';
    }

    public String getSQLTableName() {
        return '\"' + this.m_schema + '\"' + '.' + this.getSQLIdentifier();
    }

    public int hashCode() {
        return this.m_identifier.hashCode();
    }

    public SQLException getDuplicateException(String nameObject) {
        return ErrorMsg.newSQLException("Duplicate " + nameObject + " name " + this.toString(), -6000);
    }

    public SQLException getNotFoundException() {
        return this.getNotFoundException("table");
    }

    public SQLException getNotFoundException(String nameObject) {
        return ErrorMsg.newSQLException("Unknown " + nameObject + " name " + this.toString(), -4004);
    }

    public String toString() {
        return this.m_schema + '.' + this.m_identifier;
    }

    void writeToStream(DatabaseOutputStream outStream) throws IOException {
        outStream.writeString(this.m_schema);
        outStream.writeString(this.m_identifier);
    }
}

