/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.minDB.dataAccess;

import com.sap.sdb.minDB.dataAccess.DeleteLogentry;
import com.sap.sdb.minDB.dataAccess.Logentry;
import com.sap.sdb.minDB.dataAccess.SavepointImpl;
import com.sap.sdb.minDB.dataAccessInterface.DatabaseLogentry;
import java.util.Iterator;
import java.util.LinkedList;

class LogentryList {
    private Logentry m_lastLogentry = null;

    LogentryList() {
    }

    void addLogentry(Logentry entry) {
        entry.setPrevLogentry(this.m_lastLogentry);
        this.m_lastLogentry = entry;
    }

    void clear() {
        this.m_lastLogentry = null;
    }

    void collectGarbageAndClear() {
        DeleteLogentry currDelEntry;
        if (this.m_lastLogentry == null) {
            return;
        }
        DeleteLogentry deleteLogentry = currDelEntry = this.m_lastLogentry instanceof DeleteLogentry ? (DeleteLogentry)this.m_lastLogentry : this.m_lastLogentry.getPrevDeleteEntry();
        while (currDelEntry != null) {
            currDelEntry.collectGarbage();
            currDelEntry = currDelEntry.getPrevDeleteEntry();
        }
        this.m_lastLogentry = null;
    }

    public void partialRollback(DatabaseLogentry firstEntry) {
        LinkedList<Logentry> skippedSavepoints = null;
        while (this.m_lastLogentry != null) {
            Logentry entry = this.m_lastLogentry;
            this.m_lastLogentry = entry.getPrevLogentry();
            if (entry instanceof SavepointImpl) {
                if (skippedSavepoints == null) {
                    skippedSavepoints = new LinkedList<Logentry>();
                }
                skippedSavepoints.addLast(entry);
            } else {
                entry.rollback();
            }
            if (entry != firstEntry) continue;
            break;
        }
        if (skippedSavepoints != null) {
            Iterator iter = skippedSavepoints.iterator();
            while (iter.hasNext()) {
                this.addLogentry((Logentry)iter.next());
            }
        }
    }

    void rollbackAndClear() {
        while (this.m_lastLogentry != null) {
            this.m_lastLogentry.rollback();
            this.m_lastLogentry = this.m_lastLogentry.getPrevLogentry();
        }
    }
}

