/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.minDB.dataAccess;

import com.sap.sdb.minDB.common.ColumnType;
import com.sap.sdb.minDB.common.DatabaseRow;
import com.sap.sdb.minDB.common.Row;
import com.sap.sdb.minDB.dataAccess.AnyKey;
import com.sap.sdb.minDB.dataAccess.PrimaryNumKey;
import com.sap.sdb.minDB.dataAccess.TableRow;
import com.sap.sdb.minDB.dataAccessInterface.DatabaseKey;
import java.sql.SQLException;

public class IndexKey
extends AnyKey {
    private boolean m_isUnique;
    private int m_indexNo;
    private int m_initializedCols;
    private Row m_indexCols;
    private DatabaseKey m_primaryKey;
    private boolean[] m_isColAscList;

    IndexKey() {
        this.m_isUnique = false;
        this.m_indexNo = -1;
        this.m_initializedCols = 0;
        this.m_indexCols = null;
        this.m_isColAscList = null;
        this.m_primaryKey = null;
    }

    IndexKey(boolean isUnique, int indexNo, int[] indexColNoList, boolean[] isColAscList) {
        this.m_isUnique = isUnique;
        this.m_indexNo = indexNo;
        this.m_initializedCols = 0;
        this.m_primaryKey = null;
        this.m_isColAscList = isColAscList;
        this.m_indexCols = new Row(indexColNoList.length - 1, indexColNoList.length - 1);
    }

    public IndexKey(boolean isUnique, int indexNo, TableRow row, int[] indexColNoList, boolean[] isColAscList) {
        this(isUnique, indexNo, indexColNoList, isColAscList);
        for (int colNo = 1; colNo < indexColNoList.length; ++colNo) {
            this.m_indexCols.copyCol(colNo, row, indexColNoList[colNo]);
        }
        this.m_initializedCols = indexColNoList.length - 1;
        if (!isUnique) {
            this.m_primaryKey = row.getKey();
        }
    }

    public IndexKey(DatabaseRow row, int[] indexColNoList, boolean[] isColAscList, int rowNo) {
        this(rowNo < 0, -1, indexColNoList, isColAscList);
        for (int colNo = 1; colNo < indexColNoList.length; ++colNo) {
            this.m_indexCols.copyCol(colNo, row, indexColNoList[colNo]);
        }
        this.m_initializedCols = indexColNoList.length - 1;
        if (rowNo >= 0) {
            this.setRowNo(rowNo);
        }
    }

    public void addCol(int colNo, long keyValue) {
        this.m_indexCols.setNumericCol(colNo, keyValue);
        if (this.m_initializedCols < colNo) {
            this.m_initializedCols = colNo;
        }
    }

    public void addCol(int colNo, String keyValue) {
        this.m_indexCols.setCharCol(colNo, keyValue);
        if (this.m_initializedCols < colNo) {
            this.m_initializedCols = colNo;
        }
    }

    public void addCol(int colNo, Object keyValue) {
        this.m_indexCols.setObjectCol(colNo, keyValue);
        if (this.m_initializedCols < colNo) {
            this.m_initializedCols = colNo;
        }
    }

    public int compareTo(Object o) {
        IndexKey other = (IndexKey)o;
        int compareResult = this.compareToIndexPart(other);
        if (compareResult != 0) {
            return compareResult;
        }
        if (this.m_isUnique) {
            return 0;
        }
        if (this.m_primaryKey == null) {
            return other.m_primaryKey == null ? 0 : -1;
        }
        if (other.m_primaryKey == null) {
            return 1;
        }
        return this.m_primaryKey.compareTo(other.m_primaryKey);
    }

    public int compareToIndexPart(IndexKey other) {
        block7: for (int colNo = 1; colNo <= this.m_indexCols.getMaxColNo(); ++colNo) {
            if (colNo > this.m_initializedCols) {
                return this.m_initializedCols == other.m_initializedCols ? 0 : -1;
            }
            if (colNo > other.m_initializedCols) {
                return 1;
            }
            try {
                byte thisColState = this.m_indexCols.getColumnState(colNo);
                if (other.m_indexCols.isNull(colNo) && thisColState != 0) {
                    return 2;
                }
                switch (thisColState) {
                    case 0: {
                        return -2;
                    }
                    case 4: {
                        long thisNumber = this.m_indexCols.getNumericCol(colNo);
                        long otherNumber = other.m_indexCols.getNumericCol(colNo);
                        if (thisNumber < otherNumber) {
                            return this.convertCompareResult(-1, colNo);
                        }
                        if (thisNumber <= otherNumber) continue block7;
                        return this.convertCompareResult(1, colNo);
                    }
                    case 2: {
                        int compareResult = this.m_indexCols.getCharCol(colNo).compareTo(other.m_indexCols.getCharCol(colNo));
                        if (compareResult == 0) continue block7;
                        return this.convertCompareResult(compareResult, colNo);
                    }
                    default: {
                        int compareResult = ColumnType.compareObject(this.m_indexCols.getObjectCol(colNo), other.m_indexCols.getObjectCol(colNo));
                        if (compareResult == 0) continue block7;
                        return this.convertCompareResult(compareResult, colNo);
                    }
                }
            }
            catch (SQLException ex) {
                return -3;
            }
        }
        return 0;
    }

    private int convertCompareResult(int compareResult, int colNo) {
        return this.m_isColAscList[colNo] ? compareResult : -1 * compareResult;
    }

    public int getIndexNo() {
        return this.m_indexNo;
    }

    public boolean isEmpty() {
        return this.m_initializedCols < 1;
    }

    public boolean isGreaterStopKey(DatabaseKey stopKey) {
        IndexKey other = (IndexKey)stopKey;
        block6: for (int colNo = 1; colNo <= this.m_indexCols.getMaxColNo(); ++colNo) {
            if (colNo > this.m_initializedCols || colNo > other.m_initializedCols) {
                return false;
            }
            try {
                byte thisColState = this.m_indexCols.getColumnState(colNo);
                if (thisColState == 0 || other.m_indexCols.isNull(colNo)) {
                    return false;
                }
                switch (thisColState) {
                    case 4: {
                        long thisNumber = this.m_indexCols.getNumericCol(colNo);
                        long otherNumber = other.m_indexCols.getNumericCol(colNo);
                        if (thisNumber < otherNumber) {
                            return !this.m_isColAscList[colNo];
                        }
                        if (thisNumber <= otherNumber) continue block6;
                        return this.m_isColAscList[colNo];
                    }
                    case 2: {
                        int compareResult = this.m_indexCols.getCharCol(colNo).compareTo(other.m_indexCols.getCharCol(colNo));
                        if (compareResult == 0) continue block6;
                        return this.m_isColAscList[colNo] ? compareResult > 0 : compareResult < 0;
                    }
                    default: {
                        Object thisObj = this.m_indexCols.getObjectCol(colNo);
                        Object otherObj = other.m_indexCols.getObjectCol(colNo);
                        if (thisObj == null || otherObj == null) {
                            return false;
                        }
                        int compareResult = ColumnType.compareObject(thisObj, otherObj);
                        if (compareResult == 0) continue block6;
                        return this.m_isColAscList[colNo] ? compareResult > 0 : compareResult < 0;
                    }
                }
            }
            catch (SQLException ex) {
                return false;
            }
        }
        return false;
    }

    boolean isUnique() {
        return this.m_isUnique;
    }

    void setPrimaryKey(DatabaseKey primaryKey) {
        if (!this.m_isUnique) {
            this.m_primaryKey = primaryKey;
        }
    }

    void setRowNo(int rowNo) {
        if (!this.m_isUnique) {
            this.m_primaryKey = new PrimaryNumKey(rowNo);
        }
    }

    public String toString() {
        if (this.m_initializedCols == 0) {
            return "<empty>";
        }
        StringBuffer str = new StringBuffer(128);
        for (int colNo = 1; colNo <= this.m_initializedCols; ++colNo) {
            try {
                byte colState = this.m_indexCols.getColumnState(colNo);
                switch (colState) {
                    case 0: {
                        str.append("undef");
                        break;
                    }
                    case 4: {
                        str.append(this.m_indexCols.getNumericCol(colNo));
                        break;
                    }
                    case 2: {
                        str.append("'");
                        str.append(this.m_indexCols.getCharCol(colNo));
                        str.append("'");
                        break;
                    }
                    default: {
                        str.append("obj[");
                        str.append(this.m_indexCols.getObjectCol(colNo));
                        str.append("]");
                        break;
                    }
                }
            }
            catch (SQLException ex) {
                str.append("[index column ");
                str.append(colNo);
                str.append(" not exists]");
            }
            if (colNo >= this.m_initializedCols) continue;
            str.append(" ");
        }
        if (this.m_primaryKey != null) {
            str.append(" primKey: ");
            str.append(((Object)this.m_primaryKey).toString());
        }
        return str.toString();
    }
}

