/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.minDB.dataAccess;

import com.sap.sdb.minDB.common.DatabaseInputStream;
import com.sap.sdb.minDB.common.DatabaseOutputStream;
import com.sap.sdb.minDB.dataAccess.ConnectionImpl;
import com.sap.sdb.minDB.dataAccess.Table;
import com.sap.sdb.minDB.dataAccess.TableName;
import com.sap.sdb.minDB.util.Console;
import com.sap.sdb.minDB.util.ErrorMsg;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class DatabaseCatalog {
    private boolean m_tableCatalogUpdated = false;
    private boolean m_indexCatalogUpdated = false;
    private boolean m_anySchemaUpdated = false;
    private boolean m_anySeqUpdated = false;
    private HashMap m_userAndSchemaMap;
    private HashMap m_sequenceMap;
    private HashMap m_tableMap;
    private HashMap m_indexMap = new HashMap();
    private HashMap m_connectedUsers;
    private File m_databaseFolder = null;
    private static final int BACKUP_VERSION = -1380188158;
    private static final int CATALOG_VERSION = -1129512958;
    private static final int SEQ_FILE_VERSION = -1129447422;
    private static final int TYPE_UNDEF = 0;
    private static final int TYPE_SCHEMA = 1;
    private static final int TYPE_USER_STANDARD = 2;
    private static final int TYPE_USER_RESOURCE = 3;
    private static final int TYPE_USER_DBA = 4;
    private static final String CATALOG_FILENAME = "MinDB.cat";
    private static final String SEQ_FILENAME = "MinDBseq.cat";
    private static final String AUX_FILE_PREFIX = "~";

    public DatabaseCatalog(String username, String password) {
        this.m_sequenceMap = new HashMap();
        this.m_tableMap = new HashMap();
        this.m_userAndSchemaMap = new HashMap();
        this.m_connectedUsers = new HashMap();
        this.m_userAndSchemaMap.put(username, new UserAndSchemaEntry(4, password));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(ConnectionImpl connection) {
        if (this.m_databaseFolder == null) {
            return;
        }
        DatabaseCatalog databaseCatalog = this;
        synchronized (databaseCatalog) {
            this.m_connectedUsers.put(connection, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIndex(TableName indexName, Table tab) {
        HashMap hashMap = this.m_indexMap;
        synchronized (hashMap) {
            this.m_indexCatalogUpdated = true;
            this.m_indexMap.put(indexName, tab);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSequence(String schmema, String sequenceIdentifier) throws SQLException {
        TableName sequenceName = new TableName(schmema, sequenceIdentifier);
        HashMap hashMap = this.m_userAndSchemaMap;
        synchronized (hashMap) {
            HashMap hashMap2 = this.m_sequenceMap;
            synchronized (hashMap2) {
                Object obj = this.m_sequenceMap.get(sequenceName);
                if (obj != null) {
                    throw sequenceName.getDuplicateException("sequence");
                }
                if (!this.existsUserOrSchema(sequenceName.getSchema())) {
                    throw ErrorMsg.newSQLException("Unknown schema name '" + sequenceName.getSchema() + "'", -4003);
                }
                this.m_anySeqUpdated = true;
                this.m_sequenceMap.put(sequenceName, new Long(0L));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTable(Table tab) {
        if (this.m_databaseFolder != null) {
            tab.initPersistent(this.m_databaseFolder);
        }
        HashMap hashMap = this.m_tableMap;
        synchronized (hashMap) {
            this.m_tableCatalogUpdated = true;
            this.m_tableMap.put(tab.getTableName(), tab);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserOrSchema(String name, String password, String option) throws SQLException {
        int entryType = 2;
        if (option != null) {
            if (option.equals("SCHEMA")) {
                entryType = 1;
            } else if (option.equals("RESOURCE")) {
                entryType = 3;
            } else if (option.equals("DBA")) {
                entryType = 4;
            }
        }
        HashMap hashMap = this.m_userAndSchemaMap;
        synchronized (hashMap) {
            if (this.existsUserOrSchema(name)) {
                throw ErrorMsg.newSQLException("Duplicate user/schema name '" + name + "'", -6006);
            }
            this.m_anySchemaUpdated = true;
            this.m_userAndSchemaMap.put(name, new UserAndSchemaEntry(entryType, password));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alterPassword(String username, String newPassword) throws SQLException {
        this.checkNameNotEmpty(username, "user name");
        this.checkNameNotEmpty(newPassword, "password");
        HashMap hashMap = this.m_userAndSchemaMap;
        synchronized (hashMap) {
            UserAndSchemaEntry entry = (UserAndSchemaEntry)this.m_userAndSchemaMap.get(username);
            if (entry == null || entry.m_type != 2 && entry.m_type != 3 && entry.m_type != 4) {
                throw ErrorMsg.newSQLException("Unknown user name '" + username + "'", -4003);
            }
            this.m_anySchemaUpdated = true;
            entry.m_password = newPassword;
        }
    }

    public synchronized void backup(String filename) throws SQLException {
        try {
            FileOutputStream fileStream = new FileOutputStream(filename);
            this.writeToStream(fileStream, true);
        }
        catch (IOException ex) {
            throw ErrorMsg.newSQLException(ex, -903);
        }
    }

    private void checkNameNotEmpty(String name, String nameType) throws SQLException {
        if (name == null || name.equals("")) {
            throw ErrorMsg.newSQLException("Empty " + nameType + " not allowed", -3008);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkValidUser(String username, String password) throws SQLException {
        this.checkNameNotEmpty(username, "user name");
        this.checkNameNotEmpty(password, "password");
        HashMap hashMap = this.m_userAndSchemaMap;
        synchronized (hashMap) {
            UserAndSchemaEntry entry = (UserAndSchemaEntry)this.m_userAndSchemaMap.get(username);
            if (entry == null || entry.m_type != 2 && entry.m_type != 3 && entry.m_type != 4 || !entry.m_password.equals(password)) {
                throw ErrorMsg.newSQLException("Unknown user name/password combination", -4008);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropUserOrSchema(String name, String connectedUser) throws SQLException {
        this.checkNameNotEmpty(name, "user/schema name");
        if (name.equals(connectedUser)) {
            throw ErrorMsg.newSQLException("User '" + name + "' cannot drop itself", -5001);
        }
        HashMap hashMap = this.m_userAndSchemaMap;
        synchronized (hashMap) {
            HashMap hashMap2 = this.m_sequenceMap;
            synchronized (hashMap2) {
                HashMap hashMap3 = this.m_tableMap;
                synchronized (hashMap3) {
                    UserAndSchemaEntry entry;
                    if (this.isAdministrator(name)) {
                        int adminCount = 0;
                        Iterator iter = this.m_userAndSchemaMap.values().iterator();
                        while (iter.hasNext()) {
                            entry = (UserAndSchemaEntry)iter.next();
                            if (entry.m_type != 4 || ++adminCount <= 1) continue;
                        }
                        if (adminCount <= 1) {
                            throw ErrorMsg.newSQLException("Dropping the only one administrator '" + name + "' not allowed", -5001);
                        }
                    }
                    if ((entry = (UserAndSchemaEntry)this.m_userAndSchemaMap.remove(name)) == null) {
                        throw ErrorMsg.newSQLException("Unknown user/schema name '" + name + "'", -4003);
                    }
                    this.m_anySchemaUpdated = true;
                    LinkedList sequenceList = new LinkedList();
                    Iterator sequenceIter = this.m_sequenceMap.entrySet().iterator();
                    while (sequenceIter.hasNext()) {
                        Map.Entry currEntry = sequenceIter.next();
                        TableName sequenceName = (TableName)currEntry.getKey();
                        if (!sequenceName.getSchema().equals(name)) continue;
                        sequenceList.add(currEntry.getValue());
                    }
                    sequenceIter = sequenceList.iterator();
                    while (sequenceIter.hasNext()) {
                        this.m_anySeqUpdated = true;
                        this.m_sequenceMap.remove(sequenceIter.next());
                    }
                    Table[] tableList = this.getTableList();
                    if (tableList == null) {
                        return;
                    }
                    for (int i = 0; i < tableList.length; ++i) {
                        if (!tableList[i].getSchemaName().equals(name)) continue;
                        this.removeTable(tableList[i].getTableName());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsIndex(TableName indexName) {
        HashMap hashMap = this.m_indexMap;
        synchronized (hashMap) {
            return this.m_indexMap.containsKey(indexName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsTable(TableName tablename) {
        HashMap hashMap = this.m_tableMap;
        synchronized (hashMap) {
            return this.m_tableMap.containsKey(tablename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsUserOrSchema(String username) {
        HashMap hashMap = this.m_userAndSchemaMap;
        synchronized (hashMap) {
            return username == null ? false : this.m_userAndSchemaMap.containsKey(username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean flushDatabaseFolder(boolean unloadTables) throws IOException {
        boolean anyFileWritten = false;
        HashMap hashMap = this.m_userAndSchemaMap;
        synchronized (hashMap) {
            HashMap hashMap2 = this.m_tableMap;
            synchronized (hashMap2) {
                HashMap hashMap3 = this.m_indexMap;
                synchronized (hashMap3) {
                    if (this.m_anySchemaUpdated || this.m_tableCatalogUpdated || this.m_indexCatalogUpdated) {
                        this.writeCatalogOrSequencesIntoFile(true);
                        this.m_anySchemaUpdated = false;
                        this.m_tableCatalogUpdated = false;
                        this.m_indexCatalogUpdated = false;
                        anyFileWritten = true;
                    }
                    Iterator iter = this.m_tableMap.values().iterator();
                    while (iter.hasNext()) {
                        Table tab = (Table)iter.next();
                        if (!tab.writeContentIntoFile(unloadTables)) continue;
                        anyFileWritten = true;
                    }
                }
            }
        }
        hashMap = this.m_sequenceMap;
        synchronized (hashMap) {
            if (this.m_anySeqUpdated) {
                this.writeCatalogOrSequencesIntoFile(false);
                this.m_anySeqUpdated = false;
                anyFileWritten = true;
            }
        }
        return anyFileWritten;
    }

    public void flushTable(Table tab, boolean unloadTables) throws SQLException {
        if (this.m_databaseFolder == null) {
            throw ErrorMsg.newSQLException("Persistent table folder not defined", -903);
        }
        try {
            if (tab == null) {
                this.flushDatabaseFolder(unloadTables);
            } else {
                tab.writeContentIntoFile(unloadTables);
            }
        }
        catch (IOException ex) {
            throw ErrorMsg.newSQLException(ex, -903);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextSequence(String schmema, String sequenceIdentifier) throws SQLException {
        TableName sequenceName = new TableName(schmema, sequenceIdentifier);
        HashMap hashMap = this.m_sequenceMap;
        synchronized (hashMap) {
            Long sequenceObj = (Long)this.m_sequenceMap.get(sequenceName);
            if (sequenceObj == null) {
                throw sequenceName.getNotFoundException("sequence");
            }
            this.m_anySeqUpdated = true;
            long sequence = sequenceObj + 1L;
            this.m_sequenceMap.put(sequenceName, new Long(sequence));
            return sequence;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table getTable(TableName tablename) {
        HashMap hashMap = this.m_tableMap;
        synchronized (hashMap) {
            return (Table)this.m_tableMap.get(tablename);
        }
    }

    public synchronized String getFolderName() {
        return this.m_databaseFolder == null ? null : this.m_databaseFolder.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table[] getTableList() {
        HashMap hashMap = this.m_tableMap;
        synchronized (hashMap) {
            if (this.m_tableMap.size() < 1) {
                return null;
            }
            Table[] tabArray = new Table[this.m_tableMap.size()];
            Iterator iter = this.m_tableMap.values().iterator();
            for (int i = 0; i < tabArray.length; ++i) {
                tabArray[i] = (Table)iter.next();
            }
            return tabArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table getTableOfIndex(TableName indexName) {
        HashMap hashMap = this.m_indexMap;
        synchronized (hashMap) {
            return (Table)this.m_indexMap.get(indexName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getUserOrSchemaList() {
        HashMap hashMap = this.m_userAndSchemaMap;
        synchronized (hashMap) {
            if (this.m_userAndSchemaMap.size() < 1) {
                return null;
            }
            String[] userAndSchemaArray = new String[this.m_userAndSchemaMap.size()];
            Iterator iter = this.m_userAndSchemaMap.keySet().iterator();
            for (int i = 0; i < userAndSchemaArray.length; ++i) {
                userAndSchemaArray[i] = (String)iter.next();
            }
            return userAndSchemaArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getUserOrSchemaType(String name) {
        if (name == null) {
            return 0;
        }
        HashMap hashMap = this.m_userAndSchemaMap;
        synchronized (hashMap) {
            UserAndSchemaEntry entry = (UserAndSchemaEntry)this.m_userAndSchemaMap.get(name);
            return entry == null ? 0 : entry.m_type;
        }
    }

    public boolean isAdministrator(String username) {
        return this.getUserOrSchemaType(username) == 4;
    }

    public boolean isResourceUser(String username) {
        int userType = this.getUserOrSchemaType(username);
        return userType == 3 || userType == 4;
    }

    public boolean isSchema(String name) {
        return this.getUserOrSchemaType(name) == 1;
    }

    public boolean isUser(String name) {
        int userType = this.getUserOrSchemaType(name);
        return userType == 2 || userType == 3 || userType == 4;
    }

    public synchronized void markTableCatalogUpdated() {
        this.m_tableCatalogUpdated = true;
    }

    public synchronized void readDatabaseFolder(String folderName, boolean verbose) throws IOException {
        File seqFile;
        File catalogFile;
        if (folderName == null) {
            return;
        }
        if (this.m_databaseFolder != null) {
            if (folderName.equals(this.m_databaseFolder.getPath())) {
                return;
            }
            throw new IOException("database folder '" + this.m_databaseFolder.getAbsolutePath() + "' already defined");
        }
        File folder = new File(folderName);
        if (!folder.exists()) {
            if (verbose) {
                Console.println("table folder: " + folder.getAbsolutePath());
            }
            this.m_databaseFolder = folder;
            return;
        }
        if (!folder.isDirectory()) {
            throw new IOException("invalid database folder: " + folder.getAbsolutePath());
        }
        this.m_databaseFolder = folder;
        if (verbose) {
            Console.println("loading " + this.m_databaseFolder.getAbsolutePath());
        }
        if ((catalogFile = new File(this.m_databaseFolder, CATALOG_FILENAME)).exists()) {
            FileInputStream fileStream = new FileInputStream(catalogFile);
            this.replaceDatabaseFromStream(fileStream, false);
        }
        if ((seqFile = new File(this.m_databaseFolder, SEQ_FILENAME)).exists()) {
            FileInputStream fileStream = new FileInputStream(seqFile);
            DatabaseInputStream inStream = new DatabaseInputStream(fileStream);
            this.replaceSeqFromStream(inStream, false);
            inStream.close();
        }
    }

    public synchronized void recover(String filename) throws SQLException {
        try {
            FileInputStream fileStream = new FileInputStream(filename);
            this.replaceDatabaseFromStream(fileStream, true);
            if (this.m_databaseFolder != null) {
                this.flushDatabaseFolder(false);
            }
        }
        catch (IOException ex) {
            throw ErrorMsg.newSQLException(ex, -903);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(ConnectionImpl connection, boolean verbose) throws SQLException {
        if (this.m_databaseFolder == null) {
            return;
        }
        DatabaseCatalog databaseCatalog = this;
        synchronized (databaseCatalog) {
            Object obj = this.m_connectedUsers.remove(connection);
            if (obj != null && this.m_connectedUsers.isEmpty()) {
                try {
                    boolean anyFileWritten = this.flushDatabaseFolder(false);
                    if (verbose && anyFileWritten) {
                        Console.println("tables written into " + this.m_databaseFolder.getAbsolutePath());
                    }
                }
                catch (IOException ex) {
                    throw ErrorMsg.newSQLException(ex, -903);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeIndexName(TableName indexName) {
        HashMap hashMap = this.m_indexMap;
        synchronized (hashMap) {
            Object removedName = this.m_indexMap.remove(indexName);
            if (removedName == null) {
                return false;
            }
            this.m_indexCatalogUpdated = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSequence(String schmema, String sequenceIdentifier) throws SQLException {
        TableName sequenceName = new TableName(schmema, sequenceIdentifier);
        HashMap hashMap = this.m_sequenceMap;
        synchronized (hashMap) {
            Object sequence = this.m_sequenceMap.remove(sequenceName);
            if (sequence == null) {
                throw sequenceName.getNotFoundException("sequence");
            }
            this.m_anySeqUpdated = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTable(TableName tabname) {
        Table removedTab = null;
        Object object = this.m_tableMap;
        synchronized (object) {
            removedTab = (Table)this.m_tableMap.remove(tabname);
            if (removedTab == null) {
                return false;
            }
            this.m_tableCatalogUpdated = true;
        }
        object = removedTab;
        synchronized (object) {
            Enumeration indexNamesIter = removedTab.getIndexNamesIterator();
            if (indexNamesIter != null) {
                while (indexNamesIter.hasMoreElements()) {
                    TableName indexName = new TableName(tabname.getSchema(), (String)indexNamesIter.nextElement());
                    this.removeIndexName(indexName);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameTable(String oldSchema, String oldIdentifier, String newSchema, String newIdentifier) throws SQLException {
        TableName oldTabname = new TableName(oldSchema, oldIdentifier);
        TableName newTabname = new TableName(newSchema, newIdentifier);
        Table tab = null;
        HashMap hashMap = this.m_tableMap;
        synchronized (hashMap) {
            if (this.m_tableMap.containsKey(newTabname)) {
                throw newTabname.getDuplicateException("table");
            }
            tab = (Table)this.m_tableMap.get(oldTabname);
            if (tab == null || !tab.getTableName().equals(oldTabname)) {
                throw oldTabname.getNotFoundException();
            }
            this.m_tableCatalogUpdated = true;
            Table table = tab;
            synchronized (table) {
                tab.setTableName(newTabname);
            }
            this.m_tableMap.remove(oldTabname);
            this.m_tableMap.put(newTabname, tab);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void replaceDatabaseFromStream(FileInputStream fileStream, boolean readBackup) throws IOException {
        HashMap oldUserAndSchemaMap;
        int requiredVersion;
        DatabaseInputStream inStream = new DatabaseInputStream(fileStream);
        int inputVersion = inStream.readInt();
        int n = requiredVersion = readBackup ? -1380188158 : -1129512958;
        if (inputVersion != requiredVersion) {
            throw new IOException("wrong backup version " + inputVersion + " (required version: " + requiredVersion + ")");
        }
        HashMap hashMap = this.m_userAndSchemaMap;
        synchronized (hashMap) {
            oldUserAndSchemaMap = this.m_userAndSchemaMap;
        }
        try {
            File[] fileList;
            if (readBackup && this.m_databaseFolder != null) {
                fileList = this.m_databaseFolder.listFiles();
                for (int i = 0; i < fileList.length; ++i) {
                    fileList[i].delete();
                }
            }
            fileList = this.m_userAndSchemaMap;
            synchronized (this.m_userAndSchemaMap) {
                HashMap hashMap2 = this.m_tableMap;
                synchronized (hashMap2) {
                    HashMap hashMap3 = this.m_indexMap;
                    synchronized (hashMap3) {
                        this.m_userAndSchemaMap.clear();
                        int userCount = inStream.readInt();
                        for (int i = 0; i < userCount; ++i) {
                            String username = inStream.readString();
                            String password = inStream.readString();
                            int entryType = inStream.readInt();
                            this.m_userAndSchemaMap.put(username, new UserAndSchemaEntry(entryType, password));
                        }
                        this.m_tableMap.clear();
                        int tableCount = inStream.readInt();
                        for (int i = 0; i < tableCount; ++i) {
                            Table tab = Table.createFromStream(inStream, readBackup);
                            this.addTable(tab);
                            if (!readBackup) continue;
                            tab.writeContentIntoFile(true);
                        }
                        this.m_indexMap.clear();
                        int indexCount = inStream.readInt();
                        for (int i = 0; i < indexCount; ++i) {
                            TableName indexName = TableName.createFromStream(inStream);
                            TableName tabname = TableName.createFromStream(inStream);
                            this.m_indexMap.put(indexName, this.m_tableMap.get(tabname));
                        }
                        this.m_anySchemaUpdated = readBackup;
                        this.m_tableCatalogUpdated = readBackup;
                        this.m_indexCatalogUpdated = readBackup;
                    }
                }
                // ** MonitorExit[fileList] (shouldn't be in output)
                if (readBackup) {
                    this.replaceSeqFromStream(inStream, readBackup);
                }
                if ((inputVersion = inStream.readInt()) != requiredVersion) {
                    throw new IOException("wrong end-of-backup version " + inputVersion + " (required version: " + requiredVersion + ")");
                }
                inStream.close();
            }
        }
        catch (IOException ex) {
            HashMap hashMap4 = this.m_userAndSchemaMap;
            synchronized (hashMap4) {
                this.m_userAndSchemaMap.clear();
                this.m_userAndSchemaMap = oldUserAndSchemaMap;
            }
            hashMap4 = this.m_sequenceMap;
            synchronized (hashMap4) {
                this.m_sequenceMap.clear();
            }
            hashMap4 = this.m_tableMap;
            synchronized (hashMap4) {
                this.m_tableMap.clear();
            }
            hashMap4 = this.m_indexMap;
            synchronized (hashMap4) {
                this.m_indexMap.clear();
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceSeqFromStream(DatabaseInputStream inStream, boolean readBackup) throws IOException {
        int inputVersion = inStream.readInt();
        if (inputVersion != -1129447422) {
            throw new IOException("wrong sequence file version " + inputVersion + " (required version: " + -1129447422 + ")");
        }
        HashMap hashMap = this.m_sequenceMap;
        synchronized (hashMap) {
            this.m_anySeqUpdated = readBackup;
            this.m_sequenceMap.clear();
            int sequenceCount = inStream.readInt();
            for (int i = 0; i < sequenceCount; ++i) {
                TableName sequenceName = TableName.createFromStream(inStream);
                Long sequenceNo = new Long(inStream.readLong());
                this.m_sequenceMap.put(sequenceName, sequenceNo);
            }
        }
        inputVersion = inStream.readInt();
        if (inputVersion != -1129447422) {
            throw new IOException("wrong end-of-sequence-file version " + inputVersion + " (required version: " + -1129447422 + ")");
        }
    }

    private void writeCatalogOrSequencesIntoFile(boolean writeCatalog) throws IOException {
        try {
            this.m_databaseFolder.mkdirs();
            String filename = writeCatalog ? CATALOG_FILENAME : SEQ_FILENAME;
            File auxFile = new File(this.m_databaseFolder, AUX_FILE_PREFIX + filename);
            File outFile = new File(this.m_databaseFolder, filename);
            auxFile.delete();
            boolean fileAlreadyExists = outFile.exists();
            boolean fileRenamed = outFile.renameTo(auxFile);
            if (fileAlreadyExists && !fileRenamed) {
                throw new IOException("file " + outFile.getAbsolutePath() + " not accessible");
            }
            try {
                FileOutputStream fileStream = new FileOutputStream(outFile);
                if (writeCatalog) {
                    this.writeToStream(fileStream, false);
                } else {
                    DatabaseOutputStream outStream = new DatabaseOutputStream(fileStream);
                    this.writeSeqToStream(outStream);
                    fileStream.close();
                }
            }
            catch (Exception ex) {
                outFile.delete();
                if (fileAlreadyExists) {
                    auxFile.renameTo(outFile);
                }
                throw ex;
            }
            if (fileAlreadyExists) {
                auxFile.delete();
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException(ex.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSeqToStream(DatabaseOutputStream outStream) throws IOException {
        HashMap hashMap = this.m_sequenceMap;
        synchronized (hashMap) {
            outStream.writeInt(-1129447422);
            outStream.writeInt(this.m_sequenceMap.size());
            Iterator sequenceIter = this.m_sequenceMap.entrySet().iterator();
            while (sequenceIter.hasNext()) {
                Map.Entry currEntry = sequenceIter.next();
                TableName sequenceName = (TableName)currEntry.getKey();
                Long sequenceNo = (Long)currEntry.getValue();
                sequenceName.writeToStream(outStream);
                outStream.writeLong(sequenceNo);
            }
            outStream.writeInt(-1129447422);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToStream(FileOutputStream fileStream, boolean isBackup) throws IOException {
        DatabaseOutputStream outStream = new DatabaseOutputStream(fileStream);
        int version = isBackup ? -1380188158 : -1129512958;
        outStream.writeInt(version);
        HashMap hashMap = this.m_userAndSchemaMap;
        synchronized (hashMap) {
            HashMap hashMap2 = this.m_tableMap;
            synchronized (hashMap2) {
                HashMap hashMap3 = this.m_indexMap;
                synchronized (hashMap3) {
                    outStream.writeInt(this.m_userAndSchemaMap.size());
                    Iterator userIter = this.m_userAndSchemaMap.entrySet().iterator();
                    while (userIter.hasNext()) {
                        Map.Entry currEntry = userIter.next();
                        String username = (String)currEntry.getKey();
                        UserAndSchemaEntry entry = (UserAndSchemaEntry)currEntry.getValue();
                        outStream.writeString(username);
                        outStream.writeString(entry.m_password);
                        outStream.writeInt(entry.m_type);
                    }
                    userIter = null;
                    outStream.writeInt(this.m_tableMap.size());
                    Iterator tabIter = this.m_tableMap.values().iterator();
                    while (tabIter.hasNext()) {
                        Table currTab = (Table)tabIter.next();
                        currTab.writeToStream(outStream, isBackup);
                    }
                    tabIter = null;
                    outStream.writeInt(this.m_indexMap.size());
                    Iterator indexIter = this.m_indexMap.entrySet().iterator();
                    while (indexIter.hasNext()) {
                        Map.Entry currEntry = indexIter.next();
                        TableName indexName = (TableName)currEntry.getKey();
                        Table tab = (Table)currEntry.getValue();
                        indexName.writeToStream(outStream);
                        tab.getTableName().writeToStream(outStream);
                    }
                    indexIter = null;
                }
            }
        }
        if (isBackup) {
            this.writeSeqToStream(outStream);
        }
        outStream.writeInt(version);
        fileStream.close();
    }

    private class UserAndSchemaEntry {
        int m_type;
        String m_password;

        UserAndSchemaEntry(int userSchemaType, String password) {
            this.m_type = userSchemaType;
            this.m_password = password;
        }
    }
}

