/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.minDB.dataAccess;

import com.sap.sdb.minDB.common.DatabaseInputStream;
import com.sap.sdb.minDB.common.DatabaseOutputStream;
import com.sap.sdb.minDB.dataAccess.IndexKey;
import com.sap.sdb.minDB.dataAccess.MultiCharKey;
import com.sap.sdb.minDB.dataAccess.MultiColKey;
import com.sap.sdb.minDB.dataAccess.MultiNumKey;
import com.sap.sdb.minDB.dataAccess.PrimaryCharKey;
import com.sap.sdb.minDB.dataAccess.PrimaryNumKey;
import com.sap.sdb.minDB.dataAccess.PrimaryNumNumKey;
import com.sap.sdb.minDB.dataAccessInterface.DatabaseKey;
import java.io.IOException;

public abstract class AnyKey
implements DatabaseKey {
    static final int CHAR_KEY = 1;
    static final int NUM_KEY = 2;
    static final int NUM_NUM_KEY = 3;
    static final int MULTI_CHAR_KEY = 4;
    static final int MULTI_COL_KEY = 5;
    static final int MULTI_NUM_KEY = 6;
    static final int INDEX_KEY = 7;

    public void addCol(int colNo, long keyValue) {
        throw new UnsupportedOperationException("AnyKey.addCol(" + colNo + ", " + keyValue + " [long]) not supported");
    }

    public void addCol(int colNo, String keyValue) {
        throw new UnsupportedOperationException("AnyKey.addCol(" + colNo + ", " + keyValue + " [String]) not supported");
    }

    public void addCol(int colNo, Object keyValue) {
        throw new UnsupportedOperationException("AnyKey.addCol(" + colNo + ", " + keyValue.toString() + " [Object]) not supported");
    }

    public abstract int compareTo(Object var1);

    static AnyKey createFromStream(DatabaseInputStream inStream) throws IOException {
        AnyKey key = null;
        byte keyType = inStream.readByte();
        switch (keyType) {
            case 1: {
                key = new PrimaryCharKey();
                break;
            }
            case 2: {
                key = new PrimaryNumKey();
                break;
            }
            case 3: {
                key = new PrimaryNumNumKey();
                break;
            }
            case 4: {
                key = new MultiCharKey();
                break;
            }
            case 5: {
                key = new MultiColKey();
                break;
            }
            case 6: {
                key = new MultiNumKey();
                break;
            }
            case 7: {
                key = new IndexKey();
                break;
            }
            default: {
                return null;
            }
        }
        key.readFromStream(inStream);
        return key;
    }

    public int getIndexNo() {
        return -1;
    }

    public abstract boolean isGreaterStopKey(DatabaseKey var1);

    void readFromStream(DatabaseInputStream inStream) throws IOException {
        throw new IOException("AnyKey.readFromStream not supported: " + inStream.toString());
    }

    public abstract String toString();

    void writeToStream(DatabaseOutputStream outStream) throws IOException {
        throw new IOException("AnyKey.writeToStream not supported: " + outStream.toString());
    }
}

