/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.minDB.common;

import com.sap.sdb.minDB.common.AnyConnectionImpl;
import com.sap.sdb.minDB.common.StatementDummy;
import com.sap.sdb.minDB.util.ErrorMsg;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class StatementImpl
extends StatementDummy {
    private int m_maxRows = 0;
    private AnyConnectionImpl m_connection;
    private PreparedStatement m_prepStmt;

    public void close() throws SQLException {
        if (this.m_prepStmt != null) {
            this.m_prepStmt.close();
        }
    }

    public boolean execute(String sql) throws SQLException {
        if (this.m_prepStmt != null) {
            this.m_prepStmt.close();
        }
        this.m_prepStmt = this.m_connection.prepareStatement(sql);
        return this.m_prepStmt.execute();
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        if (this.m_prepStmt != null) {
            this.m_prepStmt.close();
        }
        this.m_prepStmt = this.m_connection.prepareStatement(sql);
        if (this.m_maxRows > 0) {
            this.m_prepStmt.setMaxRows(this.m_maxRows);
        }
        return this.m_prepStmt.executeQuery();
    }

    public int executeUpdate(String sql) throws SQLException {
        if (this.m_prepStmt != null) {
            this.m_prepStmt.close();
        }
        this.m_prepStmt = this.m_connection.prepareStatement(sql);
        return this.m_prepStmt.executeUpdate();
    }

    public Connection getConnection() throws SQLException {
        return this.m_connection;
    }

    public ResultSet getResultSet() throws SQLException {
        if (this.m_prepStmt == null) {
            throw ErrorMsg.newSQLException("Result set is undefined", -4001);
        }
        return this.m_prepStmt.getResultSet();
    }

    public int getUpdateCount() throws SQLException {
        return this.m_prepStmt == null ? 0 : this.m_prepStmt.getUpdateCount();
    }

    public void setMaxRows(int rows) {
        this.m_maxRows = rows;
    }

    public StatementImpl(AnyConnectionImpl connection) {
        this.m_connection = connection;
        this.m_prepStmt = null;
    }
}

