/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.minDB.common;

import com.sap.sdb.minDB.common.ResultSetDummy;
import com.sap.sdb.minDB.common.ResultSetMetaDataImpl;
import com.sap.sdb.minDB.common.Row;
import com.sap.sdb.minDB.util.ErrorMsg;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;

public abstract class ResultSetRowHandling
extends ResultSetDummy {
    private Row m_currRow;
    private int m_currColNo;
    private String[] m_schemaList;
    private String[] m_tabIdentifierList;
    private String[] m_colNameList;
    private byte[] m_colTypeList;
    private HashMap m_colNameMap;

    public int findColumn(String columnName) throws SQLException {
        Integer colNo;
        if (this.m_colNameMap == null) {
            if (this.m_colNameList == null) {
                this.triggerInitMetaData();
            }
            this.m_colNameMap = new HashMap();
            for (int i = 1; i < this.m_colNameList.length; ++i) {
                Integer currColNo = new Integer(i);
                String tabIdentifier = this.m_tabIdentifierList.length > 1 ? this.m_tabIdentifierList[i] : this.m_tabIdentifierList[0];
                this.m_colNameMap.put(this.m_colNameList[i], currColNo);
                this.m_colNameMap.put(tabIdentifier + "." + this.m_colNameList[i], currColNo);
            }
        }
        if ((colNo = (Integer)this.m_colNameMap.get(columnName)) == null) {
            throw ErrorMsg.newSQLException("Unknown result column name '" + columnName + "'", -4005);
        }
        return colNo;
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        this.m_currColNo = columnIndex;
        this.checkResultRow();
        return this.m_currRow.getBinaryCol(columnIndex);
    }

    public double getDouble(int columnIndex) throws SQLException {
        this.m_currColNo = columnIndex;
        this.checkResultRow();
        return this.m_currRow.getDoubleCol(columnIndex);
    }

    public long getLong(int columnIndex) throws SQLException {
        this.m_currColNo = columnIndex;
        this.checkResultRow();
        return this.m_currRow.getNumericCol(columnIndex);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.m_colNameList == null) {
            this.triggerInitMetaData();
        }
        return new ResultSetMetaDataImpl(this);
    }

    public Object getObject(int columnIndex) throws SQLException {
        this.m_currColNo = columnIndex;
        this.checkResultRow();
        return this.m_currRow.getObjectCol(columnIndex);
    }

    public String getString(int columnIndex) throws SQLException {
        this.m_currColNo = columnIndex;
        this.checkResultRow();
        return this.m_currRow.getCharCol(columnIndex);
    }

    public boolean wasNull() throws SQLException {
        this.checkResultRow();
        return this.m_currRow.isNull(this.m_currColNo);
    }

    public ResultSetRowHandling() {
        this.clearReferences();
    }

    private void checkResultRow() throws SQLException {
        if (this.m_currRow == null) {
            throw ErrorMsg.newSQLException("Result row not specified", -4001);
        }
        if (this.m_currColNo < 1 || this.m_currColNo > this.m_currRow.getMaxColNo()) {
            throw ErrorMsg.newSQLException("Invalid column index " + this.m_currColNo, -4005);
        }
    }

    public void clearReferences() {
        this.m_currColNo = 0;
        this.m_currRow = null;
        this.m_schemaList = null;
        this.m_tabIdentifierList = null;
        this.m_colNameList = null;
        this.m_colTypeList = null;
        this.m_colNameMap = null;
    }

    int getColumnCount() {
        return this.m_colNameList != null ? this.m_colNameList.length - 1 : (this.m_currRow != null ? this.m_currRow.getMaxColNo() : -1);
    }

    public String[] getColumnNameList() {
        return this.m_colNameList;
    }

    public byte[] getColumnTypeList() {
        return this.m_colTypeList;
    }

    public Row getCurrentRow() {
        return this.m_currRow;
    }

    public String[] getSchemaList() {
        return this.m_schemaList;
    }

    public String[] getTabIdentifierList() {
        return this.m_tabIdentifierList;
    }

    public void initMetaData(String[] schemaList, String[] tabIdentifierList, String[] colNameList, byte[] colTypeList) {
        this.m_schemaList = schemaList;
        this.m_tabIdentifierList = tabIdentifierList;
        this.m_colNameList = colNameList;
        this.m_colTypeList = colTypeList;
    }

    public void resetCurrentRow() {
        this.m_currRow = null;
        this.m_currColNo = 0;
    }

    public void setCurrentRow(Row currentRow) {
        this.m_currRow = currentRow;
        this.m_currColNo = 0;
    }

    public abstract void triggerInitMetaData() throws SQLException;
}

