/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.minDB.common;

import com.sap.sdb.minDB.common.AnyDriverImpl;
import com.sap.sdb.minDB.common.ConnectionDummy;
import com.sap.sdb.minDB.common.PreparedStatementDummy;
import com.sap.sdb.minDB.common.StatementImpl;
import com.sap.sdb.minDB.util.ErrorMsg;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;

public abstract class AnyConnectionImpl
extends ConnectionDummy {
    private AnyDriverImpl m_driver;
    private String m_url;
    private String m_username;
    private HashMap m_prepStmtMap;

    public void close() throws SQLException {
        if (this.m_prepStmtMap != null) {
            Iterator iter = this.getPrepStmtIterator();
            while (iter.hasNext()) {
                PreparedStatementDummy prepStmt = (PreparedStatementDummy)iter.next();
                prepStmt.clearReferences();
            }
            this.m_prepStmtMap = null;
        }
        this.m_driver = null;
    }

    public Statement createStatement() throws SQLException {
        return new StatementImpl(this);
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (sql == null) {
            throw ErrorMsg.newSQLException("SQL statement is null", -3008);
        }
        PreparedStatement prepStmt = this.m_driver.newPreparedStatement(this, sql);
        this.m_prepStmtMap.put(prepStmt, null);
        return prepStmt;
    }

    protected AnyConnectionImpl(AnyDriverImpl driver, String url, String username) {
        this.m_driver = driver;
        this.m_url = url;
        this.m_username = username;
        this.m_prepStmtMap = new HashMap();
    }

    public void addPrepStmt(PreparedStatement prepStmt) {
        this.m_prepStmtMap.put(prepStmt, null);
    }

    public AnyDriverImpl getDriver() {
        return this.m_driver;
    }

    protected Iterator getPrepStmtIterator() {
        return this.m_prepStmtMap.keySet().iterator();
    }

    public String getUsername() {
        return this.m_username;
    }

    String getURL() {
        return this.m_url;
    }

    public void removePrepStmt(PreparedStatement prepStmt) {
        this.m_prepStmtMap.remove(prepStmt);
    }

    public boolean supportsBatchUpdates() {
        return false;
    }
}

