/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.packettest.core;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.exceptions.TimeoutException;
import com.sap.dbtech.jdbc.packet.RequestPacket;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.sapdb.packettest.PacketTest;
import com.sap.sapdb.packettest.core.ConnectionSapDb;
import java.sql.SQLException;
import java.util.Properties;

public class SQLStatementPacket {
    private Properties connectProperties = new Properties();
    PacketTest packetTest = null;
    boolean autocommit = false;
    boolean setWithInfo = false;
    String cursorName = "";
    static int CURSORNR = 0;
    protected ConnectionSapDb connection;

    public SQLStatementPacket(PacketTest packetTest) {
        this.packetTest = packetTest;
        this.connection = packetTest.connectionSapDb;
        this.autocommit = PacketTest.getParameterBoolean((String)"AUTOCOMMIT", (boolean)false);
    }

    public StructuredBytes execute(String sql, boolean forQuery, int resultSetType, int resultSetConcurrency) throws SQLException, RTEException {
        StructuredBytes requestPacket2;
        block3: {
            this.setCursorName("JDBC_CURSOR_" + ++CURSORNR);
            requestPacket2 = null;
            boolean isQuery = false;
            String actualSQL = sql;
            boolean touchedCommand = false;
            boolean inTrans = false;
            if (sql == null) {
                throw new SQLExceptionSapDB(MessageTranslator.translate((String)"error.sqlstatement.null"), "42000");
            }
            try {
                requestPacket2 = this.sendSQL(sql, resultSetType, resultSetConcurrency, false);
            }
            catch (TimeoutException timeout) {
                if (!inTrans) break block3;
                throw timeout;
            }
        }
        return requestPacket2;
    }

    protected StructuredBytes sendSQL(String sql, int resultSetType, int resultSetConcurrency, boolean parseAgain) throws SQLException, RTEException {
        StructuredBytes requestPacket2;
        String actualSQL = sql;
        boolean touchedCommand = false;
        if (resultSetConcurrency == 1008) {
            actualSQL = String.valueOf(actualSQL) + " FOR UPDATE OF ";
            touchedCommand = true;
        }
        if (resultSetType == 1004) {
            actualSQL = String.valueOf(actualSQL) + " FOR REUSE";
            touchedCommand = true;
        }
        try {
            if (touchedCommand) {
                RequestPacket requestPacket = this.connection.getRequestPacket();
                try {
                    requestPacket2 = this.sendCommand(requestPacket, actualSQL, 1, parseAgain);
                }
                catch (SQLException sqlExc) {
                    requestPacket = this.connection.getRequestPacket();
                    requestPacket2 = this.sendCommand(requestPacket, sql, 1, parseAgain);
                }
            } else {
                RequestPacket requestPacket = this.connection.getRequestPacket();
                requestPacket2 = this.sendCommand(requestPacket, sql, 1, parseAgain);
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new SQLExceptionSapDB(MessageTranslator.translate((String)"error.sqlstatement.toolong"), "42000");
        }
        return requestPacket2;
    }

    StructuredBytes sendCommand(RequestPacket requestPacket, String sqlCmd, int gcFlags, boolean parseAgain) throws SQLException, RTEException {
        requestPacket.initDbsCommand(this.autocommit, sqlCmd, 1003);
        if (this.setWithInfo) {
            requestPacket.setWithInfo();
        }
        requestPacket.addCursorPart(this.cursorName);
        StructuredBytes requestPacket2 = this.connection.execute(requestPacket, this, gcFlags);
        return requestPacket2;
    }

    public void setCursorName(String name) throws SQLException {
        if (name != null && name.length() > 0) {
            this.cursorName = name;
        }
    }
}

