/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.packettest.core;

import com.sap.dbtech.jdbc.exceptions.TimeoutException;
import com.sap.dbtech.jdbc.packet.RequestPacket;
import com.sap.dbtech.jdbc.packet.RequestPacketUnicode;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.dbtech.util.Traceable;
import com.sap.dbtech.util.Tracer;
import com.sap.sapdb.packettest.PacketTest;
import java.sql.SQLException;

public class ConnectionSapDb {
    boolean isUnicode = false;
    boolean autocommit = false;
    PacketTest packetTest;
    public static final String APPLICATIONID = "ODB";
    public static final String APLLICATIONVERSION = "70400";

    public ConnectionSapDb(PacketTest packetTest) {
        this.packetTest = packetTest;
        this.autocommit = PacketTest.getParameterBoolean((String)"AUTOCOMMIT", (boolean)false);
        this.isUnicode = PacketTest.getParameterBoolean((String)"UNICODE", (boolean)false);
    }

    public StructuredBytes executeSQLString(String cmd, int gcFlags) throws SQLException, RTEException {
        RequestPacket requestPacket = this.getRequestPacket();
        requestPacket.initDbs(this.autocommit, 1003);
        requestPacket.addString(cmd);
        try {
            return this.execute(requestPacket, this, gcFlags);
        }
        catch (TimeoutException ignore) {
            TimeoutException.println((String)(String.valueOf(this.toString()) + " Inner Timeout " + ignore.toString()));
            return null;
        }
    }

    public StructuredBytes execute(RequestPacket requestPacket, Object executingObject, int gcFlags) throws SQLException, RTEException {
        return this.execute(requestPacket, false, false, executingObject, gcFlags);
    }

    public synchronized StructuredBytes execute(RequestPacket requestPacket, boolean ignoreErrors, boolean isParse, Object executingObject, int gcFlags) throws SQLException, RTEException {
        Object requestPacket2 = null;
        boolean localWeakReturnCode = false;
        requestPacket.closePacket();
        int requestLen = requestPacket.length();
        if (Tracer.isOn((int)5)) {
            Tracer.traceObject(null, (Traceable)requestPacket, (int)6);
        }
        return new StructuredBytes(this.packetTest.execute(requestPacket.getBase(), requestLen).getBytes(0, requestLen + 24));
    }

    public final synchronized RequestPacket getRequestPacket() throws SQLException {
        String applID = APPLICATIONID;
        String applVers = APLLICATIONVERSION;
        Object result = this.isUnicode ? new RequestPacketUnicode(this.packetTest.getRequestPacket(), applID, applVers) : new RequestPacket(this.packetTest.getRequestPacket(), 0, applID, applVers);
        result.setAvailability(true);
        return result;
    }
}

