/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.packettest;

import com.sap.dbtech.rte.comm.RTEException;
import com.sap.dbtech.rte.comm.RteC;
import com.sap.dbtech.util.FullswapMem;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.util.Tracer;
import com.sap.sapdb.packettest.core.ConnectionSapDb;
import com.sap.sapdb.packettest.core.DBConnectPacket;
import com.sap.sapdb.packettest.core.PacketTestException;
import com.sap.sapdb.packettest.core.SQLStatementPacket;
import com.sap.sapdb.packettest.rte.ConnectPacket;
import com.sap.sapdb.packettest.rte.DbPacketLayout;
import com.sap.sapdb.packettest.rte.PacketLayout;
import com.sap.sapdb.packettest.rte.RteSocketPacket;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.testcase.TestCase;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.Properties;

public abstract class PacketTest
extends TestCase {
    public static boolean DEBUG = false;
    protected Socket sock;
    protected InputStream in;
    protected OutputStream out;
    protected int remoteSwapping;
    protected int senderRef;
    protected int receiverRef;
    protected int maxSendLen;
    protected int messClass;
    protected int PORT = 7210;
    protected PacketLayout packetLayout;
    protected String URL;
    public static DecimalFormat df = new DecimalFormat("000");
    protected String dir;
    protected String DBNAME = null;
    protected TestDatabaseSap DATABASE;
    protected Properties testFrameConnectionProperties = null;
    protected Properties RTEConnectionProperties = null;
    public ConnectionSapDb connectionSapDb = new ConnectionSapDb(this);
    protected DBConnectPacket dbConnectPacket = new DBConnectPacket(this);
    protected SQLStatementPacket sqlStatementPacket = new SQLStatementPacket(this);

    public PacketTest() throws SQLException, TestDatabaseException {
        if (TestCase.getDatabase().isSap()) {
            this.DATABASE = (TestDatabaseSap)TestCase.getDatabase();
        } else {
            this.addMessage("Database is a none-SapDB database", 'E', " Test aborted");
            System.exit(1);
        }
        this.DBNAME = this.DATABASE.getName();
        this.URL = this.DATABASE.getHost();
        this.PORT = this.DATABASE.getPort();
        this.setProperties(this.DATABASE);
    }

    public abstract void run();

    public StructuredBytes createInfoRequestPacket() {
        DbPacketLayout layout = new DbPacketLayout();
        StructuredBytes rawRequest = PacketTest.createRawPacket(296);
        this.buildRTEHeader(rawRequest, 51);
        ConnectPacket connectPacket = new ConnectPacket(rawRequest.bytes(), this.DBNAME, layout);
        connectPacket.close();
        this.setActSendLen(rawRequest, connectPacket.length());
        return this.cutPacketToLen(rawRequest, connectPacket.length());
    }

    protected void setProperties(TestDatabaseSap db) throws TestDatabaseException {
        this.testFrameConnectionProperties = new Properties();
        this.testFrameConnectionProperties.setProperty("USER", db.getDBAUser());
        this.testFrameConnectionProperties.setProperty("PASSWORD", db.getDBAPassword());
        this.testFrameConnectionProperties.setProperty("HOST", db.getHost());
        this.testFrameConnectionProperties.setProperty("PORT", Integer.toString(db.getPort()));
        this.testFrameConnectionProperties.setProperty("SQLMODE", db.getSqlMode());
        this.testFrameConnectionProperties.setProperty("", "");
        this.testFrameConnectionProperties.setProperty("", "");
        String testUser = TestCase.getParameterString((String)"testUser", (String)"");
        String testPassword = TestCase.getParameterString((String)"testPassword", (String)"");
        if (testUser.equals("")) {
            testUser = "TESTUSER";
        }
        if (testPassword.equals("")) {
            testPassword = "TESTUSER";
        }
        this.DATABASE.getParameter("DEFAULT_CODE").equalsIgnoreCase("UNICODE");
        this.RTEConnectionProperties = new Properties();
        this.RTEConnectionProperties.setProperty("user", testUser);
        this.RTEConnectionProperties.setProperty("password", testPassword);
        this.RTEConnectionProperties.setProperty("url", this.URL);
        this.RTEConnectionProperties.setProperty("sqlmode", TestCase.getParameterString((String)"SQLMODE", (String)"INTERNAL"));
        this.RTEConnectionProperties.setProperty("timeout", "60");
        this.RTEConnectionProperties.setProperty("application", "ODB");
        this.RTEConnectionProperties.setProperty("appversion", "70400");
        this.RTEConnectionProperties.setProperty("", "");
        this.RTEConnectionProperties.setProperty("", "");
    }

    public StructuredBytes createDbConnectPacket(String dbname) throws RTEException {
        StructuredBytes rawRequest = PacketTest.createRawPacket(this.packetLayout.maxDataLength());
        this.buildRTEHeader(rawRequest, 61);
        ConnectPacket connectPacket = new ConnectPacket(rawRequest.bytes(), dbname, this.packetLayout);
        connectPacket.close();
        this.setActSendLen(rawRequest, connectPacket.length());
        return this.cutPacketToLen(rawRequest, connectPacket.length());
    }

    public void setActSendLen(StructuredBytes rawPacket, int sendLen) {
        rawPacket.putInt4(sendLen += 24, 0);
        rawPacket.putInt4(sendLen, 20);
    }

    public StructuredBytes cutPacketToLen(StructuredBytes rawPacket, int sendLen) {
        rawPacket = new StructuredBytes(rawPacket.getBytes(0, sendLen += 24));
        return rawPacket;
    }

    public StructuredBytes createSqlStatementPacket(String sqlstatement) throws SQLException, RTEException {
        if (this.sqlStatementPacket == null) {
            this.sqlStatementPacket = new SQLStatementPacket(this);
        }
        StructuredBytes requestPacket = this.sqlStatementPacket.execute(sqlstatement, false, 0, 0);
        this.setActSendLen(requestPacket, requestPacket.size() - 24);
        return requestPacket;
    }

    public StructuredBytes createSqlReleasePacket() throws SQLException, RTEException {
        StructuredBytes requestPacket = this.connectionSapDb.executeSQLString("ROLLBACK WORK RELEASE", 3);
        this.setActSendLen(requestPacket, requestPacket.size() - 24);
        return requestPacket;
    }

    public StructuredBytes createPacket(int messClass, StructuredBytes message) {
        StructuredBytes packet = new StructuredBytes(message.size() + 24);
        packet.putBytes(message.bytes(), 24);
        this.buildRTEHeader(packet, messClass);
        this.setActSendLen(packet, packet.size() - 24);
        return packet;
    }

    public StructuredBytes createMessage(int messageCode, int swapKind, StructuredBytes[] segments) {
        int len = 0;
        int i = 0;
        while (i < segments.length) {
            len += segments[i].size();
            ++i;
        }
        int varpartSize = this.packetLayout.maxCmdDataLength();
        StructuredBytes packet = new StructuredBytes(len + 32);
        packet.putInt1(messageCode, 0);
        packet.putInt1(swapKind, 1);
        packet.putString("70400", 4);
        packet.putString("ODB", 9);
        packet.putInt4(varpartSize, 12);
        packet.putInt4(len, 16);
        packet.putInt2(segments.length, 22);
        int offset = 0;
        int bufSize = varpartSize - 40 - 16;
        int i2 = 0;
        while (i2 < segments.length) {
            segments[i2].putInt4(offset, 4);
            segments[i2].putInt2(i2 + 1, 10);
            int noOfOParts = segments[i2].getInt2(8);
            int partoffset = 40;
            int j = 0;
            while (j < noOfOParts) {
                segments[i2].putInt4(offset, partoffset + 4);
                segments[i2].putInt4(bufSize, partoffset + 12);
                int partlen = segments[i2].getInt4(partoffset + 8);
                if (partlen % 8 != 0) {
                    partlen += 8 - partlen % 8;
                }
                partoffset += (partlen += 16);
                bufSize -= partlen;
                ++j;
            }
            packet.putBytes(segments[i2].bytes(), offset + 32);
            offset += segments.length;
            ++i2;
        }
        return packet;
    }

    public StructuredBytes createRequestSegment(StructuredBytes[] parts) {
        int commitImediately = 0;
        if (TestCase.getParameterBoolean((String)"AUTOCOMMIT", (boolean)false)) {
            commitImediately = 1;
        }
        return this.createRequestSegment(2, 1, 1, commitImediately, 0, 0, 0, 0, 0, 2, parts);
    }

    public StructuredBytes createRequestSegment(int messageType, int sqlmode, int producer, int commitImediately, int ignoreCostwarning, int prepare, int withInfo, int massCmd, int parseAgain, int options, StructuredBytes[] parts) {
        int len = 40;
        int i = 0;
        while (i < parts.length) {
            len += parts[i].size();
            ++i;
        }
        StructuredBytes packet = new StructuredBytes(len);
        packet.putInt4(len, 0);
        packet.putInt4(0, 4);
        packet.putInt2(parts.length, 8);
        packet.putInt2(0, 10);
        packet.putInt1(1, 12);
        packet.putInt1(messageType, 13);
        packet.putInt1(sqlmode, 14);
        packet.putInt1(producer, 15);
        packet.putInt1(commitImediately, 16);
        packet.putInt1(ignoreCostwarning, 17);
        packet.putInt1(prepare, 18);
        packet.putInt1(withInfo, 19);
        packet.putInt1(massCmd, 20);
        packet.putInt1(parseAgain, 21);
        packet.putInt1(options, 22);
        int offset = 40;
        int i2 = 0;
        while (i2 < parts.length) {
            packet.putBytes(parts[i2].bytes(), offset);
            offset += parts[i2].size();
            ++i2;
        }
        return packet;
    }

    public StructuredBytes createPart(int partKind, int partAttributes, int argumentCount, int bufLen, byte[] data) {
        int len = bufLen + 16;
        if (len % 8 != 0) {
            len += 8 - len % 8;
        }
        StructuredBytes packet = new StructuredBytes(len);
        packet.putInt1(partKind, 0);
        packet.putInt1(partAttributes, 1);
        packet.putInt2(argumentCount, 2);
        packet.putInt4(0, 4);
        packet.putInt4(bufLen, 8);
        packet.putInt4(0, 12);
        packet.putBytes(data, 16, bufLen);
        return packet;
    }

    public void initializePacket(StructuredBytes packet) {
        packet.putInt4(this.senderRef, 8);
    }

    public void connect() throws IOException {
        InetAddress addr = null;
        addr = InetAddress.getByName(this.URL);
        this.sock = new Socket(addr, this.PORT);
        this.sock.setTcpNoDelay(true);
        this.sock.setSendBufferSize(36864);
        this.sock.setSoLinger(true, 15);
        this.in = this.sock.getInputStream();
        this.out = this.sock.getOutputStream();
    }

    public void readSocket() throws RTEException, PacketTestException {
        StructuredBytes mem = this.receiveData();
        System.out.println("Antwort: " + new String(mem.getBytes(0, mem.size())));
    }

    public StructuredBytes receiveData() throws RTEException, PacketTestException {
        boolean firstPacket = true;
        byte[] header = new byte[24];
        int dataLength = 0;
        int bytesRead = 0;
        byte[] readBuf = null;
        StructuredBytes replyHeader = null;
        StructuredBytes result = null;
        try {
            InputStream instream = this.in;
            while (firstPacket || bytesRead < dataLength) {
                int actSendLength;
                int headerLength = instream.read(header, 0, 24);
                if (headerLength != 24) {
                    RTEException rteExc = new RTEException(MessageTranslator.translate((String)"error.data.receivefailed"), RteC.CommunicationErrorCodeMap_C[8]);
                    throw rteExc;
                }
                if (firstPacket) {
                    replyHeader = this.replyMem(header);
                    firstPacket = false;
                    int rteRC = replyHeader.getInt2(16);
                    if (rteRC != 0) {
                        if (DEBUG) {
                            System.err.println("Exspect rply but get " + new String(replyHeader.bytes()));
                        }
                        if (replyHeader.getInt1(5) == 66) {
                            throw new PacketTestException("Connection closed by peer", -1);
                        }
                        throw new IOException("CommunicationException: " + String.valueOf(rteRC));
                    }
                    dataLength = replyHeader.getInt4(20) - headerLength;
                    readBuf = new byte[dataLength];
                    result = new StructuredBytes(readBuf);
                }
                if ((actSendLength = replyHeader.getInt4(0) - headerLength) >= 0) {
                    readBuf.getClass();
                }
                while (actSendLength > 0) {
                    int chunkRead;
                    try {
                        chunkRead = instream.read(readBuf, bytesRead, actSendLength);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayExc) {
                        throw new ArrayIndexOutOfBoundsException(MessageTranslator.translate((String)"error.chunkoverflow", (Object)Integer.toString(actSendLength), (Object)Integer.toString(bytesRead), (Object)Integer.toString(readBuf.length)));
                    }
                    if (chunkRead < 0) {
                        throw new RTEException(MessageTranslator.translate((String)"error.data.receivefailed"), RteC.CommunicationErrorCodeMap_C[8]);
                    }
                    bytesRead += chunkRead;
                    actSendLength -= chunkRead;
                }
            }
        }
        catch (IOException ioexc) {
            throw new RTEException(MessageTranslator.translate((String)"error.data.receivefailed.reason", (Object)ioexc.getMessage()), RteC.CommunicationErrorCodeMap_C[8]);
        }
        if (Tracer.isOn((int)9)) {
            Tracer.traceObject((String)"REPLY:", result);
        }
        return result;
    }

    private StructuredBytes replyMem(byte[] buf) throws RTEException {
        StructuredBytes result;
        switch (this.remoteSwapping) {
            case 1: {
                result = new StructuredBytes(buf);
                break;
            }
            case 2: {
                result = new FullswapMem(buf);
                break;
            }
            default: {
                result = new StructuredBytes(buf);
            }
        }
        return result;
    }

    protected StructuredBytes receiveConnect() throws RTEException {
        StructuredBytes reply;
        int expectedReplyLen = 320;
        byte[] connectReply = new byte[expectedReplyLen];
        boolean isWrongUnixReplyPacket = false;
        try {
            InputStream instream = this.sock.getInputStream();
            int replyLen = instream.read(connectReply, 0, expectedReplyLen);
            if (replyLen < 25) {
                if (replyLen != -1) {
                    System.err.println(new String(connectReply, 0, replyLen));
                }
                throw new RTEException(MessageTranslator.translate((String)"error.recv.connect"), RteC.CommunicationErrorCodeMap_C[8]);
            }
            this.remoteSwapping = connectReply[25];
            reply = this.replyMem(connectReply);
            int fullReplyLen = reply.getInt4(0);
            if (fullReplyLen > 400000000) {
                fullReplyLen = reply.getInt1(0);
                isWrongUnixReplyPacket = true;
            }
            while (replyLen < fullReplyLen) {
                int nowreceived = instream.read(connectReply, replyLen, fullReplyLen - replyLen);
                if (nowreceived == -1) {
                    throw new RTEException(MessageTranslator.translate((String)"error.connect.receivefailed", (Object)"End of file before packet was read."), RteC.CommunicationErrorCodeMap_C[1]);
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                replyLen += nowreceived;
            }
        }
        catch (IOException ioexc) {
            throw new RTEException(MessageTranslator.translate((String)"error.connect.receivefailed", (Object)ioexc.getMessage()), RteC.CommunicationErrorCodeMap_C[1]);
        }
        if (isWrongUnixReplyPacket) {
            return reply;
        }
        this.senderRef = reply.getInt4(8);
        int replyRC = reply.getInt2(16);
        if (replyRC != 0) {
            throw new RTEException(String.valueOf(replyRC), replyRC);
        }
        return reply;
    }

    public void buildRTEHeader(StructuredBytes packet, int messClass) {
        packet.putInt4(0, 0);
        packet.putInt1(3, 4);
        packet.putInt1(messClass, 5);
        packet.putInt1(0, 6);
        packet.putInt1(0, 7);
        packet.putInt4(this.senderRef, 8);
        packet.putInt4(this.receiverRef, 12);
        packet.putInt2(0, 16);
        packet.putInt2(0, 18);
        packet.putInt4(this.maxSendLen, 20);
    }

    public static StructuredBytes createRawPacket(int dataSize) {
        return new StructuredBytes(dataSize + 24);
    }

    public StructuredBytes createSqlConnectPacket() throws SQLException {
        StructuredMem userPacket = this.dbConnectPacket.createDBConnect(this.RTEConnectionProperties);
        int sendLen = userPacket.size();
        RteSocketPacket rsp = new RteSocketPacket(userPacket.size());
        rsp.putBytes(userPacket.getBytes(0, userPacket.size()), 0, userPacket.size());
        StructuredBytes rawPacket = rsp.rteHeader;
        this.buildRTEHeader(rawPacket, 63);
        this.setActSendLen(rawPacket, sendLen);
        return rawPacket;
    }

    public StructuredBytes createSqlConnectPacket(String username, String password) throws SQLException {
        Properties prop = new Properties(this.RTEConnectionProperties);
        prop.setProperty("user", username);
        prop.setProperty("password", password);
        StructuredMem userPacket = this.dbConnectPacket.createDBConnect(prop);
        int sendLen = userPacket.size();
        RteSocketPacket rsp = new RteSocketPacket(userPacket.size());
        rsp.putBytes(userPacket.getBytes(0, userPacket.size()), 0, userPacket.size());
        StructuredBytes rawPacket = rsp.rteHeader;
        this.buildRTEHeader(rawPacket, 63);
        this.setActSendLen(rawPacket, sendLen);
        return rawPacket;
    }

    public StructuredMem getRequestPacket() {
        RteSocketPacket result = new RteSocketPacket(this.packetLayout.maxCmdDataLength());
        return result;
    }

    public StructuredBytes createReleasePacket() {
        StructuredBytes rawPacket = PacketTest.createRawPacket(0);
        this.buildRTEHeader(rawPacket, 66);
        return rawPacket;
    }

    public void disconnect() throws Exception {
        this.out.write(this.createReleasePacket().bytes());
        System.out.println("Conncetion released");
        this.in.close();
        this.out.close();
        this.in = null;
        this.out = null;
        this.sock.close();
        this.sock = null;
        System.out.println("Socket closed");
    }

    public static DbPacketLayout getPacketLayoutFromReply(StructuredBytes reply, boolean trustReply) {
        int maxDataLen = reply.getInt4(36);
        int minReplySize = reply.getInt4(44);
        int packetSize = reply.getInt4(40);
        int maxSegmentSize = trustReply ? reply.getInt4(32) : packetSize;
        DbPacketLayout result = new DbPacketLayout(maxDataLen, maxSegmentSize, minReplySize, packetSize);
        return result;
    }

    public boolean initializeConnection() {
        try {
            this.connect();
            StructuredBytes sendPacket = this.createInfoRequestPacket();
            this.out.write(sendPacket.bytes(), 0, sendPacket.size());
            StructuredBytes receivePacket = this.receiveConnect();
            this.packetLayout = PacketTest.getPacketLayoutFromReply(receivePacket, true);
            this.disconnect();
            System.out.println("Initializing complete");
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public StructuredBytes execute(StructuredMem userPacket, int len) throws RTEException {
        return this.request(userPacket, len);
    }

    public StructuredBytes request(StructuredMem userPacket, int len) throws RTEException {
        StructuredBytes rawPacket = ((RteSocketPacket)userPacket).rteHeader;
        this.buildRTEHeader(rawPacket, 63);
        return rawPacket;
    }
}

