/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.sqltest.interpreter;

import com.sap.sapdb.sqltest.interpreter.Reference;
import com.sap.sapdb.sqltest.parser.TestCaseBean;
import com.sap.sapdb.sqltest.parser.TestCasesSaxParser;
import java.util.TreeMap;

public class Cache {
    private TreeMap storage;
    private String URIPrefix;

    public Cache(String URIPrefix) {
        this.URIPrefix = URIPrefix;
        this.storage = new TreeMap();
    }

    private boolean hasReference(Reference currentRef) {
        return this.storage.containsKey(currentRef.getFileName());
    }

    private void putCasesOfReferenceToTheCache(String fileName) throws Exception {
        TreeMap cases = new TestCasesSaxParser().parseTestCases(String.valueOf(this.URIPrefix) + fileName);
        this.storage.put(fileName, cases);
    }

    public TestCaseBean getCaseForReference(Reference currentRef) throws Exception {
        if (!this.hasReference(currentRef)) {
            this.putCasesOfReferenceToTheCache(currentRef.getFileName());
        }
        return (TestCaseBean)((TreeMap)this.storage.get(currentRef.getFileName())).get(new Integer(currentRef.getNumberOfTestCase()));
    }
}

