/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.sqlmanager;

import com.sap.sapdb.testframe.testcase.TestPreparedStatement;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;

class DatabaseObject {
    private static Vector columnDatatypeList = new MyVector();
    private static Properties DatatypeSpecificationSqlStringList = new MyProperties();
    private static boolean valueListInitialized = false;
    private static String[] charunicodeValueList;
    private static String[] charasciiValueList;
    private static String[] charbyteValueList;
    private static String[] floatValueList;
    private static String[] booleanValueList;
    private static String[] integerValueList;
    private static String[] smallintValueList;
    private static Date[] dateValueList;
    private static Time[] timeValueList;
    private static Timestamp[] timestampValueList;
    private static String[] fixedValueList;
    private static String[] columnEncodingsUnicode;
    private static String[] columnEncodingsAscii;
    private static int VALUE_LIST_SIZE;
    private static int MAX_FLOAT_SIZE;
    private static int MAX_CHAR_SIZE;
    private static Random RANDOM;
    private String ObjectName;
    private String ObjectOwner;
    private String ObjectType;
    private static int ObjectViewNameNumber;
    private boolean ObjectViewNameTruncated = false;
    private String ObjectViewName;
    private Vector columnList;

    static {
        columnEncodingsUnicode = new String[]{"ASCII", "UNICODE", "BYTE"};
        columnEncodingsAscii = new String[]{"ASCII", "BYTE"};
        VALUE_LIST_SIZE = 10;
        MAX_FLOAT_SIZE = 38;
        MAX_CHAR_SIZE = 80;
        RANDOM = new Random();
        ObjectViewNameNumber = 0;
    }

    private static String stringReplace(String inputString, String searchString, String replaceString) {
        int i = inputString.indexOf(searchString);
        while (i > -1) {
            String s1 = inputString.substring(0, i);
            String s2 = inputString.substring(i + searchString.length());
            inputString = String.valueOf(s1) + replaceString + s2;
            i = inputString.indexOf(searchString);
        }
        return inputString;
    }

    public int getNextViewNumber() {
        return ++ObjectViewNameNumber;
    }

    public boolean getViewNameTruncated() {
        return this.ObjectViewNameTruncated;
    }

    public void setViewNameTruncated() {
        this.ObjectViewNameTruncated = true;
    }

    public String getObjectName() {
        return "\"" + this.ObjectName + "\"";
    }

    public String getObjectOwner() {
        return this.ObjectOwner;
    }

    public String getObjectType() {
        return this.ObjectType;
    }

    public int getColumnCount() {
        return this.columnList.size();
    }

    DatabaseObject(String ObjectOwner, String ObjectName, String ObjectType) {
        this.ObjectName = ObjectName;
        this.ObjectType = ObjectType;
        this.ObjectOwner = ObjectOwner;
        this.columnList = new Vector();
        this.ObjectViewName = "v_" + ObjectOwner + "_" + ObjectName;
        if (this.ObjectViewName.length() > 32) {
            this.setViewNameTruncated();
            this.ObjectViewName = String.valueOf(this.ObjectViewName.substring(0, 30)) + this.getNextViewNumber();
        }
    }

    public String getObjectIdentifier() {
        return String.valueOf(this.ObjectOwner) + "." + this.ObjectName;
    }

    public void setColumnList(ResultSetMetaData mdata) throws Exception {
        int i = 1;
        while (i <= mdata.getColumnCount()) {
            this.columnList.add(new ColumnSpecification(mdata.getColumnName(i), mdata.getColumnTypeName(i), mdata.getColumnDisplaySize(i), mdata.getPrecision(i), null));
            ++i;
        }
    }

    private ColumnSpecification getColumn(int Columnnumber) {
        return (ColumnSpecification)this.columnList.get(Columnnumber - 1);
    }

    public void addColumn(String columnName, String columnType, int columnSize, int Precision, String Encoding) {
        this.columnList.add(new ColumnSpecification(columnName, columnType, columnSize, Precision, Encoding));
    }

    public String getColumnName(int columnIndex) {
        return "\"" + ((ColumnSpecification)this.columnList.get(columnIndex - 1)).getColumnName() + "\"";
    }

    public String getColumnIdentifier(int columnIndex) {
        return String.valueOf(this.getObjectName()) + "." + this.getColumnName(columnIndex);
    }

    public String getColumnType(int columnIndex) {
        String enc = ((ColumnSpecification)this.columnList.get(columnIndex - 1)).getColumnEncoding();
        if (enc == null) {
            return ((ColumnSpecification)this.columnList.get(columnIndex - 1)).getColumnType();
        }
        if (enc == "UNICODE" || enc == "BYTE") {
            return String.valueOf(((ColumnSpecification)this.columnList.get(columnIndex - 1)).getColumnType()) + " " + enc;
        }
        return ((ColumnSpecification)this.columnList.get(columnIndex - 1)).getColumnType();
    }

    public String getColumnTypeWithoutEncoding(int columnIndex) {
        return ((ColumnSpecification)this.columnList.get(columnIndex - 1)).getColumnType();
    }

    public String getColumnEncoding(int columnIndex) {
        return ((ColumnSpecification)this.columnList.get(columnIndex - 1)).getColumnEncoding();
    }

    public int getColumnLength(int columnIndex) {
        return ((ColumnSpecification)this.columnList.get(columnIndex - 1)).getColumnLength();
    }

    public int getColumnPrecision(int columnIndex) {
        return ((ColumnSpecification)this.columnList.get(columnIndex - 1)).getColumnPrecision();
    }

    public long getTableLength() {
        long completeLength = 0L;
        int t = 1;
        while (t <= this.getColumnCount()) {
            completeLength += (long)this.getColumnLength(t);
            ++t;
        }
        return completeLength;
    }

    public String getObjectViewName() {
        return this.ObjectViewName;
    }

    public int getFirstColumn(String columnType) {
        int t = 1;
        while (t <= this.getColumnCount()) {
            if (this.getColumnType(t).equalsIgnoreCase(columnType)) {
                return t;
            }
            ++t;
        }
        return -1;
    }

    public boolean hasColumnType(String Columntype) {
        int t = 1;
        while (t <= this.getColumnCount()) {
            if (this.getColumnType(t).equalsIgnoreCase(Columntype) && this.isUsableColumn(t)) {
                return true;
            }
            ++t;
        }
        return false;
    }

    public boolean hasOnlyLong() {
        int t = 1;
        while (t <= this.getColumnCount()) {
            if (this.getColumnType(t).indexOf("LONG") == -1) {
                return false;
            }
            ++t;
        }
        return true;
    }

    public boolean hasUsableColumn() {
        int t = 1;
        while (t <= this.getColumnCount()) {
            if (this.isUsableColumn(t)) {
                return true;
            }
            ++t;
        }
        return false;
    }

    public boolean hasOnlyUsableColumns() {
        if (this.getColumnCount() < 1) {
            return false;
        }
        int t = 1;
        while (t <= this.getColumnCount()) {
            if (!this.isUsableColumn(t)) {
                return false;
            }
            ++t;
        }
        return true;
    }

    public int getRandomColumn() {
        int i = new Random().nextInt(this.getColumnCount()) + 1;
        if (this.hasUsableColumn()) {
            while (!this.isUsableColumn(i)) {
                if (i == this.getColumnCount()) {
                    i = 1;
                    continue;
                }
                ++i;
            }
            return i;
        }
        return -1;
    }

    public Vector getAllUsableColumns() {
        if (this.hasUsableColumn()) {
            Vector<Integer> v = new Vector<Integer>();
            int i = 1;
            while (i <= this.getColumnCount()) {
                if (this.isUsableColumn(i)) {
                    v.add(new Integer(i));
                }
                ++i;
            }
            return v;
        }
        return null;
    }

    public int getRandomColumn(String columnType) {
        int i = new Random().nextInt(this.getColumnCount()) + 1;
        if (this.hasUsableColumn() && this.hasColumnType(columnType)) {
            while (!this.getColumnType(i).equalsIgnoreCase(columnType) || !this.isUsableColumn(i)) {
                if (i == this.getColumnCount()) {
                    i = 1;
                    continue;
                }
                ++i;
            }
            return i;
        }
        return -1;
    }

    public boolean isUsableColumn(int columnNumber) {
        return this.getColumnType(columnNumber).indexOf("LONG") < 0 && this.getColumnLength(columnNumber) < 510;
    }

    public static DatabaseObject getRandomTable(String schemaName, String tableName, String columnPrefix, int maxColumnCount, boolean unicode) throws Exception {
        DatabaseObject table = new DatabaseObject(schemaName, tableName, "TABLE");
        String[] columnEncodings = unicode ? columnEncodingsUnicode : columnEncodingsAscii;
        int currentColumnCount = RANDOM.nextInt(maxColumnCount) + 1;
        int j = 1;
        while (j <= currentColumnCount) {
            int columnTypeNumber = RANDOM.nextInt(columnDatatypeList.size());
            String columnTypeName = (String)columnDatatypeList.get(columnTypeNumber);
            if (columnTypeName.indexOf("CHAR") > -1) {
                table.addColumn(String.valueOf(columnPrefix) + j, columnTypeName, MAX_CHAR_SIZE, 0, columnEncodings[RANDOM.nextInt(columnEncodings.length)]);
            } else if (columnTypeName.equalsIgnoreCase("FIXED")) {
                table.addColumn(String.valueOf(columnPrefix) + j, columnTypeName, MAX_FLOAT_SIZE, MAX_FLOAT_SIZE / 2, null);
            } else if (columnTypeName.equalsIgnoreCase("FLOAT")) {
                int floatsize = MAX_FLOAT_SIZE;
                table.addColumn(String.valueOf(columnPrefix) + j, columnTypeName, floatsize, 0, null);
            } else {
                table.addColumn(String.valueOf(columnPrefix) + j, columnTypeName, 0, 0, null);
            }
            ++j;
        }
        return table;
    }

    public String getSqlDropString() {
        return "drop table " + this.getObjectIdentifier();
    }

    private static void fillRandomValueLists() {
        Calendar myCal;
        int valueCount = VALUE_LIST_SIZE;
        booleanValueList = new String[VALUE_LIST_SIZE];
        int i = 0;
        while (i < valueCount) {
            DatabaseObject.booleanValueList[i] = Boolean.toString(RANDOM.nextBoolean());
            ++i;
        }
        floatValueList = new String[VALUE_LIST_SIZE];
        i = 0;
        while (i < valueCount) {
            DatabaseObject.floatValueList[i] = Float.toString(RANDOM.nextFloat());
            ++i;
        }
        smallintValueList = new String[VALUE_LIST_SIZE];
        i = 0;
        while (i < valueCount) {
            DatabaseObject.smallintValueList[i] = Integer.toString(RANDOM.nextInt() % Short.MAX_VALUE);
            ++i;
        }
        integerValueList = new String[VALUE_LIST_SIZE];
        i = 0;
        while (i < valueCount) {
            DatabaseObject.integerValueList[i] = Integer.toString(RANDOM.nextInt());
            ++i;
        }
        dateValueList = new Date[VALUE_LIST_SIZE];
        i = 0;
        while (i < valueCount) {
            DatabaseObject.dateValueList[i] = new Date(RANDOM.nextLong() % 3338656939707L);
            ++i;
        }
        timeValueList = new Time[VALUE_LIST_SIZE];
        long myLong = 0L;
        int i2 = 0;
        while (i2 < valueCount) {
            myLong = RANDOM.nextLong() % 3338656939707L;
            DatabaseObject.timeValueList[i2] = new Time(myLong);
            myCal = Calendar.getInstance();
            myCal.setTimeInMillis(timeValueList[i2].getTime());
            if (myCal.get(10) == 0 && myCal.get(12) < 2) {
                System.out.println(" bad time: " + timeValueList[i2] + "; long -> " + myLong);
                --i2;
            }
            ++i2;
        }
        timestampValueList = new Timestamp[VALUE_LIST_SIZE];
        i2 = 0;
        while (i2 < valueCount) {
            myLong = RANDOM.nextLong() % 3338656879707L + 60000L;
            DatabaseObject.timestampValueList[i2] = new Timestamp(myLong);
            myCal = Calendar.getInstance();
            myCal.setTimeInMillis(timestampValueList[i2].getTime());
            if (myCal.get(10) == 0 && myCal.get(12) < 2) {
                System.out.println(" bad timestamp: " + timeValueList[i2] + "; long -> " + myLong);
                --i2;
            }
            ++i2;
        }
        charunicodeValueList = new String[VALUE_LIST_SIZE];
        int i3 = 0;
        while (i3 < valueCount) {
            int charcount = RANDOM.nextInt(MAX_CHAR_SIZE);
            char[] ca = new char[charcount];
            int j = 0;
            while (j < charcount) {
                int x = RANDOM.nextInt(65537);
                ca[j] = (char)x;
                ++j;
            }
            DatabaseObject.charunicodeValueList[i3] = new String(ca);
            ++i3;
        }
        charasciiValueList = new String[VALUE_LIST_SIZE];
        byte[] ba = new byte[MAX_CHAR_SIZE];
        boolean conversionSucessfull = false;
        int i4 = 0;
        while (i4 < valueCount) {
            conversionSucessfull = false;
            while (!conversionSucessfull) {
                try {
                    RANDOM.nextBytes(ba);
                    DatabaseObject.charasciiValueList[i4] = new String(ba, "ISO-8859-1").replaceAll("'", "_").replaceAll("\"", "_");
                    conversionSucessfull = true;
                }
                catch (UnsupportedEncodingException e) {
                    conversionSucessfull = false;
                }
            }
            ++i4;
        }
        charbyteValueList = new String[VALUE_LIST_SIZE];
        int i5 = 0;
        while (i5 < valueCount) {
            long byteValue = RANDOM.nextLong();
            String byteValueString = Long.toHexString(byteValue);
            if (byteValueString.length() % 2 == 1) {
                byteValueString = byteValueString.concat("0");
            }
            DatabaseObject.charbyteValueList[i5] = "x'" + byteValueString + "'";
            ++i5;
        }
        fixedValueList = new String[VALUE_LIST_SIZE];
        int i6 = 0;
        while (i6 < valueCount) {
            int decimalPart = RANDOM.nextInt();
            int fractionalPart = Math.abs(RANDOM.nextInt());
            DatabaseObject.fixedValueList[i6] = new String(String.valueOf(decimalPart) + "." + fractionalPart);
            ++i6;
        }
        valueListInitialized = true;
    }

    private String getRandomData(ColumnSpecification column) {
        String columnType = column.getColumnType().toLowerCase();
        String columnEncoding = column.getColumnEncoding();
        int random = RANDOM.nextInt(VALUE_LIST_SIZE);
        String randomData = columnType.equals("varchar") || columnType.equals("char") ? (columnEncoding.equalsIgnoreCase("ascii") ? "'" + charasciiValueList[random] + "'" : (columnEncoding.equalsIgnoreCase("unicode") ? "'" + charunicodeValueList[random] + "'" : charbyteValueList[random])) : (columnType.equals("float") ? floatValueList[random] : (columnType.equals("boolean") ? booleanValueList[random] : (columnType.equals("smallint") ? smallintValueList[random] : (columnType.equals("integer") ? integerValueList[random] : (columnType.equals("time") ? "'" + timeValueList[random] + "'" : (columnType.equals("date") ? "'" + dateValueList[random] + "'" : (columnType.equals("timestamp") ? "'" + timestampValueList[random] + "'" : (columnType.equals("fixed") ? fixedValueList[random] : "Error"))))))));
        return randomData;
    }

    public Vector getSqlInsertRandomDataString(int rowcount) {
        if (!valueListInitialized) {
            DatabaseObject.fillRandomValueLists();
        }
        Vector<String> insertStringList = new Vector<String>();
        int i = 0;
        while (i < rowcount) {
            String insertString = "insert into " + this.getObjectIdentifier() + " values (";
            int j = 0;
            while (j < this.getColumnCount()) {
                insertString = String.valueOf(insertString) + this.getRandomData((ColumnSpecification)this.columnList.get(j));
                if (j < this.getColumnCount() - 1) {
                    insertString = String.valueOf(insertString) + ",";
                }
                ++j;
            }
            insertString = String.valueOf(insertString) + ")";
            insertStringList.add(insertString);
            ++i;
        }
        return insertStringList;
    }

    public String getSqlCreateString() {
        String createTableStatement1 = "Create table ";
        String createTableStatement2 = "(";
        String createTableStatement4 = ",";
        String createTableStatement5 = ")";
        int columnCount = this.getColumnCount();
        String createTableStatement = String.valueOf(createTableStatement1) + this.getObjectIdentifier() + createTableStatement2;
        int j = 1;
        while (j <= columnCount) {
            String columnType = this.getColumnTypeWithoutEncoding(j);
            String columnName = this.getColumnName(j);
            String datatypeSpecificationSqlString = DatatypeSpecificationSqlStringList.getProperty(columnType);
            createTableStatement = columnType.indexOf("CHAR") > -1 ? String.valueOf(createTableStatement) + columnName + " " + DatabaseObject.stringReplace(datatypeSpecificationSqlString, "#C", Integer.toString(this.getColumnLength(j))) + " " + this.getColumnEncoding(j) : (columnType.equalsIgnoreCase("FIXED") ? String.valueOf(createTableStatement) + columnName + " " + DatabaseObject.stringReplace(DatabaseObject.stringReplace(datatypeSpecificationSqlString, "#F", Integer.toString(this.getColumnLength(j))), "#P", Integer.toString(this.getColumnPrecision(j))) : (columnType.equalsIgnoreCase("FLOAT") ? String.valueOf(createTableStatement) + columnName + " " + DatabaseObject.stringReplace(datatypeSpecificationSqlString, "#F", Integer.toString(this.getColumnLength(j))) : String.valueOf(createTableStatement) + columnName + " " + datatypeSpecificationSqlString));
            if (j < columnCount) {
                createTableStatement = String.valueOf(createTableStatement) + createTableStatement4;
            }
            ++j;
        }
        createTableStatement = String.valueOf(createTableStatement) + createTableStatement5;
        return createTableStatement;
    }

    public void insertRandomData(Connection dbcon, int rowcount) throws Exception {
        if (!valueListInitialized) {
            DatabaseObject.fillRandomValueLists();
        }
        String preparedStatement = "insert into " + this.getObjectIdentifier() + " values (";
        int i = 1;
        while (i < this.getColumnCount()) {
            preparedStatement = String.valueOf(preparedStatement) + "?,";
            ++i;
        }
        preparedStatement = String.valueOf(preparedStatement) + "?)";
        TestPreparedStatement prepsta = new TestPreparedStatement(null, dbcon, preparedStatement);
        int j = 1;
        while (j <= rowcount) {
            int k = 1;
            while (k <= this.getColumnCount()) {
                ColumnSpecification column = this.getColumn(k);
                String columnType = column.getColumnType().toLowerCase();
                String columnEncoding = column.getColumnEncoding();
                int random = RANDOM.nextInt(VALUE_LIST_SIZE);
                if (columnType.equalsIgnoreCase("CHAR") || columnType.equalsIgnoreCase("VARCHAR")) {
                    if (columnEncoding.equalsIgnoreCase("ascii")) {
                        prepsta.setString(k, charasciiValueList[random]);
                    } else if (columnEncoding.equalsIgnoreCase("unicode")) {
                        prepsta.setString(k, charunicodeValueList[random]);
                    } else {
                        prepsta.setString(k, charbyteValueList[random]);
                    }
                } else if (columnType.equalsIgnoreCase("FLOAT")) {
                    prepsta.setFloat(k, Float.parseFloat(floatValueList[random]));
                } else if (columnType.equalsIgnoreCase("BOOLEAN")) {
                    prepsta.setBoolean(k, Boolean.valueOf(booleanValueList[random]).booleanValue());
                } else if (columnType.equalsIgnoreCase("INTEGER")) {
                    prepsta.setInt(k, Integer.parseInt(integerValueList[random]));
                } else if (columnType.equalsIgnoreCase("SMALLINT")) {
                    prepsta.setShort(k, Short.parseShort(smallintValueList[random]));
                } else if (columnType.equalsIgnoreCase("DATE")) {
                    prepsta.setDate(k, dateValueList[random]);
                } else if (columnType.equalsIgnoreCase("FIXED")) {
                    prepsta.setFloat(k, Float.parseFloat(fixedValueList[random]));
                } else if (columnType.equalsIgnoreCase("TIME")) {
                    prepsta.setTime(k, timeValueList[random]);
                } else if (columnType.equalsIgnoreCase("TIMESTAMP")) {
                    prepsta.setTimestamp(k, timestampValueList[random]);
                } else {
                    System.out.println("Fehler!!! " + columnType);
                }
                ++k;
            }
            prepsta.addBatch();
            ++j;
        }
        prepsta.executeBatch();
    }

    public String toString() {
        String rs = String.valueOf(this.getObjectIdentifier()) + "\n";
        int i = 1;
        while (i <= this.getColumnCount()) {
            rs = String.valueOf(rs) + this.getColumn(i) + "\n";
            ++i;
        }
        return rs;
    }

    public static void setRANDOM(Random random) {
        RANDOM = random;
    }

    public static class MyVector
    extends Vector {
        static final long serialVersionUID = 32895290587293L;

        MyVector() {
            super(10);
            this.add("CHAR");
            this.add("VARCHAR");
            this.add("FIXED");
            this.add("FLOAT");
            this.add("BOOLEAN");
            this.add("INTEGER");
            this.add("SMALLINT");
            this.add("DATE");
            this.add("TIME");
            this.add("TIMESTAMP");
        }
    }

    public static class MyProperties
    extends Properties {
        static final long serialVersionUID = 8504520422344334L;

        MyProperties() {
            this.setProperty("CHAR", "CHAR (#C) ");
            this.setProperty("VARCHAR", "VARCHAR (#C) ");
            this.setProperty("FIXED", "FIXED (#F ,#P)");
            this.setProperty("FLOAT", "FLOAT (#F)");
            this.setProperty("BOOLEAN", "BOOLEAN");
            this.setProperty("INTEGER", "INTEGER");
            this.setProperty("SMALLINT", "SMALLINT");
            this.setProperty("DATE", "DATE");
            this.setProperty("TIME", "TIME");
            this.setProperty("TIMESTAMP", "TIMESTAMP");
        }
    }

    private class ColumnSpecification {
        private String columnName;
        private String columnType;
        private int columnLength;
        private int columnPrecision;
        private String columnEncoding;

        public String getColumnEncoding() {
            return this.columnEncoding;
        }

        public void setColumnEncoding(String columnEncoding) {
            this.columnEncoding = columnEncoding;
        }

        public int getColumnLength() {
            return this.columnLength;
        }

        public int getColumnPrecision() {
            return this.columnPrecision;
        }

        public void setColumnPrecision(int columnPrecision) {
            this.columnPrecision = columnPrecision;
        }

        public void setColumnLength(int columnLength) {
            this.columnLength = columnLength;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public String getColumnType() {
            return this.columnType;
        }

        public void setColumnType(String columnType) {
            this.columnType = columnType;
        }

        ColumnSpecification(String columnName, String columnType, int LEN, int Precision, String Encoding) {
            this.setColumnName(columnName);
            this.setColumnType(columnType);
            this.setColumnLength(LEN);
            this.setColumnPrecision(Precision);
            this.setColumnEncoding(Encoding);
        }

        private String setStringSize(String s, int size) {
            String buff = s;
            if (s.length() > size) {
                buff = String.valueOf(s.substring(0, size - 2)) + "..";
            } else if (s.length() < size) {
                buff = s;
                while (buff.length() < size) {
                    buff = String.valueOf(buff) + " ";
                }
            }
            return buff;
        }

        public String toString() {
            return String.valueOf(this.setStringSize(this.getColumnName(), 30)) + this.setStringSize(this.getColumnType() == null ? " " : this.getColumnType(), 30) + this.setStringSize(this.getColumnEncoding() == null ? " " : this.getColumnEncoding(), 30) + this.getColumnLength();
        }
    }
}

