/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.optimizer;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TestClassGenerator {
    private FileWriter mFileWriter;
    private PrintWriter mPrintWriter;
    private String mClassName;
    private String mFileName;
    private int mStepNumber;
    private static boolean mDebugOn;

    public TestClassGenerator(String ClassName) {
        this.mClassName = ClassName;
        mDebugOn = false;
    }

    public TestClassGenerator(String ClassName, String ResultFileName) {
        mDebugOn = false;
        try {
            this.mFileName = ResultFileName;
            this.mFileWriter = new FileWriter(ResultFileName, false);
            this.mPrintWriter = new PrintWriter(this.mFileWriter);
            this.mClassName = ClassName;
            this.mStepNumber = 1;
            this.printHeader();
        }
        catch (Exception e) {
            this.mPrintWriter.close();
            System.out.println(e.getMessage());
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.printTrailer();
            this.mPrintWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.finalize();
    }

    public void printCheck() {
        this.printResult("      checkQuery(stm, ref, \"Check" + this.mStepNumber + "\");");
        this.printResult("      ref.clear();");
        ++this.mStepNumber;
    }

    public void printColumnNames(String ColumnNames) {
        this.printResult("      ref.add(\"[" + ColumnNames + "]\");");
    }

    public void printCommand(String CommandString) {
        this.printResult("      stm.executeUpdate(\"" + CommandString + "\");");
    }

    public void printCommandError(String CommandString, int ErrorNumber) {
        this.printResult("      // check if the command produces the error code" + ErrorNumber);
        this.printResult("      stm.enableExceptions(false);");
        this.printResult("      stm.executeUpdate(\"" + CommandString + "\");");
        this.printResult("      checkErrorCode(stm, " + ErrorNumber + ", \"Check" + this.mStepNumber + "\");");
        this.printResult("      stm.enableExceptions(true);");
        ++this.mStepNumber;
    }

    static void printDebug(String DebugMessage) {
        if (mDebugOn) {
            System.out.println(DebugMessage);
        }
    }

    public void printHeader() {
        SimpleDateFormat DForm = new SimpleDateFormat("dd.MM.yyyy");
        this.printResult("package Tests;                                                                              ");
        this.printResult("import java.sql.*;                                                                          ");
        this.printResult("import com.sap.sapdb.testframe.testcase.*;                                                       ");
        this.printResult("                                                                                            ");
        this.printResult("/**                                                                                         ");
        this.printResult(" * Generated java class for SQL tests.<p>                                                   ");
        this.printResult(" * This class is generated with Sut2Java on the <p>                                         ");
        this.printResult(" * " + DForm.format(new Date()) + "<p>                                                      ");
        this.printResult(" * from the SUT file                                                                        ");
        this.printResult(" * <pre>                                                                                    ");
        this.printResult(" * " + this.mFileName + "                                                                        ");
        this.printResult(" * </pre>                                                                                   ");
        this.printResult(" *                                                                                          ");
        this.printResult(" * <b>Important:</b> The generated SQL commands in the {@link run()}-method must            ");
        this.printResult(" * be checked manually before this class can replace the SUT!<p>                            ");
        this.printResult(" * Please use this class only as a template for the correct Single User Test.               ");
        this.printResult(" *                                                                                          ");
        this.printResult(" * @author: Tim Woehrle                                                                     ");
        this.printResult(" */                                                                                         ");
        this.printResult("public class " + this.mClassName + " extends com.sap.sapdb.testframe.testcase.TestCase {              ");
        this.printResult("/**                                                                                         ");
        this.printResult(" * Default constructor.                                                                     ");
        this.printResult(" * @exception com.sap.sapdb.testframe.driver.TestDatabaseException The exception description.    ");
        this.printResult(" * @exception java.sql.SQLException The exception description.                              ");
        this.printResult(" */                                                                                         ");
        this.printResult("public " + this.mClassName + "() throws com.sap.sapdb.testframe.driver.TestDatabaseException,        ");
        this.printResult("   java.sql.SQLException {                                                                  ");
        this.printResult("   super();                                                                                 ");
        this.printResult("}                                                                                           ");
        this.printResult("/**                                                                                         ");
        this.printResult(" * Implement test preparation code here.                                                    ");
        this.printResult(" */                                                                                         ");
        this.printResult("public static void prepare() throws TestCaseException                                       ");
        this.printResult("{                                                                                           ");
        this.printResult("}                                                                                           ");
        this.printResult("                                                                                            ");
        this.printResult("                                                                                            ");
        this.printResult("/**                                                                                         ");
        this.printResult(" * Generated method for the test execution.<p>                                              ");
        this.printResult(" * It contains the converted SQL calls from                                                 ");
        this.printResult(" * <pre>                                                                                    ");
        this.printResult(" * " + this.mFileName + "                                                                        ");
        this.printResult(" * </pre>                                                                                   ");
        this.printResult(" *                                                                                          ");
        this.printResult(" * and the definition of reference data.<p>                                                 ");
        this.printResult(" *                                                                                          ");
        this.printResult(" * <b>TODO:</b> Check if:                                                                   ");
        this.printResult(" * <li>all necessary SQL commands are converted to executexxx()-calls</li>                  ");
        this.printResult(" * <li>the reference data are correct and complete</li>                                     ");
        this.printResult(" * <li>The fetching of result sets is correct</li>                                          ");
        this.printResult(" */                                                                                         ");
        this.printResult("public void run()                                                                           ");
        this.printResult("{                                                                                           ");
        this.printResult("   java.sql.ResultSet res;                                                                  ");
        this.printResult("   Connection con;                                                                          ");
        this.printResult("   TestStatement stm;                                                                       ");
        this.printResult("   VerificationDataComplete ref;                                                              ");
        this.printResult("                                                                                            ");
        this.printResult("   try                                                                                      ");
        this.printResult("   {                                                                                        ");
        this.printResult("      con = this.getDatabase().connect(this.getUser(), this.getPassword());                 ");
        this.printResult("      stm = new TestStatement(this, con);                                                   ");
        this.printResult("      ref = new VerificationDataComplete();                                                   ");
        this.printResult("                                                                                            ");
    }

    public void printQuery(String QueryString) {
        this.printResult("      res = stm.executeQuery(\"" + QueryString + "\");");
    }

    public void printQueryError(String QueryString, int ErrorNumber) {
        this.printResult("      // check if the command produces the error code" + ErrorNumber);
        this.printResult("      stm.enableExceptions(false);");
        this.printResult("      res = stm.executeQuery(\"" + QueryString + "\");");
        this.printResult("      checkErrorCode(stm, " + ErrorNumber + ", \"Check" + this.mStepNumber + "\");");
        this.printResult("      stm.enableExceptions(true);");
        ++this.mStepNumber;
    }

    void printResult(String Message) {
        if (mDebugOn) {
            System.out.println(Message);
        }
        this.mPrintWriter.println(Message);
    }

    public void printTrailer() {
        this.printResult("                                                                                         ");
        this.printResult("   } catch (Exception e)                                                                 ");
        this.printResult("   {                                                                                     ");
        this.printResult("      this.handleExceptions(e);                                                          ");
        this.printResult("   }                                                                                     ");
        this.printResult("                                                                                         ");
        this.printResult("} // run                                                                                 ");
        this.printResult("                                                                                            ");
        this.printResult("} // class                                                                               ");
    }

    public void printUncheckedCommand(String CommandString) {
        this.printResult("      stm.enableExceptions(false);");
        this.printResult("      stm.executeUpdate(\"" + CommandString + "\");");
        this.printResult("      stm.enableExceptions(true);");
    }

    public void printValues(String Values2) {
        this.printResult("      ref.add(\"" + Values2 + "\");");
    }

    boolean run(String SourceFileName, String TargetFileName, String ClassName) {
        System.out.println("Start of run(" + SourceFileName + ", " + TargetFileName + ", " + ClassName + ")");
        return true;
    }

    public static void setDebug(boolean EnableDebug) {
        mDebugOn = EnableDebug;
    }
}

