/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.mut;

import com.sap.dbtech.powertoys.DBM;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.sapdb.oltptest.mut.OLTPTestActor;
import com.sap.sapdb.testframe.driver.TestDatabase;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestPreparedStatement;
import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sapdb.testframe.testcase.VerificationData;
import com.sap.sapdb.testframe.testcase.VerificationDataComplete;
import com.sap.sapdb.testframe.testcase.VerificationDataSorted;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;

public class RecoveryCancelOltp
extends TestCase {
    private static final String sVersion = "3.1";
    private String mKernelMode = "FAST";
    private static Connection mMainConnection = null;
    private static TestStatement mMainStatement = null;
    private static TestPreparedStatement mMainPrepStatement = null;
    private static Connection[] mConnections;
    private static TestStatement[] mStatements;
    private static TestPreparedStatement[] mPrepStatement;
    protected static int mNumberOfConcurrentUsers;
    protected static int mNumberOfKillers;
    protected static int mNumberOfWriters;
    protected static String mTypeOfKilling;
    protected static int mNoOfRecords;
    protected static int mLOG_SEGMENT_SIZE;
    protected static int mStartDistance;
    protected static int mWaitTimeAfterStart;
    protected static int mNoOfCycles;
    private String sString = null;
    private static Random mRandomGenerator;
    private static int mTraceLevel;
    private DBM mDBMan = null;
    private DBM mDBMan2 = null;
    private DBM mDBMan3 = null;
    protected static boolean noFullRecovery;
    protected static boolean killing;
    protected static Killer[] KillerSet;
    protected static QueueCountChanger queueCountChangerThread;
    protected static Integer converterVersionObj;
    protected static int converterVersionNew;
    protected static int converterVersionStart;
    protected static int recoveryAborted;
    protected boolean globalError = false;
    protected String globalErrorText = "";
    protected static boolean testIsInterrupted;

    public static String getMinimumRelease() {
        return "7.4.*";
    }

    public static String getTestClassId() {
        return "RecoveryCancelOltp";
    }

    public static void prepare() throws TestCaseException {
        RecoveryCancelOltp.readAndPrintParameters();
    }

    public static void readAndPrintParameters() throws TestCaseException {
        mTraceLevel = RecoveryCancelOltp.getParameterInt((String)"TraceLevel", (int)2);
        mNumberOfKillers = RecoveryCancelOltp.getParameterInt((String)"NumberOfKillers", (int)1);
        mTypeOfKilling = "";
        if (mNumberOfKillers == 1) {
            mTypeOfKilling = RecoveryCancelOltp.getParameterString((String)"TypeOfKilling", (String)"db_stop");
        }
        mNumberOfConcurrentUsers = mNumberOfWriters = RecoveryCancelOltp.getParameterInt((String)"NumberOfWriters", (int)8);
        mNoOfRecords = RecoveryCancelOltp.getParameterInt((String)"NoOfRecords", (int)1000);
        mNoOfCycles = RecoveryCancelOltp.getParameterInt((String)"NoOfCycles", (int)400);
        mLOG_SEGMENT_SIZE = RecoveryCancelOltp.getParameterInt((String)"LOG_SEGMENT_SIZE", (int)3000);
        mStartDistance = RecoveryCancelOltp.getParameterInt((String)"StartDistance", (int)1);
        mWaitTimeAfterStart = RecoveryCancelOltp.getParameterInt((String)"WaitTimeAfterStart", (int)2);
        RecoveryCancelOltp.printInfo(1, "\n" + RecoveryCancelOltp.getTestClassId(), "Starting " + RecoveryCancelOltp.getTestClassId() + " Test - Version: " + sVersion + "\n");
        RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Parameter: NumberOfKillers = " + mNumberOfKillers);
        if (mNumberOfKillers == 1) {
            RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Parameter: TypeOfKilling   = " + mTypeOfKilling);
        }
        RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Parameter: NumberOfWriters = " + mNumberOfWriters);
        RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Parameter: StartDistance   = " + mStartDistance);
        RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Parameter: WaitTimeAfterStart  = " + mWaitTimeAfterStart);
        RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Parameter: TraceLevel          = " + mTraceLevel);
        RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Parameter: NoOfRecords         = " + mNoOfRecords);
        RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Parameter: NoOfCycles          = " + mNoOfCycles);
        RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Parameter: LOG_SEGMENT_SIZE    = " + mLOG_SEGMENT_SIZE);
    }

    public String executeDBMCmd(String pCmd) throws TestDatabaseException {
        String logon = "USER_LOGON DBM,DBM";
        String mHost = "";
        String mName = "";
        RecoveryCancelOltp.printInfo(5, RecoveryCancelOltp.getTestClassId(), "executeDBMCmd: " + pCmd);
        try {
            mHost = RecoveryCancelOltp.getDatabase().getHost();
            mName = RecoveryCancelOltp.getDatabase().getName();
            int mPort = RecoveryCancelOltp.getDatabase().getPort();
            if (this.mDBMan == null) {
                this.mDBMan = DBM.dbDBM((String)(mHost + ":" + mPort), (String)mName);
                this.mDBMan.cmd(logon);
            }
            return this.mDBMan.cmd(pCmd);
        }
        catch (Exception e) {
            if (this.mDBMan != null) {
                try {
                    this.mDBMan.release();
                }
                catch (RTEException rte) {
                    // empty catch block
                }
                this.mDBMan = null;
            }
            throw new TestDatabaseException(e, " DBM command: " + pCmd + ", logon String: " + logon);
        }
    }

    public String executeDBMCmd2(String pCmd) throws TestDatabaseException {
        String logon = "USER_LOGON DBM,DBM";
        String mHost = "";
        String mName = "";
        try {
            mHost = RecoveryCancelOltp.getDatabase().getHost();
            mName = RecoveryCancelOltp.getDatabase().getName();
            int mPort = RecoveryCancelOltp.getDatabase().getPort();
            if (this.mDBMan2 == null) {
                this.mDBMan2 = DBM.dbDBM((String)(mHost + ":" + mPort), (String)mName);
                this.mDBMan2.cmd(logon);
            }
            return this.mDBMan2.cmd(pCmd);
        }
        catch (Exception e) {
            if (this.mDBMan2 != null) {
                try {
                    this.mDBMan2.release();
                }
                catch (RTEException rte) {
                    // empty catch block
                }
                this.mDBMan2 = null;
            }
            throw new TestDatabaseException(e, " DBM command: " + pCmd + ", logon String: " + logon);
        }
    }

    public String executeDBMCmd3(String pCmd) throws TestDatabaseException {
        String logon = "";
        String mHost = "";
        String mName = "";
        try {
            mHost = RecoveryCancelOltp.getDatabase().getHost();
            mName = RecoveryCancelOltp.getDatabase().getName();
            int mPort = RecoveryCancelOltp.getDatabase().getPort();
            if (this.mDBMan3 == null) {
                this.mDBMan3 = DBM.dbDBM((String)(mHost + ":" + mPort), (String)mName);
                logon = "USER_LOGON DBM,DBM";
                this.mDBMan3.cmd(logon);
            }
            return this.mDBMan3.cmd(pCmd);
        }
        catch (Exception e) {
            if (this.mDBMan3 != null) {
                try {
                    this.mDBMan3.release();
                }
                catch (RTEException rte) {
                    // empty catch block
                }
                this.mDBMan3 = null;
            }
            throw new TestDatabaseException(e, " DBM command: " + pCmd + ", logon String: " + logon);
        }
    }

    public static int randomInteger(int MinValue, int MaxValue) {
        return (int)((double)mRandomGenerator.nextFloat() * (double)(MaxValue - MinValue + 1)) + MinValue;
    }

    public static void cleanUp() throws TestCaseException {
        if (mTraceLevel > 0) {
            System.out.println("End of " + RecoveryCancelOltp.getTestClassId());
        }
    }

    private static void printInfo(int Level2, String pComponent, String pInfoText) {
        if (Level2 <= mTraceLevel) {
            System.out.println(pComponent + " --> " + pInfoText);
        }
        if (Level2 < 7) {
            RecoveryCancelOltp.addGlobalMessage((String)pComponent, (char)'I', (String)pInfoText);
        } else if (mTraceLevel >= 9) {
            RecoveryCancelOltp.addGlobalMessage((String)pComponent, (char)'I', (String)pInfoText);
        }
    }

    private static boolean createConnections() {
        try {
            mMainConnection = RecoveryCancelOltp.getDatabase().connect(RecoveryCancelOltp.getUser(), RecoveryCancelOltp.getPassword());
            mMainConnection.setAutoCommit(true);
            mMainStatement = new TestStatement(null, mMainConnection);
            mConnections = new Connection[mNumberOfConcurrentUsers];
            mStatements = new TestStatement[mNumberOfConcurrentUsers];
            mPrepStatement = new TestPreparedStatement[mNumberOfConcurrentUsers];
            RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Creating " + mNumberOfConcurrentUsers + " connections!");
            for (int i = 0; i < mNumberOfConcurrentUsers; ++i) {
                RecoveryCancelOltp.mConnections[i] = RecoveryCancelOltp.getDatabase().connect(RecoveryCancelOltp.getUser(), RecoveryCancelOltp.getPassword());
                mConnections[i].setAutoCommit(false);
                RecoveryCancelOltp.mStatements[i] = new TestStatement(null, mConnections[i]);
                mConnections[i].commit();
            }
        }
        catch (Exception e) {
            RecoveryCancelOltp.addGlobalMessage((String)"createConnections", (char)'E', (String)("Error during connection creation: " + e.getMessage()));
            return false;
        }
        return true;
    }

    private void createTables(int i) throws TestCaseException, SQLException {
        try {
            this.sString = "DROP TABLE RCTAB_" + i;
            RecoveryCancelOltp.printInfo(5, RecoveryCancelOltp.getTestClassId(), this.sString);
            mMainStatement.executeUpdateIgnoreErrors(this.sString);
            this.sString = "CREATE TABLE RCTAB_" + i + " (KEY1 INTEGER, KEY2 INTEGER, VALUE_A INTEGER, VALUE_B CHAR(24), PRIMARY KEY (KEY1, KEY2))";
            RecoveryCancelOltp.printInfo(3, RecoveryCancelOltp.getTestClassId(), this.sString);
            mMainStatement.executeUpdate(this.sString);
            mMainConnection.commit();
            mMainPrepStatement = new TestPreparedStatement(null, mMainConnection, "insert RCTAB_" + i + " values (?, ?, ?, ? )");
            for (int ix = 0; ix < mNoOfRecords; ++ix) {
                mMainPrepStatement.setInt(1, ix);
                mMainPrepStatement.setInt(2, 0);
                mMainPrepStatement.setInt(3, ix);
                mMainPrepStatement.setString(4, Integer.toString(ix));
                mMainPrepStatement.addBatch();
                if (ix % 1000 != 0) continue;
                mMainPrepStatement.executeBatch();
                mMainPrepStatement.clearBatch();
            }
            mMainPrepStatement.executeBatch();
            mMainConnection.commit();
            RecoveryCancelOltp.printInfo(5, RecoveryCancelOltp.getTestClassId(), "just created RCTAB_" + i);
        }
        catch (Exception e) {
            RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Error during table creation: " + e.getMessage());
        }
    }

    private void handleException(Exception e) {
        this.handleExceptions(e);
    }

    public void startingMultipleThreads(int StartDistance) throws TestCaseException {
        try {
            boolean areWAlive;
            int i;
            long SleepTime = 500 * StartDistance;
            Writer[] WriterSet = new Writer[mNumberOfWriters + 1];
            for (i = 0; i < mNumberOfWriters; ++i) {
                RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Start Writer" + Integer.toString(i));
                WriterSet[i] = new Writer(i, i);
                Thread.sleep(SleepTime);
                if (mTraceLevel > 2) {
                    System.out.println("created writer: i = " + i);
                }
                if (mTraceLevel <= 2) continue;
                System.out.println("writer uses connection: i = " + i);
            }
            SleepTime = 60000 * mWaitTimeAfterStart;
            Thread.sleep(SleepTime);
            RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Stop all writer threads");
            for (i = 0; i < mNumberOfWriters; ++i) {
                if (WriterSet[i] != null) {
                    WriterSet[i].pleaseStop();
                }
                if (mTraceLevel <= 2) continue;
                System.out.println("asked to stop writer i = " + i + " isAlive: " + WriterSet[i].isAlive());
            }
            Thread.sleep(24000L);
            int k = 0;
            do {
                ++k;
                areWAlive = false;
                for (i = 0; i < mNumberOfWriters; ++i) {
                    if (WriterSet[i] == null) continue;
                    areWAlive |= WriterSet[i].isAlive();
                }
                Thread.sleep(200L);
                for (i = 0; i < mNumberOfWriters; ++i) {
                    if (WriterSet[i] == null || !WriterSet[i].isAlive()) continue;
                    WriterSet[i].interrupt();
                }
            } while (areWAlive && k < 100);
            if (mTraceLevel > 0) {
                System.out.println("Are writers alive? Answer: " + areWAlive);
            }
            if (areWAlive) {
                RecoveryCancelOltp.addGlobalMessage((String)"db_cons show all", (char)'T', (String)("Because not all threads are stopped, call 'db_cons show all'\n" + this.executeDBMCmd("db_cons show all")));
                throw new TestCaseException("Not all threads stopped!\n");
            }
            RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "All threads stopped...\n");
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    public long getChecksum(int user) {
        String cks = "Select sum(KEY1) from RCTAB_" + user;
        long sum = 0L;
        try {
            ResultSet rs = mMainStatement.executeQuery(cks);
            if (rs.next()) {
                sum = rs.getLong(1);
                if (mTraceLevel > 0) {
                    System.out.println("***Checksum Writer_" + user + ": " + sum);
                }
            }
        }
        catch (SQLException sqlex) {
            this.handleExceptions(sqlex);
        }
        return sum;
    }

    public void pause(String mode) {
        try {
            String state = "";
            String mode2 = "unknown";
            if (mode.equalsIgnoreCase("ADMIN")) {
                mode2 = "COLD";
            }
            if (mode.equalsIgnoreCase("ONLINE")) {
                mode2 = "WARM";
            }
            if (mTraceLevel > 0) {
                if (mode2.equalsIgnoreCase("unknown")) {
                    System.out.println("Mode: '" + mode + "' \n");
                } else {
                    System.out.println("Mode: '" + mode + "' or  '" + mode2 + "'\n");
                }
            }
            while (!state.equals(mode) && !state.equals(mode2)) {
                Thread.sleep(200L);
                state = this.executeDBMCmd("db_state").substring(6).trim().toUpperCase();
                if (mTraceLevel <= 0) continue;
                System.out.println("State: '" + state + "'");
            }
        }
        catch (Exception ex) {
            this.handleExceptions(ex);
        }
    }

    public void dbCheck() {
        String query1 = "Select (KEY1) from RCTAB_0\twhere KEY1 > (select max(key1) - 10 from rctab_0) ";
        String query2 = "Select count(KEY1) from RCTAB_0";
        try {
            ResultSet rs2;
            ResultSet rs1 = mMainStatement.executeQuery(query1);
            VerificationDataSorted veri1 = new VerificationDataSorted(rs1);
            if (mTraceLevel > 0) {
                System.out.println("***RCTAB_0 - last table entries:\n" + veri1.toString());
            }
            if ((rs2 = mMainStatement.executeQuery(query2)).next() && mTraceLevel > 0) {
                System.out.println("***RCTAB_0 - Count: " + rs2.getInt(1));
            }
        }
        catch (SQLException sqlex) {
            this.handleExceptions(sqlex);
        }
    }

    public void startingKillerThread() {
        KillerSet = new Killer[mNumberOfKillers + 1];
        try {
            for (int j = 0; j < mNumberOfKillers; ++j) {
                RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Start Killer " + Integer.toString(j));
                RecoveryCancelOltp.KillerSet[j] = new Killer(j);
                if (mTraceLevel <= 0) continue;
                System.out.println("created killer: j = " + j);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public int getConverterVersion() {
        try {
            String theCurrentDBState = this.executeDBMCmd2("db_state").substring(6).trim().toUpperCase();
            if (theCurrentDBState.equals("ADMIN") || theCurrentDBState.equals("COLD")) {
                boolean theLastStatementWasOK = true;
                int attemptCounter = 0;
                String lastErrorMessage = null;
                String temp = null;
                do {
                    try {
                        ++attemptCounter;
                        temp = this.executeDBMCmd2("db_execute get restart version");
                        theLastStatementWasOK = true;
                    }
                    catch (Exception exp) {
                        theLastStatementWasOK = false;
                        lastErrorMessage = exp.getLocalizedMessage();
                    }
                } while (!theLastStatementWasOK && attemptCounter < 11);
                if (attemptCounter == 11) {
                    this.addMessage(RecoveryCancelOltp.getTestClassId(), 'E', "getConverterVersion() after 11 attempts it was not possible to call 'db_execute get restart version'; \nlast message: " + lastErrorMessage);
                    return converterVersionNew;
                }
                BufferedReader br = new BufferedReader(new StringReader(temp));
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (!line.startsWith("CONVERTER VERSION")) continue;
                    converterVersionObj = new Integer(line.substring(line.indexOf("=") + 1).trim());
                    converterVersionNew = converterVersionObj;
                    break;
                }
                br.close();
                if (mTraceLevel > 3) {
                    System.out.println("NEW Converter Version: " + converterVersionNew);
                }
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            this.addMessage(RecoveryCancelOltp.getTestClassId(), 'E', "getConverterVersion(): NumberFormatException " + e.getLocalizedMessage());
        }
        catch (TestDatabaseException e) {
            this.addMessage(RecoveryCancelOltp.getTestClassId(), 'E', "getConverterVersion() caught an exception. \n" + e.getMessage() + "\n Used Converter Version: " + converterVersionNew);
            e.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return converterVersionNew;
    }

    public int getNumberOfLogSegments() {
        int noOfSegments = 0;
        String cmd = "backup_history_list -r last -c LABEL";
        String backup = null;
        try {
            backup = this.executeDBMCmd(cmd);
            if (backup.indexOf("LOG") != -1) {
                noOfSegments = Integer.parseInt(backup.substring(backup.length() - 5, backup.length() - 2).trim());
            }
        }
        catch (NumberFormatException e) {
            this.addMessage(RecoveryCancelOltp.getTestClassId(), 'E', "getNumberOfLogSegments() caught an exception. \n" + e.getMessage() + "\n Number of log segments: " + noOfSegments);
        }
        catch (TestDatabaseException e) {
            this.addMessage(RecoveryCancelOltp.getTestClassId(), 'E', "getNumberOfLogSegments() caught an exception. \n" + e.getMessage() + "\n Number of log segments: " + noOfSegments);
        }
        this.addMessage(RecoveryCancelOltp.getTestClassId(), 'I', "Tried to call: " + cmd + "\ngot:\n" + backup + "\nNo of Segments = " + noOfSegments);
        return noOfSegments;
    }

    public int getUsedLogPage() {
        int usedLogPage = 0;
        String tmp = "";
        try {
            boolean loop_2 = true;
            do {
                try {
                    tmp = this.executeDBMCmd("db_restartinfo");
                    loop_2 = false;
                }
                catch (TestDatabaseException e) {
                    if (mTraceLevel > 0) {
                        System.out.println("*** UsedLogPage ERROR: " + e.toString());
                    }
                    this.addMessage(RecoveryCancelOltp.getTestClassId(), 'E', "getUsedLogPage() caught an exception. \n" + e.getMessage() + " usedLogPage = " + usedLogPage);
                    if (e.toString().indexOf("-104") != -1) continue;
                    loop_2 = false;
                }
            } while (loop_2);
            int index = tmp.indexOf("First");
            Integer usedLogPageObj = new Integer(tmp.substring(index - 6, index - 1).trim());
            usedLogPage = usedLogPageObj;
            if (mTraceLevel > 0) {
                System.out.println("UsedLogPage: " + usedLogPage);
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return usedLogPage;
    }

    public int getLogSegmentForRecovery(int usedLogPage) {
        Vector<Integer> lowerBound = new Vector<Integer>();
        Vector<Integer> upperBound = new Vector<Integer>();
        int LogSegmentForRecovery = 0;
        try {
            StringTokenizer hack = new StringTokenizer(this.executeDBMCmd("backup_history_list -r last -c LABEL,FIRSTLOG,LASTLOG"), "|");
            int a = 1;
            while (hack.hasMoreElements()) {
                if (++a < 6) {
                    hack.nextElement();
                    continue;
                }
                Integer int_1 = new Integer(hack.nextElement().toString().trim());
                Integer int_2 = new Integer(hack.nextElement().toString().trim());
                if (mTraceLevel > 0) {
                    System.out.println(int_1);
                }
                if (mTraceLevel > 0) {
                    System.out.println(int_2);
                }
                lowerBound.add(int_1);
                upperBound.add(int_2);
                if (mTraceLevel <= 0) continue;
                System.out.println(hack.nextElement().toString().trim());
            }
            int endOfLoop = this.getNumberOfLogSegments();
            for (int i = 0; i < endOfLoop; ++i) {
                if (usedLogPage > (Integer)lowerBound.elementAt(i) && usedLogPage < (Integer)upperBound.elementAt(i)) {
                    LogSegmentForRecovery = i + 1;
                    break;
                }
                if (usedLogPage == (Integer)lowerBound.elementAt(i) || usedLogPage == (Integer)upperBound.elementAt(i)) {
                    LogSegmentForRecovery = i + 1;
                    break;
                }
                if (usedLogPage < 0) {
                    if (mTraceLevel > 0) {
                        System.out.println("IMPOSSIBLE");
                    }
                    break;
                }
                if (usedLogPage > (Integer)upperBound.elementAt(i)) {
                    if (mTraceLevel <= 0) continue;
                    System.out.println("continue");
                    continue;
                }
                if (usedLogPage < (Integer)lowerBound.elementAt(i) && (Integer)lowerBound.elementAt(i) != 0) {
                    LogSegmentForRecovery = i;
                    break;
                }
                if (mTraceLevel > 0) {
                    System.out.println("Lower: " + (Integer)lowerBound.elementAt(i));
                }
                if (mTraceLevel <= 0) continue;
                System.out.println("Upper: " + (Integer)upperBound.elementAt(i));
            }
        }
        catch (NumberFormatException e) {
            this.addMessage(RecoveryCancelOltp.getTestClassId(), 'E', "getLogSegmentForRecovery() caught an exception. \n" + e.getMessage() + " LogSegmentForRecovery = " + LogSegmentForRecovery);
            e.printStackTrace();
        }
        catch (TestDatabaseException e) {
            this.addMessage(RecoveryCancelOltp.getTestClassId(), 'E', "getLogSegmentForRecovery() caught an exception. \n" + e.getMessage() + " LogSegmentForRecovery = " + LogSegmentForRecovery);
            e.printStackTrace();
        }
        return LogSegmentForRecovery;
    }

    public String getRecoveryString(int number) {
        String recoveryString = "";
        if (number > 0 && number < 10) {
            recoveryString = "00" + number;
        } else if (number >= 10 && number < 100) {
            recoveryString = "0" + number;
        } else if (number >= 100) {
            recoveryString = "" + number;
        } else if (number == 0) {
            if (mTraceLevel > 0) {
                System.out.println("getRecoveryString impossible ---> number = " + number);
            }
            recoveryString = "";
        }
        return recoveryString;
    }

    public static long getTimeout() {
        return 1800000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block121: {
            int i6;
            block110: {
                this.setStatus("createConnections");
                RecoveryCancelOltp.createConnections();
                if (mLOG_SEGMENT_SIZE != 1666) {
                    if (mTraceLevel > 2) {
                        System.out.println("Put LOG_SEGMENT_SIZE: " + mLOG_SEGMENT_SIZE + "\n");
                    }
                    this.executeDBMCmd("param_directput LOG_SEGMENT_SIZE " + mLOG_SEGMENT_SIZE);
                    this.executeDBMCmd("db_offline");
                }
                this.executeDBMCmd("db_warm");
                this.executeDBMCmd("autosave_off");
                this.setStatus("createBackupMedia");
                this.executeDBMCmd("util_connect");
                this.executeDBMCmd("backup_media_put recancelauto recancelauto FILE AUTO");
                this.executeDBMCmd("backup_media_put recanceldat recanceldat FILE DATA 0 8 YES NO ");
                this.executeDBMCmd("util_release");
                this.setStatus("backup DATA");
                RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Backup data");
                this.executeDBMCmd("util_connect");
                this.executeDBMCmd("backup_save recanceldat DATA");
                this.executeDBMCmd("util_release");
                this.executeDBMCmd("util_connect");
                this.executeDBMCmd("autosave_on");
                this.executeDBMCmd("util_release");
                this.setStatus("createTables + DBProcs");
                for (int i2 = 0; i2 < mNumberOfWriters; ++i2) {
                    this.createTables(i2);
                }
                this.setStatus("backup DATA");
                RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Backup data");
                this.executeDBMCmd("util_connect");
                this.executeDBMCmd("backup_save recanceldat DATA");
                this.executeDBMCmd("util_release");
                this.setStatus("Multi Users on DB");
                TestDatabase mTestDatabase = RecoveryCancelOltp.getDatabase();
                TestDatabaseSap sapdb = null;
                if (mTestDatabase.isSap()) {
                    sapdb = (TestDatabaseSap)mTestDatabase;
                }
                if (TestDriver.compareRelease((String)(sapdb.getKernelVersion() + "." + sapdb.getKernelBuild().substring(0, 3)), (String)">=", (String)"7.6.0.15")) {
                    queueCountChangerThread = new QueueCountChanger();
                    this.startingMultipleThreads(mStartDistance);
                    if (queueCountChangerThread.isAlive()) {
                        queueCountChangerThread.pleaseStop();
                        Thread.sleep(5000L);
                        if (queueCountChangerThread.isAlive()) {
                            queueCountChangerThread.pleaseStop();
                            Thread.sleep(5000L);
                            if (queueCountChangerThread.isAlive()) {
                                queueCountChangerThread.pleaseStop();
                                Thread.sleep(5000L);
                                if (queueCountChangerThread.isAlive()) {
                                    queueCountChangerThread.pleaseStop();
                                    Thread.sleep(5000L);
                                    if (queueCountChangerThread.isAlive()) {
                                        queueCountChangerThread.pleaseStop();
                                        Thread.sleep(5000L);
                                        if (queueCountChangerThread.isAlive()) {
                                            queueCountChangerThread.pleaseStop();
                                            Thread.sleep(5000L);
                                            if (queueCountChangerThread.isAlive()) {
                                                queueCountChangerThread.pleaseStop();
                                                Thread.sleep(5000L);
                                                if (queueCountChangerThread.isAlive()) {
                                                    queueCountChangerThread.pleaseStop();
                                                    Thread.sleep(5000L);
                                                    if (queueCountChangerThread.isAlive()) {
                                                        queueCountChangerThread.pleaseStop();
                                                        Thread.sleep(5000L);
                                                        if (queueCountChangerThread.isAlive()) {
                                                            queueCountChangerThread.pleaseStop();
                                                            Thread.sleep(5000L);
                                                            if (queueCountChangerThread.isAlive()) {
                                                                queueCountChangerThread.pleaseStop();
                                                                Thread.sleep(5000L);
                                                                if (queueCountChangerThread.isAlive()) {
                                                                    queueCountChangerThread.pleaseStop();
                                                                    Thread.sleep(5000L);
                                                                    if (queueCountChangerThread.isAlive()) {
                                                                        queueCountChangerThread.pleaseStop();
                                                                        Thread.sleep(5000L);
                                                                        if (queueCountChangerThread.isAlive()) {
                                                                            queueCountChangerThread.pleaseStop();
                                                                            Thread.sleep(5000L);
                                                                            queueCountChangerThread.interrupt();
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                } else {
                    this.startingMultipleThreads(mStartDistance);
                }
                if (this.globalError) {
                    throw new TestCaseException("An global error after startingMultipleThreads is occured.\nDescription: " + this.globalErrorText);
                }
                this.executeDBMCmd("util_connect");
                this.executeDBMCmd("autosave_off");
                this.executeDBMCmd("backup_start recancelauto");
                this.executeDBMCmd("autosave_on");
                this.executeDBMCmd("util_release");
                long[] check_1 = new long[mNumberOfWriters];
                for (int i3 = 0; i3 < mNumberOfWriters; ++i3) {
                    check_1[i3] = this.getChecksum(i3);
                }
                this.dbCheck();
                String query = "Select (KEY1) from RCTAB_0";
                ResultSet rs1 = mMainStatement.executeQuery(query);
                VerificationDataComplete v1 = new VerificationDataComplete(rs1);
                this.setStatus("Restart Database");
                RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Restart with init-config and backup_restore");
                this.executeDBMCmd("autosave_off");
                this.executeDBMCmd("db_offline");
                this.executeDBMCmd("db_cold -" + this.mKernelMode);
                this.executeDBMCmd("util_connect");
                this.executeDBMCmd("backup_start recancelauto");
                RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "db_activate RECOVER recanceldat DATA");
                String actualCommand = "";
                if (TestDriver.compareRelease((String)(sapdb.getKernelVersion() + "." + sapdb.getKernelBuild().substring(0, 3)), (String)">=", (String)"7.4.4.1")) {
                    actualCommand = "db_activate RECOVER recanceldat DATA";
                    this.executeDBMCmd(actualCommand);
                } else {
                    actualCommand = "util_execute INIT CONFIG";
                    this.executeDBMCmd(actualCommand);
                    actualCommand = "backup_restore recanceldat DATA";
                    this.executeDBMCmd(actualCommand);
                }
                if (mTraceLevel > 2) {
                    System.out.println("Result from backup_history_list (short): " + this.executeDBMCmd("backup_history_list -r last -c LABEL"));
                }
                int NumberOfLogSegments = 0;
                NumberOfLogSegments = this.getNumberOfLogSegments();
                if (mTraceLevel > 2) {
                    System.out.println("Number of LogSegments: " + NumberOfLogSegments);
                }
                converterVersionStart = this.getConverterVersion();
                killing = false;
                noFullRecovery = true;
                boolean firstTime = true;
                int usedLogPageForException = 0;
                recoveryAborted = 0;
                this.startingKillerThread();
                if (NumberOfLogSegments > 0) {
                    while (noFullRecovery) {
                        try {
                            for (int i4 = 1; i4 <= NumberOfLogSegments; ++i4) {
                                if (mNumberOfKillers == 1 && !killing) {
                                    if (firstTime) {
                                        if (NumberOfLogSegments > 1) {
                                            i4 = 2;
                                        }
                                        firstTime = false;
                                        RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "recover_start recancelauto 001");
                                        this.executeDBMCmd("recover_start recancelauto 001");
                                        recoveryAborted = 0;
                                    }
                                    if (NumberOfLogSegments > 1) {
                                        RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "recover_replace recancelauto " + this.getRecoveryString(i4).trim());
                                        this.executeDBMCmd("recover_replace recancelauto recancelauto " + this.getRecoveryString(i4).trim());
                                        recoveryAborted = 0;
                                    }
                                }
                                if (mNumberOfKillers == 1 && killing) {
                                    boolean loop = true;
                                    do {
                                        try {
                                            this.executeDBMCmd("util_connect");
                                            loop = false;
                                        }
                                        catch (Exception e) {
                                            if (e.toString().indexOf("-24992") != -1) continue;
                                            loop = false;
                                        }
                                    } while (loop);
                                    int usedLogPage = this.getUsedLogPage();
                                    usedLogPageForException = i4 = this.getLogSegmentForRecovery(usedLogPage);
                                    RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "recover_start " + this.getRecoveryString(i4).trim());
                                    this.executeDBMCmd("recover_start recancelauto " + this.getRecoveryString(i4).trim());
                                    recoveryAborted = 0;
                                    killing = false;
                                }
                                if (mNumberOfKillers == 0) {
                                    if (i4 == 1) {
                                        if (NumberOfLogSegments > 1) {
                                            i4 = 2;
                                        }
                                        RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "recover_start recancelauto 001");
                                        this.executeDBMCmd("recover_start recancelauto 001");
                                        RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "recover_cancel");
                                        this.executeDBMCmd("recover_cancel");
                                        this.pause("OFFLINE");
                                        this.executeDBMCmd("db_cold -" + this.mKernelMode);
                                        this.pause("ADMIN");
                                        if (mTraceLevel > 2) {
                                            System.out.println("Result from db_restartinfo: " + this.executeDBMCmd("db_restartinfo"));
                                        }
                                        this.executeDBMCmd("util_connect");
                                        RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "recover_start recancelauto 001");
                                        String rtcd = this.executeDBMCmd("recover_start recancelauto 001");
                                        if (mTraceLevel > 2) {
                                            System.out.println(rtcd);
                                        }
                                    }
                                    if (NumberOfLogSegments > 1) {
                                        RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "recover_replace recancelauto " + this.getRecoveryString(i4).trim());
                                        this.executeDBMCmd("recover_replace recancelauto recancelauto " + this.getRecoveryString(i4).trim());
                                        RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "recover_cancel");
                                        this.executeDBMCmd("recover_cancel");
                                        this.pause("OFFLINE");
                                        this.executeDBMCmd("db_cold -" + this.mKernelMode);
                                        this.pause("ADMIN");
                                        if (mTraceLevel > 2) {
                                            System.out.println("Result from db_restartinfo: " + this.executeDBMCmd("db_restartinfo"));
                                        }
                                        this.executeDBMCmd("util_connect");
                                        RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "recover_start " + this.getRecoveryString(i4).trim());
                                        this.executeDBMCmd("recover_start recancelauto " + this.getRecoveryString(i4).trim());
                                    }
                                }
                                if (i4 != NumberOfLogSegments) continue;
                                noFullRecovery = false;
                                if (mTraceLevel > 2) {
                                    System.out.println("***ENDE***");
                                }
                                for (int j = 0; j < mNumberOfKillers; ++j) {
                                    if (KillerSet[j] != null) {
                                        KillerSet[j].pleaseStop();
                                        Thread.sleep(3000L);
                                        KillerSet[j].interrupt();
                                    }
                                    if (mTraceLevel <= 2) continue;
                                    System.out.println("asked to stop killer: j = " + j + " Status: " + KillerSet[j].isAlive() + "\n");
                                }
                            }
                        }
                        catch (Exception ex) {
                            if (mTypeOfKilling.equals("db_stop") && !killing) {
                                if (++recoveryAborted >= 4) {
                                    throw new Exception("Exception: \nlocalized Message: \t " + ex.getLocalizedMessage() + ex.getMessage());
                                }
                                while (!killing) {
                                    Thread.sleep(1L);
                                }
                            }
                            if (mTypeOfKilling.equals("cancel") && !killing) {
                                if (++recoveryAborted >= 4) {
                                    throw new Exception("Exception: \nlocalized Message: \t " + ex.getLocalizedMessage() + ex.getMessage());
                                }
                                while (!killing) {
                                    Thread.sleep(1L);
                                }
                            }
                            if (mTypeOfKilling.equals("db_stop") && killing) {
                                if (++recoveryAborted >= 4) {
                                    throw new Exception("Exception: \nlocalized Message: \t " + ex.getLocalizedMessage() + ex.getMessage());
                                }
                                if (mTraceLevel > 1) {
                                    System.out.println("DB_STOP Exception");
                                }
                                this.pause("OFFLINE");
                                if (mTraceLevel > 1) {
                                    System.out.println("db_cold -" + this.mKernelMode);
                                }
                                this.executeDBMCmd("db_cold -" + this.mKernelMode);
                                this.pause("ADMIN");
                            }
                            if (mTypeOfKilling.equals("cancel") && killing) {
                                if (++recoveryAborted >= 4) {
                                    throw new Exception("Exception: \nlocalized Message: \t " + ex.getLocalizedMessage() + ex.getMessage());
                                }
                                if (ex.toString().indexOf("-24992") != -1) {
                                    this.executeDBMCmd("util_connect");
                                    this.executeDBMCmd("recover_start recancelauto " + this.getRecoveryString(usedLogPageForException).trim());
                                    killing = false;
                                }
                                if (mTraceLevel > 1) {
                                    System.out.println("CANCEL Exception");
                                }
                                this.pause("OFFLINE");
                                if (mTraceLevel > 1) {
                                    System.out.println("db_cold -" + this.mKernelMode);
                                }
                                this.executeDBMCmd("db_cold -" + this.mKernelMode);
                                this.pause("ADMIN");
                            }
                            if (mNumberOfKillers != 0) continue;
                            noFullRecovery = false;
                            if (mTraceLevel <= 0) continue;
                            System.out.println("Exception: \nlocalized Message: \t " + ex.getLocalizedMessage() + ex.getMessage());
                        }
                    }
                }
                Thread.sleep(2000L);
                this.executeDBMCmd("recover_ignore");
                RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "recover_replace recancelauto 00* done");
                if (mTraceLevel > 1) {
                    System.out.println("State: '" + this.executeDBMCmd("db_state").substring(6).trim() + "'");
                }
                long[] check_2 = new long[mNumberOfWriters];
                for (int i5 = 0; i5 < mNumberOfWriters; ++i5) {
                    check_2[i5] = this.getChecksum(i5);
                }
                for (int user = 0; user < mNumberOfWriters; ++user) {
                    if (check_1[user] == check_2[user]) {
                        if (mTraceLevel <= 0) continue;
                        System.out.println("***Writer_" + user + ": Recovery was successful***");
                        continue;
                    }
                    if (mTraceLevel <= 0) continue;
                    System.out.println("***Writer_" + user + ": Recovery FAILED***");
                }
                this.dbCheck();
                ResultSet rs2 = mMainStatement.executeQuery(query);
                System.out.println("check the reference data");
                VerificationDataComplete v2 = new VerificationDataComplete(rs2);
                if (v1.equals((VerificationData)v2)) break block110;
                System.out.println("Error 'expected data not found. -> " + v1.getErrorMessage());
                this.addMessage(RecoveryCancelOltp.getTestClassId(), 'E', "Expected result does not equal given result!\n" + v1.getErrorMessage());
            }
            Object var15_25 = null;
            try {
                RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Closing all statements!");
                mMainStatement.close();
                Thread.sleep(1000L);
                for (i6 = 0; i6 < mNumberOfConcurrentUsers; ++i6) {
                    mStatements[i6].close();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Closing all connections!");
                mMainConnection.commit();
                mMainConnection.close();
                for (i6 = 0; i6 < mNumberOfConcurrentUsers; ++i6) {
                    mConnections[i6].commit();
                    mConnections[i6].close();
                }
            }
            catch (Exception e3) {
                // empty catch block
            }
            RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Closing all opened dbm server connections!");
            if (this.mDBMan != null) {
                try {
                    this.mDBMan.release();
                }
                catch (RTEException rte) {
                    // empty catch block
                }
                this.mDBMan = null;
            }
            if (this.mDBMan2 != null) {
                try {
                    this.mDBMan2.release();
                }
                catch (RTEException rte) {
                    // empty catch block
                }
                this.mDBMan2 = null;
            }
            if (this.mDBMan3 != null) {
                try {
                    this.mDBMan3.release();
                }
                catch (RTEException rte) {
                    // empty catch block
                }
                this.mDBMan3 = null;
            }
            if (mTraceLevel > 0) {
                System.out.println("Game Over");
            }
            break block121;
            {
                catch (Exception e) {
                    testIsInterrupted = true;
                    this.handleExceptions(e);
                    Object var15_26 = null;
                    try {
                        RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Closing all statements!");
                        mMainStatement.close();
                        Thread.sleep(1000L);
                        for (int i6 = 0; i6 < mNumberOfConcurrentUsers; ++i6) {
                            mStatements[i6].close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    try {
                        RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Closing all connections!");
                        mMainConnection.commit();
                        mMainConnection.close();
                        for (int i7 = 0; i7 < mNumberOfConcurrentUsers; ++i7) {
                            mConnections[i7].commit();
                            mConnections[i7].close();
                        }
                    }
                    catch (Exception e3) {
                        // empty catch block
                    }
                    RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Closing all opened dbm server connections!");
                    if (this.mDBMan != null) {
                        try {
                            this.mDBMan.release();
                        }
                        catch (RTEException rte) {
                            // empty catch block
                        }
                        this.mDBMan = null;
                    }
                    if (this.mDBMan2 != null) {
                        try {
                            this.mDBMan2.release();
                        }
                        catch (RTEException rte) {
                            // empty catch block
                        }
                        this.mDBMan2 = null;
                    }
                    if (this.mDBMan3 != null) {
                        try {
                            this.mDBMan3.release();
                        }
                        catch (RTEException rte) {
                            // empty catch block
                        }
                        this.mDBMan3 = null;
                    }
                    if (mTraceLevel > 0) {
                        System.out.println("Game Over");
                    }
                }
            }
            catch (Throwable throwable) {
                Object var15_27 = null;
                try {
                    RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Closing all statements!");
                    mMainStatement.close();
                    Thread.sleep(1000L);
                    for (int i6 = 0; i6 < mNumberOfConcurrentUsers; ++i6) {
                        mStatements[i6].close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Closing all connections!");
                    mMainConnection.commit();
                    mMainConnection.close();
                    for (int i7 = 0; i7 < mNumberOfConcurrentUsers; ++i7) {
                        mConnections[i7].commit();
                        mConnections[i7].close();
                    }
                }
                catch (Exception e3) {
                    // empty catch block
                }
                RecoveryCancelOltp.printInfo(2, RecoveryCancelOltp.getTestClassId(), "Closing all opened dbm server connections!");
                if (this.mDBMan != null) {
                    try {
                        this.mDBMan.release();
                    }
                    catch (RTEException rte) {
                        // empty catch block
                    }
                    this.mDBMan = null;
                }
                if (this.mDBMan2 != null) {
                    try {
                        this.mDBMan2.release();
                    }
                    catch (RTEException rte) {
                        // empty catch block
                    }
                    this.mDBMan2 = null;
                }
                if (this.mDBMan3 != null) {
                    try {
                        this.mDBMan3.release();
                    }
                    catch (RTEException rte) {
                        // empty catch block
                    }
                    this.mDBMan3 = null;
                }
                if (mTraceLevel > 0) {
                    System.out.println("Game Over");
                }
                throw throwable;
            }
        }
    }

    static {
        mRandomGenerator = new Random();
        testIsInterrupted = false;
    }

    class Killer
    extends OLTPTestActor {
        boolean keepRunning = true;
        String nameR;
        int numberR;
        int tmpConVers;

        Killer(int killerNo) {
            this.nameR = "Killer " + killerNo;
            this.numberR = killerNo;
            this.tmpConVers = 0;
            if (mTraceLevel > 0) {
                System.out.println(this.nameR + " constucted!");
            }
            this.start();
            RecoveryCancelOltp.printInfo(5, RecoveryCancelOltp.getTestClassId(), this.nameR + " just started!");
        }

        public void check() {
            if (mTraceLevel > 0) {
                System.out.println("in check");
            }
        }

        public void run() {
            try {
                while (this.keepRunning && !testIsInterrupted) {
                    Killer.sleep(1000L);
                    if (!noFullRecovery) {
                        this.keepRunning = false;
                    }
                    if (!killing) {
                        this.tmpConVers = RecoveryCancelOltp.this.getConverterVersion();
                    }
                    if (this.tmpConVers <= converterVersionStart) continue;
                    this.executeKillingOps(this.numberR);
                    this.keepRunning = true;
                    converterVersionStart = this.tmpConVers;
                }
                if (testIsInterrupted) {
                    System.out.println("Killer interrupted by main test in run() - method.");
                }
            }
            catch (Exception e) {
                if (mTraceLevel > 0) {
                    System.out.println("Exception: \nlocalized Message: \t " + e.getLocalizedMessage() + e.getMessage());
                    e.printStackTrace();
                }
                RecoveryCancelOltp.this.handleException(e);
                RecoveryCancelOltp.addGlobalMessage((String)RecoveryCancelOltp.getTestClassId(), (char)'E', (String)("Killer caught an exception and stopped.\nMessage: " + e.getMessage()));
            }
        }

        public void pleaseStop() {
            if (mTraceLevel > 0) {
                System.out.println(this.nameR + ": Asking killer thread to please stop!");
            }
            this.keepRunning = false;
        }

        private void executeKillingOps(int user) throws TestCaseException {
            block11: {
                try {
                    while (this.keepRunning && !testIsInterrupted) {
                        if (mTypeOfKilling.equals("db_stop")) {
                            RecoveryCancelOltp.this.executeDBMCmd2("db_stop");
                            if (mTraceLevel > 0) {
                                System.out.println("DB_STOP by Killer");
                            }
                            killing = true;
                            if (mTraceLevel > 0) {
                                System.out.println("killing: " + killing);
                            }
                        } else if (mTypeOfKilling.equals("cancel")) {
                            RecoveryCancelOltp.this.executeDBMCmd2("db_cons cancel t4");
                            if (mTraceLevel > 0) {
                                System.out.println("Cancel by Killer");
                            }
                            Killer.sleep(1000L);
                            killing = true;
                            if (mTraceLevel > 0) {
                                System.out.println("killing: " + killing);
                            }
                        }
                        this.keepRunning = false;
                    }
                    if (testIsInterrupted) {
                        System.out.println("Killer interrupted by main test in executeKillingOps(" + user + ").");
                    }
                }
                catch (Exception e) {
                    if (mTraceLevel <= 0) break block11;
                    System.out.println("Exception: \nlocalized Message: \t " + e.getLocalizedMessage() + e.getMessage());
                }
            }
        }
    }

    class QueueCountChanger
    extends OLTPTestActor {
        boolean keepRunning = true;
        String nameR = "QueueCntChanger ";

        QueueCountChanger() {
            if (mTraceLevel > 0) {
                System.out.println(this.nameR + " constucted!");
            }
            this.start();
            RecoveryCancelOltp.printInfo(5, RecoveryCancelOltp.getTestClassId(), this.nameR + " just started!");
        }

        public void check() {
            if (mTraceLevel > 0) {
                System.out.println("in check");
            }
        }

        public void run() {
            int queueCount = 1;
            try {
                String sMaxCPU = RecoveryCancelOltp.this.executeDBMCmd3("param_directget MAXCPU");
                sMaxCPU = sMaxCPU.substring(7, 8);
                int iMaxCPU = RecoveryCancelOltp.this.string2number(sMaxCPU);
                while (this.keepRunning && !testIsInterrupted) {
                    Thread.sleep(500L);
                    String theCurrentDBState = RecoveryCancelOltp.this.executeDBMCmd3("db_state").substring(6).trim().toUpperCase();
                    if (!theCurrentDBState.equals("ONLINE") && !theCurrentDBState.equals("WARM")) continue;
                    RecoveryCancelOltp.this.executeDBMCmd3("param_put -running -permanent LOG_QUEUE_COUNT " + queueCount);
                    if (++queueCount <= iMaxCPU) continue;
                    queueCount = 0;
                }
                RecoveryCancelOltp.printInfo(5, RecoveryCancelOltp.getTestClassId(), "Exiting QueueCountChanger");
                if (testIsInterrupted) {
                    System.out.println("QueueCountChanger interrupted by main test in run() - method.");
                }
            }
            catch (Exception e) {
                if (mTraceLevel > 0) {
                    System.out.println("+++++++++++++++++++++Exception: \nlocalized Message: \t " + e.getLocalizedMessage() + e.getMessage());
                }
                if (e instanceof InterruptedException) {
                    RecoveryCancelOltp.addGlobalMessage((String)RecoveryCancelOltp.getTestClassId(), (char)'W', (String)("QueueCountChanger caught an InterruptedException and stopped.\nMessage: " + e.getMessage()));
                }
                RecoveryCancelOltp.addGlobalMessage((String)RecoveryCancelOltp.getTestClassId(), (char)'E', (String)("QueueCountChanger caught an exception and stopped.\nMessage: " + e.getMessage()));
            }
        }

        public void pleaseStop() {
            if (mTraceLevel > 0) {
                System.out.println(this.nameR + ": Asking QueueCountChanger thread to please stop!");
            }
            RecoveryCancelOltp.printInfo(5, RecoveryCancelOltp.getTestClassId(), this.nameR + " please stop!");
            this.keepRunning = false;
        }
    }

    class Writer
    extends OLTPTestActor {
        boolean keepRunning = true;
        String nameW;
        int numberW;
        int StmtCount;
        int connectionW;

        Writer(int writerNo, int conNo) {
            this.nameW = "Writer" + writerNo;
            this.numberW = writerNo;
            this.connectionW = conNo;
            this.StmtCount = 0;
            this.start();
            RecoveryCancelOltp.printInfo(5, RecoveryCancelOltp.getTestClassId(), this.nameW + " just started!");
        }

        public void check() {
            if (mTraceLevel > 0) {
                System.out.println("does not check anything yet");
            }
        }

        public void run() {
            try {
                Connection con = mConnections[this.connectionW];
                RecoveryCancelOltp.printInfo(5, RecoveryCancelOltp.getTestClassId(), this.nameW + " uses Connection number " + this.connectionW);
                while (this.keepRunning && !RecoveryCancelOltp.this.globalError) {
                    ++this.StmtCount;
                    this.executeWritingOps(con, this.numberW);
                    Thread.sleep(50L);
                }
            }
            catch (Exception e) {
                if (mTraceLevel > 0) {
                    System.out.println("Exception: \nlocalized Message: \t " + e.getLocalizedMessage() + e.getMessage());
                }
                RecoveryCancelOltp.this.handleException(e);
            }
        }

        public void pleaseStop() {
            if (mTraceLevel > 0) {
                System.out.println(this.nameW + ": Asking thread '" + this.nameW + "' to please stop!");
            }
            this.keepRunning = false;
        }

        private void executeWritingOps(Connection pConnection, int user) throws TestCaseException {
            int CurrentCycle = 0;
            int maxValue = 0;
            this.mRunning = true;
            try {
                while (this.keepRunning && !RecoveryCancelOltp.this.globalError) {
                    if (CurrentCycle % 50 == 0 && mTraceLevel > 0) {
                        System.out.println(this.nameW + " - CurrentCycle:" + CurrentCycle);
                    }
                    String sql = "SELECT MAX(KEY1) AS largestKey FROM RCTAB_" + user;
                    ResultSet rs = mStatements[user].executeQuery(sql);
                    if (rs.next()) {
                        maxValue = rs.getInt("largestKey");
                    }
                    mPrepStatement[user] = new TestPreparedStatement(null, pConnection, "insert RCTAB_" + user + " (key1, key2, value_a, value_b) values (?, ?, ?, ? )");
                    for (int ix = maxValue + 1; ix <= mNoOfRecords + maxValue; ++ix) {
                        mPrepStatement[user].setInt(1, ix);
                        mPrepStatement[user].setInt(2, 0);
                        mPrepStatement[user].setInt(3, ix);
                        mPrepStatement[user].setString(4, Integer.toString(ix));
                        mPrepStatement[user].addBatch();
                        if (ix % 1000 != 0) continue;
                        mPrepStatement[user].executeBatch();
                        mPrepStatement[user].clearBatch();
                    }
                    mPrepStatement[user].executeBatch();
                    pConnection.commit();
                    sql = "delete from rctab_" + user + " where key1 > (select max(key1) - 10 from rctab_" + user + ") ";
                    mStatements[user].executeUpdate(sql);
                    mConnections[user].commit();
                    sql = "update rctab_" + user + " set VALUE_B = 'Test' where key1 > (select max(key1) - 10 from rctab_" + user + ")";
                    mStatements[user].executeUpdate(sql);
                    mConnections[user].commit();
                    if (CurrentCycle < 11) {
                        sql = "alter table rctab_" + user + " add COL_" + CurrentCycle + " CHAR(10) default null";
                        mStatements[user].executeUpdate(sql);
                        mConnections[user].commit();
                    }
                    Writer.sleep(25L);
                    if (mNoOfCycles != -1 && ++CurrentCycle > mNoOfCycles) {
                        if (mTraceLevel > 0) {
                            System.out.println(this.nameW + ": Finished <" + (CurrentCycle - 1) + "> cycles");
                        }
                        this.keepRunning = false;
                        this.setStatus(1);
                    }
                    if (!this.mShouldStop) continue;
                    if (mTraceLevel > 0) {
                        System.out.println(this.nameW + ": Soft interrupted at " + (CurrentCycle - 1) + " cycles");
                    }
                    this.keepRunning = false;
                    this.setStatus(2, "Interrupted by master thread at " + (CurrentCycle - 1) + " cycles");
                }
            }
            catch (InterruptedException e) {
                if (mTraceLevel > 0) {
                    System.out.println(this.nameW + ": Hard interrupted");
                }
                e.printStackTrace();
                this.setStatus(2);
                RecoveryCancelOltp.this.globalError = true;
                RecoveryCancelOltp.this.globalErrorText = this.nameW + ": hard interrupted -> " + e.getMessage();
            }
            catch (Exception e) {
                RecoveryCancelOltp.this.globalError = true;
                if (mTraceLevel > 0) {
                    System.out.println(this.nameW + ": ** ERROR **  General exception: " + e.getMessage());
                }
                e.printStackTrace();
                this.setStatus(-3, "Exception: " + e.getMessage());
                RecoveryCancelOltp.this.globalErrorText = "During executeWritingOps an general exception occured for " + this.nameW + "; please look into knldiag and test protocol.";
            }
        }
    }
}

