/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.lock;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestPreparedStatement;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;

public class LockList1
extends TestCase {
    static final String TIME_OUT = "TimeOut";
    static final String NUMBER_OF_TRANSACTIONS = "NumberOfTransactions";
    static final String SLEEP_TIME = "SleepTime";
    static final String WATCH_TIME = "WatchTime";
    static final String DISPLAY_LOCKS = "DisplayLocks";
    static final String COMMIT_RATE = "CommitRate";
    static final String SLEEP_RATE = "SleepRate";
    static final String CONCURRENT_RATE = "ConcurrentRate";
    static boolean sDevTrace = false;
    private static String sUser = "BERLIN";
    private static String sPassword = "BERLIN";
    static long sLockCounter = 0L;
    private static Properties sTestParameter = null;
    private static Properties sDbParameter = null;
    private List mWatchListUser = null;
    private Map mWatchListRequest = null;

    static {
        sTestParameter = new Properties();
        sDbParameter = new Properties();
    }

    private String getDate() {
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy hh:mm:ss");
        Date date = new Date(System.currentTimeMillis());
        return df.format(date);
    }

    public static String getTestClassId() {
        return "LockList1";
    }

    private void handleException(Exception e) {
        this.handleExceptions(e);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void prepare() throws TestCaseException {
        Connection con = null;
        TestStatement stmt = null;
        TestPreparedStatement pstmt = null;
        try {
            try {
                con = TestCase.getDatabase().connect(TestCase.getUser(), TestCase.getPassword());
                stmt = new TestStatement(null, con);
                stmt.enableExceptions(false);
                stmt.executeUpdate("Drop user " + sUser);
                stmt.enableExceptions(true);
                stmt.executeUpdate("Create user " + sUser + " password " + sPassword + " resource not exclusive");
                stmt.close();
                con.close();
                con = TestCase.getDatabase().connect(sUser, sPassword);
                stmt = new TestStatement(null, con);
                stmt.enableExceptions(false);
                stmt.executeUpdate("DROP TABLE LOCKTEST");
                stmt.enableExceptions(true);
                stmt.executeUpdate("CREATE TABLE LOCKTEST (S0 VARCHAR(5) KEY)");
                pstmt = new TestPreparedStatement(null, con, "LOCK ROW LOCKTEST KEY S0 = ? IN EXCLUSIVE MODE");
                int i = 0;
                while (true) {
                    block13: {
                        String timeout;
                        String maxuser;
                        String maxlocks;
                        if (i < 100) break block13;
                        LockList1.setTestParameter(TIME_OUT, TestCase.getParameterString((String)TIME_OUT, (String)"900"));
                        LockList1.setTestParameter(NUMBER_OF_TRANSACTIONS, TestCase.getParameterString((String)NUMBER_OF_TRANSACTIONS, (String)"5"));
                        LockList1.setTestParameter(WATCH_TIME, TestCase.getParameterString((String)WATCH_TIME, (String)"30"));
                        LockList1.setTestParameter(SLEEP_TIME, TestCase.getParameterString((String)SLEEP_TIME, (String)"60"));
                        LockList1.setTestParameter(DISPLAY_LOCKS, TestCase.getParameterString((String)DISPLAY_LOCKS, (String)"1000"));
                        LockList1.setTestParameter(COMMIT_RATE, TestCase.getParameterString((String)COMMIT_RATE, (String)"1000"));
                        LockList1.setTestParameter(SLEEP_RATE, TestCase.getParameterString((String)SLEEP_RATE, (String)"50"));
                        LockList1.setTestParameter(CONCURRENT_RATE, TestCase.getParameterString((String)CONCURRENT_RATE, (String)"50"));
                        String maxcpu = TestCase.getParameterString((String)"MAXCPU", (String)"");
                        if (maxcpu != null && maxcpu.length() != 0) {
                            LockList1.setDbParameter("MAXCPU", maxcpu);
                        }
                        if ((maxlocks = TestCase.getParameterString((String)"MAXLOCKS", (String)"")) != null && maxlocks.length() != 0) {
                            LockList1.setDbParameter("MAXLOCKS", maxlocks);
                        }
                        if ((maxuser = TestCase.getParameterString((String)"MAXUSERTASKS", (String)"")) != null && maxuser.length() != 0) {
                            LockList1.setDbParameter("MAXUSERTASKS", maxuser);
                        }
                        if ((timeout = TestCase.getParameterString((String)"REQUEST_TIMEOUT", (String)"")) != null && timeout.length() != 0) {
                            LockList1.setDbParameter("REQUEST_TIMEOUT", timeout);
                        }
                        break;
                    }
                    pstmt.setString(1, "LLL" + Integer.toString(i));
                    pstmt.executeUpdate();
                    ++i;
                }
            }
            catch (Exception e) {
                throw new TestCaseException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            try {
                pstmt.close();
                stmt.close();
                con.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var7_11 = null;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        pstmt.close();
        stmt.close();
        con.close();
    }

    private void print(String pOut) {
        try {
            if (sDevTrace) {
                this.addMessage("", 'I', String.valueOf(Thread.currentThread().getName()) + " " + this.getDate() + " " + pOut);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void run() {
        try {
            Thread.sleep(60000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        TestCase.addGlobalMessage((String)"Test execution", (char)'I', (String)"Everything works fine");
    }

    private static void setDbParameter(String pKey, String pValue) {
        sDbParameter.setProperty(pKey, pValue);
        TestCase.addGlobalMessage((String)"", (char)'I', (String)("Db parameter " + pKey + " = " + pValue));
    }

    private static void setTestParameter(String pKey, String pValue) {
        sTestParameter.setProperty(pKey, pValue);
        TestCase.addGlobalMessage((String)"", (char)'I', (String)("Testparameter " + pKey + " = " + pValue));
    }

    class LockRequestor
    extends Thread {
        boolean keepRuning = true;

        LockRequestor() {
            this.start();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Connection con = null;
            TestPreparedStatement pstmt = null;
            Thread currentThread = null;
            long startTime = System.currentTimeMillis();
            String commitRate = sTestParameter.getProperty(LockList1.COMMIT_RATE);
            int CommitRate = Integer.parseInt(commitRate);
            String concurrentRate = sTestParameter.getProperty(LockList1.CONCURRENT_RATE);
            int ConcurrentRate = Integer.parseInt(concurrentRate);
            String sleepRate = sTestParameter.getProperty(LockList1.SLEEP_RATE);
            int SleepRate = Integer.parseInt(sleepRate);
            String sleepTime = sTestParameter.getProperty(LockList1.SLEEP_TIME);
            long SleepTime = 1000L * Long.parseLong(sleepTime);
            String timeout = sTestParameter.getProperty(LockList1.TIME_OUT);
            long Timeout = 1000L * Long.parseLong(timeout);
            try {
                try {
                    con = TestCase.getDatabase().connect(sUser, sPassword);
                    con.setAutoCommit(false);
                    pstmt = new TestPreparedStatement(null, con, "LOCK ROW LOCKTEST KEY S0 = ? IN EXCLUSIVE MODE");
                    currentThread = Thread.currentThread();
                    LockList1.this.mWatchListUser.add(currentThread.getName());
                    LockList1.this.mWatchListRequest.put(currentThread.getName(), new Date(System.currentTimeMillis()));
                    Random randomGenerator = new Random(System.currentTimeMillis());
                    int counter = 0;
                    while (this.keepRuning) {
                        LockList1.this.print("Lock counter = " + ++counter);
                        if (counter % CommitRate == 0) {
                            con.commit();
                            LockList1.this.print("Commit");
                        } else {
                            String key;
                            if (counter % ConcurrentRate == 0) {
                                key = "LLL " + Integer.toString(randomGenerator.nextInt());
                                if (key.length() > 5) {
                                    key = key.substring(0, 5);
                                }
                                LockList1.this.print("Concurrent lock");
                            } else {
                                key = Integer.toString(randomGenerator.nextInt());
                                LockList1.this.print("Regular lock");
                            }
                            pstmt.setString(1, key);
                            pstmt.executeUpdate();
                            ++sLockCounter;
                        }
                        if (counter % SleepRate == 0) {
                            Thread.sleep(SleepTime);
                            LockList1.this.print("Sleep");
                        }
                        if (counter % 100 == 0) {
                            LockList1.this.mWatchListRequest.put(currentThread.getName(), new Date(System.currentTimeMillis()));
                        }
                        Thread.yield();
                    }
                }
                catch (Exception e) {
                    LockList1.this.handleException(e);
                }
            }
            catch (Throwable throwable) {
                Object var21_20 = null;
                try {
                    pstmt.close();
                    con.close();
                    LockList1.this.mWatchListUser.remove(currentThread.getName());
                    long timeDiff = System.currentTimeMillis() - startTime;
                    LockList1.this.print("stopped after " + timeDiff / 1000L + "(" + Timeout / 1000L + ")");
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            {
                Object var21_21 = null;
            }
            try {}
            catch (Exception exception) {
                return;
            }
            pstmt.close();
            con.close();
            LockList1.this.mWatchListUser.remove(currentThread.getName());
            long timeDiff = System.currentTimeMillis() - startTime;
            LockList1.this.print("stopped after " + timeDiff / 1000L + "(" + Timeout / 1000L + ")");
        }

        public void pleaseStop() {
            this.keepRuning = false;
        }
    }

    class Watcher
    extends Thread {
        boolean keepRuning = true;

        Watcher() {
            LockList1.this.mWatchListUser = Collections.synchronizedList(new ArrayList());
            LockList1.this.mWatchListRequest = Collections.synchronizedMap(new HashMap());
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy hh:mm:ss");
            String watchTime = sTestParameter.getProperty(LockList1.WATCH_TIME);
            long WatchTime = 1000L * Long.parseLong(watchTime);
            while (this.keepRuning) {
                List list = LockList1.this.mWatchListUser;
                synchronized (list) {
                    ListIterator it = LockList1.this.mWatchListUser.listIterator();
                    while (it.hasNext()) {
                        String key = (String)it.next();
                        Date LastRequest = (Date)LockList1.this.mWatchListRequest.get(key);
                        long timediff = System.currentTimeMillis() - LastRequest.getTime();
                        if (timediff <= WatchTime) continue;
                        LockList1.this.print(String.valueOf(key) + " not responding since " + df.format(LastRequest).toString());
                    }
                }
                try {
                    Thread.sleep(WatchTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public void pleaseStop() {
            this.keepRuning = false;
        }
    }

    class Sysmon
    extends Thread {
        boolean keepRuning = true;

        Sysmon() {
            this.start();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Connection con = null;
            TestStatement stmt = null;
            try {
                try {
                    con = TestCase.getDatabase().connect(sUser, sPassword);
                    stmt = new TestStatement(null, con);
                    ResultSet rs = null;
                    int UserInit = 0;
                    int UserConnected = 0;
                    int UserActive = 0;
                    rs = stmt.executeQuery("select count(*) from SYSMON_US");
                    while (true) {
                        if (!rs.next()) break;
                        UserInit = rs.getInt(1);
                    }
                    LockList1.this.print("Users initially connected = " + UserInit);
                    block13: while (true) {
                        if (!this.keepRuning) {
                            con.close();
                        }
                        rs = stmt.executeQuery("select count(*) from SYSMON_US");
                        while (true) {
                            if (!rs.next()) break;
                            UserConnected = rs.getInt(1);
                        }
                        rs = stmt.executeQuery("select count(*) from SYSMON_US_ACTIVE");
                        while (true) {
                            if (!rs.next()) {
                                if (UserConnected != 1) break;
                                LockList1.this.print("Total # of Locks = " + sLockCounter);
                                this.pleaseStop();
                                continue block13;
                            }
                            UserActive = rs.getInt(1);
                        }
                        if (UserActive != UserInit) {
                            LockList1.this.print("Active users = " + UserActive + "(" + UserInit + ")");
                        }
                        if (UserConnected != UserInit) {
                            LockList1.this.print("Connected users = " + UserConnected + "(" + UserInit + ")");
                        }
                        try {
                            long WatchTime = 1000L * Long.parseLong(sTestParameter.getProperty(LockList1.WATCH_TIME));
                            Thread.sleep(WatchTime);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                catch (Exception e) {
                    LockList1.this.print(e.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                try {
                    stmt.close();
                    con.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            {
                Object var9_13 = null;
            }
            try {}
            catch (Exception exception) {
                return;
            }
            stmt.close();
            con.close();
        }

        public void pleaseStop() {
            this.keepRuning = false;
        }
    }
}

