/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simulation.unittests;

import com.sap.sapdb.oltptest.join.simulation.AndCondition;
import com.sap.sapdb.oltptest.join.simulation.BruteForceJoin;
import com.sap.sapdb.oltptest.join.simulation.DatabaseTable;
import com.sap.sapdb.oltptest.join.simulation.DbResultTable;
import com.sap.sapdb.oltptest.join.simulation.EqualConstCondition;
import com.sap.sapdb.oltptest.join.simulation.IntegerCell;
import com.sap.sapdb.oltptest.join.simulation.LessCondition;
import com.sap.sapdb.oltptest.join.simulation.MaterializeResultOperator;
import com.sap.sapdb.oltptest.join.simulation.OrCondition;
import com.sap.sapdb.oltptest.join.simulation.QualificationFilter;
import com.sap.sapdb.oltptest.join.simulation.TableRow;
import com.sap.sapdb.oltptest.join.simulation.unittests.TestHelpers;
import junit.framework.Assert;
import junit.framework.TestCase;

public class QualificationFilterTest
extends TestCase {
    public void testSimpleQualification() {
        DatabaseTable t = TestHelpers.createTable(3, 10);
        EqualConstCondition c1 = new EqualConstCondition(new DbResultTable(t), 2, new IntegerCell(5));
        EqualConstCondition c2 = new EqualConstCondition(new DbResultTable(t), 3, new IntegerCell(12));
        QualificationFilter o = new QualificationFilter(new DbResultTable(t), new OrCondition(c1, c2));
        MaterializeResultOperator m = new MaterializeResultOperator(o);
        DatabaseTable verifyTable = new DatabaseTable(m);
        TableRow verifyRow = new TableRow(verifyTable);
        verifyRow.setValue(1, new IntegerCell(4));
        verifyRow.setValue(2, new IntegerCell(5));
        verifyRow.setValue(3, new IntegerCell(6));
        verifyTable.insert(verifyRow);
        verifyRow.setValue(1, new IntegerCell(10));
        verifyRow.setValue(2, new IntegerCell(11));
        verifyRow.setValue(3, new IntegerCell(12));
        verifyTable.insert(verifyRow);
        Assert.assertTrue((boolean)verifyTable.sortAndCompare(m.getResultTable(), true));
    }

    public void testTwoTableQualification() {
        DatabaseTable t1 = TestHelpers.createTable(3, 10);
        DatabaseTable t2 = TestHelpers.createTable(4, 10);
        LessCondition c1 = new LessCondition(t1, 1, t2, 4);
        BruteForceJoin joinResult = new BruteForceJoin(new DbResultTable(t1), new DbResultTable(t2), c1);
        EqualConstCondition c2 = new EqualConstCondition(t1, 2, new IntegerCell(6));
        EqualConstCondition c3 = new EqualConstCondition(t2, 3, new IntegerCell(7));
        QualificationFilter o = new QualificationFilter(joinResult, new AndCondition(c2, c3));
        MaterializeResultOperator m = new MaterializeResultOperator(o);
        DatabaseTable verifyTable = new DatabaseTable(m);
        TableRow verifyRow = new TableRow(verifyTable);
        verifyRow.setValue(1, new IntegerCell(5));
        verifyRow.setValue(2, new IntegerCell(6));
        verifyRow.setValue(3, new IntegerCell(7));
        verifyRow.setValue(4, new IntegerCell(5));
        verifyRow.setValue(5, new IntegerCell(6));
        verifyRow.setValue(6, new IntegerCell(7));
        verifyRow.setValue(7, new IntegerCell(8));
        verifyTable.insert(verifyRow);
        Assert.assertTrue((boolean)verifyTable.sortAndCompare(m.getResultTable(), true));
    }
}

