/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simulation.unittests;

import com.sap.sapdb.oltptest.join.simulation.AddFunction;
import com.sap.sapdb.oltptest.join.simulation.CellAccessorFunction;
import com.sap.sapdb.oltptest.join.simulation.DatabaseTable;
import com.sap.sapdb.oltptest.join.simulation.DbResultTable;
import com.sap.sapdb.oltptest.join.simulation.FunctionFilter;
import com.sap.sapdb.oltptest.join.simulation.MaterializeResultOperator;
import com.sap.sapdb.oltptest.join.simulation.unittests.TestHelpers;
import java.util.ArrayList;
import junit.framework.TestCase;

public class FunctionFilterTest
extends TestCase {
    private DatabaseTable table1;

    protected void setUp() throws Exception {
        super.setUp();
        this.table1 = TestHelpers.createTable(3, 7);
    }

    public void testSimplestAdd() {
        System.out.println("FunctionFilterTest: simplest add");
        AddFunction fa = new AddFunction(new CellAccessorFunction(this.table1, 1), new CellAccessorFunction(this.table1, 3));
        FunctionFilter f = new FunctionFilter(new DbResultTable(this.table1));
        f.addFunction(fa, 2);
        DatabaseTable result = new MaterializeResultOperator(f).getResultTable();
        result.dump();
        ArrayList<DatabaseTable> tableList = new ArrayList<DatabaseTable>(1);
        tableList.add(this.table1);
        TestHelpers.verifyTableDefinition(f, tableList);
        f.dumpStructure();
    }

    public void testSimpleAdd() {
        System.out.println("FunctionFilterTest: simple add");
        CellAccessorFunction c1 = new CellAccessorFunction(this.table1, 1);
        CellAccessorFunction c2 = new CellAccessorFunction(this.table1, 2);
        CellAccessorFunction c3 = new CellAccessorFunction(this.table1, 3);
        AddFunction f0 = new AddFunction(c1, c2);
        AddFunction f1 = new AddFunction(c3, f0);
        AddFunction ff = new AddFunction(f0, f1);
        FunctionFilter f = new FunctionFilter(new DbResultTable(this.table1));
        f.addFunction(ff, 3);
        DatabaseTable result = new MaterializeResultOperator(f).getResultTable();
        result.dump();
        ArrayList<DatabaseTable> tableList = new ArrayList<DatabaseTable>(1);
        tableList.add(this.table1);
        TestHelpers.verifyTableDefinition(f, tableList);
    }
}

