/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simulation;

import com.sap.sapdb.oltptest.join.simulation.Column;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class TableDefinition
implements Cloneable {
    private List columnInfo;
    private String tableName;

    public TableDefinition() {
        this.columnInfo = new ArrayList();
    }

    public TableDefinition(TableDefinition def) {
        this.columnInfo = new ArrayList(def.columnInfo.size());
        Iterator colIt = def.columnIterator();
        while (colIt.hasNext()) {
            Column column = (Column)colIt.next();
            Column col = (Column)column.clone();
            col.setColumnNo(this.columnInfo.size() + 1);
            this.columnInfo.add(col);
        }
    }

    public void addColumn(Column col) {
        this.columnInfo.add(col);
        col.setColumnNo(this.columnInfo.size());
    }

    public int getColumnCount() {
        return this.columnInfo.size();
    }

    public Iterator columnIterator() {
        return this.columnInfo.iterator();
    }

    public Column getColumnInfo(int columnNumber) {
        return (Column)this.columnInfo.get(columnNumber - 1);
    }

    public int getColumnNo(Column column) {
        int i = 1;
        while (i <= this.columnInfo.size()) {
            if (this.getColumnInfo(i).getColumnName().equals(column.getColumnName())) {
                return i;
            }
            ++i;
        }
        throw new NoSuchElementException(column.getColumnName());
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Object clone() {
        TableDefinition o = null;
        try {
            o = (TableDefinition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        o.tableName = this.tableName;
        o.columnInfo = new ArrayList(this.columnInfo.size());
        int i = 0;
        while (i < this.columnInfo.size()) {
            o.columnInfo.add(((Column)this.columnInfo.get(i)).clone());
            ++i;
        }
        return o;
    }

    public void clear() {
        this.columnInfo.clear();
    }
}

