/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simulation;

import com.sap.sapdb.oltptest.join.simulation.Assertion;
import com.sap.sapdb.oltptest.join.simulation.Column;
import com.sap.sapdb.oltptest.join.simulation.OperatorTableDefinition;
import com.sap.sapdb.oltptest.join.simulation.ResultTable;
import com.sap.sapdb.oltptest.join.simulation.Table;
import com.sap.sapdb.oltptest.join.simulation.TableRow;
import java.io.PrintStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ProjectionOperator
extends ResultTable {
    private boolean initialized;
    private ResultTable inputTable;
    private TableRow outputRow;
    private List columnList;
    private static int projectionId;

    private static int newProjectionId() {
        return ++projectionId;
    }

    public ProjectionOperator(ResultTable inputTable, List srcColumnList) {
        this.initialized = false;
        this.inputTable = inputTable;
        this.columnList = new ArrayList(srcColumnList.size());
        Iterator iter = srcColumnList.iterator();
        while (iter.hasNext()) {
            Column srcCol = (Column)iter.next();
            this.columnList.add(new Mapping(srcCol, srcCol.getColumnName(), srcCol.getColumnNo()));
        }
    }

    public ProjectionOperator(ResultTable inputTable, Table srcTable, int srcColumnNo) {
        this.initialized = false;
        this.inputTable = inputTable;
        Column srcColumn = this.inputTable.getColumnInfo(this.inputTable.getColumnBaseOffset(srcTable) + srcColumnNo - 1);
        this.columnList = new ArrayList(1);
        this.columnList.add(new Mapping(srcColumn, srcColumn.getColumnName(), srcColumn.getColumnNo()));
        this.tableDef.setTableName("ProjectionTable" + ProjectionOperator.newProjectionId());
    }

    public ProjectionOperator(ResultTable inputTable) {
        this.inputTable = inputTable;
        this.columnList = new ArrayList();
        this.initialized = false;
        this.tableDef.setTableName("ProjectionTable" + ProjectionOperator.newProjectionId());
    }

    public void addColumn(Table srcTable, int srcColumnNumber, String newColumnName) {
        Assertion.assertTrue(!this.initialized);
        Column srcColumn = this.inputTable.getColumnInfo(this.inputTable.getColumnBaseOffset(srcTable) + srcColumnNumber - 1);
        this.columnList.add(new Mapping(srcColumn, newColumnName, srcColumn.getColumnNo()));
    }

    private void createOutputTable() {
        this.getTableDefinition().clear();
        Iterator it = this.columnList.iterator();
        while (it.hasNext()) {
            Mapping m = (Mapping)it.next();
            Column newCol = (Column)m.getSourceColumn().clone();
            newCol.setColumnName(m.getNewColumnName());
            this.addColumn(newCol);
        }
        this.outputRow = new TableRow(this);
        this.initialized = true;
    }

    public Iterator containedTablesIterator() {
        ArrayList<ProjectionOperator> tableList = new ArrayList<ProjectionOperator>();
        ((AbstractList)tableList).add(this);
        return ((AbstractList)tableList).iterator();
    }

    public OperatorTableDefinition getResultTableDefinition() {
        if (!this.initialized) {
            this.createOutputTable();
        }
        return this.tableDef;
    }

    public boolean hasNext() {
        if (!this.initialized) {
            this.createOutputTable();
        }
        return this.inputTable.hasNext();
    }

    public TableRow next() {
        if (!this.initialized) {
            this.createOutputTable();
        }
        TableRow inputRow = this.inputTable.next();
        int colNo = 1;
        while (colNo <= this.columnList.size()) {
            Mapping m = (Mapping)this.columnList.get(colNo - 1);
            this.outputRow.setValue(colNo, inputRow.getValue(m.getSourceColumnNo()));
            ++colNo;
        }
        return this.outputRow;
    }

    public void resetIterator() {
        this.inputTable.resetIterator();
    }

    public void dumpStructure(PrintStream s, String indentStr) {
        s.println(String.valueOf(indentStr) + "ProjectionOperator " + this.getTableName());
        s.println(String.valueOf(indentStr) + "  Input:");
        this.inputTable.dumpStructure(s, String.valueOf(indentStr) + "    ");
        s.println(String.valueOf(indentStr) + "  Mapping:");
        Iterator it = this.columnList.iterator();
        indentStr = String.valueOf(new String(indentStr)) + "    ";
        while (it.hasNext()) {
            Mapping m = (Mapping)it.next();
            s.println(String.valueOf(indentStr) + m.getSourceColumn().getColumnName() + " -> " + m.getNewColumnName());
        }
    }

    private class Mapping {
        Column srcColumn;
        String newName;
        int srcColNumber;

        public Mapping(Column srcColumn, String newName, int srcColNumber) {
            this.srcColumn = srcColumn;
            this.newName = newName;
            this.srcColNumber = srcColNumber;
        }

        public Column getSourceColumn() {
            return this.srcColumn;
        }

        public String getNewColumnName() {
            return this.newName;
        }

        public int getSourceColumnNo() {
            return this.srcColNumber;
        }
    }
}

