/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simulation;

import com.sap.sapdb.oltptest.join.simulation.AbstractCell;
import com.sap.sapdb.oltptest.join.simulation.AbstractCondition;
import com.sap.sapdb.oltptest.join.simulation.ResultTable;
import com.sap.sapdb.oltptest.join.simulation.Table;
import com.sap.sapdb.oltptest.join.simulation.TableRow;
import java.io.PrintStream;

public class EqualConstCondition
extends AbstractCondition {
    Table table;
    int columnNumber;
    AbstractCell constValue;
    private int rowBaseColumnNo;

    public EqualConstCondition(Table table, int columnNumber, AbstractCell constValue) {
        this.table = table;
        this.columnNumber = columnNumber;
        this.constValue = constValue;
    }

    public void prepare(ResultTable inputTable) {
        this.rowBaseColumnNo = inputTable.getColumnBaseOffset(this.table) - 1;
    }

    public boolean isTrue(TableRow row) {
        AbstractCell value = row.getValue(this.columnNumber + this.rowBaseColumnNo);
        if (value.isNull()) {
            return false;
        }
        return value.isEqual(this.constValue);
    }

    public boolean isFalse(TableRow row) {
        return !this.isTrue(row);
    }

    public void dumpStructure(PrintStream s, String indentStr) {
        s.println(String.valueOf(indentStr) + "EqualConstCondition");
        s.println(String.valueOf(indentStr) + "  Column " + String.valueOf(this.columnNumber) + " = " + this.constValue.getValue());
        s.println(String.valueOf(indentStr) + "  Table : " + this.table.getTableName());
    }
}

