/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simulation;

import com.sap.sapdb.oltptest.join.simulation.AbstractCell;
import com.sap.sapdb.oltptest.join.simulation.IntegerCell;
import com.sap.sapdb.oltptest.join.simulation.SetFunction;
import com.sap.sapdb.oltptest.join.simulation.TableRow;
import com.sap.sapdb.oltptest.join.simulation.ValueFunction;
import java.io.PrintStream;

public class AverageSetFunction
extends SetFunction {
    private int rowCount;
    private float sum;

    public AverageSetFunction(ValueFunction inputValue) {
        super(inputValue);
        this.reset();
    }

    public void evaluate(TableRow row) {
        ++this.rowCount;
        this.sum += (float)((IntegerCell)this.inputValue.evaluate(row)).getIntValue();
    }

    public AbstractCell getResult() {
        return new IntegerCell(this.sum / (float)this.rowCount);
    }

    public void reset() {
        this.rowCount = 0;
        this.sum = 0.0f;
    }

    public void dumpStructure(PrintStream s, String indentStr) {
        s.println(String.valueOf(indentStr) + "AverageSetFunction");
        s.println(String.valueOf(indentStr) + "  input value:");
        this.inputValue.dumpStructure(s, String.valueOf(indentStr) + "    ");
    }
}

