/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.description;

import com.sap.sapdb.oltptest.join.ParameterIterator;
import com.sap.sapdb.oltptest.join.data.RandomStream;
import com.sap.sapdb.oltptest.join.description.ColumnDescription;
import com.sap.sapdb.oltptest.join.description.IntForLoop;
import com.sap.sapdb.oltptest.join.description.IntPermutation;
import com.sap.sapdb.oltptest.join.description.JoinPredicate;
import com.sap.sapdb.oltptest.join.description.SingleTablePredicate;
import com.sap.sapdb.oltptest.join.description.TableDescription;
import com.sap.sapdb.oltptest.join.simplejdbc.Connection;
import com.sap.sapdb.oltptest.join.simulation.AbstractCell;
import com.sap.sapdb.oltptest.join.simulation.AbstractCondition;
import com.sap.sapdb.oltptest.join.simulation.AndCondition;
import com.sap.sapdb.oltptest.join.simulation.DatabaseTable;
import com.sap.sapdb.oltptest.join.simulation.DbResultTable;
import com.sap.sapdb.oltptest.join.simulation.FullOuterJoin;
import com.sap.sapdb.oltptest.join.simulation.IntegerCell;
import com.sap.sapdb.oltptest.join.simulation.LeftOuterJoin;
import com.sap.sapdb.oltptest.join.simulation.MaterializeResultOperator;
import com.sap.sapdb.oltptest.join.simulation.NestedLoopJoin;
import com.sap.sapdb.oltptest.join.simulation.ResultTable;
import com.sap.sapdb.oltptest.join.simulation.RightOuterJoin;
import com.sap.sapdb.oltptest.join.simulation.SortInfo;
import com.sap.sapdb.oltptest.join.simulation.SortOperator;
import com.sap.sapdb.oltptest.join.simulation.TableRow;
import com.sap.sapdb.oltptest.join.util.PrettyPrinter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class JoinQuery {
    AbstractList tables = new ArrayList();
    private AbstractList predicates = new ArrayList();
    private int[] tableOrder;
    private int[] joinLayout;
    private IndexLayout indices;
    private boolean useNewJoin = false;
    private DatabaseTable simMat = null;
    private static final int outerJoinCutoff_C = 2;
    JoinPredicate firstTableLimit = null;
    public static final int Inner_C = 1;
    public static final int LeftOuter_C = 2;
    public static final int RightOuter_C = 3;
    public static final int FullOuter_C = 4;
    public static final int Cross_C = 5;
    public static final String[] joinStrings_C = new String[]{" GARBAGE ", " INNER JOIN ", " LEFT OUTER JOIN ", " RIGHT OUTER JOIN ", " FULL OUTER JOIN ", " CROSS JOIN "};
    public static final int NoIndex_C = 1;
    public static final int AscIndex_C = 2;
    public static final int DescIndex_C = 3;
    public static final int LastIndex_C = 3;
    public static final String[] indexStrings_C = new String[]{"garbage", "none", "ASC", "DESC"};

    public TableDescription addTable(String tableName) {
        TableDescription result = new TableDescription(tableName);
        this.tables.add(result);
        return result;
    }

    public TableDescription addTable() {
        String tableName = "TABLE_" + this.tables.size();
        return this.addTable(tableName);
    }

    public TableIterator tableIterator() {
        return new TableIterator(this.tables);
    }

    public TableDescription findTable(String tableName) {
        TableIterator iter = this.tableIterator();
        while (iter.hasNext()) {
            TableDescription table = iter.nextTable();
            if (!table.getName().equals(tableName)) continue;
            return table;
        }
        return null;
    }

    public int getTableCount() {
        return this.tables.size();
    }

    public JoinQuery addPredicate(JoinPredicate predicate) {
        predicate.createColumns(this);
        this.predicates.add(predicate);
        return this;
    }

    public void setIndexLayout(IndexLayout indices) {
        this.indices = indices;
    }

    public void setIndexLayout(IndexLayout indices, Connection session) throws SQLException {
        if (this.indices == null) {
            this.indices = IndexLayout.fromJoin(this);
        }
        indices.adjustDatabase(this.indices, session);
        this.indices = indices;
    }

    public void limitFirstTable(String colName, double ratio) {
        if (this.tableOrder == null) {
            this.tableOrder = this.defaultTableOrder();
        }
        TableDescription table = (TableDescription)this.tables.get(this.tableOrder[0]);
        DatabaseTable simTable = table.getSimulatedTable();
        int colIndex = table.findColumnIndex(colName);
        SortInfo sortOrder = new SortInfo();
        sortOrder.addColumn(colIndex, 1);
        SortOperator sorted = new SortOperator(new DbResultTable(simTable), sortOrder);
        int cutoffRow = (int)((double)simTable.getRowCount() * ratio);
        int currentRow = 0;
        TableRow row = null;
        while (sorted.hasNext() && currentRow < cutoffRow) {
            row = sorted.next();
            ++currentRow;
        }
        AbstractCell cell = row.getValue(colIndex);
        Object javaValue = null;
        javaValue = cell instanceof IntegerCell ? new Integer(Integer.parseInt(cell.getValue())) : cell.getValue();
        SingleTablePredicate lessThan = new SingleTablePredicate(table.getName(), colName, "<", javaValue);
        this.firstTableLimit = lessThan;
        this.predicates.add(lessThan);
    }

    /*
     * Enabled aggressive block sorting
     */
    public String createANSISelectSQL() throws InvalidTestException {
        if (this.tableOrder == null) {
            this.tableOrder = this.defaultTableOrder();
        }
        if (this.joinLayout == null) {
            this.joinLayout = this.defaultJoinlayout();
        }
        StringBuffer buf = new StringBuffer();
        buf.append("SELECT ");
        if (this.indices != null) {
            buf.append(this.indices.asHint());
        }
        buf.append(this.selectColumnsList());
        buf.append("\nFROM ");
        PredicateCollection unusedPredicates = new PredicateCollection(this.predicates);
        TableDescription table = (TableDescription)this.tables.get(this.tableOrder[0]);
        buf.append(table.getName());
        PredicateIterator firstTablePredicates = unusedPredicates.forTable(table.getName());
        int i = 1;
        while (i < this.tableOrder.length) {
            buf.append("\n    ");
            buf.append(joinStrings_C[this.joinLayout[i]]);
            table = (TableDescription)this.tables.get(this.tableOrder[i]);
            buf.append(table.getName());
            buf.append("\n      ON ");
            PredicateIterator joinPredicates = unusedPredicates.forTable(table.getName());
            if (!joinPredicates.hasNext()) {
                throw new InvalidTestException("no join without matching predicates");
            }
            JoinPredicate predicate = joinPredicates.nextPredicate();
            buf.append(predicate.asSQL());
            while (joinPredicates.hasNext()) {
                buf.append(" AND ");
                predicate = joinPredicates.nextPredicate();
                buf.append(predicate.asSQL());
            }
            if (firstTablePredicates != null) {
                while (firstTablePredicates.hasNext()) {
                    buf.append(" AND ");
                    predicate = firstTablePredicates.nextPredicate();
                    buf.append(predicate.asSQL());
                }
                firstTablePredicates = null;
            }
            ++i;
        }
        PredicateIterator iter = unusedPredicates.unusedPredicates();
        if (iter.hasNext()) {
            buf.append("\nWHERE ");
            String delimiter = "";
            while (iter.hasNext()) {
                buf.append(delimiter);
                buf.append(iter.nextPredicate().asSQL());
                delimiter = "\n  AND ";
            }
        }
        return buf.toString();
    }

    public String createSelectSQL() {
        StringBuffer buf = new StringBuffer();
        buf.append("SELECT ");
        buf.append(this.selectColumnsList());
        buf.append("\nFROM ");
        TableIterator tables = this.tableIterator();
        String delimiter = "";
        while (tables.hasNext()) {
            TableDescription table = tables.nextTable();
            buf.append(delimiter);
            buf.append(table.getName());
            delimiter = ", ";
        }
        buf.append("\nWHERE ");
        PredicateIterator iter = new PredicateIterator(this.predicates);
        delimiter = "";
        while (iter.hasNext()) {
            buf.append(delimiter);
            buf.append(iter.nextPredicate().asSQL());
            delimiter = "\n  AND ";
        }
        return buf.toString();
    }

    protected String selectColumnsList() {
        String delimiter = "";
        TableIterator tables = this.tableIterator();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.tableOrder.length) {
            TableDescription table = (TableDescription)this.tables.get(this.tableOrder[i]);
            TableDescription.ColumnIterator columns = table.columnIterator();
            while (columns.hasNext()) {
                ColumnDescription col = columns.nextColumn();
                String colName = col.getFullName();
                buf.append(delimiter);
                buf.append(colName);
                buf.append(" \"");
                buf.append(colName);
                buf.append('\"');
                delimiter = ", ";
            }
            delimiter = ",\n    ";
            ++i;
        }
        return buf.toString();
    }

    public void generateSUT(DatabaseTable simMat, DatabaseTable sqlMat) {
        try {
            String select;
            String filename = this.getUniqueFile("jointest", ".vdnts");
            PrintStream printer = new PrintStream(new FileOutputStream(filename));
            printer.println("* diff in JoinTest");
            printer.println("FILE xinitdbk!");
            printer.println("file connect ( kern test !");
            TableIterator iter = this.tableIterator();
            while (iter.hasNext()) {
                TableDescription table = iter.nextTable();
                printer.print(table.createTableSQL());
                printer.println("!\n");
                DatabaseTable memTable = table.getSimulatedTable();
                System.out.println(String.valueOf(table.getName()) + " => " + memTable);
                DbResultTable cursor = new DbResultTable(memTable);
                int colCount = table.getColumnCount();
                while (cursor.hasNext()) {
                    TableRow row = cursor.next();
                    StringBuffer buf = new StringBuffer("INSERT INTO ");
                    buf.append(table.getName());
                    buf.append(" VALUES (");
                    String delimiter = "";
                    int i = 1;
                    while (i <= colCount) {
                        AbstractCell value = row.getValue(i);
                        buf.append(delimiter);
                        buf.append(value.getSqlLiteral());
                        delimiter = ", ";
                        ++i;
                    }
                    buf.append(")!");
                    printer.println(buf.toString());
                }
                printer.println("");
            }
            if (this.indices != null) {
                this.indices.genCreatesForSUT(printer);
                printer.println();
            }
            if (this.useNewJoin) {
                printer.println("DIAGNOSE NEW JOIN ON!");
            }
            try {
                select = this.createANSISelectSQL();
            }
            catch (InvalidTestException testExc) {
                select = "INVALID SQL";
            }
            printer.print("EXPLAIN " + select);
            printer.println("!\n");
            printer.println("FETCH !\n");
            printer.print(select);
            printer.println("!\n");
            printer.println("FETCH !\n");
            printer.println("rollback release !");
            printer.println("FILE SHUTDOWN !");
            printer.println("VDNEXIT !");
            DatabaseTable[] data = new DatabaseTable[]{simMat, sqlMat};
            String[] comments = new String[]{"simulated query", "sql query"};
            int i = 0;
            while (i < data.length) {
                printer.println("* ");
                printer.println("* " + comments[i]);
                Iterator cursor = data[i].rowIterator();
                while (cursor.hasNext()) {
                    printer.println("* " + cursor.next().toString());
                }
                ++i;
            }
            printer.close();
        }
        catch (IOException ioExc) {
            throw new Error(ioExc.toString());
        }
    }

    protected String getUniqueFile(String prefix, String suffix) {
        int index = 1;
        while (true) {
            String number = new Integer(index).toString();
            while (number.length() < 5) {
                number = "0" + number;
            }
            String fname = String.valueOf(prefix) + number + suffix;
            if (!new File(fname).exists()) {
                return fname;
            }
            ++index;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public ResultTable createSimulatedQuery() throws InvalidTestException {
        void var4_5;
        if (this.tableOrder == null) {
            this.tableOrder = this.defaultTableOrder();
        }
        if (this.joinLayout == null) {
            this.joinLayout = this.defaultJoinlayout();
        }
        PredicateCollection unusedPredicates = new PredicateCollection(this.predicates);
        TableDescription table = (TableDescription)this.tables.get(this.tableOrder[0]);
        PredicateIterator firstTablePredicates = unusedPredicates.forTable(table.getName());
        DbResultTable dbResultTable = new DbResultTable(table.getSimulatedTable());
        int i = 1;
        while (i < this.tableOrder.length) {
            table = (TableDescription)this.tables.get(this.tableOrder[i]);
            PredicateIterator joinPredicates = unusedPredicates.forTable(table.getName());
            if (!joinPredicates.hasNext()) {
                throw new InvalidTestException("no join without matching predicates");
            }
            JoinPredicate predicate = joinPredicates.nextPredicate();
            AbstractCondition condition = predicate.buildCondition(this);
            while (joinPredicates.hasNext()) {
                predicate = joinPredicates.nextPredicate();
                AbstractCondition condition2 = predicate.buildCondition(this);
                condition = new AndCondition(condition, condition2);
            }
            DbResultTable nextStream = new DbResultTable(table.getSimulatedTable());
            switch (this.joinLayout[i]) {
                case 1: {
                    NestedLoopJoin nestedLoopJoin = new NestedLoopJoin((ResultTable)var4_5, nextStream, condition);
                    break;
                }
                case 2: {
                    LeftOuterJoin leftOuterJoin = new LeftOuterJoin((ResultTable)var4_5, nextStream, condition);
                    break;
                }
                case 3: {
                    MaterializeResultOperator materializeResultOperator = new MaterializeResultOperator((ResultTable)var4_5);
                    RightOuterJoin rightOuterJoin = new RightOuterJoin(materializeResultOperator, nextStream, condition);
                    break;
                }
                case 4: {
                    MaterializeResultOperator materializeResultOperator = new MaterializeResultOperator((ResultTable)var4_5);
                    FullOuterJoin fullOuterJoin = new FullOuterJoin(materializeResultOperator, nextStream, condition);
                    break;
                }
                case 5: {
                    NestedLoopJoin nestedLoopJoin = new NestedLoopJoin((ResultTable)var4_5, nextStream, null);
                    break;
                }
            }
            ++i;
        }
        return var4_5;
    }

    public void cacheSimulatedResult(DatabaseTable simMat) {
        this.simMat = simMat;
    }

    public boolean referenceDataValid() {
        return this.simMat != null;
    }

    public DatabaseTable getReferenceData() {
        return this.simMat;
    }

    public void setTableOrder(int[] tableOrder) {
        this.tableOrder = tableOrder;
        this.simMat = null;
        if (this.firstTableLimit != null) {
            this.predicates.remove(this.firstTableLimit);
            this.firstTableLimit = null;
        }
    }

    private int[] defaultTableOrder() {
        int[] order = new int[this.tables.size()];
        int i = 0;
        while (i < order.length) {
            order[i] = i;
            ++i;
        }
        return order;
    }

    public ParameterIterator allTableOrders() {
        return new AllTableOrders(this.tables.size());
    }

    public ParameterIterator randomTableOrders(int count) {
        int[][] tableOrders = new int[count][];
        int i = 0;
        while (i < count) {
            int[] currentOrder = new int[this.tables.size()];
            int j = 0;
            while (j < currentOrder.length) {
                currentOrder[j] = j;
                ++j;
            }
            j = currentOrder.length - 1;
            while (j >= 0) {
                int randomIndex = RandomStream.nextInt(j + 1);
                int tmp = currentOrder[randomIndex];
                currentOrder[randomIndex] = currentOrder[j];
                currentOrder[j] = tmp;
                --j;
            }
            tableOrders[i] = currentOrder;
            ++i;
        }
        return this.literalTableOrders(tableOrders);
    }

    public ParameterIterator randomTableOrder() {
        return this.randomTableOrders(1);
    }

    public ParameterIterator literalTableOrders(int[][] tableOrders) {
        int i = 0;
        while (i < tableOrders.length) {
            int[] currentOrder = tableOrders[i];
            if (currentOrder.length != this.tables.size()) {
                throw new Error("must use exactly all tables");
            }
            boolean[] tablesUsed = new boolean[this.tables.size()];
            int j = 0;
            while (j < currentOrder.length) {
                int tableIndex = currentOrder[j];
                if (tableIndex < 0 || this.tables.size() <= tableIndex) {
                    throw new Error("table indices must b between 0 and " + this.tables.size());
                }
                if (tablesUsed[tableIndex]) {
                    throw new Error("table " + tableIndex + " already used");
                }
                tablesUsed[tableIndex] = true;
                ++j;
            }
            ++i;
        }
        return new LiteralTableOrders(tableOrders);
    }

    public ParameterIterator literalTableOrder(int[] tableOrder) {
        return this.literalTableOrders(new int[][]{tableOrder});
    }

    public void setJoinLayout(int[] joinLayout) {
        this.joinLayout = joinLayout;
        this.simMat = null;
    }

    private int[] defaultJoinlayout() {
        int[] layout = new int[this.tables.size()];
        int i = 0;
        while (i < layout.length) {
            layout[i] = 1;
            ++i;
        }
        return layout;
    }

    public ParameterIterator allJoinLayouts() {
        return new AllJoinLayouts(this.tables.size());
    }

    public ParameterIterator randomJoinLayouts(int count) {
        int[][] result = new int[count][];
        int i = 0;
        while (i < count) {
            int[] layout = new int[this.tables.size()];
            int j = 1;
            while (j < layout.length) {
                int newValue = layout.length > 2 ? RandomStream.nextInt(2) + 1 : RandomStream.nextInt(4) + 1;
                layout[j] = newValue;
                ++j;
            }
            result[i] = layout;
            ++i;
        }
        return this.literalJoinLayouts(result);
    }

    public ParameterIterator randomJoinLayout() {
        return this.randomJoinLayouts(1);
    }

    public ParameterIterator literalJoinLayouts(int[][] joinLayouts) {
        int i = 0;
        while (i < joinLayouts.length) {
            int[] currentLayout = joinLayouts[i];
            int j = 1;
            while (j < currentLayout.length) {
                int element = currentLayout[j];
                if (element < 1 || 4 < element) {
                    throw new Error("invalid join kind in " + JoinQuery.joinLayoutToString(currentLayout));
                }
                if (joinLayouts.length > 2 && 2 < element) {
                    throw new Error("no right outer join with more than two tables - in " + JoinQuery.joinLayoutToString(currentLayout));
                }
                ++j;
            }
            ++i;
        }
        return new LiteralJoinLayouts(joinLayouts);
    }

    public ParameterIterator literalJoinLayout(int joinlayout) {
        return this.literalJoinLayouts(new int[][]{this.joinLayout});
    }

    private static boolean invalidLayout(int[] joinLayout) {
        int i = 2;
        while (i < joinLayout.length) {
            switch (joinLayout[i]) {
                case 3: 
                case 4: {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private static String joinLayoutToString(int[] joinLayout) {
        StringBuffer result = new StringBuffer();
        String delimiter = "";
        result.append("{");
        int i = 0;
        while (i < joinLayout.length) {
            String name;
            int current = joinLayout[i];
            try {
                name = joinStrings_C[current];
            }
            catch (Exception e) {
                name = "unknown";
            }
            result.append(delimiter);
            result.append(name);
            result.append(" (");
            result.append(current);
            result.append(")");
            delimiter = ", ";
            ++i;
        }
        result.append("}");
        return result.toString();
    }

    public ParameterIterator randomIndexLayouts(int count) {
        IndexFlag[][] flagLists = new IndexFlag[count][];
        IndexLayout baseLayout = IndexLayout.fromJoin(this);
        int i = 0;
        while (i < flagLists.length) {
            flagLists[i] = baseLayout.getRandomFlags();
            ++i;
        }
        return new LiteralIndexLayouts(flagLists);
    }

    public ParameterIterator randomIndexLayout() {
        return this.randomIndexLayouts(1);
    }

    public ParameterIterator literalIndexLayouts(IndexFlag[][] flagList) {
        return new LiteralIndexLayouts(flagList);
    }

    public ParameterIterator literalIndexLayout(IndexFlag[] flags) {
        return new LiteralIndexLayouts(new IndexFlag[][]{flags});
    }

    public void setNewJoin(boolean useNewJoin, Connection session) throws SQLException {
        this.useNewJoin = useNewJoin;
        if (session != null) {
            if (useNewJoin) {
                session.sql("DIAGNOSE OPTIMIZE OPERATOR JOIN ON");
            } else {
                session.sql("DIAGNOSE OPTIMIZE OPERATOR JOIN OFF");
            }
        }
    }

    public LayoutIterator allLayouts() {
        return new LayoutIterator(this.tables.size());
    }

    public String layoutString(int[] layout, String delimiter) {
        StringBuffer buf = new StringBuffer();
        TableDescription table = (TableDescription)this.tables.get(layout[0]);
        buf.append(table.getName());
        int i = 1;
        while (i < layout.length) {
            buf.append(delimiter);
            if (i % 2 == 0) {
                table = (TableDescription)this.tables.get(layout[i]);
                buf.append(table.getName());
            } else {
                buf.append(joinStrings_C[layout[i]]);
            }
            ++i;
        }
        return buf.toString();
    }

    public static void main(String[] args) throws SQLException {
        IndexLayout layout = new IndexLayout(new IndexFlag[]{new IndexFlag("T1", "C1"), new IndexFlag("T1", "C2"), new IndexFlag("T2", "C1")});
        int i = 0;
        System.out.println(layout.toString());
        while (layout.next()) {
            System.out.println(layout.toString());
            ++i;
        }
    }

    public class PredicateCollection {
        AbstractList unused = new ArrayList();
        AbstractList usedTables;

        public PredicateCollection(AbstractList predicates) {
            this.unused.addAll(predicates);
            this.usedTables = new ArrayList();
        }

        PredicateIterator forTable(String tableName) {
            ArrayList<JoinPredicate> result = new ArrayList<JoinPredicate>();
            PredicateIterator iter = new PredicateIterator(this.unused);
            while (iter.hasNext()) {
                JoinPredicate predicate = iter.nextPredicate();
                if (!predicate.suitableForOn(tableName, this.usedTables)) continue;
                ((AbstractList)result).add(predicate);
            }
            this.usedTables.add(tableName);
            this.unused.removeAll(result);
            return new PredicateIterator(result);
        }

        PredicateIterator unusedPredicates() {
            return new PredicateIterator(this.unused);
        }
    }

    public static class TableIterator {
        private Iterator iter;

        TableIterator(AbstractList collection) {
            this.iter = collection.iterator();
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public TableDescription nextTable() {
            return (TableDescription)this.iter.next();
        }
    }

    public static class PredicateIterator {
        private Iterator iter;

        PredicateIterator(AbstractList collection) {
            this.iter = collection.iterator();
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public JoinPredicate nextPredicate() {
            return (JoinPredicate)this.iter.next();
        }
    }

    public class LayoutIterator {
        int tableCount;
        IntPermutation tablePermutations;
        int[] tablePermutation;
        IntForLoop joinVariations;

        public LayoutIterator(int tableCount) {
            this.tableCount = tableCount;
            this.tablePermutations = new IntPermutation(tableCount);
            this.tablePermutation = this.tablePermutations.next();
            this.initJoinVariations();
        }

        protected void initJoinVariations() {
            this.joinVariations = new IntForLoop(1, 4, this.tableCount - 1);
        }

        public int[] next() {
            int[] joinVariation = this.joinVariations.next();
            if (joinVariation == null) {
                this.tablePermutation = this.tablePermutations.next();
                if (this.tablePermutation == null) {
                    return null;
                }
                this.initJoinVariations();
                joinVariation = this.joinVariations.next();
            }
            int[] result = new int[this.tableCount + this.tableCount - 1];
            int i = 0;
            while (i < this.tableCount) {
                result[2 * i] = this.tablePermutation[i];
                ++i;
            }
            i = 0;
            while (i < this.tableCount - 1) {
                result[2 * i + 1] = joinVariation[i];
                ++i;
            }
            return result;
        }
    }

    static class AllTableOrders
    extends ParameterIterator {
        private int tableCount;
        private IntPermutation permutations;
        private int[] currentOrder = null;

        AllTableOrders(int tableCount) {
            this.tableCount = tableCount;
            try {
                this.resetFor(null, null);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }

        public boolean resetFor(JoinQuery join, Connection session) throws SQLException {
            this.permutations = new IntPermutation(this.tableCount);
            boolean result = false;
            return this.nextFor(join, session);
        }

        public boolean nextFor(JoinQuery join, Connection session) throws SQLException {
            int[] tableOrder = this.permutations.next();
            if (tableOrder != null && join != null) {
                join.setTableOrder(tableOrder);
            }
            this.currentOrder = tableOrder;
            return tableOrder != null;
        }

        public String dumpString() {
            return "TableOrder: " + PrettyPrinter.intarray(this.currentOrder);
        }
    }

    static class LiteralTableOrders
    extends ParameterIterator {
        private int[][] tableOrders;
        private int index;

        LiteralTableOrders(int[][] tableOrders) {
            this.tableOrders = tableOrders;
            this.index = -1;
        }

        public boolean resetFor(JoinQuery join, Connection session) throws SQLException {
            this.index = -1;
            return this.nextFor(join, session);
        }

        public boolean nextFor(JoinQuery join, Connection session) throws SQLException {
            if (this.index + 1 >= this.tableOrders.length) {
                return false;
            }
            ++this.index;
            join.setTableOrder(this.tableOrders[this.index]);
            return true;
        }

        public String dumpString() {
            return "TableOrder: " + PrettyPrinter.intarray(this.tableOrders[this.index]);
        }
    }

    static class AllJoinLayouts
    extends ParameterIterator {
        private int tableCount;
        private int[] joinLayout;

        public AllJoinLayouts(int tableCount) {
            this.tableCount = tableCount;
            try {
                this.resetFor(null, null);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }

        public boolean resetFor(JoinQuery join, Connection session) throws SQLException {
            this.joinLayout = new int[this.tableCount];
            int i = 1;
            while (i < this.tableCount) {
                this.joinLayout[i] = 1;
                ++i;
            }
            return true;
        }

        public boolean nextFor(JoinQuery join, Connection session) throws SQLException {
            boolean result;
            while ((result = this.next(this.tableCount - 1)) && JoinQuery.invalidLayout(this.joinLayout)) {
            }
            if (result) {
                this.applyLayout(join, this.joinLayout);
            }
            return result;
        }

        private boolean next(int index) {
            if (index < 1) {
                return false;
            }
            if (this.joinLayout[index] == 4) {
                return this.next(index - 1);
            }
            int n = index;
            this.joinLayout[n] = this.joinLayout[n] + 1;
            int i = index + 1;
            while (i < this.tableCount) {
                this.joinLayout[i] = 1;
                ++i;
            }
            return true;
        }

        private void applyLayout(JoinQuery join, int[] joinLayout) {
            if (join != null) {
                int[] copy = new int[joinLayout.length];
                System.arraycopy(joinLayout, 0, copy, 0, joinLayout.length);
                join.setJoinLayout(copy);
            }
        }

        public String dumpString() {
            return "JoinLayout: " + PrettyPrinter.intarray(this.joinLayout, joinStrings_C);
        }
    }

    static class LiteralJoinLayouts
    extends ParameterIterator {
        private int[][] joinLayouts;
        private int index;

        LiteralJoinLayouts(int[][] joinLayouts) {
            this.joinLayouts = joinLayouts;
            this.index = -1;
        }

        public boolean resetFor(JoinQuery join, Connection session) throws SQLException {
            this.index = -1;
            return this.nextFor(join, session);
        }

        public boolean nextFor(JoinQuery join, Connection session) throws SQLException {
            if (this.index + 1 >= this.joinLayouts.length) {
                return false;
            }
            ++this.index;
            join.setJoinLayout(this.joinLayouts[this.index]);
            return true;
        }

        public String dumpString() {
            return "JoinLayout: " + PrettyPrinter.intarray(this.joinLayouts[this.index], joinStrings_C);
        }
    }

    public static class IndexLayout {
        private IndexFlag[] flags;

        public IndexLayout(IndexFlag[] flags) {
            this.flags = flags;
        }

        public static IndexLayout fromJoin(JoinQuery join) {
            ArrayList<IndexFlag> list = new ArrayList<IndexFlag>();
            TableIterator tables = join.tableIterator();
            while (tables.hasNext()) {
                TableDescription table = tables.nextTable();
                String tableName = table.getName();
                TableDescription.ColumnIterator cols = table.columnIterator();
                while (cols.hasNext()) {
                    String colName = cols.nextColumn().getName();
                    if (colName.equals("id")) continue;
                    IndexFlag flag = new IndexFlag(tableName, colName);
                    ((AbstractList)list).add(flag);
                }
            }
            IndexFlag[] indexFlags = new IndexFlag[((AbstractCollection)list).size()];
            int i = 0;
            while (i < indexFlags.length) {
                indexFlags[i] = (IndexFlag)((AbstractList)list).get(i);
                ++i;
            }
            return new IndexLayout(indexFlags);
        }

        public String toString() {
            StringBuffer result = new StringBuffer("[");
            String delimiter = "";
            int i = 0;
            while (i < this.flags.length) {
                result.append(delimiter);
                result.append(this.flags[i].toString());
                delimiter = ", ";
                ++i;
            }
            result.append("]");
            return result.toString();
        }

        public boolean next() {
            return this.next(this.flags.length - 1);
        }

        protected boolean next(int index) {
            if (index < 0) {
                return false;
            }
            IndexFlag changed = this.flags[index].nextForIterator();
            if (changed == null) {
                return this.next(index - 1);
            }
            this.flags[index] = changed;
            int i = index + 1;
            while (i < this.flags.length) {
                this.flags[i] = this.flags[i].resetForIterator();
                ++i;
            }
            return true;
        }

        public boolean next(Connection session) throws SQLException {
            IndexFlag[] oldFlags = new IndexFlag[this.flags.length];
            System.arraycopy(this.flags, 0, oldFlags, 0, this.flags.length);
            boolean hasNext = this.next();
            if (hasNext) {
                int i = 0;
                while (i < oldFlags.length) {
                    this.flags[i].changeIndex(session, oldFlags[i]);
                    ++i;
                }
            }
            return hasNext;
        }

        void adjustDatabase(IndexLayout oldLayout, Connection session) throws SQLException {
            IndexFlag[] oldFlags = oldLayout.flags;
            int i = 0;
            while (i < oldFlags.length) {
                this.flags[i].changeIndex(session, oldFlags[i]);
                ++i;
            }
        }

        public void clear(Connection session) throws SQLException {
            int i = 0;
            while (i < this.flags.length) {
                this.flags[i].dropAllIndices(session);
                ++i;
            }
        }

        public String asHint() {
            StringBuffer result = new StringBuffer("/*");
            String delimiter = "+";
            int i = 0;
            while (i < this.flags.length) {
                String indexName = this.flags[i].getIndexName();
                if (indexName != null) {
                    result.append(delimiter);
                    result.append("INDEXACCES(");
                    result.append(indexName);
                    result.append(")");
                    delimiter = ",";
                }
                ++i;
            }
            result.append(" */\n");
            return result.toString();
        }

        public void genCreatesForSUT(PrintStream printer) {
            int i = 0;
            while (i < this.flags.length) {
                String cmd = this.flags[i].createCmd();
                if (cmd != null) {
                    printer.println(String.valueOf(cmd) + "!");
                }
                ++i;
            }
        }

        public IndexFlag[] getRandomFlags() {
            IndexFlag[] flags = new IndexFlag[this.flags.length];
            int i = 0;
            while (i < flags.length) {
                flags[i] = this.flags[i].randomize();
                ++i;
            }
            return flags;
        }
    }

    public static class IndexFlag {
        private String tableName;
        private String colName;
        private int indexKind;
        private String indexName;

        public IndexFlag(String tableName, String colName, int indexKind) {
            this.tableName = tableName;
            this.colName = colName;
            this.indexKind = indexKind;
            this.indexName = "\"" + tableName + "." + colName + " " + indexStrings_C[indexKind] + "\"";
        }

        public IndexFlag(String tableName, String colName) {
            this(tableName, colName, 1);
        }

        public String getIndexName() {
            if (this.indexKind == 1) {
                return null;
            }
            return this.indexName;
        }

        public String toString() {
            return "[INDEX " + this.indexName + "]";
        }

        public String createCmd() {
            if (this.indexKind == 1) {
                return null;
            }
            return "CREATE INDEX " + this.indexName + " ON " + this.tableName + " (" + this.colName + " " + indexStrings_C[this.indexKind] + ")";
        }

        public void createIndex(Connection session) throws SQLException {
            String cmd = this.createCmd();
            if (cmd != null) {
                session.ddl(cmd);
            }
        }

        public void dropIndex(Connection session) throws SQLException {
            if (this.indexKind != 1) {
                String cmd = "DROP INDEX " + this.indexName;
                session.ddl(cmd);
            }
        }

        public void dropAllIndices(Connection session) throws SQLException {
            int i = 2;
            while (i <= 3) {
                try {
                    String indexName = "\"" + this.tableName + "." + this.colName + " " + indexStrings_C[i] + "\"";
                    String cmd = "DROP INDEX " + indexName;
                    session.ddl(cmd);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ++i;
            }
        }

        public void changeIndex(Connection session, IndexFlag oldState) throws SQLException {
            if (!this.tableName.equals(oldState.tableName)) {
                return;
            }
            if (!this.colName.equals(oldState.colName)) {
                return;
            }
            if (this.indexKind == oldState.indexKind) {
                return;
            }
            switch (this.indexKind) {
                case 1: {
                    oldState.dropIndex(session);
                    break;
                }
                case 2: {
                    if (oldState.indexKind == 3) {
                        oldState.dropIndex(session);
                    }
                    this.createIndex(session);
                    break;
                }
                case 3: {
                    if (oldState.indexKind == 2) {
                        oldState.dropIndex(session);
                    }
                    this.createIndex(session);
                }
            }
        }

        public IndexFlag nextForIterator() {
            if (this.indexKind == 3) {
                return null;
            }
            return new IndexFlag(this.tableName, this.colName, this.indexKind + 1);
        }

        public IndexFlag resetForIterator() {
            return new IndexFlag(this.tableName, this.colName, 1);
        }

        public IndexFlag randomize() {
            int random = RandomStream.nextInt(3) + 1;
            return new IndexFlag(this.tableName, this.colName, random);
        }
    }

    public static class AllIndexLayouts
    extends ParameterIterator {
        private IndexLayout layout;

        public AllIndexLayouts(JoinQuery join) {
            this.layout = IndexLayout.fromJoin(join);
        }

        public boolean resetFor(JoinQuery join, Connection session) throws SQLException {
            this.layout = IndexLayout.fromJoin(join);
            this.layout.clear(session);
            return true;
        }

        public boolean nextFor(JoinQuery join, Connection session) throws SQLException {
            return this.layout.next(session);
        }

        public String dumpString() {
            return this.layout.toString();
        }
    }

    class LiteralIndexLayouts
    extends ParameterIterator {
        IndexFlag[][] flagLists;
        private int index;

        LiteralIndexLayouts(IndexFlag[][] flagLists) {
            this.flagLists = flagLists;
            this.index = -1;
        }

        public boolean resetFor(JoinQuery join, Connection session) throws SQLException {
            this.index = -1;
            return this.nextFor(join, session);
        }

        public boolean nextFor(JoinQuery join, Connection session) throws SQLException {
            if (this.index + 1 >= this.flagLists.length) {
                return false;
            }
            ++this.index;
            IndexLayout newLayout = new IndexLayout(this.flagLists[this.index]);
            join.setIndexLayout(newLayout, session);
            return true;
        }

        public String dumpString() {
            IndexFlag[] flags = this.flagLists[this.index];
            Object[] dumps = new Object[flags.length];
            int i = 0;
            while (i < flags.length) {
                dumps[i] = flags[i].toString();
                ++i;
            }
            return "IndexLayout: " + PrettyPrinter.join(dumps, ", ");
        }
    }

    public class InvalidTestException
    extends Exception {
        InvalidTestException(String msg) {
            super(msg);
        }
    }
}

