/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join;

import com.sap.sapdb.oltptest.join.description.JoinQuery;
import com.sap.sapdb.oltptest.join.description.TableDescription;
import com.sap.sapdb.oltptest.join.simplejdbc.Connection;
import com.sap.sapdb.oltptest.join.simulation.DatabaseTable;
import com.sap.sapdb.oltptest.join.simulation.IntegerCell;
import com.sap.sapdb.oltptest.join.simulation.IntegerColumn;
import com.sap.sapdb.oltptest.join.simulation.MaterializeResultOperator;
import com.sap.sapdb.oltptest.join.simulation.ResultTable;
import com.sap.sapdb.oltptest.join.simulation.TableRow;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Properties;

public abstract class JoinTest {
    protected Connection session = new Connection();
    protected boolean forSQL = true;
    protected boolean forSim = true;
    protected int verbosity = 0;
    protected int testsRun = 0;
    protected int errors = 0;
    public static final String[] noWords = new String[]{"no", "off"};

    public JoinTest() throws ClassNotFoundException, SQLException {
        Properties sysprops = System.getProperties();
        String voption = sysprops.getProperty("sdb.jointest.verbosity", "0");
        this.verbosity = Integer.parseInt(voption);
        this.forSQL = JoinTest.isOff(sysprops, "sdb.jointest.sql");
        this.forSim = JoinTest.isOff(sysprops, "sdb.jointest.simulation");
    }

    static boolean isOff(Properties props, String key) {
        String value = props.getProperty(key);
        int i = 0;
        while (i < noWords.length) {
            if (value == null) {
                return true;
            }
            if (value.equals(noWords[i])) {
                return true;
            }
            ++i;
        }
        return true;
    }

    protected int run() throws SQLException, JoinQuery.InvalidTestException {
        JoinQuery join = new JoinQuery();
        this.declareTables(join);
        this.addJoinPredicates(join);
        this.createTables(join);
        this.enterData(join);
        int result = this.runAndCompare(join);
        return result;
    }

    protected abstract void declareTables(JoinQuery var1);

    protected abstract void addJoinPredicates(JoinQuery var1);

    void createTables(JoinQuery join) throws SQLException {
        if (this.forSQL) {
            this.createSQLTables(join);
        }
        if (this.forSim) {
            this.createSimulationTables(join);
        }
    }

    protected void createSQLTables(JoinQuery join) throws SQLException {
        JoinQuery.TableIterator iter = join.tableIterator();
        while (iter.hasNext()) {
            TableDescription table = iter.nextTable();
            String createSQL = table.createTableSQL();
            if (this.verbosity >= 2) {
                System.out.println(createSQL);
            }
            this.session.ddlIgnoreErrors("DROP TABLE " + table.getName());
            this.session.ddl(createSQL);
            this.session.commit();
        }
    }

    protected void createSimulationTables(JoinQuery join) {
        JoinQuery.TableIterator iter = join.tableIterator();
        while (iter.hasNext()) {
            TableDescription table = iter.nextTable();
            table.createSimulationTable();
        }
    }

    protected abstract void enterData(JoinQuery var1) throws SQLException;

    protected DatabaseTable runSimulatedQuery(JoinQuery join) throws JoinQuery.InvalidTestException {
        if (join.referenceDataValid()) {
            return join.getReferenceData();
        }
        ResultTable simulatedResult = null;
        if (this.forSim) {
            simulatedResult = join.createSimulatedQuery();
            if (this.verbosity >= 2) {
                simulatedResult.dumpStructure();
            }
        }
        DatabaseTable simMat = new MaterializeResultOperator(simulatedResult).getResultTable();
        simMat.setTableName("materialized Simulation");
        simMat.sort();
        if (this.verbosity >= 5) {
            simMat.dump();
        }
        join.cacheSimulatedResult(simMat);
        return simMat;
    }

    protected DatabaseTable runSQLQuery(JoinQuery join) throws SQLException, JoinQuery.InvalidTestException {
        String select = join.createANSISelectSQL();
        if (this.verbosity >= 2) {
            System.out.println(select);
        }
        if (this.verbosity >= 3) {
            this.session.dumpQuery("EXPLAIN " + select);
        }
        ResultSet cursor = this.session.select(select);
        DatabaseTable sqlMat = new DatabaseTable("materialized SQL");
        ResultSetMetaData desc = cursor.getMetaData();
        int colCount = desc.getColumnCount();
        int i = 1;
        while (i <= colCount) {
            IntegerColumn col = new IntegerColumn(desc.getColumnName(i));
            sqlMat.addColumn(col);
            ++i;
        }
        TableRow row = new TableRow(sqlMat);
        while (cursor.next()) {
            int i2 = 1;
            while (i2 <= colCount) {
                int value = cursor.getInt(i2);
                if (cursor.wasNull()) {
                    row.setNullValue(i2);
                } else {
                    row.setValue(i2, new IntegerCell(value));
                }
                ++i2;
            }
            sqlMat.insert(row);
        }
        sqlMat.sort();
        if (this.verbosity >= 5) {
            sqlMat.dump();
        }
        return sqlMat;
    }

    protected int runAndCompare(JoinQuery join) throws SQLException, JoinQuery.InvalidTestException {
        int result = 0;
        DatabaseTable simMat = null;
        if (this.forSim) {
            simMat = this.runSimulatedQuery(join);
        }
        DatabaseTable sqlMat = null;
        if (this.forSQL) {
            sqlMat = this.runSQLQuery(join);
        }
        if (this.forSQL && this.forSim && !sqlMat.sortAndCompare(simMat, true)) {
            System.out.println("comparison failed");
            result = 1;
        }
        return result;
    }

    public boolean hasErrors() {
        return this.errors > 0;
    }

    public static void main(JoinTest test) throws ClassNotFoundException, SQLException {
        int result = 0;
        try {
            test.run();
            if (test.hasErrors()) {
                result = 1;
            }
        }
        catch (JoinQuery.InvalidTestException testExc) {
            result = 2;
        }
        System.exit(result);
    }
}

