/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.innertransaction.sync;

import com.sap.sapdb.oltptest.innertransaction.InnerTransactionTest;
import com.sap.sapdb.oltptest.innertransaction.sync.SyncMaster;

class SyncThread
extends Thread {
    private Boolean stop = Boolean.FALSE;
    private long maximumWaitTime;
    private SyncMaster syncMaster;
    private InnerTransactionTest fatherTest;
    private int currentSequenceNumber;

    protected SyncThread(long maximumWaitTime, SyncMaster syncMaster, InnerTransactionTest fatherTest, int currentSequenceNumber) {
        this.maximumWaitTime = maximumWaitTime;
        this.syncMaster = syncMaster;
        this.fatherTest = fatherTest;
        this.currentSequenceNumber = currentSequenceNumber;
    }

    public void run() {
        long startTime = System.currentTimeMillis();
        do {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                this.syncMaster.setEndBecauseOfError();
                this.fatherTest.ownAddMessage(-1, this.currentSequenceNumber, -1, 1, 'W', "synchronisation thread interrupted (end thread)", null);
                return;
            }
            long currentTime = System.currentTimeMillis();
            if (currentTime - startTime <= this.maximumWaitTime) continue;
            this.syncMaster.endCurrentSyncPoint();
            this.fatherTest.ownAddMessage(-1, this.currentSequenceNumber, -1, 1, 'I', "synchronisation thread: maximum time to wait is over (notify all waiting threads)", null);
            return;
        } while (!this.stop.booleanValue());
    }

    protected void comeToAnEnd() {
        this.stop = Boolean.TRUE;
    }
}

