/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.aggregates;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestPreparedStatement;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SUM
extends TestCase {
    static int MAXROW = 10;
    static int MAXCOL = 2;
    static int[][] mTestData = new int[2 * MAXROW][];
    static String sUser = "Berlin";
    static String sPassword = "Berlin";

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void cleanUp() throws TestCaseException {
        Connection con = null;
        TestStatement stmt = null;
        try {
            try {
                con = TestCase.getDatabase().connect(sUser, sPassword);
                stmt = new TestStatement(null, con);
                stmt.enableExceptions(false);
                stmt.executeUpdate("Drop user " + sUser);
                stmt.enableExceptions(true);
            }
            catch (Exception e) {
                TestCase.addGlobalMessage((String)"Clean up", (char)'E', (String)"failed");
                throw new TestCaseException("Error during clean up: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            try {
                stmt.close();
                con.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        stmt.close();
        con.close();
    }

    public static String getTestClassId() {
        return "SUM";
    }

    public static void prepare() throws TestCaseException {
        Connection con = null;
        TestStatement stmt = null;
        TestPreparedStatement pstmt = null;
        try {
            int col;
            con = TestCase.getDatabase().connect(TestCase.getUser(), TestCase.getPassword());
            stmt = new TestStatement(null, con);
            stmt.enableExceptions(false);
            stmt.executeUpdate("Drop user " + sUser);
            stmt.enableExceptions(true);
            stmt.executeUpdate("Create user " + sUser + " password " + sPassword + " resource not exclusive");
            stmt.close();
            con.close();
            con = TestCase.getDatabase().connect(sUser, sPassword);
            stmt = new TestStatement(null, con);
            try {
                stmt.executeUpdate("drop table TEST");
            }
            catch (Exception exception) {
                // empty catch block
            }
            stmt.executeUpdate("create table TEST (F1 integer, F2 integer)");
            int row = 0;
            while (row < MAXROW) {
                SUM.mTestData[row] = new int[MAXCOL];
                col = 0;
                while (col < MAXCOL) {
                    SUM.mTestData[row][col] = (row + 1) * (col + 1);
                    ++col;
                }
                ++row;
            }
            row = MAXROW;
            while (row < 2 * MAXROW) {
                SUM.mTestData[row] = new int[MAXCOL];
                SUM.mTestData[row][0] = row + 1;
                col = 1;
                while (col < MAXCOL) {
                    SUM.mTestData[row][col] = 50;
                    ++col;
                }
                ++row;
            }
            pstmt = new TestPreparedStatement(null, con, "insert TEST values (?,?)");
            row = 0;
            while (row < MAXROW) {
                pstmt.setInt(1, mTestData[row][0]);
                pstmt.setInt(2, mTestData[row][1]);
                pstmt.executeUpdate();
                ++row;
            }
            row = MAXROW;
            while (row < 2 * MAXROW) {
                pstmt.setInt(1, mTestData[row][0]);
                pstmt.setInt(2, mTestData[row][1]);
                pstmt.executeUpdate();
                ++row;
            }
            ResultSet rs = stmt.executeQuery("select F1,F2 from TEST");
            int rowCounter = 0;
            while (rs.next()) {
                int f1 = rs.getInt("F1");
                int f2 = rs.getInt("F2");
                if (f1 != mTestData[rowCounter][0]) {
                    String message = "Database value differs from original value";
                    TestCase.addGlobalMessage((String)"Prepare", (char)'E', (String)(String.valueOf(message) + " " + Integer.toString(f1) + "(" + Integer.toString(mTestData[rowCounter][0]) + ")"));
                    throw new TestCaseException(message);
                }
                if (f2 != mTestData[rowCounter][1]) {
                    String message = "Database value differs from original value";
                    TestCase.addGlobalMessage((String)"Prepare", (char)'E', (String)(String.valueOf(message) + " " + Integer.toString(f2) + "(" + Integer.toString(mTestData[rowCounter][1]) + ")"));
                    throw new TestCaseException(message);
                }
                ++rowCounter;
            }
            con.close();
        }
        catch (Exception e) {
            throw new TestCaseException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Connection con = null;
        TestStatement stmt = null;
        try {
            try {
                con = TestCase.getDatabase().connect(sUser, sPassword);
                stmt = new TestStatement(null, con);
                this.step1((Statement)stmt);
                this.step2((Statement)stmt);
                this.step3((Statement)stmt);
                this.step4((Statement)stmt);
                this.step5((Statement)stmt);
                this.step6((Statement)stmt);
                this.step8((Statement)stmt);
                this.step9((Statement)stmt);
                this.step10((Statement)stmt);
                this.step11((Statement)stmt);
                this.step12((Statement)stmt);
                this.step13((Statement)stmt);
                this.step14((Statement)stmt);
                this.step15((Statement)stmt);
                this.step16((Statement)stmt);
                this.step17((Statement)stmt);
                this.step18((Statement)stmt);
                this.step19((Statement)stmt);
                this.step21((Statement)stmt);
                this.step22((Statement)stmt);
                this.step23((Statement)stmt);
                this.step24((Statement)stmt);
                this.step25((Statement)stmt);
                this.step26((Statement)stmt);
                this.step27((Statement)stmt);
                this.step28((Statement)stmt);
                this.step29((Statement)stmt);
                this.step30((Statement)stmt);
                this.step31((Statement)stmt);
                this.step32((Statement)stmt);
                this.step33((Statement)stmt);
                this.step34((Statement)stmt);
                this.step35((Statement)stmt);
                this.step36((Statement)stmt);
                this.step37((Statement)stmt);
                this.step38((Statement)stmt);
                this.step39((Statement)stmt);
                this.step40((Statement)stmt);
                this.step41((Statement)stmt);
                this.step42((Statement)stmt);
                this.step43((Statement)stmt);
                this.step44((Statement)stmt);
                this.step45((Statement)stmt);
                this.step46((Statement)stmt);
                this.step47((Statement)stmt);
                this.step48((Statement)stmt);
                this.step49((Statement)stmt);
                this.step50((Statement)stmt);
                this.step51((Statement)stmt);
                this.step52((Statement)stmt);
                this.step53((Statement)stmt);
                this.step54((Statement)stmt);
                this.step55((Statement)stmt);
                this.step56((Statement)stmt);
                con.close();
            }
            catch (Exception e) {
                this.handleExceptions(e);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                stmt.close();
                con.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (SQLException sQLException) {
            return;
        }
        stmt.close();
        con.close();
    }

    private void step1(Statement pStmt) {
        try {
            String sql = "select F1+F2 from TEST";
            ResultSet rs = pStmt.executeQuery(sql);
            int rowCounter = 0;
            while (rs.next()) {
                int ref;
                int res = rs.getInt(1);
                if (res != (ref = mTestData[rowCounter][0] + mTestData[rowCounter][1])) {
                    this.addMessage(sql, 'E', "F1+F2 " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
                }
                ++rowCounter;
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step10(Statement pStmt) {
        try {
            String sql = "select SUM(F1) from TEST order by 1";
            ResultSet rs = pStmt.executeQuery(sql);
            while (rs.next()) {
                int res = rs.getInt(1);
                int ref = 0;
                int row = 0;
                while (row < 2 * MAXROW) {
                    ref += mTestData[row][0];
                    ++row;
                }
                if (res == ref) continue;
                this.addMessage(sql, 'E', "SUM(F1) " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step11(Statement pStmt) {
        try {
            String sql = "select DISTINCT SUM(F1) + F2 from TEST group by F2 order by 1";
            ResultSet rs = pStmt.executeQuery(sql);
            int rowCounter = 0;
            while (rs.next()) {
                int res = rs.getInt(1);
                int ref = mTestData[rowCounter][1];
                if (rowCounter < MAXROW) {
                    ref += mTestData[rowCounter][0];
                } else {
                    int row = MAXROW;
                    while (row < 2 * MAXROW) {
                        ref += mTestData[row][0];
                        ++row;
                    }
                }
                if (res != ref) {
                    this.addMessage(sql, 'E', "DISTINCT SUM(F1)+F2 " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
                }
                ++rowCounter;
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step12(Statement pStmt) {
        try {
            String sql = "select DISTINCT SUM(F1+F2) from TEST order by 1";
            ResultSet rs = pStmt.executeQuery(sql);
            while (rs.next()) {
                int res = rs.getInt(1);
                int ref = 0;
                int row = 0;
                while (row < 2 * MAXROW) {
                    int col = 0;
                    while (col < MAXCOL) {
                        ref += mTestData[row][col];
                        ++col;
                    }
                    ++row;
                }
                if (res == ref) continue;
                this.addMessage(sql, 'E', "DISTINCT SUM(F1+F2) " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step13(Statement pStmt) {
        try {
            String sql = "select F1 from TEST where F1 > 0";
            ResultSet rs = pStmt.executeQuery(sql);
            int rowCounter = 0;
            while (rs.next()) {
                int ref;
                int res = rs.getInt(1);
                if (res != (ref = mTestData[rowCounter][0])) {
                    this.addMessage(sql, 'E', "F1 " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
                }
                ++rowCounter;
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step14(Statement pStmt) {
        try {
            String sql = "select F1+F2 from TEST where F1 > 0";
            ResultSet rs = pStmt.executeQuery(sql);
            int rowCounter = 0;
            while (rs.next()) {
                int ref;
                int res = rs.getInt(1);
                if (res != (ref = mTestData[rowCounter][0] + mTestData[rowCounter][1])) {
                    this.addMessage(sql, 'E', "F1+F2 " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
                }
                ++rowCounter;
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step15(Statement pStmt) {
        try {
            String sql = "select SUM(F1) from TEST where F1 > 0";
            ResultSet rs = pStmt.executeQuery(sql);
            while (rs.next()) {
                int res = rs.getInt(1);
                int ref = 0;
                int row = 0;
                while (row < 2 * MAXROW) {
                    ref += mTestData[row][0];
                    ++row;
                }
                if (res == ref) continue;
                this.addMessage(sql, 'E', "SUM(F1) " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step16(Statement pStmt) {
        try {
            String sql = "select SUM(F1)+F2 from TEST where F1 > 0 group by F2";
            ResultSet rs = pStmt.executeQuery(sql);
            int rowCounter = 0;
            while (rs.next()) {
                int res = rs.getInt(1);
                int ref = mTestData[rowCounter][1];
                if (rowCounter < MAXROW) {
                    ref += mTestData[rowCounter][0];
                } else {
                    int row = MAXROW;
                    while (row < 2 * MAXROW) {
                        ref += mTestData[row][0];
                        ++row;
                    }
                }
                if (res != ref) {
                    this.addMessage(sql, 'E', "SUM(F1)+F2 " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
                }
                ++rowCounter;
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step17(Statement pStmt) {
        try {
            String sql = "select SUM(F1+F2) from TEST where F1 > 0";
            ResultSet rs = pStmt.executeQuery(sql);
            while (rs.next()) {
                int res = rs.getInt(1);
                int ref = 0;
                int row = 0;
                while (row < 2 * MAXROW) {
                    int col = 0;
                    while (col < MAXCOL) {
                        ref += mTestData[row][col];
                        ++col;
                    }
                    ++row;
                }
                if (res == ref) continue;
                this.addMessage(sql, 'E', "SUM(F1+F2) " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step18(Statement pStmt) {
        try {
            String sql = "select DISTINCT F1 + F2 from TEST where F1 > 0";
            ResultSet rs = pStmt.executeQuery(sql);
            int rowCounter = 0;
            while (rs.next()) {
                int col;
                int res = rs.getInt(1);
                int ref = 0;
                if (rowCounter < 6) {
                    col = 0;
                    while (col < MAXCOL) {
                        ref += mTestData[rowCounter + 3][col];
                        ++col;
                    }
                } else if (rowCounter == 6) {
                    col = 0;
                    while (col < MAXCOL) {
                        ref += mTestData[0][col];
                        ++col;
                    }
                } else if (rowCounter == 7) {
                    col = 0;
                    while (col < MAXCOL) {
                        ref += mTestData[MAXROW - 1][col];
                        ++col;
                    }
                } else if (rowCounter == 8) {
                    col = 0;
                    while (col < MAXCOL) {
                        ref += mTestData[1][col];
                        ++col;
                    }
                } else if (rowCounter >= 9 && rowCounter < 18) {
                    col = 0;
                    while (col < MAXCOL) {
                        ref += mTestData[rowCounter + 1][col];
                        ++col;
                    }
                } else if (rowCounter == 18) {
                    col = 0;
                    while (col < MAXCOL) {
                        ref += mTestData[2 * MAXROW - 1][col];
                        ++col;
                    }
                } else {
                    col = 0;
                    while (col < MAXCOL) {
                        ref += mTestData[2][col];
                        ++col;
                    }
                }
                if (res != ref) {
                    this.addMessage(Integer.toString(rowCounter), 'E', "DISTINCT F1+F2 " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
                }
                ++rowCounter;
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step19(Statement pStmt) {
        try {
            String sql = "select DISTINCT SUM(F1) from TEST where F1 > 0";
            ResultSet rs = pStmt.executeQuery(sql);
            while (rs.next()) {
                int res = rs.getInt(1);
                int ref = 0;
                int row = 0;
                while (row < 2 * MAXROW) {
                    ref += mTestData[row][0];
                    ++row;
                }
                if (res == ref) continue;
                this.addMessage(sql, 'E', "DISTINCT SUM(F1) " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step2(Statement pStmt) {
        try {
            String sql = "select SUM(F1) from TEST";
            ResultSet rs = pStmt.executeQuery(sql);
            while (rs.next()) {
                int res = rs.getInt(1);
                int ref = 0;
                int row = 0;
                while (row < 2 * MAXROW) {
                    ref += mTestData[row][0];
                    ++row;
                }
                if (res == ref) continue;
                this.addMessage(sql, 'E', "SUM(F1) " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step21(Statement pStmt) {
        try {
            String sql = "select DISTINCT SUM(F1+F2) from TEST where F1 > 0";
            ResultSet rs = pStmt.executeQuery(sql);
            while (rs.next()) {
                int res = rs.getInt(1);
                int ref = 0;
                int row = 0;
                while (row < 2 * MAXROW) {
                    int col = 0;
                    while (col < MAXCOL) {
                        ref += mTestData[row][col];
                        ++col;
                    }
                    ++row;
                }
                if (res == ref) continue;
                this.addMessage(sql, 'E', "DISTINCT SUM(F1+F2) " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step22(Statement pStmt) {
        try {
            String sql = "select F1+F2 from TEST where F1 > 0 order by 1";
            ResultSet rs = pStmt.executeQuery(sql);
            int rowCounter = 0;
            while (rs.next()) {
                int ref;
                int res = rs.getInt(1);
                if (res != (ref = mTestData[rowCounter][0] + mTestData[rowCounter][1])) {
                    this.addMessage(sql, 'E', "F1+F2 " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
                }
                ++rowCounter;
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step23(Statement pStmt) {
        try {
            String sql = "select DISTINCT SUM(F1) from TEST where F1 > 0 order by 1";
            ResultSet rs = pStmt.executeQuery(sql);
            while (rs.next()) {
                int res = rs.getInt(1);
                int ref = 0;
                int row = 0;
                while (row < 2 * MAXROW) {
                    ref += mTestData[row][0];
                    ++row;
                }
                if (res == ref) continue;
                this.addMessage(sql, 'E', "DISTINCT SUM(F1) " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step24(Statement pStmt) {
        try {
            String sql = "select DISTINCT SUM(F1) + F2 from TEST where F1 > 0 group by F2 order by 1";
            ResultSet rs = pStmt.executeQuery(sql);
            int rowCounter = 0;
            while (rs.next()) {
                int res = rs.getInt(1);
                int ref = mTestData[rowCounter][1];
                if (rowCounter < MAXROW) {
                    ref += mTestData[rowCounter][0];
                } else {
                    int row = MAXROW;
                    while (row < 2 * MAXROW) {
                        ref += mTestData[row][0];
                        ++row;
                    }
                }
                if (res != ref) {
                    this.addMessage(sql, 'E', "DISTINCT SUM(F1)+F2 " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
                }
                ++rowCounter;
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step25(Statement pStmt) {
        try {
            String sql = "select DISTINCT SUM(F1+F2) from TEST where F1 > 0 order by 1";
            ResultSet rs = pStmt.executeQuery(sql);
            while (rs.next()) {
                int res = rs.getInt(1);
                int ref = 0;
                int row = 0;
                while (row < 2 * MAXROW) {
                    int col = 0;
                    while (col < MAXCOL) {
                        ref += mTestData[row][col];
                        ++col;
                    }
                    ++row;
                }
                if (res == ref) continue;
                this.addMessage(sql, 'E', "DISTINCT SUM(F1+F2) " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step26(Statement pStmt) {
        try {
            String sql = "select ROWNO, F1 from TEST";
            ResultSet rs = pStmt.executeQuery(sql);
            int rowCounter = 0;
            while (rs.next()) {
                int rowno = rs.getInt(1);
                int res = rs.getInt(2);
                int ref = mTestData[rowCounter][0];
                if (rowno != rowCounter + 1) {
                    this.addMessage(sql, 'E', "ROWNO " + Integer.toString(rowno) + "(" + Integer.toString(rowCounter) + ")");
                }
                if (res != ref) {
                    this.addMessage(sql, 'E', "F1 " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
                }
                ++rowCounter;
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step27(Statement pStmt) {
        try {
            String sql = "select ROWNO, F1+F2 from TEST";
            ResultSet rs = pStmt.executeQuery(sql);
            int rowCounter = 0;
            while (rs.next()) {
                int rowno = rs.getInt(1);
                int res = rs.getInt(2);
                int ref = 0;
                int col = 0;
                while (col < MAXCOL) {
                    ref += mTestData[rowCounter][col];
                    ++col;
                }
                if (rowno != rowCounter + 1) {
                    this.addMessage(sql, 'E', "ROWNO " + Integer.toString(rowno) + "(" + Integer.toString(rowCounter) + ")");
                }
                if (res != ref) {
                    this.addMessage(sql, 'E', "F1 " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
                }
                ++rowCounter;
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step28(Statement pStmt) {
        try {
            String sql = "select ROWNO, SUM(F1) from TEST";
            ResultSet rs = pStmt.executeQuery(sql);
            int rowCounter = 0;
            while (rs.next()) {
                int rowno = rs.getInt(1);
                int res = rs.getInt(2);
                int ref = 0;
                int row = 0;
                while (row < 2 * MAXROW) {
                    ref += mTestData[row][0];
                    ++row;
                }
                if (rowno != rowCounter + 1) {
                    this.addMessage(sql, 'E', "ROWNO " + Integer.toString(rowno) + "(" + Integer.toString(rowCounter) + ")");
                }
                if (res != ref) {
                    this.addMessage(sql, 'E', "SUM(F1) " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
                }
                ++rowCounter;
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step29(Statement pStmt) {
        try {
            String sql = "select ROWNO, SUM(F1)+F2 from TEST group by F2";
            ResultSet rs = pStmt.executeQuery(sql);
            int rowCounter = 0;
            while (rs.next()) {
                int rowno = rs.getInt(1);
                int res = rs.getInt(2);
                int ref = mTestData[rowCounter][1];
                if (rowCounter < MAXROW) {
                    ref += mTestData[rowCounter][0];
                } else {
                    int row = MAXROW;
                    while (row < 2 * MAXROW) {
                        ref += mTestData[row][0];
                        ++row;
                    }
                }
                if (rowno != rowCounter + 1) {
                    this.addMessage(sql, 'E', "ROWNO " + Integer.toString(rowno) + "(" + Integer.toString(rowCounter) + ")");
                }
                if (res != ref) {
                    this.addMessage(sql, 'E', "SUM(F1)+F2 " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
                }
                ++rowCounter;
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step3(Statement pStmt) {
        try {
            String sql = "select SUM(F1)+F2 from TEST group by F2";
            ResultSet rs = pStmt.executeQuery(sql);
            int rowCounter = 0;
            while (rs.next()) {
                int res = rs.getInt(1);
                int ref = mTestData[rowCounter][1];
                if (rowCounter < MAXROW) {
                    ref += mTestData[rowCounter][0];
                } else {
                    int row = MAXROW;
                    while (row < 2 * MAXROW) {
                        ref += mTestData[row][0];
                        ++row;
                    }
                }
                if (res != ref) {
                    this.addMessage(sql, 'E', "SUM(F1)+F2 " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
                }
                ++rowCounter;
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step30(Statement pStmt) {
        try {
            String sql = "select ROWNO, SUM(F1+F2) from TEST";
            ResultSet rs = pStmt.executeQuery(sql);
            int rowCounter = 0;
            while (rs.next()) {
                int rowno = rs.getInt(1);
                int res = rs.getInt(2);
                int ref = 0;
                int row = 0;
                while (row < 2 * MAXROW) {
                    int col = 0;
                    while (col < MAXCOL) {
                        ref += mTestData[row][col];
                        ++col;
                    }
                    ++row;
                }
                if (rowno != rowCounter + 1) {
                    this.addMessage(sql, 'E', "ROWNO " + Integer.toString(rowno) + "(" + Integer.toString(rowCounter) + ")");
                }
                if (res != ref) {
                    this.addMessage(sql, 'E', "SUM(F1+F2) " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
                }
                ++rowCounter;
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step31(Statement pStmt) {
        try {
            String sql = "select F1 from TEST where ROWNO < 11";
            ResultSet rs = pStmt.executeQuery(sql);
            int rowCounter = 0;
            while (rs.next()) {
                int ref;
                int res = rs.getInt(1);
                if (res != (ref = mTestData[rowCounter][0])) {
                    this.addMessage(sql, 'E', "F1 " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
                }
                ++rowCounter;
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step32(Statement pStmt) {
        try {
            String sql = "select F1+F2 from TEST where ROWNO < 11";
            ResultSet rs = pStmt.executeQuery(sql);
            int rowCounter = 0;
            while (rs.next()) {
                int res = rs.getInt(1);
                int ref = 0;
                int col = 0;
                while (col < MAXCOL) {
                    ref += mTestData[rowCounter][col];
                    ++col;
                }
                if (res != ref) {
                    this.addMessage(sql, 'E', "F1+F2 " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
                }
                ++rowCounter;
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step33(Statement pStmt) {
        try {
            String sql = "select SUM(F1) from TEST where ROWNO < 11";
            ResultSet rs = pStmt.executeQuery(sql);
            while (rs.next()) {
                int res = rs.getInt(1);
                int ref = 0;
                int row = 0;
                while (row < MAXROW) {
                    ref += mTestData[row][0];
                    ++row;
                }
                if (res == ref) continue;
                this.addMessage(sql, 'E', "SUM(F1) " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step34(Statement pStmt) {
        try {
            String sql = "select SUM(F1)+F2 from TEST where ROWNO < 11 group by F2";
            ResultSet rs = pStmt.executeQuery(sql);
            int rowCounter = 0;
            while (rs.next()) {
                int res = rs.getInt(1);
                int ref = 0;
                int col = 0;
                while (col < MAXCOL) {
                    ref += mTestData[rowCounter][col];
                    ++col;
                }
                if (res != ref) {
                    this.addMessage(sql, 'E', "SUM(F1)+F2 " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
                }
                ++rowCounter;
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step35(Statement pStmt) {
        try {
            String sql = "select SUM(F1+F2) from TEST where ROWNO < 11";
            ResultSet rs = pStmt.executeQuery(sql);
            while (rs.next()) {
                int res = rs.getInt(1);
                int ref = 0;
                int row = 0;
                while (row < MAXROW) {
                    int col = 0;
                    while (col < MAXCOL) {
                        ref += mTestData[row][col];
                        ++col;
                    }
                    ++row;
                }
                if (res == ref) continue;
                this.addMessage(sql, 'E', "SUM(F1+F2) " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step36(Statement pStmt) {
        try {
            String sql = "select SUM(F1) from TEST group by F1 having F1 > 10";
            ResultSet rs = pStmt.executeQuery(sql);
            int rowCounter = 0;
            while (rs.next()) {
                int ref;
                int res = rs.getInt(1);
                if (res != (ref = mTestData[rowCounter + MAXROW][0])) {
                    this.addMessage(sql, 'E', "SUM(F1) " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
                }
                ++rowCounter;
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step37(Statement pStmt) {
        try {
            String sql = "select SUM(F1)+F2 from TEST group by F1,F2 having F1 > 10";
            ResultSet rs = pStmt.executeQuery(sql);
            int rowCounter = 0;
            while (rs.next()) {
                int res = rs.getInt(1);
                int ref = 0;
                int col = 0;
                while (col < MAXCOL) {
                    ref += mTestData[rowCounter + MAXROW][col];
                    ++col;
                }
                if (res != ref) {
                    this.addMessage(sql, 'E', "SUM(F1)+F2 " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
                }
                ++rowCounter;
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step38(Statement pStmt) {
        try {
            String sql = "select SUM(F1+F2) from TEST group by F1 having F1 > 10";
            ResultSet rs = pStmt.executeQuery(sql);
            int rowCounter = 0;
            while (rs.next()) {
                int res = rs.getInt(1);
                int ref = 0;
                int col = 0;
                while (col < MAXCOL) {
                    ref += mTestData[rowCounter + MAXROW][col];
                    ++col;
                }
                if (res != ref) {
                    this.addMessage(sql, 'E', "SUM(F1+F2) " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
                }
                ++rowCounter;
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step39(Statement pStmt) {
        try {
            String sql = "select F1+F2 from TEST group by F1,F2 having F1+F2 > 60";
            ResultSet rs = pStmt.executeQuery(sql);
            int rowCounter = 0;
            while (rs.next()) {
                int res = rs.getInt(1);
                int ref = 0;
                int col = 0;
                while (col < MAXCOL) {
                    ref += mTestData[rowCounter + MAXROW][col];
                    ++col;
                }
                if (res != ref) {
                    this.addMessage(sql, 'E', "F1+F2 " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
                }
                ++rowCounter;
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step4(Statement pStmt) {
        try {
            String sql = "select SUM(F1+F2) from TEST";
            ResultSet rs = pStmt.executeQuery(sql);
            while (rs.next()) {
                int res = rs.getInt(1);
                int ref = 0;
                int row = 0;
                while (row < 2 * MAXROW) {
                    int col = 0;
                    while (col < MAXCOL) {
                        ref += mTestData[row][col];
                        ++col;
                    }
                    ++row;
                }
                if (res == ref) continue;
                this.addMessage(sql, 'E', "SUM(F1+F2) " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step40(Statement pStmt) {
        try {
            String sql = "select SUM(F1) from TEST group by F1,F2 having F1+F2 > 60";
            ResultSet rs = pStmt.executeQuery(sql);
            int rowCounter = 0;
            while (rs.next()) {
                int ref;
                int res = rs.getInt(1);
                if (res != (ref = mTestData[rowCounter + MAXROW][0])) {
                    this.addMessage(sql, 'E', "SUM(F1) " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
                }
                ++rowCounter;
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step41(Statement pStmt) {
        try {
            String sql = "select SUM(F1)+F2 from TEST group by F1,F2 having F1+F2 > 60";
            ResultSet rs = pStmt.executeQuery(sql);
            int rowCounter = 0;
            while (rs.next()) {
                int res = rs.getInt(1);
                int ref = 0;
                int col = 0;
                while (col < MAXCOL) {
                    ref += mTestData[rowCounter + MAXROW][col];
                    ++col;
                }
                if (res != ref) {
                    this.addMessage(sql, 'E', "SUM(F1)+F2 " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
                }
                ++rowCounter;
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step42(Statement pStmt) {
        try {
            String sql = "select SUM(F1+F2) from TEST group by F1,F2 having F1+F2 > 60";
            ResultSet rs = pStmt.executeQuery(sql);
            int rowCounter = 0;
            while (rs.next()) {
                int res = rs.getInt(1);
                int ref = 0;
                int col = 0;
                while (col < MAXCOL) {
                    ref += mTestData[rowCounter + MAXROW][col];
                    ++col;
                }
                if (res != ref) {
                    this.addMessage(sql, 'E', "SUM(F1+F2) " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
                }
                ++rowCounter;
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step43(Statement pStmt) {
        try {
            String sql = "select F1 from TEST group by F1,F2 having SUM(F1) > 10";
            ResultSet rs = pStmt.executeQuery(sql);
            int rowCounter = 0;
            while (rs.next()) {
                int ref;
                int res = rs.getInt(1);
                if (res != (ref = mTestData[rowCounter + MAXROW][0])) {
                    this.addMessage(sql, 'E', "SUM(F1) " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
                }
                ++rowCounter;
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step44(Statement pStmt) {
        try {
            String sql = "select SUM(F1) from TEST group by F1 having SUM(F1) > 10";
            ResultSet rs = pStmt.executeQuery(sql);
            int rowCounter = 0;
            while (rs.next()) {
                int ref;
                int res = rs.getInt(1);
                if (res != (ref = mTestData[rowCounter + MAXROW][0])) {
                    this.addMessage(sql, 'E', "SUM(F1) " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
                }
                ++rowCounter;
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step45(Statement pStmt) {
        try {
            String sql = "select SUM(F1)+F2 from TEST group by F1,F2 having SUM(F1) > 10";
            ResultSet rs = pStmt.executeQuery(sql);
            int rowCounter = 0;
            while (rs.next()) {
                int res = rs.getInt(1);
                int ref = 0;
                int col = 0;
                while (col < MAXCOL) {
                    ref += mTestData[rowCounter + MAXROW][col];
                    ++col;
                }
                if (res != ref) {
                    this.addMessage(sql, 'E', "SUM(F1)+F2 " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
                }
                ++rowCounter;
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step46(Statement pStmt) {
        try {
            String sql = "select SUM(F1+F2) from TEST group by F1 having SUM(F1) > 10";
            ResultSet rs = pStmt.executeQuery(sql);
            int rowCounter = 0;
            while (rs.next()) {
                int res = rs.getInt(1);
                int ref = 0;
                int col = 0;
                while (col < MAXCOL) {
                    ref += mTestData[rowCounter + MAXROW][col];
                    ++col;
                }
                if (res != ref) {
                    this.addMessage(sql, 'E', "SUM(F1+F2) " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
                }
                ++rowCounter;
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step47(Statement pStmt) {
        try {
            String sql = "select F1 from TEST group by F1,F2 having SUM(F1)+F2 > 60";
            ResultSet rs = pStmt.executeQuery(sql);
            int rowCounter = 0;
            while (rs.next()) {
                int ref;
                int res = rs.getInt(1);
                if (res != (ref = mTestData[rowCounter + MAXROW][0])) {
                    this.addMessage(sql, 'E', "F1 " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
                }
                ++rowCounter;
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step48(Statement pStmt) {
        try {
            String sql = "select F1+F2 from TEST group by F1,F2 having SUM(F1)+F2 > 60";
            ResultSet rs = pStmt.executeQuery(sql);
            int rowCounter = 0;
            while (rs.next()) {
                int res = rs.getInt(1);
                int ref = 0;
                int col = 0;
                while (col < MAXCOL) {
                    ref += mTestData[rowCounter + MAXROW][col];
                    ++col;
                }
                if (res != ref) {
                    this.addMessage(sql, 'E', "F1+F2 " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
                }
                ++rowCounter;
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step49(Statement pStmt) {
        try {
            String sql = "select SUM(F1) from TEST group by F1,F2 having SUM(F1)+F2 > 60";
            ResultSet rs = pStmt.executeQuery(sql);
            int rowCounter = 0;
            while (rs.next()) {
                int ref;
                int res = rs.getInt(1);
                if (res != (ref = mTestData[rowCounter + MAXROW][0])) {
                    this.addMessage(sql, 'E', "SUM(F1) " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
                }
                ++rowCounter;
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step5(Statement pStmt) {
        try {
            String sql = "select DISTINCT F1 + F2 from TEST";
            ResultSet rs = pStmt.executeQuery(sql);
            int rowCounter = 0;
            while (rs.next()) {
                int col;
                int res = rs.getInt(1);
                int ref = 0;
                if (rowCounter < 6) {
                    col = 0;
                    while (col < MAXCOL) {
                        ref += mTestData[rowCounter + 3][col];
                        ++col;
                    }
                } else if (rowCounter == 6) {
                    col = 0;
                    while (col < MAXCOL) {
                        ref += mTestData[0][col];
                        ++col;
                    }
                } else if (rowCounter == 7) {
                    col = 0;
                    while (col < MAXCOL) {
                        ref += mTestData[MAXROW - 1][col];
                        ++col;
                    }
                } else if (rowCounter == 8) {
                    col = 0;
                    while (col < MAXCOL) {
                        ref += mTestData[1][col];
                        ++col;
                    }
                } else if (rowCounter >= 9 && rowCounter < 18) {
                    col = 0;
                    while (col < MAXCOL) {
                        ref += mTestData[rowCounter + 1][col];
                        ++col;
                    }
                } else if (rowCounter == 18) {
                    col = 0;
                    while (col < MAXCOL) {
                        ref += mTestData[2 * MAXROW - 1][col];
                        ++col;
                    }
                } else {
                    col = 0;
                    while (col < MAXCOL) {
                        ref += mTestData[2][col];
                        ++col;
                    }
                }
                if (res != ref) {
                    this.addMessage(Integer.toString(rowCounter), 'E', "DISTINCT F1+F2 " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
                }
                ++rowCounter;
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step50(Statement pStmt) {
        try {
            String sql = "select SUM(F1)+F2 from TEST group by F1,F2 having SUM(F1)+F2 > 60";
            ResultSet rs = pStmt.executeQuery(sql);
            int rowCounter = 0;
            while (rs.next()) {
                int res = rs.getInt(1);
                int ref = 0;
                int col = 0;
                while (col < MAXCOL) {
                    ref += mTestData[rowCounter + MAXROW][col];
                    ++col;
                }
                if (res != ref) {
                    this.addMessage(sql, 'E', "SUM(F1)+F2 " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
                }
                ++rowCounter;
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step51(Statement pStmt) {
        try {
            String sql = "select SUM(F1+F2) from TEST group by F1,F2 having SUM(F1)+F2 > 60";
            ResultSet rs = pStmt.executeQuery(sql);
            int rowCounter = 0;
            while (rs.next()) {
                int res = rs.getInt(1);
                int ref = 0;
                int col = 0;
                while (col < MAXCOL) {
                    ref += mTestData[rowCounter + MAXROW][col];
                    ++col;
                }
                if (res != ref) {
                    this.addMessage(sql, 'E', "SUM(F1+F2) " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
                }
                ++rowCounter;
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step52(Statement pStmt) {
        try {
            String sql = "select F1 from TEST group by F1 having SUM(F1+F2) > 60";
            ResultSet rs = pStmt.executeQuery(sql);
            int rowCounter = 0;
            while (rs.next()) {
                int ref;
                int res = rs.getInt(1);
                if (res != (ref = mTestData[rowCounter + MAXROW][0])) {
                    this.addMessage(sql, 'E', "F1 " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
                }
                ++rowCounter;
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step53(Statement pStmt) {
        try {
            String sql = "select F1+F2 from TEST group by F1,F2 having SUM(F1+F2) > 60";
            ResultSet rs = pStmt.executeQuery(sql);
            int rowCounter = 0;
            while (rs.next()) {
                int res = rs.getInt(1);
                int ref = 0;
                int col = 0;
                while (col < MAXCOL) {
                    ref += mTestData[rowCounter + MAXROW][col];
                    ++col;
                }
                if (res != ref) {
                    this.addMessage(sql, 'E', "F1+F2 " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
                }
                ++rowCounter;
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step54(Statement pStmt) {
        try {
            String sql = "select SUM(F1) from TEST group by F1,F2 having SUM(F1+F2) > 60";
            ResultSet rs = pStmt.executeQuery(sql);
            int rowCounter = 0;
            while (rs.next()) {
                int ref;
                int res = rs.getInt(1);
                if (res != (ref = mTestData[rowCounter + MAXROW][0])) {
                    this.addMessage(sql, 'E', "SUM(F1) " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
                }
                ++rowCounter;
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step55(Statement pStmt) {
        try {
            String sql = "select SUM(F1)+F2 from TEST group by F2 having SUM(F1+F2) > 60";
            ResultSet rs = pStmt.executeQuery(sql);
            while (rs.next()) {
                int res = rs.getInt(1);
                int ref = mTestData[MAXROW][1];
                int row = MAXROW;
                while (row < 2 * MAXROW) {
                    ref += mTestData[row][0];
                    ++row;
                }
                if (res == ref) continue;
                this.addMessage(sql, 'E', "SUM(F1)+F2 " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step56(Statement pStmt) {
        try {
            String sql = "select SUM(F1+F2) from TEST group by F2 having SUM(F1+F2) > 60";
            ResultSet rs = pStmt.executeQuery(sql);
            int rowCounter = 0;
            while (rs.next()) {
                int res = rs.getInt(1);
                int ref = 0;
                int row = MAXROW;
                while (row < 2 * MAXROW) {
                    int col = 0;
                    while (col < MAXCOL) {
                        ref += mTestData[row][col];
                        ++col;
                    }
                    ++row;
                }
                if (res != ref) {
                    this.addMessage(sql, 'E', "SUM(F1+F2) " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
                }
                ++rowCounter;
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step6(Statement pStmt) {
        try {
            String sql = "select DISTINCT SUM(F1) from TEST";
            ResultSet rs = pStmt.executeQuery(sql);
            while (rs.next()) {
                int res = rs.getInt(1);
                int ref = 0;
                int row = 0;
                while (row < 2 * MAXROW) {
                    ref += mTestData[row][0];
                    ++row;
                }
                if (res == ref) continue;
                this.addMessage(sql, 'E', "DISTINCT SUM(F1) " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step8(Statement pStmt) {
        try {
            String sql = "select DISTINCT SUM(F1+F2) from TEST";
            ResultSet rs = pStmt.executeQuery(sql);
            while (rs.next()) {
                int res = rs.getInt(1);
                int ref = 0;
                int row = 0;
                while (row < 2 * MAXROW) {
                    int col = 0;
                    while (col < MAXCOL) {
                        ref += mTestData[row][col];
                        ++col;
                    }
                    ++row;
                }
                if (res == ref) continue;
                this.addMessage(sql, 'E', "DISTINCT SUM(F1+F2) " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private void step9(Statement pStmt) {
        try {
            String sql = "select F1+F2 from TEST order by 1";
            ResultSet rs = pStmt.executeQuery(sql);
            int rowCounter = 0;
            while (rs.next()) {
                int ref;
                int res = rs.getInt(1);
                if (res != (ref = mTestData[rowCounter][0] + mTestData[rowCounter][1])) {
                    this.addMessage(sql, 'E', "F1+F2 " + Integer.toString(res) + "(" + Integer.toString(ref) + ")");
                }
                ++rowCounter;
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }
}

