/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

public class SuballocatedIntVector {
    protected int m_blocksize;
    protected int m_numblocks = 32;
    protected int[][] m_map;
    protected int m_firstFree = 0;
    protected int[] m_map0;

    public SuballocatedIntVector() {
        this(2048);
    }

    public SuballocatedIntVector(int blocksize) {
        this.m_blocksize = blocksize;
        this.m_map0 = new int[blocksize];
        this.m_map = new int[this.m_numblocks][];
        this.m_map[0] = this.m_map0;
    }

    public SuballocatedIntVector(int blocksize, int increaseSize) {
        this(blocksize);
    }

    public int size() {
        return this.m_firstFree;
    }

    private void setSize(int sz) {
        if (this.m_firstFree < sz) {
            this.m_firstFree = sz;
        }
    }

    public void addElement(int value) {
        if (this.m_firstFree < this.m_blocksize) {
            this.m_map0[this.m_firstFree++] = value;
        } else {
            int[] block;
            int index = this.m_firstFree / this.m_blocksize;
            int offset = this.m_firstFree % this.m_blocksize;
            if (index >= this.m_map.length) {
                int newsize = index + this.m_numblocks;
                int[][] newMap = new int[newsize][];
                System.arraycopy(this.m_map, 0, newMap, 0, this.m_map.length);
                this.m_map = newMap;
            }
            if (null == (block = this.m_map[index])) {
                this.m_map[index] = new int[this.m_blocksize];
                block = this.m_map[index];
            }
            block[offset] = value;
            ++this.m_firstFree;
        }
    }

    private void addElements(int value, int numberOfElements) {
        if (this.m_firstFree + numberOfElements < this.m_blocksize) {
            int i = 0;
            while (i < numberOfElements) {
                this.m_map0[this.m_firstFree++] = value;
                ++i;
            }
        } else {
            int index = this.m_firstFree / this.m_blocksize;
            int offset = this.m_firstFree % this.m_blocksize;
            this.m_firstFree += numberOfElements;
            while (numberOfElements > 0) {
                int[] block;
                if (index >= this.m_map.length) {
                    int newsize = index + this.m_numblocks;
                    int[][] newMap = new int[newsize][];
                    System.arraycopy(this.m_map, 0, newMap, 0, this.m_map.length);
                    this.m_map = newMap;
                }
                if (null == (block = this.m_map[index])) {
                    this.m_map[index] = new int[this.m_blocksize];
                    block = this.m_map[index];
                }
                int copied = this.m_blocksize - offset < numberOfElements ? this.m_blocksize - offset : numberOfElements;
                numberOfElements -= copied;
                while (copied-- > 0) {
                    block[offset++] = value;
                }
                ++index;
                offset = 0;
            }
        }
    }

    private void addElements(int numberOfElements) {
        int newlen = this.m_firstFree + numberOfElements;
        if (newlen > this.m_blocksize) {
            int index = this.m_firstFree % this.m_blocksize;
            int newindex = (this.m_firstFree + numberOfElements) % this.m_blocksize;
            int i = index + 1;
            while (i <= newindex) {
                this.m_map[i] = new int[this.m_blocksize];
                ++i;
            }
        }
        this.m_firstFree = newlen;
    }

    private void insertElementAt(int value, int at) {
        if (at == this.m_firstFree) {
            this.addElement(value);
        } else if (at > this.m_firstFree) {
            int[] block;
            int index = at / this.m_blocksize;
            if (index >= this.m_map.length) {
                int newsize = index + this.m_numblocks;
                int[][] newMap = new int[newsize][];
                System.arraycopy(this.m_map, 0, newMap, 0, this.m_map.length);
                this.m_map = newMap;
            }
            if (null == (block = this.m_map[index])) {
                this.m_map[index] = new int[this.m_blocksize];
                block = this.m_map[index];
            }
            int offset = at % this.m_blocksize;
            block[offset] = value;
            this.m_firstFree = offset + 1;
        } else {
            int index = at / this.m_blocksize;
            int maxindex = this.m_firstFree / this.m_blocksize;
            ++this.m_firstFree;
            int offset = at % this.m_blocksize;
            while (index <= maxindex) {
                int push;
                int copylen = this.m_blocksize - offset - 1;
                int[] block = this.m_map[index];
                if (null == block) {
                    push = 0;
                    this.m_map[index] = new int[this.m_blocksize];
                    block = this.m_map[index];
                } else {
                    push = block[this.m_blocksize - 1];
                    System.arraycopy(block, offset, block, offset + 1, copylen);
                }
                block[offset] = value;
                value = push;
                offset = 0;
                ++index;
            }
        }
    }

    public void removeAllElements() {
        this.m_firstFree = 0;
    }

    private boolean removeElement(int s) {
        int at = this.indexOf(s, 0);
        if (at < 0) {
            return false;
        }
        this.removeElementAt(at);
        return true;
    }

    private void removeElementAt(int at) {
        if (at < this.m_firstFree) {
            int index = at / this.m_blocksize;
            int maxindex = this.m_firstFree / this.m_blocksize;
            int offset = at % this.m_blocksize;
            while (index <= maxindex) {
                int copylen = this.m_blocksize - offset - 1;
                int[] block = this.m_map[index];
                if (null == block) {
                    this.m_map[index] = new int[this.m_blocksize];
                    block = this.m_map[index];
                } else {
                    System.arraycopy(block, offset + 1, block, offset, copylen);
                }
                if (index < maxindex) {
                    int[] next = this.m_map[index + 1];
                    if (next != null) {
                        block[this.m_blocksize - 1] = next != null ? next[0] : 0;
                    }
                } else {
                    block[this.m_blocksize - 1] = 0;
                }
                offset = 0;
                ++index;
            }
        }
        --this.m_firstFree;
    }

    public void setElementAt(int value, int at) {
        if (at < this.m_blocksize) {
            this.m_map0[at] = value;
        } else {
            int[] block;
            int index = at / this.m_blocksize;
            int offset = at % this.m_blocksize;
            if (index >= this.m_map.length) {
                int newsize = index + this.m_numblocks;
                int[][] newMap = new int[newsize][];
                System.arraycopy(this.m_map, 0, newMap, 0, this.m_map.length);
                this.m_map = newMap;
            }
            if (null == (block = this.m_map[index])) {
                this.m_map[index] = new int[this.m_blocksize];
                block = this.m_map[index];
            }
            block[offset] = value;
        }
        if (at >= this.m_firstFree) {
            this.m_firstFree = at + 1;
        }
    }

    public int elementAt(int i) {
        if (i < this.m_blocksize) {
            return this.m_map0[i];
        }
        return this.m_map[i / this.m_blocksize][i % this.m_blocksize];
    }

    private boolean contains(int s) {
        return this.indexOf(s, 0) >= 0;
    }

    public int indexOf(int elem, int index) {
        int[] block;
        if (index >= this.m_firstFree) {
            return -1;
        }
        int bindex = index / this.m_blocksize;
        int boffset = index % this.m_blocksize;
        int maxindex = this.m_firstFree / this.m_blocksize;
        while (bindex < maxindex) {
            block = this.m_map[bindex];
            if (block != null) {
                int offset = boffset;
                while (offset < this.m_blocksize) {
                    if (block[offset] == elem) {
                        return offset + bindex * this.m_blocksize;
                    }
                    ++offset;
                }
            }
            boffset = 0;
            ++bindex;
        }
        int maxoffset = this.m_firstFree % this.m_blocksize;
        block = this.m_map[maxindex];
        int offset = boffset;
        while (offset < maxoffset) {
            if (block[offset] == elem) {
                return offset + maxindex * this.m_blocksize;
            }
            ++offset;
        }
        return -1;
    }

    public int indexOf(int elem) {
        return this.indexOf(elem, 0);
    }

    private int lastIndexOf(int elem) {
        int boffset = this.m_firstFree % this.m_blocksize;
        int index = this.m_firstFree / this.m_blocksize;
        while (index >= 0) {
            int[] block = this.m_map[index];
            if (block != null) {
                int offset = boffset;
                while (offset >= 0) {
                    if (block[offset] == elem) {
                        return offset + index * this.m_blocksize;
                    }
                    --offset;
                }
            }
            boffset = 0;
            --index;
        }
        return -1;
    }
}

