/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import java.util.Enumeration;
import java.util.Stack;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.transformer.CountersTable;
import org.apache.xalan.transformer.ResultTreeHandler;
import org.apache.xalan.transformer.TransformSnapshot;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.utils.BoolStack;
import org.apache.xml.utils.NamespaceSupport2;
import org.apache.xml.utils.NodeVector;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.VariableStack;
import org.apache.xpath.XPathContext;
import org.xml.sax.helpers.NamespaceSupport;

class TransformSnapshotImpl
implements TransformSnapshot {
    private VariableStack m_variableStacks;
    private int[] m_currentNodes;
    private int[] m_currentExpressionNodes;
    private Stack m_contextNodeLists;
    private DTMIterator m_contextNodeList;
    private Stack m_axesIteratorStack;
    private BoolStack m_currentTemplateRuleIsNull;
    private ElemTemplateElement[] m_currentTemplateElements;
    private Stack m_currentMatchTemplates;
    private NodeVector m_currentMatchNodes;
    private CountersTable m_countersTable;
    private Stack m_attrSetStack;
    boolean m_nsContextPushed;
    private NamespaceSupport m_nsSupport;
    int m_eventCount;

    TransformSnapshotImpl(TransformerImpl transformer) {
        try {
            ResultTreeHandler rtf = transformer.getResultTreeHandler();
            this.m_eventCount = rtf.m_eventCount;
            this.m_nsSupport = new NamespaceSupport2();
            Enumeration prefixes = rtf.m_nsSupport.getPrefixes();
            while (prefixes.hasMoreElements()) {
                String prefix = (String)prefixes.nextElement();
                String uri = rtf.m_nsSupport.getURI(prefix);
                this.m_nsSupport.declarePrefix(prefix, uri);
            }
            this.m_nsContextPushed = rtf.m_nsContextPushed;
            XPathContext xpc = transformer.getXPathContext();
            this.m_variableStacks = (VariableStack)xpc.getVarStack().clone();
            this.m_currentNodes = (int[])xpc.getCurrentNodeStack().clone();
            this.m_currentExpressionNodes = (int[])xpc.getCurrentExpressionNodeStack().clone();
            this.m_contextNodeLists = (Stack)xpc.getContextNodeListsStack().clone();
            if (!this.m_contextNodeLists.empty()) {
                this.m_contextNodeList = (DTMIterator)xpc.getContextNodeList().clone();
            }
            this.m_axesIteratorStack = (Stack)xpc.getAxesIteratorStackStacks().clone();
            this.m_currentTemplateRuleIsNull = (BoolStack)transformer.m_currentTemplateRuleIsNull.clone();
            this.m_currentTemplateElements = (ElemTemplateElement[])transformer.m_currentTemplateElements.clone();
            this.m_currentMatchTemplates = (Stack)transformer.m_currentMatchTemplates.clone();
            this.m_currentMatchNodes = (NodeVector)transformer.m_currentMatchedNodes.clone();
            this.m_countersTable = (CountersTable)transformer.getCountersTable().clone();
            if (transformer.m_attrSetStack != null) {
                this.m_attrSetStack = (Stack)transformer.m_attrSetStack.clone();
            }
        }
        catch (CloneNotSupportedException cnse) {
            throw new WrappedRuntimeException(cnse);
        }
    }

    void apply(TransformerImpl transformer) {
        try {
            ResultTreeHandler rtf = transformer.getResultTreeHandler();
            if (rtf != null) {
                rtf.m_eventCount = 1;
                rtf.m_nsSupport = new NamespaceSupport();
                Enumeration prefixes = this.m_nsSupport.getPrefixes();
                while (prefixes.hasMoreElements()) {
                    String prefix = (String)prefixes.nextElement();
                    String uri = this.m_nsSupport.getURI(prefix);
                    rtf.m_nsSupport.declarePrefix(prefix, uri);
                }
                rtf.m_nsContextPushed = this.m_nsContextPushed;
            }
            XPathContext xpc = transformer.getXPathContext();
            xpc.setVarStack((VariableStack)this.m_variableStacks.clone());
            xpc.setCurrentNodeStack((int[])this.m_currentNodes.clone());
            xpc.setCurrentExpressionNodeStack((int[])this.m_currentExpressionNodes.clone());
            xpc.setContextNodeListsStack((Stack)this.m_contextNodeLists.clone());
            if (this.m_contextNodeList != null) {
                xpc.pushContextNodeList((DTMIterator)this.m_contextNodeList.clone());
            }
            xpc.setAxesIteratorStackStacks((Stack)this.m_axesIteratorStack.clone());
            transformer.m_currentTemplateRuleIsNull = (BoolStack)this.m_currentTemplateRuleIsNull.clone();
            transformer.m_currentTemplateElements = (ElemTemplateElement[])this.m_currentTemplateElements.clone();
            transformer.m_currentMatchTemplates = (Stack)this.m_currentMatchTemplates.clone();
            transformer.m_currentMatchedNodes = (NodeVector)this.m_currentMatchNodes.clone();
            transformer.m_countersTable = (CountersTable)this.m_countersTable.clone();
            if (this.m_attrSetStack != null) {
                transformer.m_attrSetStack = (Stack)this.m_attrSetStack.clone();
            }
        }
        catch (CloneNotSupportedException cnse) {
            throw new WrappedRuntimeException(cnse);
        }
    }
}

