/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.triggerMinDB;

import com.sap.sdb.minDB.triggerInterface.Trigger;
import com.sap.sdb.minDB.triggerInterface.TriggerConnection;
import com.sap.sdb.minDB.triggerInterface.TriggerImageSet;
import com.sap.sdb.minDB.triggerInterface.TriggerParamSet;
import com.sap.sdb.syncMan.triggerMinDB.ClientTrigger;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;

public class ClientInsertTrigger
extends ClientTrigger
implements Trigger {
    private static final String PARAM_ROW_CREATOR = "ROW_CREATOR";
    private static final String STMT_INSERT_SHADOW_TAB = "insertShadowTab";
    private static final String STMT_INSERT_VERSION_TAB = "insertVersionTab";

    public void executeTrigger(TriggerConnection connection, HashMap prepStmtMap, TriggerParamSet param, TriggerImageSet image) throws SQLException {
        try {
            String rowVersion;
            String syncUser = param.getString("SYNCMAN_USER");
            String syncSchema = param.getString("SYNCMAN_SCHEMA");
            if (connection.getUsername().equals(syncUser)) {
                return;
            }
            int colCount = param.getInt("COLUMN_COUNT");
            int keyCount = param.getInt("KEY_COUNT");
            String rowCreator = param.getString(PARAM_ROW_CREATOR);
            String transID = Long.toString(connection.getTransactionID());
            String sequenceNo = rowVersion = super.getNextSequenceNo(connection, param, syncSchema);
            PreparedStatement insShadowStmt = (PreparedStatement)prepStmtMap.get(STMT_INSERT_SHADOW_TAB);
            if (insShadowStmt == null) {
                insShadowStmt = this.prepareShadowTableInsert(connection, param, syncSchema, colCount);
                prepStmtMap.put(STMT_INSERT_SHADOW_TAB, insShadowStmt);
            }
            this.setShadowTableColumnValues(insShadowStmt, param, image, colCount);
            insShadowStmt.setString(colCount + 1, transID);
            insShadowStmt.setString(colCount + 2, sequenceNo);
            insShadowStmt.setString(colCount + 3, rowCreator);
            insShadowStmt.setString(colCount + 4, rowVersion);
            insShadowStmt.setString(colCount + 5, rowCreator);
            insShadowStmt.executeUpdate();
            insShadowStmt = null;
            PreparedStatement insVersionStmt = (PreparedStatement)prepStmtMap.get(STMT_INSERT_VERSION_TAB);
            if (insVersionStmt == null) {
                insVersionStmt = this.prepareVersionTableInsert(connection, param, syncSchema, keyCount);
                prepStmtMap.put(STMT_INSERT_VERSION_TAB, insVersionStmt);
            }
            for (int i = 1; i <= keyCount; ++i) {
                int colIndex = image.findColumn(param.getString("KEY" + i));
                insVersionStmt.setString(i, image.getNewString(colIndex));
            }
            insVersionStmt.setString(keyCount + 1, rowCreator);
            insVersionStmt.setString(keyCount + 2, rowVersion);
            insVersionStmt.setString(keyCount + 3, rowCreator);
            insVersionStmt.executeUpdate();
            insVersionStmt = null;
            this.insertIntoTransList(connection, prepStmtMap, image, syncSchema, transID, sequenceNo);
        }
        catch (SQLException ex) {
            if (connection.isVerboseTrigger()) {
                connection.printStackTrace((Exception)ex);
            }
            throw ex;
        }
    }

    private PreparedStatement prepareShadowTableInsert(TriggerConnection connection, TriggerParamSet param, String syncSchema, int colCount) throws SQLException {
        String colParameters = "";
        for (int i = 0; i < colCount; ++i) {
            colParameters = colParameters + " ?,";
        }
        String sql = "INSERT INTO " + syncSchema + "." + param.getString("SHADOW_TABLE") + " VALUES (" + colParameters + " ?, ?," + " 0, NULL," + " ?, ?, ?," + " '-1')";
        if (connection.isVerboseTrigger()) {
            connection.println(sql);
        }
        return connection.prepareStatement(sql);
    }

    private PreparedStatement prepareVersionTableInsert(TriggerConnection connection, TriggerParamSet param, String syncSchema, int keyCount) throws SQLException {
        String keyParameters = "";
        for (int i = 0; i < keyCount; ++i) {
            keyParameters = keyParameters + "?, ";
        }
        String sql = "INSERT INTO " + syncSchema + "." + param.getString("VERSION_TABLE") + " VALUES (" + keyParameters + " ?, ?, ?," + " '-1')";
        if (connection.isVerboseTrigger()) {
            connection.println(sql);
        }
        return connection.prepareStatement(sql);
    }

    private void setShadowTableColumnValues(PreparedStatement prepStmt, TriggerParamSet param, TriggerImageSet image, int colCount) throws SQLException {
        block7: for (int i = 1; i <= colCount; ++i) {
            int colIndex = image.findColumn(param.getString("COL" + i));
            int colType = image.getColumnType(colIndex);
            if (image.isNewNull(colIndex)) {
                prepStmt.setNull(i, colType);
                continue;
            }
            switch (colType) {
                case -2: 
                case 2004: {
                    prepStmt.setBytes(i, image.getNewBytes(colIndex));
                    continue block7;
                }
                case 1: 
                case 2005: {
                    prepStmt.setString(i, image.getNewString(colIndex));
                    continue block7;
                }
                case 8: {
                    prepStmt.setDouble(i, image.getNewDouble(colIndex));
                    continue block7;
                }
                case 2: {
                    prepStmt.setLong(i, image.getNewLong(colIndex));
                    continue block7;
                }
                case 2000: {
                    prepStmt.setObject(i, image.getNewObject(colIndex));
                }
            }
        }
    }
}

