/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.message;

import com.sap.sdb.syncMan.capture.CaptureResultRow;
import com.sap.sdb.syncMan.message.SyncManMessage;
import com.sap.sdb.syncMan.util.DebugOutput;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;

public class RowSendMessage
extends SyncManMessage {
    private int m_columnCount;
    private HashMap m_unqualifiedClients;
    private long m_ignoreOneClientID;
    private long m_singleReceiverClientID;
    private ByteArrayOutputStream m_outColByteStream = new ByteArrayOutputStream(512);
    private DataOutputStream m_outColDataStream = new DataOutputStream(this.m_outColByteStream);
    private LinkedList m_colTrace = DebugOutput.isVerboseCaptureMsg() ? new LinkedList() : null;

    RowSendMessage() {
        this.resetSendMessage();
    }

    public void addColumn(long columnID, Object obj) throws SQLException {
        if (this.m_colTrace != null) {
            this.m_colTrace.addLast(new Byte(1));
            this.m_colTrace.addLast(new Long(columnID));
            this.m_colTrace.addLast(obj);
        }
        ++this.m_columnCount;
        try {
            this.m_outColDataStream.writeByte(1);
            this.m_outColDataStream.writeLong(columnID);
            if (obj == null) {
                this.m_outColDataStream.writeInt(0);
                return;
            }
            if (obj instanceof Short) {
                this.m_outColDataStream.writeInt(5);
                this.m_outColDataStream.writeShort(((Short)obj).shortValue());
                return;
            }
            if (obj instanceof Integer) {
                this.m_outColDataStream.writeInt(4);
                this.m_outColDataStream.writeInt((Integer)obj);
                return;
            }
            if (obj instanceof String) {
                this.m_outColDataStream.writeInt(1);
                this.m_outColDataStream.writeUTF((String)obj);
                return;
            }
            this.m_outColDataStream.writeInt(1111);
            this.writeObject(obj);
        }
        catch (IOException ex) {
            throw new SQLException(ex.toString());
        }
    }

    public void addColumn(long columnID, int columnType, CaptureResultRow captureRow, int captureColIndex, byte imageType) throws SQLException {
        if (this.m_colTrace != null) {
            this.m_colTrace.addLast(new Byte(imageType));
            this.m_colTrace.addLast(new Long(columnID));
        }
        ++this.m_columnCount;
        try {
            this.m_outColDataStream.writeByte(imageType);
            this.m_outColDataStream.writeLong(columnID);
            switch (columnType) {
                case 5: {
                    short x = captureRow.getShort(captureColIndex);
                    if (this.writeTypeCheckNotNull(captureRow, columnType)) {
                        this.m_outColDataStream.writeShort(x);
                        if (this.m_colTrace != null) {
                            this.m_colTrace.addLast(new Short(x));
                        }
                    }
                    return;
                }
                case 4: {
                    int x = captureRow.getInt(captureColIndex);
                    if (this.writeTypeCheckNotNull(captureRow, columnType)) {
                        this.m_outColDataStream.writeInt(x);
                        if (this.m_colTrace != null) {
                            this.m_colTrace.addLast(new Integer(x));
                        }
                    }
                    return;
                }
                case 8: {
                    double x = captureRow.getDouble(captureColIndex);
                    if (this.writeTypeCheckNotNull(captureRow, columnType)) {
                        this.m_outColDataStream.writeDouble(x);
                        if (this.m_colTrace != null) {
                            this.m_colTrace.addLast(new Double(x));
                        }
                    }
                    return;
                }
                case -1: 
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 12: {
                    String x = captureRow.getString(captureColIndex);
                    if (this.writeTypeCheckNotNull(captureRow, columnType)) {
                        this.m_outColDataStream.writeUTF(x);
                        if (this.m_colTrace != null) {
                            this.m_colTrace.addLast(x);
                        }
                    }
                    return;
                }
                case -4: 
                case -3: 
                case -2: {
                    byte[] x = captureRow.getBytes(captureColIndex);
                    if (this.writeTypeCheckNotNull(captureRow, columnType)) {
                        this.writeByteArray(x);
                        if (this.m_colTrace != null) {
                            this.m_colTrace.addLast(x);
                        }
                    }
                    return;
                }
            }
            Object x = captureRow.getObject(captureColIndex);
            if (this.writeTypeCheckNotNull(captureRow, columnType)) {
                this.writeObject(x);
                if (this.m_colTrace != null) {
                    this.m_colTrace.addLast(x);
                }
            }
            return;
        }
        catch (IOException ex) {
            throw new SQLException(ex.toString());
        }
    }

    public void addUnqualifiedClient(Long clientUnitID) {
        if (this.m_unqualifiedClients == null) {
            this.m_unqualifiedClients = new HashMap();
        }
        this.m_unqualifiedClients.put(clientUnitID, null);
    }

    public void appendToJMSMessage(Message jmsMsg) throws JMSException {
        BytesMessage jmsBytesMsg = (BytesMessage)jmsMsg;
        super.appendHeaderToJMSMessage(jmsBytesMsg);
        this.serialize(jmsBytesMsg);
    }

    public boolean buildJMSMessage(Message jmsMsg) throws JMSException {
        BytesMessage jmsBytesMsg = (BytesMessage)jmsMsg;
        super.initJMSMessage(jmsBytesMsg, 1);
        this.serialize(jmsBytesMsg);
        boolean sendToAll = true;
        if (this.m_ignoreOneClientID != -1L) {
            String unqualClientProp = "ignoreClientID" + Long.toString(this.m_ignoreOneClientID);
            jmsMsg.setBooleanProperty(unqualClientProp, true);
            sendToAll = false;
        } else if (this.m_unqualifiedClients != null) {
            Iterator iter = this.m_unqualifiedClients.keySet().iterator();
            while (iter.hasNext()) {
                String unqualClientProp = "ignoreClientID" + ((Long)iter.next()).toString();
                jmsMsg.setBooleanProperty(unqualClientProp, true);
                sendToAll = false;
            }
        } else if (this.m_singleReceiverClientID != -1L) {
            jmsMsg.setLongProperty("singleReceiver", this.m_singleReceiverClientID);
            sendToAll = false;
        }
        return sendToAll;
    }

    public int getColumnDataSize() {
        return this.m_outColDataStream == null ? 0 : this.m_outColDataStream.size();
    }

    public int getUnqualifiedClientsCount() {
        return this.m_unqualifiedClients == null ? 0 : this.m_unqualifiedClients.size();
    }

    public void initMultiJMSMessage(Message jmsMsg, int messagesPerJMSMsg) throws JMSException {
        BytesMessage jmsBytesMsg = (BytesMessage)jmsMsg;
        super.initJMSMessage(jmsBytesMsg, messagesPerJMSMsg);
        this.serialize(jmsBytesMsg);
    }

    void printTrace() {
        if (this.m_colTrace == null) {
            return;
        }
        try {
            Iterator iter = this.m_colTrace.iterator();
            for (int i = 1; i <= this.m_columnCount; ++i) {
                String image = (Byte)iter.next() == 1 ? " AFTER " : " BEFORE";
                long id = (Long)iter.next();
                Object obj = iter.next();
                String value = obj == null ? "null" : (obj instanceof String ? (String)obj : (obj instanceof byte[] ? "<byte[" + ((byte[])obj).length + "]>" : obj.toString()));
                DebugOutput.println("   " + i + image + " colID=" + id + ", value=" + value);
            }
            if (this.m_ignoreOneClientID != -1L) {
                DebugOutput.println("   ignoreClientID: " + this.m_ignoreOneClientID);
            }
            if (this.m_unqualifiedClients != null) {
                Iterator clientIter = this.m_unqualifiedClients.keySet().iterator();
                while (clientIter.hasNext()) {
                    DebugOutput.println("   ignoreClientID: " + ((Long)clientIter.next()).toString());
                }
            }
            if (this.m_singleReceiverClientID != -1L) {
                DebugOutput.println("   singleReceiver: " + this.m_singleReceiverClientID);
            }
        }
        catch (Exception ex) {
            DebugOutput.println("*** RepSendMessage.printTrace: " + ex.getMessage());
            DebugOutput.printException(ex);
        }
    }

    void resetSendMessage() {
        super.resetSendMessage();
        this.m_columnCount = 0;
        this.m_unqualifiedClients = null;
        this.m_ignoreOneClientID = -1L;
        this.m_singleReceiverClientID = -1L;
        this.m_outColByteStream.reset();
        if (this.m_colTrace != null) {
            this.m_colTrace.clear();
        }
    }

    private void serialize(BytesMessage jmsBytesMsg) throws JMSException {
        if (this.m_colTrace != null) {
            DebugOutput.println("---------- RowSendMessage ----------");
            DebugOutput.println(this.toString());
            this.printTrace();
        }
        jmsBytesMsg.writeInt(this.m_columnCount);
        if (this.m_columnCount > 0) {
            jmsBytesMsg.writeBytes(this.m_outColByteStream.toByteArray());
        }
        jmsBytesMsg.writeInt(super.getMessageEndVersion());
    }

    public void setIgnoreOneClient(long clientUnitID) {
        this.m_ignoreOneClientID = clientUnitID;
    }

    public void setSingleReceiver(long clientUnitID) {
        this.m_singleReceiverClientID = clientUnitID;
    }

    public String toString() {
        return "SEND: " + super.toString() + ", colCnt=" + this.m_columnCount;
    }

    private void writeByteArray(byte[] byteArray) throws IOException {
        if (byteArray == null) {
            this.m_outColDataStream.writeInt(-1);
            return;
        }
        this.m_outColDataStream.writeInt(byteArray.length);
        this.m_outColDataStream.write(byteArray);
    }

    private void writeObject(Object obj) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(256);
        ObjectOutputStream objStream = new ObjectOutputStream(byteStream);
        try {
            objStream.writeObject(obj);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException(ex.toString());
        }
        objStream.flush();
        this.m_outColDataStream.writeInt(byteStream.size());
        byteStream.writeTo(this.m_outColDataStream);
        objStream.close();
    }

    private boolean writeTypeCheckNotNull(CaptureResultRow captureRow, int columnType) throws IOException, SQLException {
        if (captureRow.wasNull()) {
            this.m_outColDataStream.writeInt(0);
            if (this.m_colTrace != null) {
                this.m_colTrace.addLast(null);
            }
            return false;
        }
        this.m_outColDataStream.writeInt(columnType);
        return true;
    }
}

